#include "mbed.h"
/*  En esta practica se hace la configuracion para realizar un comunicacion serial por medio
    del puerto UART del microcontrolador, se controla el estado del led rgb de la tarjeta
    por medio de los comandos que se envien al microcontrolador desde la PC, como se indica:

    - Cuando se teclea "R" se encuende el LED rojo, Cuando se teclea "r" se apagar el led rojo
    - Cuando se teclea "V" se encuende el LED verde, Cuando se teclea "v" se apagar el led verde
    - Cuando se teclea "A" se encuende el LED azul, Cuando se teclea "a" se apagar el led azul
    - Si se teclea cualquier otro caracter, aparece un mensaje indicando que el dato es no es valido

    Se puede visualizar todo a travez de un Terminal serial, en este caso es Tera Term.*/

DigitalOut rgb_rojo(PTB18,1);// inicializamos el led rgb rojo con salida digital con estado inicial 1 
DigitalOut rgb_verde(PTB19,1);// inicializamos el led rgb verde con salida digital con estado inicial 1 
DigitalOut rgb_azul(PTD1,1);// inicializamos el led rgb azul con salida digital con estado inicial 1 

Serial teclado(USBTX,USBRX); // inicializamos el puerto UART del microcontrolador

int main()
{
    teclado.baud(115200); // indicamos la cantidad de baudios en la transferencia
    while(1) 
    {
        switch(teclado.getc()) // dependiendo del caracter recivido por el teaclado
        {
            case 'R':
                rgb_rojo = 0;
                teclado.printf("Led rojo encendido \r\n");
                break;
            case 'r':
                rgb_rojo = 1;
                teclado.printf("Led rojo apagado \r\n");
                break;
            case 'V':
                rgb_verde = 0;
                teclado.printf("Led verde encendido \r\n");
                break;
            case 'v':
                rgb_verde = 1;
                teclado.printf("Led verde apagado \r\n");
                break;
            case 'A':
                rgb_azul = 0;
                teclado.printf("Led azul encendido \r\n");
                break;
            case 'a':
                rgb_azul = 1;
                teclado.printf("Led azul apagado \r\n");
                break;

            default:
                teclado.printf("El dato no es valido \r\n");
                break;
        }
    }
}
