#include "mbed.h"

/* Practica de configuracion de un pin de salida para usarlo como PWM a la frecuencia default de mbed,
   se visualiza como un LED conectado al pin de salida PWM, varia su intensidad liminosa dependiendo
   del ancho de pulso del PWM
   
   Reto: Variar el ancho del PWM utilizando un potenciometro mediante una lectura con el ADC, asi como 
   tambien indicar con el led rgb lo siguiente:
   - solo esta encendido el led rojo cuando el ancho de pulso es mayor a 20%
   - solo esta encendido el led verde cuando el ancho de pulso es mayor a 50%
   - solo esta encendido el led azul cuando el ancho de pulso es mayor a 80%
   - Para todos los demas cosas el led rgb debe estar apagado */

PwmOut led(D2); // se confura el pin D2 como puerto de salida PWM.

int main() 
{
   while(1) 
   {
   led = led + 0.01; // el ancho de pulso del PWM aumenta poco a poco en pasos del 1%.       
   wait(0.2); // es necesario hacer un retaro
   if(led == 1.0) led = 0; // si el ancho de pulso llega al maximo se hace un reset al minimo ancho de pulso.   
   }    
}
