#include "mbed.h"

/*  En esta practica se ve la configuracion de un pin que se usa como entrada analogica,
    tiene un potenciometro conectada al pin analogico A0, y se lee el valor de ADC que
    esta en el puerto, este valor se usa como un retardo para hacer oscilar el led rgb rojo,
    la funcion que se esta usando es .read
    
    Reto: Hacer un programa que mediante la lectura simple del ADC (.read), puede encender o apagar un LED de la siguiente forma:
    
    - Encender solo el led rgb rojo, cuando el valor sea mayor que 0.2.
    - Encender solo el led rgb verde, cuando el valor sea mayor que 0.6
    - Encender solo el led rgb azul, cuando el valor sea mayor que 0.9
    - Si no se cumple ningun caso, todos los led deben estar apagados. */
    
DigitalOut led_rgb_rojo(PTB18,1); // inicializamos el led rgb rojo como salida digital y estado inicial de 1.
AnalogIn   pot(A0); // inicializamos el pin A0 como una entrada analogica a la que esta conectada el potenciometro.

float valor_pot; // variable donde se almacena el valor leido por el ADC en la entrada analogica 

int main() {
    while(1) {
        valor_pot = pot.read(); // se lee el valor analogico en el pin y se guarda en la variable valor_pot, toma valores entre 0.0 - 1.0
        led_rgb_rojo = 0; // encendemos el led rgb rojo
        wait(valor_pot); // el retardo depende del valor leido en la entrada digital, 0.0 seg - 1.0 seg
        led_rgb_rojo = 1; // se apaga el led rgb rojo
        wait(valor_pot);
    }
}
