#include "mbed.h"

#include "mbed_globals.h"
#include "interrupts.h"
#include "serial.h"
#include "leds.h"

void serialOut(unsigned char c) {
    SERIAL_PUTCHAR(c);
}

void serialOutString(const char * c) {
    while (*c) {
        SERIAL_PUTCHAR(*c);
        c++;
    }
}

void serialOutHex32(unsigned int i)
{
    for(int j = 0; j < 8; j++)
    {
        unsigned char c = (i & 0xF0000000) >> 28;
        if(c < 10)
            serialOut('0' + c);
        else
            serialOut('A' + c - 10);
        i = i << 4;
    }
}

SERIAL_INTERRUPT_HANDLER(void) {
    // Check if interrupt is pending
    if(!SERIAL_CHECK_INTERRUPT())
        return;

    // While some data to read
    while (SERIAL_DATA_TO_READ()) {
        char c = SERIAL_GETCHAR();
        serialOut('[');
        serialOut(c);
        serialOut(']');
    }
}

int main() {
    // Hardware Init
    SERIAL_INIT();
    SERIAL_SETBAUD(9600);
    SERIAL_ENABLE_INTERRUPT(SERIAL_INT_RX);
    
    serialOutString("Simple UART Sample Code\r\n");
    
    while (1);
}