#include "mbed.h"
#include "leds.h"
#include "timers.h"

TIMER0_INTERRUPT_HANDLER(void)
{
    TIMER0_CLEAR_INTERRUPT(MR0_INT);
    static int i = 0;
    i++;
    if(i%2)
        LEDS_SET(LED1);
    else
        LEDS_SET(LED2);
}

int main() {
    LEDS_INIT();
    TIMER0_INIT();
    TIMER0_SETPCLK(CCLK);
    TIMER0_SETPRESCALE(96000); // 1ms
    TIMER0_SETMATCH(0, 100);
    TIMER0_SETMATCHCONTROL(0, MATCH_RESET | MATCH_INTERRUPT); // Reset and Interrupt each 100ms
    TIMER0_ENABLE_INTERRUPT();
    TIMER0_START();
    while (1);
}
