#ifndef _SDCARD_ 

#define _SDCARD_  

#include "mbed.h" 

#include "SDBlockDevice.h" 

#include "FATFileSystem.h" 

#include "sample_hardware.hpp" 

#include "messageStruct.hpp" 

  

class SDcard 

{     

    private: 

     

     float temp;       //current temperature of sensor 

     float pressure;  //current pressure of sensor 

     float fLDR;      //current light level from LDR 

      

      void update_temp(double t) //use this function to update the current temperature value 

            { 

                temp = t; 

            }  

        void update_pressure(double p) //use this function to update the current pressure value 

            { 

                pressure = p;     

            }  

        void update_LDR(double L) 

            { 

                fLDR = L;    

            } 

      

      

    public: 

     

    EventQueue SDcard_Queue; 

     

     SDcard(){                      //constructor,  

     

    // initalising the SD card 

      printf("Initialise\n"); 

    if ( sd.init() != 0) { 

        printf("Init failed \n"); 

        errorCode(FATAL); 

    }     

    //Create a filing system for SD Card 

    FATFileSystem fs("sd", &sd); 

         

        temp = 0; 

        pressure = 0;  

        fLDR = 0; 

    }    

         

      ~SDcard(){                      //Deconstructor,  

         

   //Close down SD card 

    sd.deinit(); 

    printf("Finished\n"); 

    errorCode(OK); 

        

        temp = 0; 

        pressure = 0;  

        fLDR = 0; 

    }    

     

     

      void update_sensor_info(sample_message msg) //updates all current sensor information, this is called by a ticker every 5 seconds to read from the mailbox 

    { 

         update_temp(msg.temp);                  // Include message class passing of data 

         update_pressure(msg.pressure); 

         update_LDR(msg.ldr); 

    } 

     

     

     

    void Save_Data() {          

       

    FILE* fp = fopen("/sd/SensorData.csv","a"); 

         

    if (fp == NULL) { 

        error("Could not open file for write\n"); 

        errorCode(FATAL); 

    } 

     

    //Storing sensor data in csv file 

    fprintf(fp, " Temperature , %4.2fC , Pressure , %4.2fmbar , Lux , %4.2f \n", temp , pressure , fLDR ); 

  

     

    //Close the file 

    fclose("/sd/SensorData.csv","a"); 

     

   

   } 

   

} 

// creating the instance SD of the class SDcard 

SDcard m_oSD; 

#endif 