#ifndef _SWITCHMANAGER_
#define _SWITCHMANAGER_

#include "mbed.h"
#include "sample_hardware.hpp"
#include "LCD.hpp"

InterruptIn sw1(PE_12);

//This class manages an Interrupt attached to a button
//It automatically manages the switch-debounce using edge detection and timers

class SwitchManager {
private:
// enum State {LOW, LOW_DEBOUNCE, HIGH, HIGH_DEBOUNCE};  
    InterruptIn& switchInterrupt;
    Timeout t;
    
    void waitForRising() {
        //Turn off interrupt
        switchInterrupt.rise(NULL);
        //Turn on timer
        t.attach(callback(this, &SwitchManager::waitForStabilityRising), 0.2);
    }
    
    void waitForStabilityRising() {
        //Look for falling edge
        switchInterrupt.fall(callback(this, &SwitchManager::waitForFalling));
    }
    
    void waitForFalling() {
        //When button is pressed, adds update_time_date function to the LCD queue
        m_oDisplay.LCD_Queue.call(&m_oDisplay, &LCD_Data::update_time_date);
        switchInterrupt.fall(NULL);
        t.attach(callback(this, &SwitchManager::waitForStabilityFalling), 0.2);
    }
    
    void waitForStabilityFalling() {
        //Look for rising edge
        switchInterrupt.rise(callback(this, &SwitchManager::waitForRising));
    }
    
public:
    SwitchManager(InterruptIn& intIn) : switchInterrupt(intIn) {
        //Listen for rising edge
        switchInterrupt.rise(callback(this, &SwitchManager::waitForRising));
    }
    ~SwitchManager() {
        //Turn off LED and shut off any ISRs
        switchInterrupt.rise(NULL);
        switchInterrupt.fall(NULL);
        t.detach();
    }
};
     
SwitchManager sm1(sw1);       

#endif