#include "mbed.h"

class Serialcomms
{
    private:
         float fTemp;      //current temperature of sensor
         float fPressure;  //current pressure of sensor
         float fLDR;      //current light level from LDR
         
    public:
        EventQueue SERIAL_Queue;                   //Initialise the EventQueue
   
        void setsampledata(sample_message msg)      // Update internal values
        {
            fTemp = msg.temp;
            fPressure = msg.pressure;
            fLDR = msg.ldr;   
        }
        
        sample_message getsampledata()          // Retrieves the data
        {
            sample_message msg;
            msg.temp = fTemp;
            msg.pressure = fPressure;
            msg.ldr = fLDR;
            return msg;
        }
        
        void updateTerminal()                   // Print internal values of sensors
        {            
            printf("======= Sensor Update ========\n");
            printf("Temperate: %5.2f\n", fTemp);
            printf("Pressure: %5.2f\n", fPressure);
            printf("Light Level: %5.2f\n", fLDR);
            printf("==============================\n");              
        }
    
        void updateTimeDate()
        {
        }
        
        Serialcomms()
        {
            printf("Serial Comms Initialised\n");
        }
        ~Serialcomms()
        {
        }  
};

Serialcomms m_oSerial;

