#ifndef _LCD_
#define _LCD_
#include "mbed.h"
#include "messageStruct.hpp"
#include "sample_hardware.hpp"
#include "Network.hpp"
#include <stdio.h>
#include <string>


class LCD_Data
    {
     friend class Network;
     
     private:  //private variables can only be changed via functions in this class
         float temp;       //current temperature of sensor, updated every 15 seconds
         float pressure;  //current pressure of sensor, updated every 15 seconds
         float fLDR;      //current light level from LDR, updated every 15 seconds
         
         int flip; //integer used to flip the bottom line of LCD
         
         string day; //string containing the current day when pulled from NTP server
         string month; //string containing the current month when pulled from NTP server
         string date; //string containing the current date when pulled from NTP server
         string time; //string containing the current time when pulled from NTP server
         string year; //string containing the current year when pulled from NTP server


     private:
         struct tm Time_Date; //decale instance Time_Date of structure tm which is defined by mbed / C
        
         
         void update_temp(double t) //used to update the current temperature value with an input
            {
                temp = t; //sets private variable temp
            } 
        void update_pressure(double p) //used to update the current pressure value with an input
            {
                pressure = p; 
            } 
        void update_LDR(double L) //used to update the LDR value with an input
            {
                fLDR = L;   
            }
    
    
    
    public:
    
    EventQueue LCD_Queue;  //create an event queue for main to run
    time_t timestamp; //current time in format of unix time, can be converted to DAY_OF_WEEK MONTH DAY HOUR:MINUTE:SECOND YEAR using ctime(&timestamp);
    
    
    
    LCD_Data(){ //constructor, initializes the FLIP variable for use in toggling the bottom line of the LCD
        flip = 1; //initalize what state the bottom line starts on
        temp = 0; //set temperature to start at 0
        pressure = 0; //set pressure to start at 0
        fLDR = 0; //set LDR value to start at 0


    }   
    
    
    
    void update_sensor_info(sample_message msg) //updates all current sensor information. recieves sensor info in structure type sample_message and takes it apart
    {
         update_temp(msg.temp);    // takes temperature from sample_message and feeds to update temp function
         update_pressure(msg.pressure); //takes pressure from sample_message and feeds to update pressure function
         update_LDR(msg.ldr); //takes the LDR value from sample_message and feeds to update LDR function
    }
    

    
    
    void display_LCD() //updates the current LCD display with the new sensor information, and flips bottom line of LCD
        {
         lcd.cls(); //clear current LCD display
         
         lcd.printf("%4.2fC", temp); //print temperature to the top line of LCD, 2dp celcius
         
         
         switch(flip){
         case 1: 
            lcd.printf("\n%4.2f mbar", pressure); //print pressure to bottom line of LCD, 2dp mbar
            flip = 2; //swaps to case 2 next time function is run so LDR is printed instead
            break;  
         case 2:
             lcd.printf("\n%4.2f Lux", fLDR); //print LDR value to bottom line of LCD, 2dp
             flip = 1; //swaps to case 1 next time function is run so pressure is printed instead
            break;  
         case 3: //only ever used when the interupt button is pressed to update time
             lcd.printf("\nTime updated"); //informs the user the current time has been set by printing onto bottom line
             printf("Current time is %s\r\n", ctime(&timestamp)); //prints current time and date in human readable time to terminal
             flip = 1; //swaps back to case 1 next time function is run
            break;         
        default: 
            printf("Error in LCD flip function"); //only reached if the case is set incorrectly
            break;
         }
       } 
       
       
       
       void update_time_date (){ //used to update time and date, called only when button interrupt is pressed
           
       timestamp = ntp.get_timestamp(); //reads the current time from a local NTP server in UNIX format
       
       string current_time =  ctime(&timestamp); //converts time to human readable format string
        
       printf("%s", current_time); //prints current time and date onto terminal

     
     day.assign(current_time, 0, 3); //extract only day from current_time string
     month.assign(current_time, 4, 3); //extract only month from current_time string
     date.assign(current_time, 9, 1); //extract only date from current_time string
     time.assign(current_time, 11, 8); //extract only time from current_time string
     year.assign(current_time, 20, 4); //extract only year from current_time string
     
     
     //printf("current day is: %s\n", day);
       // printf("current year is: %s\n", year);
      // printf("current time is: %s\n", time);
       // printf("current date is: %s\n", date);
     // printf("current month is: %s\n", month);
     
 
          
       m_oNet.Network_Queue.call(&m_oNet, &Network::update_Time, current_time); //sends the whole time and date string to networking to be displayed
       
       time_and_date Timemsg; // Define instance of message structure, used by serial communications
        Timemsg.day = day; 
        Timemsg.month = month;
        Timemsg.date = date;
        Timemsg.time = time;
        Timemsg.year = year;
        Timemsg.current_time = current_time;
        
       flip = 3; //will tell the user that the time has been updated on next FLIP instance with the LCD
       
     //  return Timemsg; //swap this for a function that sends the structure to ollie?
        
       }
       
       
    };  //end of LCD class
    
    
    
// Define the member object for the LCD
LCD_Data m_oDisplay;
#endif