#ifndef _NETWORK_ 

#define _NETWORK_ 

#include "mbed.h" 

#include "FATFileSystem.h" 

#include "sample_hardware.hpp" 

#include "EthernetInterface.h" 

#include "TCPServer.h" 

//#include "messageStruct.hpp" 

//#include "LCD.hpp"

#include "TCPSocket.h" 

#include <iostream> 

#include <string>  

#include "ntp-client/NTPClient.h"




 

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK" 
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8" 
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div id=\"Sensor Data\" name=\"Sensor Date\" style=\"margin:auto\">" "\r\n"        \
"      <h1> <b>Sensor Data</b> </h1>" "\r\n"                     \
"      <p>The LDR value is "                                    

#define HTTP_MESSAGE_BODY2 ""                                    \
       " Lux </p>" "\r\n"                                        \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <p>The Temperature value is "     

#define HTTP_MESSAGE_BODY3 ""                                    \
       " Degrees</p>" "\r\n"                                     \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <p>The Pressure value is "       

#define HTTP_MESSAGE_BODY4 ""                                    \
       " mbar </p>" "\r\n"                                     \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <p>The current Time is  "       

#define HTTP_MESSAGE_BODY5 ""                                    \
       " </p>" "\r\n"                                       \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>" 

 

 

 
#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

  

#define IP        "10.0.0.10"

#define NETMASK   "255.0.0.0"

#define GATEWAY   "10.0.0.2"

EthernetInterface eth; 

NTPClient ntp(&eth);   


  

class Network 
{ 
//friend class LCD_Data;
    private: 
     float temp;       //current temperature of sensor 
     float pressure;  //current pressure of sensor 
     float fLDR;      //current light level from LDR 
     string time;

      void update_temp(double t) //use this function to update the current temperature value 
            { 
                temp = t; 
            }  

        void update_pressure(double p) //use this function to update the current pressure value 
            { 
                pressure = p;     
            }  

        void update_LDR(double L) 
            { 
                fLDR = L;    
            } 

             
    public: 
    EventQueue Network_Queue; 



    Network(){     //constructor  

    //Configure an ethernet connection 
    eth.set_network(IP, NETMASK, GATEWAY); 
    eth.connect(); 
    } 
  

    ~Network(){     //deconstructor  

    } 

  

  

      void update_sensor_info(sample_message msg) //updates all current sensor information, this is called by a ticker every 5 seconds to read from the mailbox 

    { 
         update_temp(msg.temp);                  // Include message class passing of data 
         update_pressure(msg.pressure); 
         update_LDR(msg.ldr); 
    } 

     
    void update_Time(string tm)
    {
        time = tm;
    }
     

    void NetPush(){ 
     

  //Now setup a web server 

    TCPServer srv;           //TCP/IP Server 
    TCPSocket clt_sock;      //Socket for communication 
    SocketAddress clt_addr;  //Address of incoming connection 


     

    /* Open the server on ethernet stack */ 
    srv.open(&eth); 


    /* Bind the HTTP port (TCP 80) to the server */ 
    srv.bind(eth.get_ip_address(), 80); 


    /* Can handle 5 simultaneous connections */ 
    srv.listen(5); 

      //Block and wait on an incoming connection 

        srv.accept(&clt_sock, &clt_addr); 

        //printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port()); 

             

        //Uses a C++ string to make it easier to concatinate 

        string response; 

         

        //This is a C string 

        char ldr_str[64]; 

        char temp_str[64]; 

        char pressure_str[64]; 

        //printf("%s", time);

        //Convert to a C String 

        sprintf(ldr_str, "%5.3f", fLDR ); 

        sprintf(temp_str, "%5.3f", temp ); 

        sprintf(pressure_str, "%5.3f", pressure ); 

         

         
        //Build the C++ string response 

        response = HTTP_MESSAGE_BODY1; 

        response += ldr_str; 

        response += HTTP_MESSAGE_BODY2; 

        response += temp_str; 

        response += HTTP_MESSAGE_BODY3; 

        response += pressure_str; 

        response += HTTP_MESSAGE_BODY4; 

        response += time;
        
        response += HTTP_MESSAGE_BODY5; 
 

         

         

        //Send static HTML response (as a C string) 

      //  clt_sock.send(response.c_str(), response.size()+6);  
        clt_sock.send(response.c_str(), response.size());  

               

         

        } 

}; 

     

  

Network m_oNet; 

#endif