#include "mbed.h"
#include "ntp-client/NTPClient.h"
#include "sample_hardware.hpp"
#include "Sampler.hpp"
#include "SwitchManager.hpp"

void LCD_Thread(void);
void SAMP_Thread(void);
void SERIAL_Thread(void);
void Network_Thread(void);

Thread tLCD, tSAMP, tSERIAL, tSD, tNET;

// Define member object
Sampler m_oSample;

int main()
{  
    tLCD.start(LCD_Thread);
    tSAMP.start(SAMP_Thread);
    tSERIAL.start(SERIAL_Thread);
    tNET.start(Network_Thread);
    Thread::wait(osWaitForever);
}


void LCD_Thread()
{   
    while(1)
    {
        //m_oDisplay.LCD_Queue.call(&m_oDisplay, &LCD_Data::update_time_date);
        m_oDisplay.LCD_Queue.call_every(1000, &m_oDisplay, &LCD_Data::display_LCD); //displays the current sensor information onto the LCD screen every x miliseconds 
        m_oDisplay.LCD_Queue.dispatch();  //dispatches the above tasks to the queue, then blocks main forever unless ' break_dispatch () ' is used 
        while(true) 
        {
            redLED = 1;
            wait(0.5);
            redLED = 0;
            wait(0.1);    
        }
    }
}

void SAMP_Thread()
 {
     while(1)
     {
        m_oSample.SAMP_Queue.call_every(500, &m_oSample, &Sampler::publishSample);     // Publish sample 
        m_oSample.SAMP_Queue.dispatch();
        while(true) 
        {   // Flash if the event queue is exited.
            yellowLED = 1;
            wait(0.5);
            yellowLED = 0;
            wait(0.1);    
        }
     }
}

void SERIAL_Thread()
{
      while(1)
     {
        m_oSerial.SERIAL_Queue.call_every(1000, &m_oSerial, &Serialcomms::updateTerminal);     // Publish sample 
        m_oSerial.SERIAL_Queue.dispatch();
        while(true) 
        {   // Flash if the event queue is exited.
            yellowLED = 1;
            wait(0.5);
            yellowLED = 0;
            wait(0.1);    
        }
     }   
}



    void Network_Thread() 
{ 
    while(1) 
    { 
         m_oNet.Network_Queue.call_every(10, &m_oNet, &Network::NetPush); 
         m_oNet.Network_Queue.dispatch(); 

          while(true)  
        {   // Flash if the event queue is exited. 
            greenLED = 1; 
            wait(0.5); 
            greenLED = 0; 
            wait(0.1);     

        } 
    }    
} 

    
