#ifndef _SAMPLER_
#define _SAMPLER_
#include "mbed.h"
#include "LCD.hpp"
#include "SerialComms.hpp"
#include "sample_hardware.hpp"
#define Activate_Flag 1

class Sampler
{
private:
    
public: 
    EventQueue SAMP_Queue;                  //Initialise the EventQueue

    void publishSample()
    {
        sample_message message = getData();
        m_oDisplay.LCD_Queue.call(&m_oDisplay, &LCD_Data::update_sensor_info, message);
        m_oSerial.SERIAL_Queue.call(&m_oSerial, &Serialcomms::setsampledata, message);
        //SD_Queue.call(&m_oSD_data, &SD_Queue::update_sensor_info, sample_data, sample_data);
    }
    
    sample_message getData()
    {       
        float temp = sensor.getTemperature();
        float pressure = sensor.getPressure();
        float LDR = adcIn.read()*4095;
        #ifdef BME
        float humidity = sensor.getHumidity();
        #endif
        sample_message msg; // Define instance of message structure
        msg.temp = temp;
        msg.pressure = pressure;
        msg.ldr = LDR;
        return msg;
    }
    
    void updateTimeData();

    Sampler()   //Constructor 
    {
    }
    ~Sampler() //Destructor - should the instance go out of scope, this is called
    {
    }
};
#endif