#ifndef _LCD_
#define _LCD_
#include "mbed.h"
#include "messageStruct.hpp"
#include "sample_hardware.hpp"
#include "Network.hpp"


class LCD_Data
    {
     friend class Network;
     
     private:  //private variables can only be changed via functions in this class
         float temp;       //current temperature of sensor, updated every 15 seconds
         float pressure;  //current pressure of sensor, updated every 15 seconds
         float fLDR;      //current light level from LDR, updated every 15 seconds
         int flip;
         

     private:
         struct tm Time_Date; //decale instance Time_Date of structure tm which is defined by mbed / C
        
         
         void update_temp(double t) //use this function to update the current temperature value
            {
                temp = t;
            } 
        void update_pressure(double p) //use this function to update the current pressure value
            {
                pressure = p;    
            } 
        void update_LDR(double L)
            {
                fLDR = L;   
            }
    
    
    
    public:
    
    EventQueue LCD_Queue;  //create an event queue for main
    time_t timestamp; //current time in format of unix time, can be converted to DAY_OF_WEEK MONTH DAY HOUR:MINUTE:SECOND YEAR using ctime(&timestamp);
    
    
    
    LCD_Data(){ //constructor, initializes the FLIP variable for use in toggling the bottom line of the LCD
        flip = 1;
        temp = 0;
        pressure = 0; 
        fLDR = 0;


    }   
    
    
    
    void update_sensor_info(sample_message msg) //updates all current sensor information, this is called by a ticker every 5 seconds to read from the mailbox
    {
         update_temp(msg.temp);    // Include message class passing of data
         update_pressure(msg.pressure);
         update_LDR(msg.ldr);
    }
    
    
    
    
    void display_LCD() //updates the current LCD display with the new sensor information
        {
         lcd.cls(); //clear current LCD display
         
         lcd.printf("%4.2fC", temp); //print temperature to the top line of LCD, 2dp celcius
         
         
         switch(flip){
         case 1: 
            lcd.printf("\n%4.2f mbar", pressure); //print pressure to bottom line of LCD, 2dp mbar
            flip = 2;
            break;  
         case 2:
             lcd.printf("\n%4.2f Lux", fLDR); //print pressure to bottom line of LCD, 2dp mbar
             flip = 1;   
            break;  
         case 3: //only ever called when the interupt button is pressed to update time
             lcd.printf("\nTime updated"); //informs the user the current time has been set
             printf("Current time is %s\r\n", ctime(&timestamp)); //prints current time and date in human readable time to terminal
             flip = 1;
            break;         
        default: 
            printf("Error in LCD flip function");
            break;
         }
       } 
       
       
       
       void update_time_date (){
        timestamp = ntp.get_timestamp();
       //timestamp = Network::ntp.get_timestamp(); //gets current time and date from NTP server in unix format
      // timestamp = m_oNet.ntp.get_timestamp(); //gets current time and date from NTP server in unix format
       
       flip = 3; //will tell the user that the time has been updated on next FLIP instance
       
       }
       
       
    };  //end of LCD class
    
    
    
// Define the member object for the LCD
LCD_Data m_oDisplay;
#endif