#include "mbed.h"
#include "beep.h"
#include "EthernetInterface.h"
#include "rtos.h"
#include "SDFileSystem.h"

InterruptIn movimento(D2);
Serial pc(USBTX, USBRX); // tx, rx
Beep buzzer(D5);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

DigitalIn buttonStopLog(SW2);
DigitalOut led0(LED_RED);
DigitalOut led1(LED_GREEN);
DigitalOut rgb_red(D7);
DigitalOut rgb_green(D8);

Mutex PIR;
Timer timer;
EthernetInterface eth;
Mutex ETH_IN;

unsigned int move_detected = 0;

unsigned int alarme = 0;

const char* ECHO_SERVER_ADDRESS = "10.3.2.6";//"192.168.15.5";

const int ECHO_SERVER_PORT = 23;

void irq_handler(void)
{
    move_detected = 1;
}

//Thread 1 - Leitura do sensor PIR
void Le_sensor()
{
    wait(1);
    movimento.rise(&irq_handler);

    while(1)
    {
        timer.start();
        if(timer.read()>=60){
        timer.reset();
        alarme=0;
        }
        
        if(move_detected)
        {
            PIR.lock();
            alarme++;
            move_detected = 0;
            pc.printf("Alarme disparou %d vezes\n", alarme);
            PIR.unlock();
        }
        
        Thread::wait(300);
    }
    
}

//Thread 2 - Acionamento do atuador
void Aciona_buzzer()
{
    while(1)
    {
        if(movimento.read()==1 && move_detected == 1)
        {
            rgb_red = 0;
            rgb_green = 1;
            buzzer.beep(1000,0.5); //Aumentar frequencia e tempo de duração
        }
         else
         {
            rgb_red = 1;
            rgb_green = 0;
         }
         
    }
    
}

//Thread 3 - Gravação de informações no cartão SD
void Armazena_cartao()
{

    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/log.txt", "w");
    fprintf(fp, "Alarme");
    fprintf(fp, "\t");
    fprintf(fp, "Tempo");
    fprintf(fp, "\r\n");

    while(1)
    {
        if(buttonStopLog.read()==0)
            break;
        PIR.lock();
        fprintf(fp, "%d", alarme);
        fprintf(fp, "\t");
        fprintf(fp, "%.f", timer.read());
        fprintf(fp, "\r\n");
        PIR.unlock();
        Thread::wait(50);
    }
    fclose(fp);
    led0 = 1;
    led1 = 0;
}

//Thread 4 - Protocolo de comunicações TCP/IP
void Ethernet_Interface()
{
    
    eth.init();
    eth.connect();
    printf("\nClient IP Address is %s\n", eth.getIPAddress());
    
    // Connect to Server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        Thread::wait(500);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char buffer[1000] = "";
    
      while(socket.is_connected())
      {
       ETH_IN.lock();
       snprintf(buffer, 1000, "Alarm: %d  Tempo: %.f \n", alarme, timer.read());
       socket.send_all(buffer, sizeof(buffer));
       printf("\nAlarme: %d \n\r", alarme);
       printf("Tempo: %.f\n\r", timer.read()); 
       ETH_IN.unlock();
       Thread::wait(100);
     }
    
    // Clean up
    socket.close();
    
    
    
}
//Função Principal
int main(void)
{
    led1 = 1;
    led0 = 0;
    rgb_red = 1;
    rgb_green=0;

    Thread SensorPIR;
    Thread Atuador_Buzzer;
    Thread Cartao_SD;
    Thread Ethernet;

    SensorPIR.start(Le_sensor); //Utilizar callback na chamada SensorPIR.start(callback(Le_sensor))
    Atuador_Buzzer.start(Aciona_buzzer);
    Cartao_SD.start(Armazena_cartao);
    Ethernet.start(Ethernet_Interface);

    while(1){
    }
}