#include "mbed.h"
#include "TextLCD.h"
#include "button_value.h"
#include <map>

// Define screen
TextLCD lcd(PA_8, PA_9, PC_7, PB_6, PA_7, PA_6, PA_5); // RS, RW, E, D4-D7
 
// Define Bus In for Buttons (Do, Re, Mi, Fa)
BusIn Bus_In(PA_10, PB_3, PB_5, PB_4);

// Define the PWM speaker
PwmOut speaker(PB_10);
    
//Define variables for sound
volatile int state_buttons = 0;
std::map<int, double> period;

void print_note(char *str)
{
    lcd.cls();
    lcd.printf(str);
}

void print_char()
{
    lcd.printf("Hello world!");
    fflush(stdout);
}

Thread thread;

DigitalOut led1(LED1);

void print_thread()
{
    while (true) {
        wait(1);
        print_char();
    }
}

void    refresh_state_button()
{
   printf("refresh_state_button \n");
   state_buttons = Bus_In & Bus_In.mask(); // read the bus and mask out bits not being used    
   printf("state_button [ %d ]\n", state_buttons);
}

void        play_music(int key)
{
   printf("play_music \n");
   printf("key [%x], value[%f]\n", key, period[key]);
   speaker.period(period[key]);            
   while (state_buttons == key) {
     refresh_state_button();
   }
   check_buttons();
}

void        check_buttons()
{
   printf("check_buttons \n");
    // check bits set in bus
    switch(state_buttons) { 
        case 0x0: 
            printf("0b0000, All buttons pressed [%d] \n\r", Bus_In & Bus_In.mask());
            speaker = 0.25;
            print_note("DO RE MI FA");
            play_music(0x0);
            break;
        case 0x1: 
            printf("0b0001, Button 2 & 3 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            speaker = 0.25;
            print_note("RE MI FA");
            play_music(0x1);
            break;
        case 0x2: 
            printf("0b0010, Button 1 & 3 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO MI FA");
            speaker = 0.25;
            play_music(0x2);
            break; 
        case 0x3: 
            printf("0b0011, Button 3 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("MI FA");
            speaker = 0.25;
            play_music(0x3);
            break;
        case 0x4: 
            printf("0b0100, Button 1 & 2 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO RE FA");
            speaker = 0.25;
            play_music(0x4);
            break;
        case 0x5: 
            printf("0b0101, Button 2 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("RE FA");
            speaker = 0.25;
            play_music(0x5);
            break;
        case 0x6: 
            printf("0b0110, Button 1 & 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO FA");
            speaker = 0.25;
            play_music(0x6);
            break;
        case 0x7: 
            printf("0b0111, Button 4 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("FA");
            speaker = 0.5;
            play_music(0x7);
            break;
        case 0x8: 
            printf("0b1000, Button 1 & 2 & 3 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO RE MI");
            speaker = 0.25;
            play_music(0x8);
            break; 
        case 0x9: 
            printf("0b1001, Button 2 & 3 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("RE MI");
            speaker = 0.25;
            play_music(0x9);
            break; 
        case 0xA: 
            printf("0b1010, Button 1 & 3 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO MI");
            speaker = 0.25;
            play_music(0xA);
            break;
        case 0xB: 
            printf("0b1011, Button 3 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("MI");
            speaker = 0.5;
            play_music(0xB);
            break;
        case 0xC: 
            printf("0b1100, Button 1 & 2 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            speaker = 0.25;
            print_note("DO RE");
            play_music(0xC);
            break; 
        case 0xD: 
            printf("0b1101, Button 2 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("RE");
            speaker = 0.5;
            play_music(0xD);
            break; 
        case 0xE: 
            printf("0b1110, Button 1 pressed [%d] \n\r", Bus_In & Bus_In.mask());
            print_note("DO");
            speaker = 0.5;
            play_music(0xE);
            break; 
        case 0xF: 
            printf("0b1111, No button pressed [%d] \n\r", Bus_In & Bus_In.mask());
            speaker = 0;
            lcd.cls();
            break;
    }
}

// TODO: perios of notes with ID
// TODO: implement new 4 buttons
// TODO: link new 2 buttons + implementation
// TODO: deal with gamme

// TODO: PB with DO RE on the screen (board crashes)

int main()
{
    printf("\n\n*** CS 435 - Piano ***\n");
    
    period[0xE] = 1.0 / 262.0; // DO
    period[0xD] = 1.0 / 294.0; // RE
    period[0xB] = 1.0 / 330.0; // MI
    period[0x7] = 1.0 / 349.0; // FA
    period[0xC] = 1.0 / (262.0 + 294.0); // DO + RE
    period[0x8] = 1.0 / (262.0 + 294.0 + 330.0) 
    lcd.printf("CS 435 - Piano");

    //thread.start(print_thread);

    while (true) {
        printf("loop\n");
        led1 = !led1;
        refresh_state_button();
        check_buttons();
        wait(0.1);
    }
}
