#ifndef OBDII_H
#define OBDII_H
//Can Speed
#define CANSPEED_125      125000
#define CANSPEED_250      250000
#define CANSPEED_500      500000

/* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs
to add more options simply find the required PIDs  from
http://en.wikipedia.org/wiki/OBD-II_PIDs and define them*/
#define ENGINE_COOLANT_TEMP 0x05
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define O2_VOLTAGE          0x14


#define PID_REQUEST         0x7DF
#define PID_REPLY           0x7E8

namespace mbed {

class OBDII {

public:
    OBDII(int can_speed);
    unsigned char request(unsigned char pid,  char *buffer);

private:
    int i;

};

}

#endif