/* Buenas tardes, este es un programa creado para realizar distintas actividades que en el siguiente espacio mencionaremos:

Se cargara a el microcontrolador freedom FDRM KL25Z. El cual nos ayudara de 2 maneras.

En general el microcontrolador tendra conectado dos displays de 7 segmentos de anodo comun, 1 boton pulsador y 2 entradas analogicas que seran las 
diferentes funciones que mediremos.

La primera de ellas será un voltimetro que nos desplegara el resultado en los displays previamente conectados, el cual para los valores de 0 - 9 
mostrara un decimal, y para los valores de 10 - 28V nos mostrara el valor de la parte entera 

La segunda sera un ohmetro que nos desplegara el resultado en los displays, el cual nos desplegara el resultado siempre en Kiloohms 

Autor: Emilio Esteban Jimenez Godinez & Jose Alfredo Ocegueda Barraza
Fecha: 12 de Marzo del 2014
Version: 1.1 */


#include "mbed.h"

DigitalIn boton(PTB2);  // cambia el estado ya sea para utilizar el voltimetro o el ohmetro
AnalogIn lecvol(PTB3);  // Entrada analogica que nos permite saber la lectura para el voltimetro
AnalogIn lecres(PTC2);  // Entrada analogica que nos permite saber la lectura para el ohmetro
//                 A   B    C    D    E    F    G
BusOut display_1(PTD2,PTD0,PTD5,PTE0,PTE1,PTD3,PTD1);   // son las salidas haia el display izquierdo
//                 A    B    C    D    E    F    G
BusOut display_2(PTA12,PTD4,PTA2,PTC8,PTC9,PTA4,PTA5);  // son las salidas haia el display derecho
DigitalOut dp_display1(PTA13);            // Esta salida es para el punto del display izquierdo
DigitalOut dp_display2(PTA1);             // Esta salida es para el punto del display derecho
int tiempo=0;                             // nos sirve de auxiliar en la lectura de tiempo
int promedio=0;
float promedio_voltaje=0;
float promedio_resistencia=0;
int estado=0;                             // 0= Voltimetro; 1= Ohmetro
int i;                                    // Variable auxiliar para instruccion for
float voltaje[]={0};                      // Arreglo para guardar las lecturas de voltaje
float resistencia[]={0};                  // Arreglo para guardar las lecturas de resistencia
int dis_1;                                // Variable auxiliar par regresar el valor de la funcion entero
int dis_2;                                 // Variable auxiliar par regresar el valor de la funcion entero

int display_entero(int entero);          //funcion para obtener el valor del display1 que necesitamos
int display_decimal(int decimal);        //funcion para obtener el valor del display2 que necesitamos
 
int main() 
{
    Timer volt;
    Timer resis;

    while(1) 
    {
        if(boton==1){      //utilizamos esta instruccion para cada vez que se presione el boton cambiemos de estado una variable
            estado=!estado;
        }   
        if (estado == 0){                                     // Cuando estado sea = 0 metemos la formula para que nos de el resultado del voltimetro
             volt.start();                                    // y sacamos el promedio, despues hacemos lo necesario para imprimir la respuesta en los displays
             for(i=0; i<=9; i++){
                 int resultado_voltaje = (lecvol*3.3*5780)/680;
                 if(volt.read_ms() == tiempo){
                     voltaje[i]=resultado_voltaje;
                     promedio+=resultado_voltaje;
                     tiempo+=200;
                 }
            }
            if(volt.read_ms() ==2000){
                promedio_voltaje=promedio/10;
                if (promedio_voltaje >= 10){                            // Si el resultado es mayor a 10 entonces separamos en dos numeros
                    int display_1 = display_entero(promedio_voltaje/10); // Mandamos llamar la funcion que nos regresa el valor del display 1
                    int display_2 = display_decimal(int(promedio_voltaje)%10);// Mandamos llamar la funcion que nos regresa el valor del display 2
                    }
                if (promedio_voltaje < 10){                                                // Si el resultado es menor a 10 entonces separamos en dos numeros uno sera la
                    int display_1 = display_entero(promedio_voltaje);                      // Mandamos llamar la funcion que nos regresa el valor del display 1
                    dp_display1=1;                                                         // Prendemos el punto del display 1 asi sabremos que da decimales
                    int display_2 = display_decimal((promedio_voltaje*10)%10);                  // Mandamos llamar la funcion que nos regresa el valor del display 2
                }
                volt.reset();
            }
        }
        if (estado == 1){                                                      // Cuando estado sea = 0 metemos la formula para que nos de el resultado del ohmetro
            resis.start();                                                     // y sacamos el promedio, despues hacemos lo necesario para imprimir la respuesta en los displays
            dp_display2=1;                                                     // Para saber que el resultado sera en kohms activamos el dot poitn del segundo display y lo dejamos encendido siempre
            for(i=0; i<=9; i++){
                int resultado_resistencia = ((3.3*10)/(lecres*3.3))-10;        // Despues de sacar esta formula el resultado sera en Kohms
                if(resis.read_ms() == tiempo){
                    resistencia[i]=resultado_resistencia;
                    promedio+=resultado_resistencia;
                    tiempo+=200;
                }
            }
            if(resis.read_ms() == 2000){
                promedio_resistencia=promedio/10;
                if(promedio_resistencia<1){                                      // Si el resultado de la formula es menor a 1 desplegaremos en el display en decimas de kohms
                    display_1 = ~63;                                             // Debido a que sera menor a 1 dejamos el primer display en 0
                    dp_display1=1;                                               // Activamos el dot point del primer display ya que dara decimales
                    int display_2 = display_decimal(promedio_resistencia*10);    // Mandamos llamar la funcion que nos regresa el valor del display 2
                }
                if(promedio_resistencia>=1&&promedio_resistencia<10){             // Si el resultado de la formula es mayor o igual a 1 y menor a 10 seguiremos dando decimales
                    int display_1 = display_entero(promedio_resistencia);         // Mandamos llamar la funcion que nos regresa el valor del display 1
                    dp_display1=1;                                                // Activamos el dot point del primer display ya que dara decimales
                    int display_2 = display_decimal((promedio_resistencia*10)%10);     // Mandamos llamar la funcion que nos regresa el valor del display 2
                }
                if(promedio_resistencia>=10){                                     // Si el resultado de la formula es mayor o igual a 10 hacemos lo necesario para que los displays nos desplieguen el resultado
                    int display_1 = display_entero(promedio_resistencia/10);         // Mandamos llamar la funcion que nos regresa el valor del display 1
                    int display_2 = display_decimal(int(promedio_resistencia)%10);     // Mandamos llamar la funcion que nos regresa el valor del display 2
                }
                resis.reset();
            }
        }
    }
}

int display_entero (int entero){   // Esta funcion es para desplegar el numero en el primer display, a todos los resultados se les aplica un inversor
    switch(entero){                // debido a que los display que utilizamos son de anodo comun, entonces seria todo de manera inversa
        case 0:
            dis_1=~63;
            break;
        case 1:
            display_1=~6;
            break;
        case 2:
            dis_1=~91;
            break;
        case 3:
            dis_1=~79;
            break;
        case 4:
            dis_1=~102;
            break;
        case 5:
            dis_1=~109;
            break;
        case 6:
            dis_1=~125;
            break;
        case 7:
            dis_1=~7;
            break;
        case 8:
            dis_1=~127;
            break;
        case 9:
            dis_1=~103;
            break;
    }
    return dis_1;
}

int display_decimal(int decimal){   // Esta funcion es para desplegar el numero en el segundo display, a todos los resultados se les aplica un inversor
    switch(decimal){                // debido a que los display que utilizamos son de anodo comun, entonces seria todo de manera inversa
        case 0:
            dis_2=~63;
            break;
        case 1:
            dis_2=~6;
            break;
        case 2:
            dis_2=~91;
            break;
        case 3:
            dis_2=~79;
            break;
        case 4:
            dis_2=~102;
            break;
        case 5:
            dis_2=~109;
            break;
        case 6:
            dis_2=~125;
            break;
        case 7:
            dis_2=~7;
            break;
        case 8:
            dis_2=~127;
            break;
        case 9:
            dis_2=~103;
            break;
    }
    return dis_2;
}
