#include <stdint.h>
#include "MKL25Z4.h"

#include "kl25z_clock.h"
#include "board.h"

void switchFEItoPEE( void )
{
    /* SIM->SCGC5: PORTA=1 */
    SIM->SCGC5 |= (uint32_t)0x0200UL;     /* Enable clock gate for ports to enable pin routing */
    /* SIM->CLKDIV1: OUTDIV1=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,OUTDIV4=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
    //SIM->CLKDIV1 = (uint32_t)0x10010000UL; /* Update system prescalers */
    /* SIM->CLKDIV1: OUTDIV1=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,OUTDIV4=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
    SIM->CLKDIV1 = (uint32_t)0x10010000UL; /* Update system prescalers */
    /* PORTA->PCR18: ISF=0,MUX=0 */
    PORTA->PCR[18] &= (uint32_t)~0x01000700UL;
    /* PORTA->PCR19: ISF=0,MUX=0 */
    PORTA->PCR[19] &= (uint32_t)~0x01000700UL;
    /* Switch to FBE Mode */
    /* OSC0->CR: ERCLKEN=1,??=0,EREFSTEN=0,??=0,SC2P=1,SC4P=0,SC8P=0,SC16P=1 */
    OSC0->CR = (uint8_t)0x89U;
    /* MCG->C2: LOCRE0=0,??=0,RANGE0=2,HGO0=0,EREFS0=1,LP=0,IRCS=0 */
    MCG->C2 = (uint8_t)0x24U;
    /* MCG->C1: CLKS=2,FRDIV=3,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
    MCG->C1 = (uint8_t)0x9AU;
    /* MCG->C4: DMX32=0,DRST_DRS=0 */
    MCG->C4 &= (uint8_t)~(uint8_t)0xE0U;
    /* MCG->C5: ??=0,PLLCLKEN0=0,PLLSTEN0=0,PRDIV0=1 */
    MCG->C5 = (uint8_t)0x01U;
    /* MCG->C6: LOLIE0=0,PLLS=0,CME0=0,VDIV0=0 */
    MCG->C6 = (uint8_t)0x00U;
    while((MCG->S & MCG_S_IREFST_MASK) != 0x00U) { /* Check that the source of the FLL reference clock is the external reference clock. */
    }
    while((MCG->S & 0x0CU) != 0x08U) {    /* Wait until external reference clock is selected as MCG output */
    }
    /* Switch to PBE Mode */
    /* MCG->C6: LOLIE0=0,PLLS=1,CME0=0,VDIV0=0 */
    MCG->C6 = (uint8_t)0x40U;
    while((MCG->S & 0x0CU) != 0x08U) {    /* Wait until external reference clock is selected as MCG output */
    }
    while((MCG->S & MCG_S_LOCK0_MASK) == 0x00U) { /* Wait until locked */
    }
    /* Switch to PEE Mode */
    /* MCG->C1: CLKS=0,FRDIV=3,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
    MCG->C1 = (uint8_t)0x1AU;
    while((MCG->S & 0x0CU) != 0x0CU) {    /* Wait until output of the PLL is selected */
    }
    
    /* Run this to get the new system frequency */
    //SIM->CLKDIV1 = (uint32_t)0x20000000UL; /* Update system prescalers */
    SystemCoreClockUpdate();
    
}
 
void switchPEEtoBLPI( void )
{
    
    
    // Move to PBE
    MCG->C1 = (uint8_t)0x90U;                       /* Switch the system clock source to the external reference clock */
    while((MCG->S & MCG_S_CLKST_MASK) != 0x2U<<MCG_S_CLKST_SHIFT) {   /* Wait until external reference clock is selected as MCG output */
    }
    
    
    // Move to FBE
    MCG->C6 = (uint8_t)0x00U;                       /* Select FLL */
    while((MCG->S & MCG_S_PLLST_MASK) != 0x00U) {   /* Wait until the current source for the PLLS clock is the FLL */
    }
    
    // Ok till here
    
    // Move to FBI
    MCG->C1 = (uint8_t)0x54U;                       /* Switch the system clock to the internal reference clock */
    while((MCG->S & MCG_S_IREFST_MASK) != 0x00U) {   /* Wait until the current source for the PLLS clock is the FLL */
    }
    while((MCG->S & MCG_S_CLKST_MASK) != 0x1U << MCG_S_CLKST_SHIFT) {   /* Wait until the the internal reference clock is selected to feed MCGOUTCLK */
    }
    
    // Move to BLPI
    MCG->C2 = (uint8_t)0x02;                     /* LP is 1 */
    MCG->C1 |= MCG_C1_IRCLKEN_MASK;              /* Clock is always active */
    
    /* Run this to get the new system frequency */
    //SystemCoreClockUpdate();
    
}

void switchBLPItoFEI( void )
{
    // Move to FBI
    /* LP is 0 */
    MCG->C2 = (uint8_t) 0x00;                     
    
    // Move to FEI
    /* Update system prescalers */
    SIM->CLKDIV1 = (uint32_t)0x00020000UL;          
    /* MCG->C1: CLKS=0,FRDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=0 */
    MCG->C1 = (uint8_t)0x06U;
    /* MCG_C2: LOCRE0=0,??=0,RANGE0=0,HGO0=0,EREFS0=0,LP=0,IRCS=0 */
    MCG->C2 = (uint8_t)0x00U;
    /* MCG->C4: DMX32=0,DRST_DRS=1 */
    MCG->C4 = (uint8_t)((MCG->C4 & (uint8_t)~(uint8_t)0xC0U) | (uint8_t)0x20U);
    /* OSC0->CR: ERCLKEN=1,??=0,EREFSTEN=0,??=0,SC2P=0,SC4P=0,SC8P=0,SC16P=0 */
    OSC0->CR = (uint8_t)0x80U;
    /* MCG->C5: ??=0,PLLCLKEN0=0,PLLSTEN0=0,PRDIV0=0 */
    MCG->C5 = (uint8_t)0x00U;
    /* MCG->C6: LOLIE0=0,PLLS=0,CME0=0,VDIV0=0 */
    MCG->C6 = (uint8_t)0x00U;
    while((MCG->S & MCG_S_IREFST_MASK) == 0x00U) { /* Check that the source of the FLL reference clock is the internal reference clock. */
    }
    while((MCG->S & 0x0CU) != 0x00U) {    /* Wait until output of the FLL is selected */
    } 
    
    /* Run this to get the new system frequency */
    SystemCoreClockUpdate();
}