//inclui as bibliotecas
#include "mbed.h"
#include "TextLCD.h"


TextLCD lcd(D8, D9, D4, D5, D6, D7); //declara uso do display lcd
Serial pc(USBTX, USBRX); //declara serial
CAN can1(PB_8, PB_9); //declara CAN
AnalogIn EX(A2); //declara entrada eixo x do joystick
AnalogIn EY(A3); //declara entrada eixo y do joystick

static char info[5] = {0x55, 0x54, 0x53, 0x52, 0x51};  //vetor para as 5 msgs

int main()
{
    //cria mensagens que serão utilizadas
    CANMessage cima(5, &info[0], 8, CANData, CANStandard);
    CANMessage baixo(5, &info[1], 8, CANData, CANStandard);
    CANMessage esquerda(5, &info[2], 8, CANData, CANStandard);
    CANMessage direita(5, &info[3], 8, CANData, CANStandard);
    CANMessage recebida(5, &info[4], 8, CANData, CANStandard);
    pc.printf("Ola!\n");
    int x;  //cria variavel inteira x
    int y;  ////cria variavel inteira x
    
    while(1)
    {
        x = EX.read()*1000; //atribui à variável x o valor da leitura no pino vezes 1000
        y = EY.read()*1000; //atribui à variável y o valor da leitura no pino vezes 1000
        
        //escreve as mensagens certas para as condições de valor do joystick
        if (x<100)
        {
           if(can1.write(esquerda))
            {
                pc.printf("Esquerda");
            }
            else
            {
                pc.printf("mensagem NAO enviada\n"); 
            }
        }
        
        if (x>900)
        {
           if(can1.write(direita))
            {
                pc.printf("Direita");
            }
            else
            {
                pc.printf("mensagem NAO enviada\n"); 
            }
        }
        
         if (y<100)
        {
           if(can1.write(baixo))
            {
                pc.printf("Baixo");
            }
            else
            {
                pc.printf("mensagem NAO enviada\n"); 
            }
        }
        
        if (y>900)
        {
           if(can1.write(cima))
            {
                pc.printf("Cima");
            }
            else
            {
                pc.printf("mensagem NAO enviada\n"); 
            }
        }
        
        //faz a comparação da msg escrevida com as msgs criadas. quando for igual, ou seja, qndo o valor de uma msg for igual ao de cima, baixo, esq e dir, printa no LCD

        if (can1.read(recebida))
        {
            pc.printf("mensagem recebida %x\n", recebida.data[0]); 
        }
        
        if (recebida.data[0] == 0x55)
        {
            lcd.locate(0,0);
            lcd.printf("Cima     ");
        }
        
        if (recebida.data[0] == 0x54)
        {
            lcd.locate(0,0);
            lcd.printf("Baixo     ");
        }
        
        if (recebida.data[0] == 0x53)
        {
            lcd.locate(0,0);
            lcd.printf("Esquerda     ");
        }
        
        if (recebida.data[0] == 0x52)
        {
            lcd.locate(0,0);
            lcd.printf("Direita     ");
        }
        recebida.data[0] = 0;  //limpa as variaveis
        
        
    } 
      
}
      
            