#include "mbed.h"
#include "Speaker.h"
 
InterruptIn MagSense(p16);
DigitalOut Blink(LED4);
Speaker Interrupt(p21);
 
void flip() {
    
    while(1){
        
        Interrupt.PlayNote(969, 0.1, 1.0);      // When contact is broken, interrupt the main program and sound the alarm
        Interrupt.PlayNote(800, 0.1, 1.0);
    }
           
}
 
int main() {
    MagSense.rise(&flip);  // attach the address of the flip function to the rising edge
    while(1) {           // Do this until contact is broken
        Blink = !Blink;
        wait(0.25);
    }
}