#include "mbed.h"
#include "Speaker.h"

AnalogIn magsense(p16);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

Serial pc(USBTX,USBRX);           // Optional, this is just to provide feedback.
Speaker mySpeaker(p21);           // Create a Speaker object

int sensor = 0;     


int main() {
    
    while(1) {
        
    sensor=magsense.read();     // Read in the sensor value
    
        if(sensor!=0){            //If the contact is broken, turn on the LED's and sound the alarm!
            
            myled1=1;
            myled2=1;
            myled3=1;
            myled4=1;
            
            mySpeaker.PlayNote(1200, 0.1, 1.0);
            mySpeaker.PlayNote(1205, 0.1, 1.0);
            mySpeaker.PlayNote(1210, 0.1, 1.0);
            
            pc.printf("Value %d,", sensor);
        }
        
        else {
            
            myled1=0;
            myled2=0;
            myled3=0;
            myled4=0;
        }
        
    }
}
