#ifndef MBED_FLASHER_H
#define MBED_FLASHER_H 
#include "mbed.h"

/** Magnetic Contact Sensor control class, based on AnalogIn / InterruptIn
 *
 * Example:
 * @code
 * // Continuously sweep the servo through it's full range
 * #include "mbed.h"
 * #include "MagSensor.h"
 *
 * MagSensor magsense(p21);
 *
 * DigitalOut myled1(LED1);
 *
 * int main() {
 *
 *  myled1=0;
 *
 *  while(1) {
 *
 * // Read in the sensor value
 *
 *      myled1 = magsense.read();
 *
 *   // When contact is broken, turn LED1 on. When contact is present, turn LED off
 *
 *  }
 * }
 * @endcode
 */

 
class MagSensor {
public:
    MagSensor(PinName pin);
    MagSenseInt(PinName pin);
    
  
private:  
    AnalogIn _pin;
    InterruptIn _pin2
};
 
#endif
