#ifndef HCSR04_H
#define HCSR04_H
 
#include "mbed.h"
 
 
 
/** 
 * Sonar HC-SR04 example.
 * @code
 * #include "mbed.h"
 * #include "HCSR04.h"
 *
 * DigitalOut myled(LED1);
 * Serial pc(USBTX,USBRX);     
 *
 * HCSR04 sonar(PTD5, PTA13);
 *
 * int main() {
 *     while(1) {
 *         printf("Distancia detectada pelo sensor Frente %.2f cm \n", sonar.getCm()); 
 *         wait_ms(1000);
 *     }
 * }
 *
 * @endcode
*/
 
class HCSR04 {    
    public:    
        /** Constructor, create HCSR04 instance 
          *
          * @param trigger TRIG pin
          * @param echo ECHO pin
          */
        HCSR04(PinName trigger, PinName echo);
 
        /** It make a reading of the sonar Faz uma leitura do sonar
          * 
          * @returns Tempo do pulso echo em microsegundos*/
        float readEcho(void);
        
        /** It messures the distance in centimeter "cm" 
          *
          *@returns Distance in centimeter
          */
        float getCm(void);
        
        /** Mede a distência em polegadas "in" 
          *
          *@returns Distência em in*/
        float getIn(void);
        
    private:
        float tdist;        //Leitura do tempo transcorrido
        float distcm;       //Guarda o valor da distanciância em centímetros
        float distin;       //Guarda o valor da distência em polegadas
        
        DigitalOut _t;      //Configuração do pino de Trigger  
        DigitalIn _e;       //Configuração do pino de Echo
        Timer _tempo;       //Cria um objeto timer
        
};
 
#endif