/***********************************
name:   ur_Bertl.h      Version: 1.0
author: PE HTL BULME
email:  pe@bulme.at
description:
    Definition portion of the class ur_Bertl The Robot


***********************************/
#include "mbed.h"

#ifndef UR_BERTL_H
#define UR_BERTL_H

#define LEFTSENSOR P1_12
#define RIGHTSENSOR P1_13
/********************************************//**
 name:   ur_Bertl.h 
 version: 1.0
 author: PE HTL BULME.
 email:  pe@bulme.at
 description:
    Definition and documentation portion of the class ur_Bertl The Robot.
   
***********************************************/
/** 
@code
//
@endcode

Example motor sensor test:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"
 
int main()
{
    ur_Bertl karel(LEFTSENSOR);  // RIGHTSENSOR

    while(true) {
        karel.NibbleLeds(karel.Read());
    }
}
@endcode

Example moving the robot around:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"

int main()
{
    ur_Bertl karel;
    
    while(karel.WaitUntilButtonPressed()){}
    //karel.Move();
    karel.TurnLeft();
    karel.ShutOff();
}
@endcode

Example LEDs:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"

int main()
{
   ur_Bertl karel;
   
   while(karel.WaitUntilButtonPressed()){}

   karel.TurnLedOn(LED_FL1 | LED_FR1);  // see const.h
   wait(1);
   karel.TurnLedOn(0xFF);               // or use hex
   wait(1);
   karel.RGBLed(1,0,0);     // red
   wait(1);
   karel.RGBLed(0,1,0);     // green
   wait(1);
   karel.RGBLed(0,0,1);     // blue
   karel.BlueLedsON();
   karel.NibbleLeds(karel.Read());
   wait(1);
   karel.BlueLedsOFF();
   karel.TurnLedOff(0xFF);
   karel.ShutOff();
} 
@endcode
 */
class ur_Bertl
{
protected:
    int beepersInBag;       /**< how many beepers does the robot have in his bag*/
    char cmd[3];            /**< I2C command */
    int16_t btns;           /**< which button is pressed */
    InterruptIn _interrupt; /**< interrupted used*/
    volatile int _count;    /**< values of motor sensor*/

    /**
    protected methodes for internal purposes only
    */
    void increment();       /**< ISR to increment sensor values of motor */
    bool backIsClear();     /**< don't now for what */
    bool frontButtonPressed();/**< TRUE if a a button on the front of Robot is pressed else FALSE */
    void error();           /**< Error: stops the robot and all LEDs are blinking*/

public:
    ur_Bertl();                 /**< default constructor; you have to define constants in config.h such as SPEED, DISTANCE or ANGLE*/
    ur_Bertl(PinName pin);      /**< parameterized constructor; on what pin should the interrupt work; SPEED, DISTANCE or ANGLE have to bee defined in config.h */

    void Move();                /**< Robot moves one turn as much as the constant DISTANCE; if one of the buttons fire --> Error()*/      
    void TurnLeft();            /**< Robot turns left as much as the constant ANGLE*/      
    void PutBeeper();           /**< if Robot has any Beepers in his bag he can put one or more Beeper; if not --> Error(()*/  
    void PickBeeper();          /**< if Robot stands on a black item he can pick one or more Beeper (max. 16 --> Error()); if not --> Error()*/   
    void NibbleLeds(int value); /**< methode for the 4 (half byte) yellow LEDs at the back left side */
    void TurnLedOn(int16_t led);/**< turns the specified one or more LEDs ON; description and name in const.h, such as LED_FL1 = 0x01; front LED white */
    void TurnLedOff(int16_t led);/**< turns the specified one or more LEDs OFF; description and name in const.h, such as LED_FL1 = 0x01; front LED white */
    bool WaitUntilButtonPressed();  /**< wait until any button is pressed at the robot */
    void RGBLed(bool red, bool green, bool blue); /**<RGB Led with red, green and blue component of the Color */
    void BlueLedsOFF();         /**< OFF all blue LEDs which are on the same Port 1_28 */   
    void BlueLedsON();          /**< ON all blue LEDs which are on the same Port 1_28 */   
    void ShutOff();             /**<  turnes the robot off */
    int Read();
};
#endif