#include "mbed.h"
#include "QEI.h"
#include "HIDScope.h"
HIDScope scope(2); // We’re going to send 2 channels of data
Ticker AInTicker;
AnalogIn pot(A1);

QEI Encoder(D13,D12,NC,32);


volatile float x;
volatile float x_prev =0; 
volatile float y; // filtered 'output' of ReadAnalogInAndFilter 
volatile float z;

void ReadAnalogInAndFilter()
{
        int n_rev= Encoder.getRevolutions();
        int n_pulse= Encoder.getPulses();
        
        x =  n_pulse*(360/32)-(32*n_rev) ; // Capture data        scope.set(0, x);   // store data in first element of scope memory
      //  y =    0;// averaging filter
        scope.set(1, x);  // store data in second element of scope memory
       // x_prev = x; // Prepare for next round
       // z= button1;
       // scope.set(0,z);
        scope.send(); // send what's in scope memory to PC
}

int main()
{
    AInTicker.attach(&ReadAnalogInAndFilter, 0.01);
    
    Encoder.reset();
    
    
    while (true) 
    {
        
        
        
        
       
    }
}

