#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"
#include "QEI.h"
#include "iostream"
class Motor {
  private:
    float velocity ; // acual velocity of motor in degrees/s
    float angle ;    // angle of the motor in degrees
    float frequency ;
    float sample_time;   // set sample time of  motor 
    float angle_prev;
    float safety_angle; //safety angle in degrees
    int POS , NEG;
    QEI _Encoder;
    DigitalOut _direction;
    PwmOut _PWM;
    
    
  public:
    Motor();
    Motor(float , PinName , PinName , PinName , PinName , PinName , int , float , int , float , float , int);
    void change_direction();
    void control_velocity(float);
    void set_period(float);
    void set_angle();               //needs to be updated 
    void set_velocity();            //needs to be updated
    
    float get_velocity();
    float get_period();
    
    
};

#endif