#include "mission.h"
#include <iostream>
#include <sstream>

namespace VivesCityGame
{
    std::string Mission::get_type()
    {
        return type;
    }

    int Mission::get_id()
    {
        return id;
    }

    std::string Mission::get_message()
    {
        return message;
    }

    std::string Mission::get_hint()
    {
        return hint;
    }

    bool Mission::get_deadline()
    {
        return deadline;
    }

    int Mission::get_deadlineTime()
    {
        return deadlineTime;
    }

    double Mission::get_latitude()
    {
        return latitude;
    }

    double Mission::get_longitude()
    {
        return longitude;
    }

    int Mission::get_radius()
    {
        return radius;
    }

    void Mission::from_json(MbedJSONValue& json)
    {
        type = json["type"].get<std::string>();
        id = json["id"].get<int>();
        message = json["message"].get<std::string>();
        hint = json["hint"].get<std::string>();
        deadline = json["deadline"].get<bool>();
        deadlineTime = json["deadlineTime"].get<int>();
        latitude = json["latitude"].get<double>();
        longitude = json["longitude"].get<double>();
        radius = json["radius"].get<int>();
    }

    std::string Mission::to_string(void)
    {
        /*
        std::stringstream ss;

        ss << "Type: " << get_type();
        ss << "Id: " << get_id();
        ss << "Message: " << get_message();
        ss << "Hint: " << get_hint();
        ss << "Deadline: " << get_deadline();
        ss << "DeadlineTime: " << get_deadlineTime();
        ss << "latitude: " << get_latitude();
        ss << "Longitude: " << get_longitude();
        ss << "Radius: " << get_radius();

        return ss.str();
        */
        
        return "mission";
    }
};
