#define HIGH 1
#define LOW 0
#include "mbed.h"
#include <string>
typedef bool boolean;
typedef std::string String;
#include "nRF24L01P.h"

char txdata[32] ;
float LX;
float LY;
float RX;
float RY;
int Yaw;
int Roll;
int Pitch;
int Power;
long CycleCount;
int Yaw_config;
int Pitch_config;
int Roll_config;
char i;
long SendCount;

#define NRF24_TRANSFER_SIZE 32
nRF24L01P nrf24_PB_15(PB_15,PB_14,PB_13,PB_6,PB_5,PB_7);
Serial Serial_1(PA_9,PA_10);
InterruptIn intrPB_0(PB_0);
InterruptIn intrPB_1(PB_1);
InterruptIn intrPB_3(PB_3);
InterruptIn intrPB_4(PB_4);
InterruptIn intrPA_5(PA_5);
InterruptIn intrPB_10(PB_10);
DigitalOut myDigitalOutPA_7(PA_7);
AnalogIn myIOPA_0(PA_0);
AnalogIn myIOPA_1(PA_1);
AnalogIn myIOPA_2(PA_2);
AnalogIn myIOPA_3(PA_3);
Ticker tick742927;
DigitalOut myDigitalOutPA_6(PA_6);

void intrPB_0_interrupt_fun() {
Pitch_config = Pitch_config + 1;
}

void intrPB_1_interrupt_fun() {
Pitch_config = Pitch_config - 1;
}

void intrPB_3_interrupt_fun() {
Roll_config = Roll_config + 1;
}

void intrPB_4_interrupt_fun() {
Roll_config = Roll_config - 1;
}

void intrPA_5_interrupt_fun() {
Yaw_config = Yaw_config + 1;
}

void intrPB_10_interrupt_fun() {
Yaw_config = Yaw_config - 1;
}

void tick742927_handle() {
SendCount = SendCount + 1;
myDigitalOutPA_7.write((CycleCount % 2 == 0));
LX = myIOPA_0.read();
LY = myIOPA_1.read();
RX = myIOPA_2.read();
RY = myIOPA_3.read();
Power = (1 - LY) * 1000 + 1000;
Yaw = (1 - LX) * 1000 + 1000;
Pitch = (1 - RY) * 1000 + 1000;
Roll = (1 - RX) * 1000 + 1000;
txdata[0] = 36;
txdata[1] = 77;
txdata[2] = 60;
txdata[3] = 16;
txdata[4] = 105;
txdata[5] = Roll % 256;
txdata[6] = Roll / 256;
txdata[7] = Pitch % 256;
txdata[8] = Pitch / 256;
txdata[9] = Yaw % 256;
txdata[10] = Yaw / 256;
txdata[11] = Power % 256;
txdata[12] = Power / 256;
txdata[13] = 0;
txdata[14] = 0;
txdata[15] = 0;
txdata[16] = 0;
txdata[17] = 0;
txdata[18] = 0;
nrf24_PB_15.write( NRF24L01P_PIPE_P0, txdata, NRF24_TRANSFER_SIZE);
}


int main() {
nrf24_PB_15.powerUp();
nrf24_PB_15.setTransferSize( NRF24_TRANSFER_SIZE );
nrf24_PB_15.setReceiveMode();
nrf24_PB_15.setRxAddress(1ull);
nrf24_PB_15.setTxAddress(1ull);
nrf24_PB_15.enable();

Serial_1.baud(9600);

intrPB_0.fall(&intrPB_0_interrupt_fun);
intrPB_0.mode(PullNone);
intrPB_1.fall(&intrPB_1_interrupt_fun);
intrPB_1.mode(PullNone);
intrPB_3.fall(&intrPB_3_interrupt_fun);
intrPB_3.mode(PullNone);
intrPB_4.fall(&intrPB_4_interrupt_fun);
intrPB_4.mode(PullNone);
intrPA_5.fall(&intrPA_5_interrupt_fun);
intrPA_5.mode(PullNone);
intrPB_10.fall(&intrPB_10_interrupt_fun);
intrPB_10.mode(PullNone);

tick742927.attach(&tick742927_handle,0.01);

Roll_config = 0;
Pitch_config = 0;
Yaw_config = 0;
CycleCount = 0;
SendCount = 0;
for (i = 1; i <= 32; i++) {
txdata[(i - 1)] = 0;
}
while (true) {
CycleCount = CycleCount + 1;
myDigitalOutPA_6.write((CycleCount % 2 == 0));
//for (i = 1; i <= 32; i++) {
//Serial_1.printf("%d ",txdata[(i - 1)]);
//}
//Serial_1.printf("Next\n");
}

}