#include "mbed.h"
#include "WIZnetInterface.h"
#include "MQTTSocket.h"
#include "MQTTClient.h"
#include "ETHW5500.h"
Serial pc(PA_2,PA_3);//串口
//W5500接线 mosi,miso,sclk,cs,reset
WIZnetInterface wiz(PA_7,PA_6,PA_5,PB_5,PB_4);
//WIZnetInterface wiz(PA_7,PA_6,PA_5,PB_6,PC_7);
DigitalIn BTN(PA_4);//按键
//节点名称任取
char *NODE_NAME="n_12345";
 //接在同一子网下的设备MAC地址必须不同
uint8_t mac_addr[6]={0x50,0x51,0x50,0x00,0x00,0x01};
char* URL="tdxls-iot.xicp.net"; //服务器地址
MQTTSocket sock;
MClient client(sock);
int main() {
   
   const char* actuators = "switch,int\n";
   const char* sensors = "analog,mV\n";
   pc.printf("Initing\n");
   Eth_Init(mac_addr);
   Eth_ConnetToSever(URL);
   Eth_Subscribe("control",NODE_NAME,"switch");
    
   Eth_Report("event",NODE_NAME,"online",NULL,0,false);
   Eth_Report("capability",NODE_NAME,"control",actuators,strlen(actuators),true);
   Eth_Report("capability",NODE_NAME,"values",sensors,strlen(sensors),true);
   bool btn = 0;
   while(1){
        bool newBTN = BTN;
        if(newBTN != btn){
            char buf[16];
            int value = newBTN ? 3300 : 0;
            sprintf(buf, "%d mV", value);
            Eth_Report("values",NODE_NAME,"analog",buf,strlen(buf),true);
            btn = newBTN;
        }else{
            wait(0.1);
        }
    }
}
