#include "ETHW5500.h"
#include "WIZnetInterface.h"
#include "MQTTSocket.h"
#include "MQTTClient.h"
//W5500接线 mosi,miso,sclk,cs,reset
//WIZnetInterface wiz(PA_7,PA_6,PA_5,PB_6,PC_7);
extern WIZnetInterface wiz;
extern Serial pc;
extern MQTTSocket sock;
extern MClient client;
void meta_report( const char *topic, 
                    const char* payload = NULL, size_t payload_len =    0, 
                    bool retain = false, MQTT::QoS qos = MQTT::QOS1){
    int ret = client.publish(topic, (void*)payload, payload_len, qos, retain);
    pc.printf("client.publish()=%d\r\n",ret);
}
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    char buf[64];
    int value, len = sizeof(buf)-1;
    if(message.payloadlen < len)
        len = message.payloadlen;
    memcpy(buf, message.payload, len);
    buf[len] = '\0';
    sscanf(buf, "%d", &value);
    pc.printf("received %d\r\n", value);
}

void Eth_Init(uint8_t *mac_addr)
{
    wiz.init(mac_addr);
    pc.printf("DHCP...\r\n");
    wiz.connect();
    pc.printf("IP: %s\r\n", wiz.getIPAddress());
}

int Eth_ConnetToSever(char* URL)
{
    int ret;
    int timecount=1;
    ret = sock.connect(URL,1883);
    //pc.printf("%d-th Server connetion attemp\n",timecount);
    while(ret!=0){
        timecount++;
        //pc.printf("%d-th Server connetion attemp\n",timecount);
        ret = sock.connect("tdxls-iot.xicp.net",1883);
        if(timecount>20){
            pc.printf("failed to connet Server,Please Check out and Reset\n");
            return 1;
        }
    }
    pc.printf("sock.connect()=%d\r\n",ret);
    
    ret = client.connect();
    if(ret != 0){
        pc.printf("MQTT connect failed\r\n");
        return 1;
    }
    pc.printf("client.connect()=%d\r\n",ret);
    return ret;
}

int Eth_Subscribe(const char* ns,const char *NODE_NAME, const char* type)
{
    int ret;
    char topic[64];
    sprintf(topic, "/%s/%s/%s", ns, NODE_NAME, type);
    //printf("topic=%s\r\n",topic);
    ret = client.subscribe(topic, MQTT::QOS1, messageArrived);    
    pc.printf("sock.subscribe()=%d\r\n",ret);
    return ret;
}
void Eth_Report(const char* ns,const char *NODE_NAME, const char* type,const char* payload = NULL, size_t payload_len = 0, 
                    bool retain = false)
{
        char topic[64];
        sprintf(topic, "/%s/%s/%s", ns, NODE_NAME, type);
        //printf("topic=%s\r\n",topic);
        meta_report(topic,payload,payload_len,retain);
}

 
