#define HIGH 1
#define LOW 0
#include "mbed.h"
#include "nRF24L01P.h"
#include "MPU6050.h"
#include <string>
typedef bool boolean;
typedef std::string String;

char rxdata[12] ;
float Yaw,Pitch,Roll,Power;
int Yaw_t;
int Pitch_t;
int Roll_t;
int Power_t;
long CycleCount;
long ReceiveCount;

#define NRF24_TRANSFER_SIZE 12
nRF24L01P nrf24_PB_15(PB_15,PB_14,PB_13,PB_6,PB_5,PB_7);
Serial Serial_1(PA_2,PA_3);
DigitalOut myDigitalOutPA_7(PA_7);
DigitalOut myDigitalOutPA_6(PA_6);
MPU6050 mpu6050(PB_9,PB_8);
int main() {
Serial_1.baud(9600);
Serial_1.printf("Init\n");
mpu6050.Init();

nrf24_PB_15.powerUp();
nrf24_PB_15.setTransferSize( NRF24_TRANSFER_SIZE );
nrf24_PB_15.setReceiveMode();
nrf24_PB_15.setRxAddress(12345ull);
nrf24_PB_15.setTxAddress(12345ull);
nrf24_PB_15.enable();



CycleCount = 0;
ReceiveCount = 0;
Serial_1.printf("Ready to Receive\n");
while (true) {
CycleCount = CycleCount + 1;

mpu6050.receiveData(&Yaw,&Pitch,&Roll);  //读取传感器姿态 
Serial_1.printf("Sensor Data: Yaw, Pitch, Roll: %.2f %.2f %.2f\n\r", Yaw, Pitch, Roll);

if (nrf24_PB_15.readable()) {
ReceiveCount = ReceiveCount + 1;
myDigitalOutPA_7.write((ReceiveCount % 2 == 0));
nrf24_PB_15.read( NRF24L01P_PIPE_P0, rxdata, NRF24_TRANSFER_SIZE);
if (rxdata[0] == 82) {
Power_t = rxdata[1];
Yaw_t = rxdata[2] - 45;
Pitch_t = rxdata[3] - 45;
Roll_t = rxdata[4] - 45;
Serial_1.printf("Target: Power=%d, Yaw=%d, Pitch=%d, Roll=%d \n",Power_t,Yaw_t,Pitch_t,Roll_t);
}
}
myDigitalOutPA_6.write((CycleCount % 2 == 0));
wait(0.01);
}

}