#ifndef __USEFUL_FUNC_H
#define __USEFUL_FUNC_H

#ifdef ENABLE_ESP8266
#include "esp8266.h"
#endif	// ENABLE_ESP8266

#include "mbed.h"
#include <vector>
#include <string>

#ifdef ENABLE_FILESYSTEM
void read_file_names(const char *dir, vector<string> & filenames);
#endif // ENABLE_FILESYSTEM

#ifdef ENABLE_ESP8266
void send_file_names(Esp8266 & client, vector<string> & filenames, const char * publish_topic);
void mqtt_client_init(
	Esp8266 & client, 
	const char* device_name, 
	const char* publish_topic[][2], 
	const char* subscribe_topic[][2]
);
#endif	// ENABLE_ESP8266

#endif	// !__USEFUL_FUNC_H

