#include "sensors.h"
#include "ir.h"
#include "irda.h"
#include "eeprom.h"
#include <string.h>

#define IR_DATA_BYTES     112
#define TOTAL_IR_CHANNELS 18



//static uint16_t irData[TOTAL_IR_CHANNELS][IR_DATA_BYTES/sizeof(uint16_t)];
static czx_vu8 irda_data[IR_DATA_BYTES];
IRDA_io_t *IRDA_IO;
static EEPROM *pEEPROM;

void IR_Init(PinName scl, PinName sda, PinName busy, EEPROM &eeprom)
{
		if(IRDA_IO)
				delete IRDA_IO;
		IRDA_IO = new IRDA_io_t(scl, sda, busy);
		pEEPROM = &eeprom;
    IRDA_INIT();
}

int IR_StartLearning(uint8_t channel)
{
    MSG_DBG("Learning channel %d", channel);
		if(!IRDA_IO)
				return -1;
    if(channel >= TOTAL_IR_CHANNELS)
        return -1;

    IRDA_learn_start();
    while(!IRDA_BUSY_S()){
        //LED_BLUE(false);
        wait_ms(200);
        //LED_BLUE(true);
        wait_ms(200);
    }
    uint8_t len = IRDA_learn_data_in_out(irda_data);
    MSG_DBG("Learned, length=%d", len);
    if(!len)
        return len;

		/*
    FlashEEP_WriteHalfWords(
        (uint16_t*)irda_data,
        sizeof(irda_data)/sizeof(uint16_t),
        (uint32_t)irData[channel]
        );
		*/
		
		/*
		memcpy((void*)irData[channel], (void*)irda_data, sizeof(irda_data));
		*/
		
		pEEPROM->write(channel*IR_DATA_BYTES, (void*)irda_data, IR_DATA_BYTES);

    return len;
}

bool IR_Emit(uint8_t channel)
{
    MSG_DBG("Emit channel %d", channel);
		if(!IRDA_IO)
				return false;
    if(channel >= TOTAL_IR_CHANNELS)
        return false;
		/*
    IRDA_tx_data((czx_vu8*)irData[channel],sizeof(irData[channel]));
		*/
		
		/*
		memcpy((void*)irda_data, (void*)irData[channel], sizeof(irda_data));
		*/
		
		pEEPROM->read(channel*IR_DATA_BYTES, (void*)irda_data, IR_DATA_BYTES);

    IRDA_tx_data((czx_vu8*)irda_data, sizeof(irda_data));

    MSG_DBG("Emitted");

    return true;
}


