#ifndef LD3320_H
#define LD3320_H

#include "mbed.h"

#define uint8 unsigned char
#define SPI_MODE_MASK 0x0C  // CPOL = bit 3, CPHA = bit 2 on SPCR
#define MIC 0x0b
#define MONO 0x23
#define uint8 unsigned char
#define CLK_IN   	     24///频率
#define PLL_11			(uint8)((CLK_IN/2.0)-1)
#define PLL_ASR_19 		(uint8)(CLK_IN*32.0/(PLL_11+1) - 0.51)
#define PLL_ASR_1B 		0x48
#define PLL_ASR_1D 		0x1f


//	以下五个状态定义用来记录程序是在运行ASR识别过程中的哪个状态
#define LD_ASR_NONE				0x00	//	表示没有在作ASR识别
#define LD_ASR_RUNING			0x01	//	表示LD3320正在作ASR识别中
#define LD_ASR_FOUNDOK			0x10	//	表示一次识别流程结束后，有一个识别结果
#define LD_ASR_FOUNDZERO 		0x11	//	表示一次识别流程结束后，没有识别结果
#define LD_ASR_ERROR	 		0x31	//	表示一次识别流程中LD3320芯片内部出现不正确的状态


// #define MEGA_SOFT_SPI 0
// #if MEGA_SOFT_SPI && (defined(__AVR_ATmega1280__)||defined(__AVR_ATmega2560__))
#define SOFTWARE_SPI
// #endif  // MEGA_SOFT_SPI




class VoiceRecognition
{

public:
    VoiceRecognition(PinName cs, PinName miso, PinName mosi, PinName sck, PinName rst);

    void reset();
    void init(uint8_t mic = MIC);
    void ASR_init();
    unsigned char start();
    void addCommand(const char *pass, int num);
    int read();

    void micVol(uint8_t vol);
    void speechEndpoint(uint8_t speech_endpoint_);
    void speechStartTime(uint8_t speech_start_time_);
    void speechEndTime(uint8_t speech_end_time_);
    void voiceMaxLength(uint8_t voice_max_length_);
    void noiseTime(uint8_t noise_time_);
private:
    void addAllCommands();
    void doAddCommand(const char *pass, int num);
    void writeReg(unsigned char address, unsigned char value);
    unsigned char readReg(unsigned char address);
    void spiDelay(int _time);
    uint8_t transfer(uint8_t _data);
    void cSHigh(void);
    void cSLow(void);
    void update();
    void restart();
    int check_b2();

    uint8_t g_Mic;
    DigitalOut RSTB;//RSTB引脚定义
    DigitalOut CS;//CS引脚定义
//------------------------------------------------------------------------------
// SPI pin definitions
//
#ifndef SOFTWARE_SPI
// hardware pin defs

    uint8_t LD_CHIP_SELECT_PIN = SS;
    // The following three pins must not be redefined for hardware SPI.
    /** SPI Master Out Slave In pin */
    uint8_t SPI_MOSI_PIN = MOSI;
    /** SPI Master In Slave Out pin */
    uint8_t SPI_MISO_PIN = MISO;
    /** SPI Clock pin */
    uint8_t SPI_SCK_PIN = SCK;

    /** optimize loops for hardware SPI */
#define OPTIMIZE_HARDWARE_SPI

    /** SPI chip select pin */
    DigitalOut LD_CHIP_SELECT_PIN;
#else  // SOFTWARE_SPI
    // define software SPI pins
    /** SPI Master Out Slave In pin */
    DigitalOut SPI_MOSI_PIN;
    /** SPI Master In Slave Out pin */
    DigitalIn SPI_MISO_PIN;
    /** SPI Clock pin */
    DigitalOut SPI_SCK_PIN;
#endif  // SOFTWARE_SPI
    uint8_t MIC_VOL;
    uint8_t speech_endpoint;
    uint8_t speech_start_time;
    uint8_t speech_end_time;
    uint8_t voice_max_length;
    uint8_t noise_time;
    //uint8_t ASR_time最长时间
    uint8_t asr_state;
    uint8_t readnum;
    uint8_t instance_id;
    const char* asr_cmd_str[8];
    uint8_t asr_cmd_number[8];
    static bool SPI_inited;
    static uint8_t n_instance;
};
#endif

