/*****************************************************
*
*制作人：
*
* 单位:    深圳市宏芯达科技有限公司
*
* 部门:   技术部
*
* 目的：  STM32与HXD019通讯
*
* 日期:   2013年夏
******************************************************/

#ifndef __IRDA_H__
#define __IRDA_H__
#include "irdaDataType.h"
#include "mbed.h"

//#define DEBUG

struct IRDA_io_t{
	DigitalInOut SCL;
	DigitalInOut SDA;
	DigitalInOut Busy;
	
	IRDA_io_t(PinName scl, PinName sda, PinName busy):
		SCL(scl,PIN_OUTPUT,OpenDrain,1),SDA(sda,PIN_OUTPUT,OpenDrain,1),Busy(busy,PIN_OUTPUT,OpenDrain,1){}
};

extern IRDA_io_t *IRDA_IO;
//#define DEBUG
#ifdef DEBUG
extern Serial Serial_2;
#define MSG_DBG(fmt, ...) Serial_2.printf("[DBG]%s:" fmt "\r\n", __func__, ##__VA_ARGS__)
#else
#define MSG_DBG(fmt, ...)
#endif

#define     IRDA_NO_ERROR   0

#define     IRDA_DELAY_40US     4
#define     IRDA_DELAY_20MS     20

#define     IRDA_SCL_H()    IRDA_IO->SCL.write(1)
#define     IRDA_SCL_L()    IRDA_IO->SCL.write(0)
#define     IRDA_SET_SCL_OUT()    IRDA_IO->SCL.output()
#define     IRDA_SET_SCL_IN()     IRDA_IO->SCL.input()
#define     IRDA_SDA_H()    IRDA_IO->SDA.write(1)
#define     IRDA_SDA_L()    IRDA_IO->SDA.write(0)
#define     IRDA_SET_SDA_OUT()    IRDA_IO->SDA.output()
#define     IRDA_SET_SDA_IN()     IRDA_IO->SDA.input()
#define     IRDA_GET_ACK()  IRDA_IO->SDA.read()
#define     IRDA_GET_DATA() IRDA_IO->SDA.read()
#define     IRDA_BUSY_H()   IRDA_IO->Busy.write(1)
#define     IRDA_BUSY_L()   IRDA_IO->Busy.write(0)
#define     IRDA_BUSY_S()   IRDA_IO->Busy.read()
#define     IRDA_SET_BUSY_OUT()   IRDA_IO->Busy.output()
#define     IRDA_SET_BUSY_IN()    IRDA_IO->Busy.input()

//#define         IRDA_LED_OFF()  GPIO_SetBits(GPIOB,GPIO_Pin_0)
//#define         IRDA_LED_ON()   GPIO_ResetBits(GPIOB,GPIO_Pin_0)


void    IRDA_INIT();
void    IRDA_delay_10us(czx_vu32 t);
void    IRDA_delay_1ms(czx_vu32 t);
//void    IRDA_SET_SDA_OUT(void);
//void    IRDA_SET_SDA_IN(void);
//void    IRDA_SET_SCL_OUT(void);
//void    IRDA_SET_BUSY_IN(void);
//void    IRDA_SET_BUSY_OUT(void);
czx_u8  IRDA_getACKsign(void);
void    IRDA_sendACKsign(void);

czx_u16 IRDA_open(void);
#define IRDA_close()  IRDA_open()

czx_u16 IRDA_start(void);
czx_u16 IRDA_stop(void);
czx_u16 IRDA_write(czx_vu8 d);
void    IRDA_tx_data(czx_vu8 *d, czx_vu8 len); //发送数据
czx_u16 IRDA_read(czx_vu8 *d);
void    IRDA_learn_start(void);
czx_u8  IRDA_rx_data(czx_vu8 *d);
czx_u8  IRDA_learn_data_in_out(czx_vu8*learn_data_out);


//czx_vu8       IRDA_learn_data_in_out(czx_vu8  *pd);//学习遥控
#endif // __IRDA_H__

