#pragma once

#include <cstdlib>
#include <string>

namespace std{
static inline int stoi(const string &s) {
    return atoi(s.c_str());
}
static inline long stol(const string &s) {
    return atol(s.c_str());
}
static inline float stof(const string &s) {
    return float(atof(s.c_str()));
}
#define _c_to_string(fmt,val) { \
    char buf[16];\
    snprintf(buf, sizeof(buf), fmt, val);\
    return string(buf);\
}
static inline string to_string(string s) {
    return s;
}
static inline string to_string(const char* cs) {
    return string(cs);
}
static inline string to_string(bool v) {
    _c_to_string("%d", (int)v);
}
static inline string to_string(char v) {
    _c_to_string("%c", v);
}
static inline string to_string(int v) {
    _c_to_string("%d", v);
}
static inline string to_string(long v) {
    _c_to_string("%ld", v);
}
static inline string to_string(float v) {
    _c_to_string("%f", v);
}
}

inline bool  _p(bool x) { return x; }
inline char  _p(char x) { return x; }
inline int   _p(int x) { return x; }
inline long  _p(long x) { return x; }
inline float _p(float x) { return x; }
inline void* _p(void* x) { return x; }
inline const char* _p(const std::string &x) { return x.c_str(); }

