 //.............................................................................................................................................................................................
//                                                                      PROGRAMA DE LEITURA DE DADOS DA IMU6050
//.............................................................................................................................................................................................
// Autor: FabiÃ¡n Barrera Prieto
// Curso: Mestrado em Sistemas MecatrÃ´nicos
// Instituicao: Universidade de BrasÃ­lia
// Data: 17/04/2017
//.............................................................................................................................................................................................

//----------------------------------------------------------------------------
//                                BIBLIOTECAS
//----------------------------------------------------------------------------
#include "mbed.h"

// Enderecos dos escravos
#define    MPU6500_address            0xD0 // 7 bit I2C EndereÃ§o da MPU6500 (giroscÃ³pio e acelerÃ´metro)

// Escalas do girÃ´scopio
#define    GYRO_FULL_SCALE_250_DPS    0x00 // SCALE_250 (Â°/s) = 0 (0x00 = 000|00|000)
#define    GYRO_FULL_SCALE_500_DPS    0x08 // SCALE_500 (Â°/s) = 1 (0x08 = 000|01|000)
#define    GYRO_FULL_SCALE_1000_DPS   0x10 // SCALE_1000 (Â°/s) = 2 (0x10 = 000|10|000)
#define    GYRO_FULL_SCALE_2000_DPS   0x18 // SCALE_2000 (Â°/s) = 3 (0x18 = 000|11|000)

// Escalas do acelerÃ´metro
#define    ACC_FULL_SCALE_2_G        0x00 // SCALE_2_G (g) = 0 (0x00 = 000|00|000)
#define    ACC_FULL_SCALE_4_G        0x08 // SCALE_4_G (g) = 1 (0x08 = 000|01|000)
#define    ACC_FULL_SCALE_8_G        0x10 // SCALE_8_G (g) = 2 (0x10 = 000|10|000)
#define    ACC_FULL_SCALE_16_G       0x18 // SCALE_16_G (g) = 3 (0x18 = 000|11|000)

// Escalas de conversao (As taxas de conversÃ£o sÃ£o especificadas na documentaÃ§Ã£o)
#define SENSITIVITY_ACCEL     2.0/32768.0             // Valor de conversÃ£o do AcelerÃ´metro (g/LSB) para 2g e 16 bits de comprimento da palavra
#define SENSITIVITY_GYRO      250.0/32768.0           // Valor de conversÃ£o do GirÃ´scopio ((Â°/s)/LSB) para 250 Â°/s e 16 bits de comprimento da palavra
#define SENSITIVITY_TEMP      333.87                  // Valor de sensitividade do Termometro (Datasheet: MPU-9250 Product Specification, pag. 12)
#define TEMP_OFFSET           21                      // Valor de offset do Termometro (Datasheet: MPU-9250 Product Specification, pag. 12)
#define SENSITIVITY_MAGN      (10.0*4800.0)/32768.0   // Valor de conversÃ£o do MagnetÃ´metro (mG/LSB) para 4800uT, 16 bits de comprimento da palavra e conversao a Gauss (10mG = 1uT)

//----------------------------------------------------------------------------
//                           DECLARACAO DE VARIAVEIS
//----------------------------------------------------------------------------

// Valores "RAW" de tipo inteiro
int16_t raw_accelx, raw_accely, raw_accelz;
int16_t raw_gyrox, raw_gyroy, raw_gyroz;
int16_t raw_temp;
// Valores "RAW" de tipo float
float Raw_accelx, Raw_accely, Raw_accelz;
float Raw_gyrox, Raw_gyroy, Raw_gyroz;
//
// Valores de "offsets" de tipo float 
float offset_accelx = -586.00, offset_accely = -604.00, offset_accelz = 17320.00;
float offset_gyrox = -192.50, offset_gyroy = -19.00, offset_gyroz = -16.00;
 //
 
// SaÃ­das nao calibradas
float accelx, accely, accelz;
float gyrox, gyroy, gyroz;
float temp;

// SaÃ­das calibradas
float Accelx, Accely, Accelz;
float Gyrox, Gyroy, Gyroz;

// Bytes
char cmd[2];
char data[1];
char GirAcel[14];

float buffer[500][8];
int i;
Timer t; //Cria-se o objeto do temporizador
float timer=0,t_fin=10.0,cont_timer=0.0;
//.....................................................................
//                        Inicializacao I2C
//..................................................................... 
Serial pc(SERIAL_TX, SERIAL_RX);
I2C i2c(PB_9, PB_8 );//SDA,SCL

//DigitalOut myled(LED1);

int main(){
    // Desativa modo de hibernaÃ§Ã£o do MPU6050
    cmd[0] = 0x6B;
    cmd[1] = 0x00;
    i2c.write(MPU6500_address, cmd, 2);
    /*
    pc.printf("TESTE DE CONEXAO PARA O GIROSCOPIO E O ACELEROMETRO \n\r");
    //.....................................................................
    //        Quem sou eu para a MPU6050 (giroscÃ³pio e acelerÃ´metro)
    //.....................................................................
    pc.printf("1. Teste de conexao da MPU6050... \n\r"); // Verifica a conexao
    cmd[0] = 0x75;
    i2c.write(MPU6500_address, cmd, 1);
    i2c.read(MPU6500_address, data, 1);
    if (data[0] != 0x68) { // DEFAULT_REGISTER_WHO_AM_I_MPU6050 0x68
      pc.printf("Erro de conexao com a MPU6050 \n\r");
      pc.printf("Opaaa. Eu nao sou a MPU6050, Quem sou eu? :S. I am: %#x \n\r",data[0]);
      pc.printf("\n\r");
      while (1);
    }else{
      pc.printf("Conexao bem sucedida com a MPU6050 \n\r");
      pc.printf("Oi, tudo joia?... Eu sou a MPU6050 XD \n\r");
      pc.printf("\n\r");
    }
    wait(0.1);
      */
    // Configura o GirÃ´scopio (Full Scale Gyro Range  = 250 deg/s)
    cmd[0] = 0x1B; //GYRO_CONFIG 0x1B //Registrador de configuracao do GirÃ´scopio
    cmd[1] = 0x00;
    i2c.write(MPU6500_address, cmd, 2);                //gyro full scale 250 DPS
    // Configura o AcelerÃ´metro (Full Scale Accelerometer Range  = 2g)
    cmd[0] = 0x1C; // ACCEL_CONFIG 0x1C //Registrador de configuracao do AcelerÃ´metro
    cmd[1] = 0x00;
    i2c.write(MPU6500_address, cmd, 2);                //ACC fullsclae 2G
    wait(0.01);
    
    
    while(1) {
        //.................ConstrucciÃ³n de la mediciÃ³n de los valores .................. 
        if(pc.readable()){
                if(pc.getc()=='H'){
                    for(i=0; i<100;i++){
                    cmd[0]=0x3B;
                    i2c.write(MPU6500_address, cmd, 1);            //Escritura del registro de inicio
                    i2c.read(MPU6500_address, GirAcel, 14);    //Lectura en rafaga de los valores de la MPU
                    t.reset();
                    t.start();
                    raw_accelx = GirAcel[0]<<8 | GirAcel[1];    
                    raw_accely = GirAcel[2]<<8 | GirAcel[3];
                    raw_accelz = GirAcel[4]<<8 | GirAcel[5];
                    raw_temp = GirAcel[6]<<8 | GirAcel[7];
                    raw_gyrox = GirAcel[8]<<8 | GirAcel[9];
                    raw_gyroy = GirAcel[10]<<8 | GirAcel[11];
                    raw_gyroz = GirAcel[12]<<8 | GirAcel[13];
                    wait_us(8380);
                    t.stop();
                    timer=t.read();
            
                    pc.printf("%d %.2f %.2f %.2f %.2f %.2f %.2f %.2f \n", i, timer ,(float)raw_accelx,(float)raw_accely,(float)raw_accelz,(float)raw_gyrox,(float)raw_gyroy,(float)raw_gyroz);
                   
                    
//offset_accelx = 294.00, offset_accely = 110.00, offset_accelz = 17452.00, offset_gyrox = -184.50, offset_gyroy = -4.00, offset_gyroz = -24.50 
               }
            }
        }
    }
}