#include "Controller.h"

int main() {
    pc.baud(115200);
    initMotors();
    initControllers();
    calibratePower(); // store max amplitude each emg signal

    while(true)
    {
        calibrate(); // calibrate position
        while(!button){} // button not pressed is true, this is here to make sure that the it will only go run if you have let go of the button and calibrated
        run();
    }
}

void run() 
{
    motorControl.attach(&setUpdate_flag, RATE); // rate =0.001
    while(button) // button not presseed
    {
        if(update_flag) //
        { 
            // returns filtered value
            r = signal.readValue(1); 
            l = signal.readValue(2);         
            u = signal.readValue(3);
            d = signal.readValue(4);
            
            pc.printf("r : %f \n\r", r);
            pc.printf("l : %f \n\r", l);           
            // calculate r,l,u,d relative to the max [0,1]
            percentageR = r/rMax;
            percentageL = l/lMax;
            percentageU = u/uMax;
            percentageD = d/dMax;
            
            // ignore the weaker signal,motorValue calculation, threshold set
            if ( percentageR > percentageL)
            { // horizontal speed request
                motorValueX = percentageR;
            }   
            else 
            {
                motorValueX = -percentageL;
            }
            
            if (percentageU > percentageD) // vertical speed request
            { 
                motorValueY = percentageU;
            }
               
            else 
            {
                motorValueY = -percentageD;
            }
            
            // current pulses
            xPulses = X_Motor.getPulses();
            yPulses = Y_Motor.getPulses();
           
            //edge detection
            if ((xPulses > (x_max-margin)) && (motorValueX > sensitivityFactor)) // (x_max-margin
            { // right should correspond to positive motorvalue
                motorValueX = 0;
            }
            if ((xPulses < margin) && (motorValueX < (-1 * sensitivityFactor))) 
            { 
                motorValueX = 0;
            }
            if ((yPulses > (y_max-margin)) && (motorValueY > sensitivityFactor)) 
            { // up should correspond to positive motorvalue
                motorValueY = 0;
            }
            if ((yPulses < margin) && (motorValueY < ((-1) * sensitivityFactor))) 
            {
                motorValueY = 0;
            } 
            // Quantize the linear speed request
            // motorValue is a value [-1,1], currently only 0 or 1/-1
            
             //pc.printf("X_MotorValue : %f \n\r", motorValueX);
            if (motorValueX >= maxXValue){motorValueX = maxXValue;} // boundary for the motor value
            else if (motorValueX <= -maxXValue){motorValueX = -maxXValue;}
            else if ((motorValueX >= sensitivityFactor) && (motorValueX < maxXValue)){motorValueX = maxXValue;} // if threshold is met go a fixed speed%, we could quantize here
            else if ((motorValueX <= -sensitivityFactor) && (motorValueX > -maxXValue)){motorValueX = -maxXValue;}
            else {motorValueX = 0;}
            
            if (motorValueY >= maxYValue){motorValueY = maxYValue;}
            else if (motorValueY <= -maxYValue){motorValueY = -maxYValue;}
            else if ((motorValueY >= sensitivityFactor) && (motorValueY < maxYValue)){motorValueY = maxYValue;}
            else if ((motorValueY <= -sensitivityFactor) && (motorValueY > -maxYValue)){motorValueY = -maxYValue;}
            else {motorValueY = 0;}
            
            
            
            // current position of pen in Meters
            float currentX = (xPulses/(8400.0f))*(2*PI)*RmX;
            float currentY = (yPulses/(8400.0f))*(2*PI)*Rpulley; 
            
            // upcoming position of pen in Meters
            //toX = currentX + motorValueX*maxSpeed*RATE; // speed is in m/s rate is in s
            //toY = currentY + motorValueY*maxSpeed*RATE; 
            
            // distance it should travel for 1 interval in Meters 
            float deltaX = motorValueX*maxSpeed*RATE;
            float deltaY = motorValueY*maxSpeed*RATE;
            
            // desired velocity in m/s for this interval
            float toVelX = deltaX/RATE;
            float toVelY = deltaY/RATE;
            
            // set setpoint of PID controller, this is the thing you want
            X_Controller.setSetPoint(toVelX);
            Y_Controller.setSetPoint(toVelY);
            
            // current velocity in M/s, the thing you measure
            // horizontal motor
            float currVelX = (currentX - prevX)/RATE;
            prevX = currentX;
            X_Controller.setProcessValue(currVelX);
            
            //vertical motor
            float currVelY = (currentY - prevY)/RATE;
            prevY = currentY;
            Y_Controller.setProcessValue(currVelY);
           
           
           
            
            // compute the output
            float X_MotorOutput = 9 * X_Controller.compute();
           //pc.printf("X_MotorOutput : %f \n\r", X_MotorOutput);    
           
            if (X_MotorOutput > maxSpeed) // 
            { // right request
                X_Direction.write(CW);
                X_Magnitude.write(maxSpeed); // 
            }   
            else if (X_MotorOutput <= -maxSpeed)
            {
                X_Direction.write(!CW); // left request
                X_Magnitude.write(maxSpeed); //motor output will be negative and you need to write a pos value
            }
            else if ((X_MotorOutput < maxSpeed) && (X_MotorOutput > sensitivityFactor))
            {
                X_Magnitude.write(X_MotorOutput);
                X_Direction.write(CW);
            }
                        
            else if ((X_MotorOutput > -maxSpeed) && (X_MotorOutput < -sensitivityFactor))
            {
                X_Magnitude.write(X_MotorOutput);
                X_Direction.write(!CW);
            }
            else 
            {
                X_Magnitude.write(0);
                }
            

            float Y_MotorOutput = 9 * Y_Controller.compute();
            if (Y_MotorOutput > maxSpeed) // 
            { // right request
                Y_Direction.write(CW);
                Y_Magnitude.write(maxSpeed); // 
            }   
            else if (Y_MotorOutput <= -maxSpeed)
            {
                Y_Direction.write(!CW); // left request
                Y_Magnitude.write(maxSpeed); //motor output will be negative and you need to write a pos value
            }
            else if ((Y_MotorOutput < maxSpeed) && (Y_MotorOutput > sensitivityFactor))
            {
                Y_Magnitude.write(Y_MotorOutput);
                Y_Direction.write(CW);
            }
            
               
            else if ((Y_MotorOutput > -maxSpeed) && (Y_MotorOutput < -sensitivityFactor))
            {
                Y_Magnitude.write(Y_MotorOutput);
                Y_Direction.write(!CW);
            }
            
            else 
            {
                Y_Magnitude.write(0);
            }
            
            update_flag = false;
            
        }
    }
    motorControl.detach();
}

void setUpdate_flag() {
    update_flag = true;
}

void calibrate() {
    
    // GO-TO pos (0,0)
    while ((X_Motor.getPulses() > margin) || (Y_Motor.getPulses() > margin)){
        float pulses = X_Motor.getPulses();
        printf("pulsesX : %f\n\r", pulses);
        
        if (X_Motor.getPulses() > margin)
        {
        // go direction LEFT
            X_Direction.write(!CW);
            X_Magnitude.write(calibrationSpeed); // 8 RPM with no load, maybe compensate for internal friction
        }   
        else 
        { //motormagX 0 
            X_Direction.write(CW);
            X_Magnitude.write(0.0);   
        }
        if (Y_Motor.getPulses() > margin)
        {
        // go direction DOWN
            Y_Direction.write(!CW);
            Y_Magnitude.write(calibrationSpeed);
        }   
        else 
        { //motormagY 0  
            Y_Direction.write(CW);
            Y_Magnitude.write(0.0);   
        }
    }
    prevX = (X_Motor.getPulses()/(8400.0f))*(2*PI)*RmX;
    prevY = (X_Motor.getPulses()/(8400.0f))*(2*PI)*Rpulley; 
}   
 
void calibratePower(){ 
    motorControl.attach(&setUpdate_flag, RATE);
    led = false; // contract now, false = on
    while (counter < 3000) // get 3000 samples for the max
    {
        if(update_flag)
        {
            float rCal = signal.readValue(1); 
            if ( rCal > rMax)
            {
                rMax = rCal;
            }
            
            float lCal = signal.readValue(2);
            if ( lCal > lMax)
            {
                lMax = lCal;
            }
            
            float uCal = signal.readValue(3);
            if ( uCal > uMax)
            {
                uMax = uCal;
            }   
            float dCal = signal.readValue(4);
            if ( dCal > dMax)
            {
                dMax = dCal;
            }
            counter++;         
            update_flag = false;
        }  
    }
    counter = 0;
    pc.printf("rMax : %f\n\r", rMax);
    pc.printf("lMax : %f\n\r", lMax);
    motorControl.detach();
    led = true;
}
