#include "mbed.h"
#include "GPS.h"
#include "C12832_lcd.h"
#include "MSCFileSystem.h"
#include "PwmIn.h"
#include "MMA7660.h"
#include "EthernetPowerControl.h"

#define FSNAME "msc"

MSCFileSystem msc(FSNAME);
Serial pc(USBTX, USBRX);
GPS gps(p9, p10);
PwmIn Bearing(p21);
C12832_LCD lcd;
MMA7660 MMA(p28, p27);// local name for the Accelerometer
DigitalOut connectionLed(LED1); // debug LED
 

float timing;

int main() {
 	
 	PHY_PowerDown();
 	
    FILE *fp;
    fp = fopen( "/" FSNAME "/GPSData.txt", "w");
    fprintf(fp,"");
  	fclose(fp);
  	
  	FILE *fp2;
    fp2 = fopen( "/" FSNAME "/CompassData.txt", "w");
    fprintf(fp2,"");
    fclose(fp2);
 
    FILE *fp3; 
    fp3 = fopen( "/" FSNAME "/AccelerometerData.txt", "w");
    fprintf(fp3,"");
    fclose(fp3);
    
    if ( fp == NULL )
    {
        lcd.cls();//clear LCD for next reading round
        lcd.locate(3,3);
        lcd.printf("File error\n");
    }
    
    if ( fp2 == NULL )
    {
        lcd.cls();//clear LCD for next reading round
        lcd.locate(3,3);
        lcd.printf("File error\n");
    }
    
    if ( fp3 == NULL )
    {
        lcd.cls();//clear LCD for next reading round
        lcd.locate(3,3);
        lcd.printf("File error\n");
    }
    
     if (MMA.testConnection()){
    connectionLed = 1;// LEDs are very useful to demonstrate something is working
    }
    
    while(1) 
    {
               
       if(gps.sample()) 
        {
            fp = fopen( "/" FSNAME "/GPSData.txt", "a");
            fprintf(fp, "%.1f ",timing); //time when read
            fprintf(fp, "%f ", gps.longitude); 
            fprintf(fp, "%f\n", gps.latitude);
        
            pc.printf("%f, %f\r\n",gps.latitude,gps.longitude);
        
            
            fp2 = fopen( "/" FSNAME "/CompassData.txt", "a");
        	float angle = Bearing.pulsewidth();
       		//pc.printf("\ntimer: %.1f",time);
        	pc.printf("\nBearing: %.2f \r\n", (angle*10000)-10);
        	fprintf(fp2, "%.1f ",timing); //time when read
        	fprintf(fp2, "%.2f\r\n",(angle*10000)-10); //angle 
        	
        	fp3 = fopen( "/" FSNAME "/AccelerometerData.txt", "a");
        	float zaxis = MMA.z();
        	float xaxis = MMA.x();
        	float yaxis = MMA.y();
     
     		pc.printf("%.2f ",xaxis);
     		pc.printf("%.2f ",yaxis);
     		pc.printf("%.2f \r\n",zaxis);
     		fprintf(fp3, "%.1f ",timing);
        	fprintf(fp3, "%.2f ",xaxis);
       		fprintf(fp3, "%.2f ",yaxis);
        	fprintf(fp3, "%.2f \n",zaxis);
        
        	lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);
            lcd.printf("%.3f\n",gps.latitude);//print x to LCD at locate position
            lcd.locate(30,3);//move LCD location for y component
            lcd.printf("%.3f Lat/Long\n",gps.longitude);//print y to LCD to new locate position
            
            lcd.locate(3,21);
          	lcd.printf("%.2f Angle\n",(angle*10000)-10);
            
          	lcd.locate(3,12);//initial LCD location for x component of acceleration
          	lcd.printf("%.2f\n",MMA.x());//print x to LCD at locate position
          	lcd.locate(28,12);//move LCD location for y component
          	lcd.printf("%.2f\n",MMA.y());//print y to LCD to new locate position
          	lcd.locate(53,12);//move LCD location for z component
          	lcd.printf("%.2f XYZ\n",MMA.z());//print z to LCD
    
          	wait(0.5);
            fclose(fp);
            fclose(fp2);
            fclose(fp3);
            timing = timing + 0.5;
        } 
        
        else 
        {
            pc.printf("Oh Dear! No lock :(\r\n");
            lcd.cls();
            lcd.locate(3,3);
            lcd.printf("No GPS Lock");
        }
               
    }
}