/* Copyright (c) 2011 Alex Allen, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef RADIO

    #include "mbed.h"

    class UM12 : private Serial
    {
        DigitalOut *sleepPin, *resetPin;
        
        public:
        
        UM12( PinName tx, PinName rx, PinName slp = LED1, PinName rst = LED2);
        virtual ~UM12();
        
        void sleep(); // Send UM12 to sleep
        void wake(); // Wake UM12 from sleep
        void reset(); // Reset UM12
        
        void send(char msg); // Send a single char
        void send(bool msg); // Send a boolean message
        void send(int msg); // Send a four byte integer
        void send(float msg); // Send a four byte floating point number
        
        char receive(char &msg); // Receive a single char
        bool receive(bool &msg); // Receive a boolean
        int receive(int &msg); // Receive a four byte integer
        float receive(float &msg); // Receive a four byte floating point number
        
        
    };
    #define RADIO 1
#endif