/* Copyright (c) 2011 Alex Allen, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "UM12.h"
#include "mbed.h"

UM12::UM12( PinName tx, PinName rx, PinName slp, PinName rst) : Serial::Serial(tx, rx)
{
    if(slp != LED1) sleepPin = new DigitalOut(slp);
    else sleepPin = 0;
    if(rst != LED2) resetPin = new DigitalOut(rst);
    else resetPin = 0;
    baud(1200);
    format(8, Serial::Even, 1);
}

UM12::~UM12()
{
    if(sleepPin) delete sleepPin;
    if(resetPin) delete resetPin;
}
        
void UM12::sleep()
{
    if(sleepPin) *sleepPin = 1;
}

void UM12::wake()
{
    if(sleepPin) *sleepPin = 0;
}

void UM12::reset()
{
    if(resetPin)
    {
        *resetPin = 0;
        wait(0.15);
        *resetPin = 1;
    }
}

void UM12::send(char msg)
{
    putc(msg);
}

void UM12::send(bool msg)
{
    putc((int) msg);
}

void UM12::send(int msg)
{
        char *ch;
        ch = (char*) &msg;
        for (int i=0; i<sizeof(float);i++) putc(ch[i]);
}

void UM12::send(float msg)
{
        char *ch;
        ch = (char*) &msg;
        for (int i=0; i<sizeof(float);i++) putc(ch[i]);
}

char UM12::receive(char &msg)
{
    msg = getc();
    return msg;
}

bool UM12::receive(bool &msg)
{
    msg = getc();
    return msg;
}

int UM12::receive(int &msg)
{
    int i, intsize = sizeof(int);
    char bytes[intsize];

    for(i=0; i<intsize; i++) bytes[i] = getc();

    int *rec;
    rec = (int*) bytes;
    msg = *rec;
    
    return msg;
}


float UM12::receive(float &msg)
{
    int i, flsize = sizeof(float);
    char bytes[flsize];

    for(i=0; i<flsize; i++) bytes[i] = getc();

    float *rec;
    rec = (float*) bytes;
    msg = *rec;
    
    return msg;
}