#include "mbed.h"
#include "GPS.h"
#include "MMA7660.h"
#include "CMPS03.h"
#include "MSCFileSystem.h"
#include "C12832_lcd.h"

#define FSNAME "USB"

// Initialisation
Serial pc(USBTX, USBRX);
GPS gps(p9, p10);                                       // GPS connections
MMA7660 MMA(p28, p27);                                  // Accelerometer connections 
CMPS03 compass(p28, p27, CMPS03_DEFAULT_I2C_ADDRESS);   // Compass connections
C12832_LCD lcd;

// Declarations
float ax, ay, az; // acceleration values 
DigitalOut connectionLed(LED1); 
MSCFileSystem msc(FSNAME);


int main()
{
    DIR *d;
    struct dirent *p;
     
    d = opendir("/" FSNAME);
    
    pc.printf("\nList of files on the flash drive:\n");
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )
        {
            pc.printf(" - %s\n", p->d_name);
        }
    }
    else
    {
        error("Could not open directory!");
    }
    //printf("\nTesting file write:\n");
    FILE *CompassFile = fopen( "/" FSNAME "/CMP_file.txt", "w");
    if ( CompassFile == NULL )
    {
        error("Could not open compass file for write\n");
    }
    FILE *GPSFile = fopen("/" FSNAME "/GPS_file.txt", "w");
    if ( GPSFile == NULL )
    {
        error("Could not open GPS file for write\n");
    }
    FILE *AccelFile = fopen("/" FSNAME "/MMA_file.txt", "w");
    if ( AccelFile == NULL )
    {
        error("Could not open acceleration file for write\n");
    }
    if (MMA.testConnection()) 
        connectionLed = 1; // check that MMA is connected and display on LED1
        
    float refPoint = 1.0; 
    float bearing;
    int i = 1;
    
    while (1)
    {
        refPoint = compass.readBearing();
        while(i == 1)
        {
            CompassFile = fopen("/" FSNAME "/CMP_file.txt", "a");
            GPSFile = fopen("/" FSNAME "/GPS_file.txt", "a");
            AccelFile = fopen("/" FSNAME "/MMA_file.txt", "a");
        
        // GPS code
            if(gps.sample()) 
            {
                fprintf(GPSFile, "\n%f %f\r\n", gps.latitude, gps.longitude);
                lcd.locate(1,1);
                lcd.printf("GPS: %.4f %.4f", gps.latitude, gps.longitude);
            } 
            else 
            {
                fprintf(GPSFile, "\nNo lock!\r\n");
                lcd.locate(1,1);
                lcd.printf("GPS: No lock!");
            }
            
        // Accelerometer code
            ax=MMA.x(); // read accelerometer values 
            ay=MMA.y(); 
            az=MMA.z(); 
            fprintf(AccelFile, "%f %f %f\r\n",ax,ay,az); 
            lcd.locate(1,11);
            lcd.printf("MMA: %.4f %.4f %.4f",ax,ay,az);
            
        // Compass code
            bearing = (compass.readBearing()/10 - refPoint/10);
            if(bearing < 0.0)
            {
                bearing = 360 + bearing;
                fprintf(CompassFile, "Bearing : %f\r\n", bearing);
                lcd.locate(1,21);
                lcd.printf("Ref.b: %.2f :CMP: %.2f", refPoint/10, bearing);
            }
            else
            {
                fprintf(CompassFile, "Bearing : %f\r\n", bearing);
                lcd.locate(1,21);
                lcd.printf("Ref.b: %.2f :CMP: %.2f", refPoint/10, bearing);
            }
            fclose(CompassFile);
            fclose(AccelFile);
            fclose(GPSFile);  
        }        
    } 
}