#include "ENVIROMENTAL.h"


//#define Ro 28 //Change this value with the value from Calibrate and uncomment


ENVIROMENTAL::ENVIROMENTAL (PinName envi_SDA, PinName envi_SCL,PinName mq_analog):climate(envi_SDA,envi_SCL),bmp(envi_SDA,envi_SCL),i2c(envi_SDA,envi_SCL),uv(i2c)
{
    _mq_pin = mq_analog;
    uv.begin(VEML6070_1_T);
}
ENVIROMENTAL::~ENVIROMENTAL(){}


void ENVIROMENTAL::calibrate_mq()
{

    AnalogIn analog_value(_mq_pin);
    float MQ7_read;
    float VRL;
    float Rs;
    float Ro;
    float RL;
      for(int test_cycle = 1 ; test_cycle <= 500 ; test_cycle++) //Read the analog output of the sensor for 200 times
              {
                MQ7_read = MQ7_read + analog_value.read(); //add the values for 500
              }
      MQ7_read = MQ7_read/500.0f; //Take average
    VRL = MQ7_read*(5.0f); //Convert analog value to voltage
    Rs = ((5.0f/VRL)-1) * RL; //is the formula obtained from datasheet
    Ro = Rs/1.7f;  //RS/RO is 1.7 as we obtained from graph of datasheet
    printf("Ro at fresh air = %f\n\r",Ro);
}



float ENVIROMENTAL::get_CO()
{
    AnalogIn analog_value(_mq_pin);
    float MQ7_read;
    float VRL;
    float Rs;
    float ratio;
    float Ro;
    float ppm;
    float RL;
    float m =-0.661;
    float b =1.332;
    for(int test_cycle = 1 ; test_cycle <= 500 ; test_cycle++) //Read the analog output of the sensor for 200 times
                {
                  MQ7_read = MQ7_read + analog_value.read(); //add the values for 500
                }
      MQ7_read = MQ7_read/500.0f; //Take average

    VRL = MQ7_read*(5.0f); //Convert analog value to voltage
    Rs = ((5.0f/VRL)-1.0f) * RL; //is the formula obtained from datasheet
    ratio = Rs/Ro;
    ppm = pow(10, ((log10(ratio)-b)/m)); //use formula to calculate ppm
    return ppm;
}


float ENVIROMENTAL::get_temp()
{
  float temp=0;
  for(int i=0;i<20;i++)
    {
      _tmp = climate.get_temperature();
      temp=temp + _tmp;
  }

        return temp/20;

}


uint32_t ENVIROMENTAL::get_humidity(){
    _tmp=0;
    uint32_t hum=0;
    for(int i=0;i<20;i++)
      {
        _tmp=climate.get_humidity();
        hum = hum + _tmp;
    }

          return hum/20;

}

int32_t ENVIROMENTAL::get_pressure(){
    _tmp=0;
    int32_t pres=0;
    for(int i=0;i<20;i++)
      {
        _tmp=bmp.getPressure();
        pres = pres + _tmp;
    }

          return pres/20;

}

int ENVIROMENTAL::get_uv(){
    int uvi=0;
    _tmp=0;
    for(int i=0;i<20;i++)
      {
        _tmp = uv.readUV();
        uvi = uvi + _tmp;
    }

          return uvi/20;
    
    
    
}