/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     (C) COPYRIGHT 2015-2015 ARM Limited
**     ALL RIGHTS RESERVED
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2015-08-03) (ARM)
**         All accesses to memory are replaced by equivalent macros; this allows
**         memory read/write operations to be re-defined if needed (for example,
**         to implement new security features
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_WDOG_REGISTERS_H__
#define __HW_WDOG_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 WDOG
 *
 * Generation 2008 Watchdog Timer
 *
 * Registers defined in this header file:
 * - HW_WDOG_STCTRLH - Watchdog Status and Control Register High
 * - HW_WDOG_STCTRLL - Watchdog Status and Control Register Low
 * - HW_WDOG_TOVALH - Watchdog Time-out Value Register High
 * - HW_WDOG_TOVALL - Watchdog Time-out Value Register Low
 * - HW_WDOG_WINH - Watchdog Window Register High
 * - HW_WDOG_WINL - Watchdog Window Register Low
 * - HW_WDOG_REFRESH - Watchdog Refresh register
 * - HW_WDOG_UNLOCK - Watchdog Unlock register
 * - HW_WDOG_TMROUTH - Watchdog Timer Output Register High
 * - HW_WDOG_TMROUTL - Watchdog Timer Output Register Low
 * - HW_WDOG_RSTCNT - Watchdog Reset Count register
 * - HW_WDOG_PRESC - Watchdog Prescaler register
 *
 * - hw_wdog_t - Struct containing all module registers.
 */

#define HW_WDOG_INSTANCE_COUNT (1U) /*!< Number of instances of the WDOG module. */

/*******************************************************************************
 * HW_WDOG_STCTRLH - Watchdog Status and Control Register High
 ******************************************************************************/

/*!
 * @brief HW_WDOG_STCTRLH - Watchdog Status and Control Register High (RW)
 *
 * Reset value: 0x01D3U
 */
typedef union _hw_wdog_stctrlh
{
    uint16_t U;
    struct _hw_wdog_stctrlh_bitfields
    {
        uint16_t WDOGEN : 1;           /*!< [0]  */
        uint16_t CLKSRC : 1;           /*!< [1]  */
        uint16_t IRQRSTEN : 1;         /*!< [2]  */
        uint16_t WINEN : 1;            /*!< [3]  */
        uint16_t ALLOWUPDATE : 1;      /*!< [4]  */
        uint16_t DBGEN : 1;            /*!< [5]  */
        uint16_t STOPEN : 1;           /*!< [6]  */
        uint16_t WAITEN : 1;           /*!< [7]  */
        uint16_t RESERVED0 : 2;        /*!< [9:8]  */
        uint16_t TESTWDOG : 1;         /*!< [10]  */
        uint16_t TESTSEL : 1;          /*!< [11]  */
        uint16_t BYTESEL : 2;          /*!< [13:12]  */
        uint16_t DISTESTWDOG : 1;      /*!< [14]  */
        uint16_t RESERVED1 : 1;        /*!< [15]  */
    } B;
} hw_wdog_stctrlh_t;

/*!
 * @name Constants and macros for entire WDOG_STCTRLH register
 */
/*@{*/
#define HW_WDOG_STCTRLH_ADDR(x)  ((x) + 0x0U)

#define HW_WDOG_STCTRLH(x)       (*(__IO hw_wdog_stctrlh_t *) HW_WDOG_STCTRLH_ADDR(x))
#define HW_WDOG_STCTRLH_RD(x)    (ADDRESS_READ(hw_wdog_stctrlh_t, HW_WDOG_STCTRLH_ADDR(x)))
#define HW_WDOG_STCTRLH_WR(x, v) (ADDRESS_WRITE(hw_wdog_stctrlh_t, HW_WDOG_STCTRLH_ADDR(x), v))
#define HW_WDOG_STCTRLH_SET(x, v) (HW_WDOG_STCTRLH_WR(x, HW_WDOG_STCTRLH_RD(x) |  (v)))
#define HW_WDOG_STCTRLH_CLR(x, v) (HW_WDOG_STCTRLH_WR(x, HW_WDOG_STCTRLH_RD(x) & ~(v)))
#define HW_WDOG_STCTRLH_TOG(x, v) (HW_WDOG_STCTRLH_WR(x, HW_WDOG_STCTRLH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_STCTRLH bitfields
 */

/*!
 * @name Register WDOG_STCTRLH, field WDOGEN[0] (RW)
 *
 * Enables or disables the WDOG's operation. In the disabled state, the watchdog
 * timer is kept in the reset state, but the other exception conditions can
 * still trigger a reset/interrupt. A change in the value of this bit must be held
 * for more than one WDOG_CLK cycle for the WDOG to be enabled or disabled.
 *
 * Values:
 * - 0 - WDOG is disabled.
 * - 1 - WDOG is enabled.
 */
/*@{*/
#define BP_WDOG_STCTRLH_WDOGEN (0U)        /*!< Bit position for WDOG_STCTRLH_WDOGEN. */
#define BM_WDOG_STCTRLH_WDOGEN (0x0001U)   /*!< Bit mask for WDOG_STCTRLH_WDOGEN. */
#define BS_WDOG_STCTRLH_WDOGEN (1U)        /*!< Bit field size in bits for WDOG_STCTRLH_WDOGEN. */

/*! @brief Read current value of the WDOG_STCTRLH_WDOGEN field. */
#define BR_WDOG_STCTRLH_WDOGEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WDOGEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_WDOGEN. */
#define BF_WDOG_STCTRLH_WDOGEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_WDOGEN) & BM_WDOG_STCTRLH_WDOGEN)

/*! @brief Set the WDOGEN field to a new value. */
#define BW_WDOG_STCTRLH_WDOGEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WDOGEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field CLKSRC[1] (RW)
 *
 * Selects clock source for the WDOG timer and other internal timing operations.
 *
 * Values:
 * - 0 - WDOG clock sourced from LPO .
 * - 1 - WDOG clock sourced from alternate clock source.
 */
/*@{*/
#define BP_WDOG_STCTRLH_CLKSRC (1U)        /*!< Bit position for WDOG_STCTRLH_CLKSRC. */
#define BM_WDOG_STCTRLH_CLKSRC (0x0002U)   /*!< Bit mask for WDOG_STCTRLH_CLKSRC. */
#define BS_WDOG_STCTRLH_CLKSRC (1U)        /*!< Bit field size in bits for WDOG_STCTRLH_CLKSRC. */

/*! @brief Read current value of the WDOG_STCTRLH_CLKSRC field. */
#define BR_WDOG_STCTRLH_CLKSRC(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_CLKSRC)))

/*! @brief Format value for bitfield WDOG_STCTRLH_CLKSRC. */
#define BF_WDOG_STCTRLH_CLKSRC(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_CLKSRC) & BM_WDOG_STCTRLH_CLKSRC)

/*! @brief Set the CLKSRC field to a new value. */
#define BW_WDOG_STCTRLH_CLKSRC(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_CLKSRC), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field IRQRSTEN[2] (RW)
 *
 * Used to enable the debug breadcrumbs feature. A change in this bit is updated
 * immediately, as opposed to updating after WCT.
 *
 * Values:
 * - 0 - WDOG time-out generates reset only.
 * - 1 - WDOG time-out initially generates an interrupt. After WCT, it generates
 *     a reset.
 */
/*@{*/
#define BP_WDOG_STCTRLH_IRQRSTEN (2U)      /*!< Bit position for WDOG_STCTRLH_IRQRSTEN. */
#define BM_WDOG_STCTRLH_IRQRSTEN (0x0004U) /*!< Bit mask for WDOG_STCTRLH_IRQRSTEN. */
#define BS_WDOG_STCTRLH_IRQRSTEN (1U)      /*!< Bit field size in bits for WDOG_STCTRLH_IRQRSTEN. */

/*! @brief Read current value of the WDOG_STCTRLH_IRQRSTEN field. */
#define BR_WDOG_STCTRLH_IRQRSTEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_IRQRSTEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_IRQRSTEN. */
#define BF_WDOG_STCTRLH_IRQRSTEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_IRQRSTEN) & BM_WDOG_STCTRLH_IRQRSTEN)

/*! @brief Set the IRQRSTEN field to a new value. */
#define BW_WDOG_STCTRLH_IRQRSTEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_IRQRSTEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field WINEN[3] (RW)
 *
 * Enables Windowing mode.
 *
 * Values:
 * - 0 - Windowing mode is disabled.
 * - 1 - Windowing mode is enabled.
 */
/*@{*/
#define BP_WDOG_STCTRLH_WINEN (3U)         /*!< Bit position for WDOG_STCTRLH_WINEN. */
#define BM_WDOG_STCTRLH_WINEN (0x0008U)    /*!< Bit mask for WDOG_STCTRLH_WINEN. */
#define BS_WDOG_STCTRLH_WINEN (1U)         /*!< Bit field size in bits for WDOG_STCTRLH_WINEN. */

/*! @brief Read current value of the WDOG_STCTRLH_WINEN field. */
#define BR_WDOG_STCTRLH_WINEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WINEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_WINEN. */
#define BF_WDOG_STCTRLH_WINEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_WINEN) & BM_WDOG_STCTRLH_WINEN)

/*! @brief Set the WINEN field to a new value. */
#define BW_WDOG_STCTRLH_WINEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WINEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field ALLOWUPDATE[4] (RW)
 *
 * Enables updates to watchdog write-once registers, after the reset-triggered
 * initial configuration window (WCT) closes, through unlock sequence.
 *
 * Values:
 * - 0 - No further updates allowed to WDOG write-once registers.
 * - 1 - WDOG write-once registers can be unlocked for updating.
 */
/*@{*/
#define BP_WDOG_STCTRLH_ALLOWUPDATE (4U)   /*!< Bit position for WDOG_STCTRLH_ALLOWUPDATE. */
#define BM_WDOG_STCTRLH_ALLOWUPDATE (0x0010U) /*!< Bit mask for WDOG_STCTRLH_ALLOWUPDATE. */
#define BS_WDOG_STCTRLH_ALLOWUPDATE (1U)   /*!< Bit field size in bits for WDOG_STCTRLH_ALLOWUPDATE. */

/*! @brief Read current value of the WDOG_STCTRLH_ALLOWUPDATE field. */
#define BR_WDOG_STCTRLH_ALLOWUPDATE(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_ALLOWUPDATE)))

/*! @brief Format value for bitfield WDOG_STCTRLH_ALLOWUPDATE. */
#define BF_WDOG_STCTRLH_ALLOWUPDATE(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_ALLOWUPDATE) & BM_WDOG_STCTRLH_ALLOWUPDATE)

/*! @brief Set the ALLOWUPDATE field to a new value. */
#define BW_WDOG_STCTRLH_ALLOWUPDATE(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_ALLOWUPDATE), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field DBGEN[5] (RW)
 *
 * Enables or disables WDOG in Debug mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Debug mode.
 * - 1 - WDOG is enabled in CPU Debug mode.
 */
/*@{*/
#define BP_WDOG_STCTRLH_DBGEN (5U)         /*!< Bit position for WDOG_STCTRLH_DBGEN. */
#define BM_WDOG_STCTRLH_DBGEN (0x0020U)    /*!< Bit mask for WDOG_STCTRLH_DBGEN. */
#define BS_WDOG_STCTRLH_DBGEN (1U)         /*!< Bit field size in bits for WDOG_STCTRLH_DBGEN. */

/*! @brief Read current value of the WDOG_STCTRLH_DBGEN field. */
#define BR_WDOG_STCTRLH_DBGEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_DBGEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_DBGEN. */
#define BF_WDOG_STCTRLH_DBGEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_DBGEN) & BM_WDOG_STCTRLH_DBGEN)

/*! @brief Set the DBGEN field to a new value. */
#define BW_WDOG_STCTRLH_DBGEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_DBGEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field STOPEN[6] (RW)
 *
 * Enables or disables WDOG in Stop mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Stop mode.
 * - 1 - WDOG is enabled in CPU Stop mode.
 */
/*@{*/
#define BP_WDOG_STCTRLH_STOPEN (6U)        /*!< Bit position for WDOG_STCTRLH_STOPEN. */
#define BM_WDOG_STCTRLH_STOPEN (0x0040U)   /*!< Bit mask for WDOG_STCTRLH_STOPEN. */
#define BS_WDOG_STCTRLH_STOPEN (1U)        /*!< Bit field size in bits for WDOG_STCTRLH_STOPEN. */

/*! @brief Read current value of the WDOG_STCTRLH_STOPEN field. */
#define BR_WDOG_STCTRLH_STOPEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_STOPEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_STOPEN. */
#define BF_WDOG_STCTRLH_STOPEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_STOPEN) & BM_WDOG_STCTRLH_STOPEN)

/*! @brief Set the STOPEN field to a new value. */
#define BW_WDOG_STCTRLH_STOPEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_STOPEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field WAITEN[7] (RW)
 *
 * Enables or disables WDOG in Wait mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Wait mode.
 * - 1 - WDOG is enabled in CPU Wait mode.
 */
/*@{*/
#define BP_WDOG_STCTRLH_WAITEN (7U)        /*!< Bit position for WDOG_STCTRLH_WAITEN. */
#define BM_WDOG_STCTRLH_WAITEN (0x0080U)   /*!< Bit mask for WDOG_STCTRLH_WAITEN. */
#define BS_WDOG_STCTRLH_WAITEN (1U)        /*!< Bit field size in bits for WDOG_STCTRLH_WAITEN. */

/*! @brief Read current value of the WDOG_STCTRLH_WAITEN field. */
#define BR_WDOG_STCTRLH_WAITEN(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WAITEN)))

/*! @brief Format value for bitfield WDOG_STCTRLH_WAITEN. */
#define BF_WDOG_STCTRLH_WAITEN(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_WAITEN) & BM_WDOG_STCTRLH_WAITEN)

/*! @brief Set the WAITEN field to a new value. */
#define BW_WDOG_STCTRLH_WAITEN(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_WAITEN), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field TESTWDOG[10] (RW)
 *
 * Puts the watchdog in the functional test mode. In this mode, the watchdog
 * timer and the associated compare and reset generation logic is tested for correct
 * operation. The clock for the timer is switched from the main watchdog clock
 * to the fast clock input for watchdog functional test. The TESTSEL bit selects
 * the test to be run.
 */
/*@{*/
#define BP_WDOG_STCTRLH_TESTWDOG (10U)     /*!< Bit position for WDOG_STCTRLH_TESTWDOG. */
#define BM_WDOG_STCTRLH_TESTWDOG (0x0400U) /*!< Bit mask for WDOG_STCTRLH_TESTWDOG. */
#define BS_WDOG_STCTRLH_TESTWDOG (1U)      /*!< Bit field size in bits for WDOG_STCTRLH_TESTWDOG. */

/*! @brief Read current value of the WDOG_STCTRLH_TESTWDOG field. */
#define BR_WDOG_STCTRLH_TESTWDOG(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_TESTWDOG)))

/*! @brief Format value for bitfield WDOG_STCTRLH_TESTWDOG. */
#define BF_WDOG_STCTRLH_TESTWDOG(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_TESTWDOG) & BM_WDOG_STCTRLH_TESTWDOG)

/*! @brief Set the TESTWDOG field to a new value. */
#define BW_WDOG_STCTRLH_TESTWDOG(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_TESTWDOG), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field TESTSEL[11] (RW)
 *
 * Effective only if TESTWDOG is set. Selects the test to be run on the watchdog
 * timer.
 *
 * Values:
 * - 0 - Quick test. The timer runs in normal operation. You can load a small
 *     time-out value to do a quick test.
 * - 1 - Byte test. Puts the timer in the byte test mode where individual bytes
 *     of the timer are enabled for operation and are compared for time-out
 *     against the corresponding byte of the programmed time-out value. Select the
 *     byte through BYTESEL[1:0] for testing.
 */
/*@{*/
#define BP_WDOG_STCTRLH_TESTSEL (11U)      /*!< Bit position for WDOG_STCTRLH_TESTSEL. */
#define BM_WDOG_STCTRLH_TESTSEL (0x0800U)  /*!< Bit mask for WDOG_STCTRLH_TESTSEL. */
#define BS_WDOG_STCTRLH_TESTSEL (1U)       /*!< Bit field size in bits for WDOG_STCTRLH_TESTSEL. */

/*! @brief Read current value of the WDOG_STCTRLH_TESTSEL field. */
#define BR_WDOG_STCTRLH_TESTSEL(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_TESTSEL)))

/*! @brief Format value for bitfield WDOG_STCTRLH_TESTSEL. */
#define BF_WDOG_STCTRLH_TESTSEL(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_TESTSEL) & BM_WDOG_STCTRLH_TESTSEL)

/*! @brief Set the TESTSEL field to a new value. */
#define BW_WDOG_STCTRLH_TESTSEL(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_TESTSEL), v))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field BYTESEL[13:12] (RW)
 *
 * This 2-bit field selects the byte to be tested when the watchdog is in the
 * byte test mode.
 *
 * Values:
 * - 00 - Byte 0 selected
 * - 01 - Byte 1 selected
 * - 10 - Byte 2 selected
 * - 11 - Byte 3 selected
 */
/*@{*/
#define BP_WDOG_STCTRLH_BYTESEL (12U)      /*!< Bit position for WDOG_STCTRLH_BYTESEL. */
#define BM_WDOG_STCTRLH_BYTESEL (0x3000U)  /*!< Bit mask for WDOG_STCTRLH_BYTESEL. */
#define BS_WDOG_STCTRLH_BYTESEL (2U)       /*!< Bit field size in bits for WDOG_STCTRLH_BYTESEL. */

/*! @brief Read current value of the WDOG_STCTRLH_BYTESEL field. */
#define BR_WDOG_STCTRLH_BYTESEL(x) (UNION_READ(hw_wdog_stctrlh_t, HW_WDOG_STCTRLH_ADDR(x), U, B.BYTESEL))

/*! @brief Format value for bitfield WDOG_STCTRLH_BYTESEL. */
#define BF_WDOG_STCTRLH_BYTESEL(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_BYTESEL) & BM_WDOG_STCTRLH_BYTESEL)

/*! @brief Set the BYTESEL field to a new value. */
#define BW_WDOG_STCTRLH_BYTESEL(x, v) (HW_WDOG_STCTRLH_WR(x, (HW_WDOG_STCTRLH_RD(x) & ~BM_WDOG_STCTRLH_BYTESEL) | BF_WDOG_STCTRLH_BYTESEL(v)))
/*@}*/

/*!
 * @name Register WDOG_STCTRLH, field DISTESTWDOG[14] (RW)
 *
 * Allows the WDOG's functional test mode to be disabled permanently. After it
 * is set, it can only be cleared by a reset. It cannot be unlocked for editing
 * after it is set.
 *
 * Values:
 * - 0 - WDOG functional test mode is not disabled.
 * - 1 - WDOG functional test mode is disabled permanently until reset.
 */
/*@{*/
#define BP_WDOG_STCTRLH_DISTESTWDOG (14U)  /*!< Bit position for WDOG_STCTRLH_DISTESTWDOG. */
#define BM_WDOG_STCTRLH_DISTESTWDOG (0x4000U) /*!< Bit mask for WDOG_STCTRLH_DISTESTWDOG. */
#define BS_WDOG_STCTRLH_DISTESTWDOG (1U)   /*!< Bit field size in bits for WDOG_STCTRLH_DISTESTWDOG. */

/*! @brief Read current value of the WDOG_STCTRLH_DISTESTWDOG field. */
#define BR_WDOG_STCTRLH_DISTESTWDOG(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_DISTESTWDOG)))

/*! @brief Format value for bitfield WDOG_STCTRLH_DISTESTWDOG. */
#define BF_WDOG_STCTRLH_DISTESTWDOG(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLH_DISTESTWDOG) & BM_WDOG_STCTRLH_DISTESTWDOG)

/*! @brief Set the DISTESTWDOG field to a new value. */
#define BW_WDOG_STCTRLH_DISTESTWDOG(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLH_ADDR(x), BP_WDOG_STCTRLH_DISTESTWDOG), v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_STCTRLL - Watchdog Status and Control Register Low
 ******************************************************************************/

/*!
 * @brief HW_WDOG_STCTRLL - Watchdog Status and Control Register Low (RW)
 *
 * Reset value: 0x0001U
 */
typedef union _hw_wdog_stctrll
{
    uint16_t U;
    struct _hw_wdog_stctrll_bitfields
    {
        uint16_t RESERVED0 : 15;       /*!< [14:0]  */
        uint16_t INTFLG : 1;           /*!< [15]  */
    } B;
} hw_wdog_stctrll_t;

/*!
 * @name Constants and macros for entire WDOG_STCTRLL register
 */
/*@{*/
#define HW_WDOG_STCTRLL_ADDR(x)  ((x) + 0x2U)

#define HW_WDOG_STCTRLL(x)       (*(__IO hw_wdog_stctrll_t *) HW_WDOG_STCTRLL_ADDR(x))
#define HW_WDOG_STCTRLL_RD(x)    (ADDRESS_READ(hw_wdog_stctrll_t, HW_WDOG_STCTRLL_ADDR(x)))
#define HW_WDOG_STCTRLL_WR(x, v) (ADDRESS_WRITE(hw_wdog_stctrll_t, HW_WDOG_STCTRLL_ADDR(x), v))
#define HW_WDOG_STCTRLL_SET(x, v) (HW_WDOG_STCTRLL_WR(x, HW_WDOG_STCTRLL_RD(x) |  (v)))
#define HW_WDOG_STCTRLL_CLR(x, v) (HW_WDOG_STCTRLL_WR(x, HW_WDOG_STCTRLL_RD(x) & ~(v)))
#define HW_WDOG_STCTRLL_TOG(x, v) (HW_WDOG_STCTRLL_WR(x, HW_WDOG_STCTRLL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_STCTRLL bitfields
 */

/*!
 * @name Register WDOG_STCTRLL, field INTFLG[15] (RW)
 *
 * Interrupt flag. It is set when an exception occurs. IRQRSTEN = 1 is a
 * precondition to set this flag. INTFLG = 1 results in an interrupt being issued
 * followed by a reset, WCT later. The interrupt can be cleared by writing 1 to this
 * bit. It also gets cleared on a system reset.
 */
/*@{*/
#define BP_WDOG_STCTRLL_INTFLG (15U)       /*!< Bit position for WDOG_STCTRLL_INTFLG. */
#define BM_WDOG_STCTRLL_INTFLG (0x8000U)   /*!< Bit mask for WDOG_STCTRLL_INTFLG. */
#define BS_WDOG_STCTRLL_INTFLG (1U)        /*!< Bit field size in bits for WDOG_STCTRLL_INTFLG. */

/*! @brief Read current value of the WDOG_STCTRLL_INTFLG field. */
#define BR_WDOG_STCTRLL_INTFLG(x) (ADDRESS_READ(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLL_ADDR(x), BP_WDOG_STCTRLL_INTFLG)))

/*! @brief Format value for bitfield WDOG_STCTRLL_INTFLG. */
#define BF_WDOG_STCTRLL_INTFLG(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_STCTRLL_INTFLG) & BM_WDOG_STCTRLL_INTFLG)

/*! @brief Set the INTFLG field to a new value. */
#define BW_WDOG_STCTRLL_INTFLG(x, v) (ADDRESS_WRITE(uint16_t, BITBAND_ADDRESS16(HW_WDOG_STCTRLL_ADDR(x), BP_WDOG_STCTRLL_INTFLG), v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_TOVALH - Watchdog Time-out Value Register High
 ******************************************************************************/

/*!
 * @brief HW_WDOG_TOVALH - Watchdog Time-out Value Register High (RW)
 *
 * Reset value: 0x004CU
 */
typedef union _hw_wdog_tovalh
{
    uint16_t U;
    struct _hw_wdog_tovalh_bitfields
    {
        uint16_t TOVALHIGH : 16;       /*!< [15:0]  */
    } B;
} hw_wdog_tovalh_t;

/*!
 * @name Constants and macros for entire WDOG_TOVALH register
 */
/*@{*/
#define HW_WDOG_TOVALH_ADDR(x)   ((x) + 0x4U)

#define HW_WDOG_TOVALH(x)        (*(__IO hw_wdog_tovalh_t *) HW_WDOG_TOVALH_ADDR(x))
#define HW_WDOG_TOVALH_RD(x)     (ADDRESS_READ(hw_wdog_tovalh_t, HW_WDOG_TOVALH_ADDR(x)))
#define HW_WDOG_TOVALH_WR(x, v)  (ADDRESS_WRITE(hw_wdog_tovalh_t, HW_WDOG_TOVALH_ADDR(x), v))
#define HW_WDOG_TOVALH_SET(x, v) (HW_WDOG_TOVALH_WR(x, HW_WDOG_TOVALH_RD(x) |  (v)))
#define HW_WDOG_TOVALH_CLR(x, v) (HW_WDOG_TOVALH_WR(x, HW_WDOG_TOVALH_RD(x) & ~(v)))
#define HW_WDOG_TOVALH_TOG(x, v) (HW_WDOG_TOVALH_WR(x, HW_WDOG_TOVALH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_TOVALH bitfields
 */

/*!
 * @name Register WDOG_TOVALH, field TOVALHIGH[15:0] (RW)
 *
 * Defines the upper 16 bits of the 32-bit time-out value for the watchdog
 * timer. It is defined in terms of cycles of the watchdog clock.
 */
/*@{*/
#define BP_WDOG_TOVALH_TOVALHIGH (0U)      /*!< Bit position for WDOG_TOVALH_TOVALHIGH. */
#define BM_WDOG_TOVALH_TOVALHIGH (0xFFFFU) /*!< Bit mask for WDOG_TOVALH_TOVALHIGH. */
#define BS_WDOG_TOVALH_TOVALHIGH (16U)     /*!< Bit field size in bits for WDOG_TOVALH_TOVALHIGH. */

/*! @brief Read current value of the WDOG_TOVALH_TOVALHIGH field. */
#define BR_WDOG_TOVALH_TOVALHIGH(x) (HW_WDOG_TOVALH(x).U)

/*! @brief Format value for bitfield WDOG_TOVALH_TOVALHIGH. */
#define BF_WDOG_TOVALH_TOVALHIGH(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_TOVALH_TOVALHIGH) & BM_WDOG_TOVALH_TOVALHIGH)

/*! @brief Set the TOVALHIGH field to a new value. */
#define BW_WDOG_TOVALH_TOVALHIGH(x, v) (HW_WDOG_TOVALH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_TOVALL - Watchdog Time-out Value Register Low
 ******************************************************************************/

/*!
 * @brief HW_WDOG_TOVALL - Watchdog Time-out Value Register Low (RW)
 *
 * Reset value: 0x4B4CU
 *
 * The time-out value of the watchdog must be set to a minimum of four watchdog
 * clock cycles. This is to take into account the delay in new settings taking
 * effect in the watchdog clock domain.
 */
typedef union _hw_wdog_tovall
{
    uint16_t U;
    struct _hw_wdog_tovall_bitfields
    {
        uint16_t TOVALLOW : 16;        /*!< [15:0]  */
    } B;
} hw_wdog_tovall_t;

/*!
 * @name Constants and macros for entire WDOG_TOVALL register
 */
/*@{*/
#define HW_WDOG_TOVALL_ADDR(x)   ((x) + 0x6U)

#define HW_WDOG_TOVALL(x)        (*(__IO hw_wdog_tovall_t *) HW_WDOG_TOVALL_ADDR(x))
#define HW_WDOG_TOVALL_RD(x)     (ADDRESS_READ(hw_wdog_tovall_t, HW_WDOG_TOVALL_ADDR(x)))
#define HW_WDOG_TOVALL_WR(x, v)  (ADDRESS_WRITE(hw_wdog_tovall_t, HW_WDOG_TOVALL_ADDR(x), v))
#define HW_WDOG_TOVALL_SET(x, v) (HW_WDOG_TOVALL_WR(x, HW_WDOG_TOVALL_RD(x) |  (v)))
#define HW_WDOG_TOVALL_CLR(x, v) (HW_WDOG_TOVALL_WR(x, HW_WDOG_TOVALL_RD(x) & ~(v)))
#define HW_WDOG_TOVALL_TOG(x, v) (HW_WDOG_TOVALL_WR(x, HW_WDOG_TOVALL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_TOVALL bitfields
 */

/*!
 * @name Register WDOG_TOVALL, field TOVALLOW[15:0] (RW)
 *
 * Defines the lower 16 bits of the 32-bit time-out value for the watchdog
 * timer. It is defined in terms of cycles of the watchdog clock.
 */
/*@{*/
#define BP_WDOG_TOVALL_TOVALLOW (0U)       /*!< Bit position for WDOG_TOVALL_TOVALLOW. */
#define BM_WDOG_TOVALL_TOVALLOW (0xFFFFU)  /*!< Bit mask for WDOG_TOVALL_TOVALLOW. */
#define BS_WDOG_TOVALL_TOVALLOW (16U)      /*!< Bit field size in bits for WDOG_TOVALL_TOVALLOW. */

/*! @brief Read current value of the WDOG_TOVALL_TOVALLOW field. */
#define BR_WDOG_TOVALL_TOVALLOW(x) (HW_WDOG_TOVALL(x).U)

/*! @brief Format value for bitfield WDOG_TOVALL_TOVALLOW. */
#define BF_WDOG_TOVALL_TOVALLOW(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_TOVALL_TOVALLOW) & BM_WDOG_TOVALL_TOVALLOW)

/*! @brief Set the TOVALLOW field to a new value. */
#define BW_WDOG_TOVALL_TOVALLOW(x, v) (HW_WDOG_TOVALL_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_WINH - Watchdog Window Register High
 ******************************************************************************/

/*!
 * @brief HW_WDOG_WINH - Watchdog Window Register High (RW)
 *
 * Reset value: 0x0000U
 *
 * You must set the Window Register value lower than the Time-out Value Register.
 */
typedef union _hw_wdog_winh
{
    uint16_t U;
    struct _hw_wdog_winh_bitfields
    {
        uint16_t WINHIGH : 16;         /*!< [15:0]  */
    } B;
} hw_wdog_winh_t;

/*!
 * @name Constants and macros for entire WDOG_WINH register
 */
/*@{*/
#define HW_WDOG_WINH_ADDR(x)     ((x) + 0x8U)

#define HW_WDOG_WINH(x)          (*(__IO hw_wdog_winh_t *) HW_WDOG_WINH_ADDR(x))
#define HW_WDOG_WINH_RD(x)       (ADDRESS_READ(hw_wdog_winh_t, HW_WDOG_WINH_ADDR(x)))
#define HW_WDOG_WINH_WR(x, v)    (ADDRESS_WRITE(hw_wdog_winh_t, HW_WDOG_WINH_ADDR(x), v))
#define HW_WDOG_WINH_SET(x, v)   (HW_WDOG_WINH_WR(x, HW_WDOG_WINH_RD(x) |  (v)))
#define HW_WDOG_WINH_CLR(x, v)   (HW_WDOG_WINH_WR(x, HW_WDOG_WINH_RD(x) & ~(v)))
#define HW_WDOG_WINH_TOG(x, v)   (HW_WDOG_WINH_WR(x, HW_WDOG_WINH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_WINH bitfields
 */

/*!
 * @name Register WDOG_WINH, field WINHIGH[15:0] (RW)
 *
 * Defines the upper 16 bits of the 32-bit window for the windowed mode of
 * operation of the watchdog. It is defined in terms of cycles of the watchdog clock.
 * In this mode, the watchdog can be refreshed only when the timer has reached a
 * value greater than or equal to this window length. A refresh outside this
 * window resets the system or if IRQRSTEN is set, it interrupts and then resets the
 * system.
 */
/*@{*/
#define BP_WDOG_WINH_WINHIGH (0U)          /*!< Bit position for WDOG_WINH_WINHIGH. */
#define BM_WDOG_WINH_WINHIGH (0xFFFFU)     /*!< Bit mask for WDOG_WINH_WINHIGH. */
#define BS_WDOG_WINH_WINHIGH (16U)         /*!< Bit field size in bits for WDOG_WINH_WINHIGH. */

/*! @brief Read current value of the WDOG_WINH_WINHIGH field. */
#define BR_WDOG_WINH_WINHIGH(x) (HW_WDOG_WINH(x).U)

/*! @brief Format value for bitfield WDOG_WINH_WINHIGH. */
#define BF_WDOG_WINH_WINHIGH(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_WINH_WINHIGH) & BM_WDOG_WINH_WINHIGH)

/*! @brief Set the WINHIGH field to a new value. */
#define BW_WDOG_WINH_WINHIGH(x, v) (HW_WDOG_WINH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_WINL - Watchdog Window Register Low
 ******************************************************************************/

/*!
 * @brief HW_WDOG_WINL - Watchdog Window Register Low (RW)
 *
 * Reset value: 0x0010U
 *
 * You must set the Window Register value lower than the Time-out Value Register.
 */
typedef union _hw_wdog_winl
{
    uint16_t U;
    struct _hw_wdog_winl_bitfields
    {
        uint16_t WINLOW : 16;          /*!< [15:0]  */
    } B;
} hw_wdog_winl_t;

/*!
 * @name Constants and macros for entire WDOG_WINL register
 */
/*@{*/
#define HW_WDOG_WINL_ADDR(x)     ((x) + 0xAU)

#define HW_WDOG_WINL(x)          (*(__IO hw_wdog_winl_t *) HW_WDOG_WINL_ADDR(x))
#define HW_WDOG_WINL_RD(x)       (ADDRESS_READ(hw_wdog_winl_t, HW_WDOG_WINL_ADDR(x)))
#define HW_WDOG_WINL_WR(x, v)    (ADDRESS_WRITE(hw_wdog_winl_t, HW_WDOG_WINL_ADDR(x), v))
#define HW_WDOG_WINL_SET(x, v)   (HW_WDOG_WINL_WR(x, HW_WDOG_WINL_RD(x) |  (v)))
#define HW_WDOG_WINL_CLR(x, v)   (HW_WDOG_WINL_WR(x, HW_WDOG_WINL_RD(x) & ~(v)))
#define HW_WDOG_WINL_TOG(x, v)   (HW_WDOG_WINL_WR(x, HW_WDOG_WINL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_WINL bitfields
 */

/*!
 * @name Register WDOG_WINL, field WINLOW[15:0] (RW)
 *
 * Defines the lower 16 bits of the 32-bit window for the windowed mode of
 * operation of the watchdog. It is defined in terms of cycles of the pre-scaled
 * watchdog clock. In this mode, the watchdog can be refreshed only when the timer
 * reaches a value greater than or equal to this window length value. A refresh
 * outside of this window resets the system or if IRQRSTEN is set, it interrupts and
 * then resets the system.
 */
/*@{*/
#define BP_WDOG_WINL_WINLOW  (0U)          /*!< Bit position for WDOG_WINL_WINLOW. */
#define BM_WDOG_WINL_WINLOW  (0xFFFFU)     /*!< Bit mask for WDOG_WINL_WINLOW. */
#define BS_WDOG_WINL_WINLOW  (16U)         /*!< Bit field size in bits for WDOG_WINL_WINLOW. */

/*! @brief Read current value of the WDOG_WINL_WINLOW field. */
#define BR_WDOG_WINL_WINLOW(x) (HW_WDOG_WINL(x).U)

/*! @brief Format value for bitfield WDOG_WINL_WINLOW. */
#define BF_WDOG_WINL_WINLOW(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_WINL_WINLOW) & BM_WDOG_WINL_WINLOW)

/*! @brief Set the WINLOW field to a new value. */
#define BW_WDOG_WINL_WINLOW(x, v) (HW_WDOG_WINL_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_REFRESH - Watchdog Refresh register
 ******************************************************************************/

/*!
 * @brief HW_WDOG_REFRESH - Watchdog Refresh register (RW)
 *
 * Reset value: 0xB480U
 */
typedef union _hw_wdog_refresh
{
    uint16_t U;
    struct _hw_wdog_refresh_bitfields
    {
        uint16_t WDOGREFRESH : 16;     /*!< [15:0]  */
    } B;
} hw_wdog_refresh_t;

/*!
 * @name Constants and macros for entire WDOG_REFRESH register
 */
/*@{*/
#define HW_WDOG_REFRESH_ADDR(x)  ((x) + 0xCU)

#define HW_WDOG_REFRESH(x)       (*(__IO hw_wdog_refresh_t *) HW_WDOG_REFRESH_ADDR(x))
#define HW_WDOG_REFRESH_RD(x)    (ADDRESS_READ(hw_wdog_refresh_t, HW_WDOG_REFRESH_ADDR(x)))
#define HW_WDOG_REFRESH_WR(x, v) (ADDRESS_WRITE(hw_wdog_refresh_t, HW_WDOG_REFRESH_ADDR(x), v))
#define HW_WDOG_REFRESH_SET(x, v) (HW_WDOG_REFRESH_WR(x, HW_WDOG_REFRESH_RD(x) |  (v)))
#define HW_WDOG_REFRESH_CLR(x, v) (HW_WDOG_REFRESH_WR(x, HW_WDOG_REFRESH_RD(x) & ~(v)))
#define HW_WDOG_REFRESH_TOG(x, v) (HW_WDOG_REFRESH_WR(x, HW_WDOG_REFRESH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_REFRESH bitfields
 */

/*!
 * @name Register WDOG_REFRESH, field WDOGREFRESH[15:0] (RW)
 *
 * Watchdog refresh register. A sequence of 0xA602 followed by 0xB480 within 20
 * bus clock cycles written to this register refreshes the WDOG and prevents it
 * from resetting the system. Writing a value other than the above mentioned
 * sequence or if the sequence is longer than 20 bus cycles, resets the system, or if
 * IRQRSTEN is set, it interrupts and then resets the system.
 */
/*@{*/
#define BP_WDOG_REFRESH_WDOGREFRESH (0U)   /*!< Bit position for WDOG_REFRESH_WDOGREFRESH. */
#define BM_WDOG_REFRESH_WDOGREFRESH (0xFFFFU) /*!< Bit mask for WDOG_REFRESH_WDOGREFRESH. */
#define BS_WDOG_REFRESH_WDOGREFRESH (16U)  /*!< Bit field size in bits for WDOG_REFRESH_WDOGREFRESH. */

/*! @brief Read current value of the WDOG_REFRESH_WDOGREFRESH field. */
#define BR_WDOG_REFRESH_WDOGREFRESH(x) (HW_WDOG_REFRESH(x).U)

/*! @brief Format value for bitfield WDOG_REFRESH_WDOGREFRESH. */
#define BF_WDOG_REFRESH_WDOGREFRESH(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_REFRESH_WDOGREFRESH) & BM_WDOG_REFRESH_WDOGREFRESH)

/*! @brief Set the WDOGREFRESH field to a new value. */
#define BW_WDOG_REFRESH_WDOGREFRESH(x, v) (HW_WDOG_REFRESH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_UNLOCK - Watchdog Unlock register
 ******************************************************************************/

/*!
 * @brief HW_WDOG_UNLOCK - Watchdog Unlock register (RW)
 *
 * Reset value: 0xD928U
 */
typedef union _hw_wdog_unlock
{
    uint16_t U;
    struct _hw_wdog_unlock_bitfields
    {
        uint16_t WDOGUNLOCK : 16;      /*!< [15:0]  */
    } B;
} hw_wdog_unlock_t;

/*!
 * @name Constants and macros for entire WDOG_UNLOCK register
 */
/*@{*/
#define HW_WDOG_UNLOCK_ADDR(x)   ((x) + 0xEU)

#define HW_WDOG_UNLOCK(x)        (*(__IO hw_wdog_unlock_t *) HW_WDOG_UNLOCK_ADDR(x))
#define HW_WDOG_UNLOCK_RD(x)     (ADDRESS_READ(hw_wdog_unlock_t, HW_WDOG_UNLOCK_ADDR(x)))
#define HW_WDOG_UNLOCK_WR(x, v)  (ADDRESS_WRITE(hw_wdog_unlock_t, HW_WDOG_UNLOCK_ADDR(x), v))
#define HW_WDOG_UNLOCK_SET(x, v) (HW_WDOG_UNLOCK_WR(x, HW_WDOG_UNLOCK_RD(x) |  (v)))
#define HW_WDOG_UNLOCK_CLR(x, v) (HW_WDOG_UNLOCK_WR(x, HW_WDOG_UNLOCK_RD(x) & ~(v)))
#define HW_WDOG_UNLOCK_TOG(x, v) (HW_WDOG_UNLOCK_WR(x, HW_WDOG_UNLOCK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_UNLOCK bitfields
 */

/*!
 * @name Register WDOG_UNLOCK, field WDOGUNLOCK[15:0] (RW)
 *
 * Writing the unlock sequence values to this register to makes the watchdog
 * write-once registers writable again. The required unlock sequence is 0xC520
 * followed by 0xD928 within 20 bus clock cycles. A valid unlock sequence opens a
 * window equal in length to the WCT within which you can update the registers.
 * Writing a value other than the above mentioned sequence or if the sequence is
 * longer than 20 bus cycles, resets the system or if IRQRSTEN is set, it interrupts
 * and then resets the system. The unlock sequence is effective only if
 * ALLOWUPDATE is set.
 */
/*@{*/
#define BP_WDOG_UNLOCK_WDOGUNLOCK (0U)     /*!< Bit position for WDOG_UNLOCK_WDOGUNLOCK. */
#define BM_WDOG_UNLOCK_WDOGUNLOCK (0xFFFFU) /*!< Bit mask for WDOG_UNLOCK_WDOGUNLOCK. */
#define BS_WDOG_UNLOCK_WDOGUNLOCK (16U)    /*!< Bit field size in bits for WDOG_UNLOCK_WDOGUNLOCK. */

/*! @brief Read current value of the WDOG_UNLOCK_WDOGUNLOCK field. */
#define BR_WDOG_UNLOCK_WDOGUNLOCK(x) (HW_WDOG_UNLOCK(x).U)

/*! @brief Format value for bitfield WDOG_UNLOCK_WDOGUNLOCK. */
#define BF_WDOG_UNLOCK_WDOGUNLOCK(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_UNLOCK_WDOGUNLOCK) & BM_WDOG_UNLOCK_WDOGUNLOCK)

/*! @brief Set the WDOGUNLOCK field to a new value. */
#define BW_WDOG_UNLOCK_WDOGUNLOCK(x, v) (HW_WDOG_UNLOCK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_TMROUTH - Watchdog Timer Output Register High
 ******************************************************************************/

/*!
 * @brief HW_WDOG_TMROUTH - Watchdog Timer Output Register High (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_wdog_tmrouth
{
    uint16_t U;
    struct _hw_wdog_tmrouth_bitfields
    {
        uint16_t TIMEROUTHIGH : 16;    /*!< [15:0]  */
    } B;
} hw_wdog_tmrouth_t;

/*!
 * @name Constants and macros for entire WDOG_TMROUTH register
 */
/*@{*/
#define HW_WDOG_TMROUTH_ADDR(x)  ((x) + 0x10U)

#define HW_WDOG_TMROUTH(x)       (*(__IO hw_wdog_tmrouth_t *) HW_WDOG_TMROUTH_ADDR(x))
#define HW_WDOG_TMROUTH_RD(x)    (ADDRESS_READ(hw_wdog_tmrouth_t, HW_WDOG_TMROUTH_ADDR(x)))
#define HW_WDOG_TMROUTH_WR(x, v) (ADDRESS_WRITE(hw_wdog_tmrouth_t, HW_WDOG_TMROUTH_ADDR(x), v))
#define HW_WDOG_TMROUTH_SET(x, v) (HW_WDOG_TMROUTH_WR(x, HW_WDOG_TMROUTH_RD(x) |  (v)))
#define HW_WDOG_TMROUTH_CLR(x, v) (HW_WDOG_TMROUTH_WR(x, HW_WDOG_TMROUTH_RD(x) & ~(v)))
#define HW_WDOG_TMROUTH_TOG(x, v) (HW_WDOG_TMROUTH_WR(x, HW_WDOG_TMROUTH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_TMROUTH bitfields
 */

/*!
 * @name Register WDOG_TMROUTH, field TIMEROUTHIGH[15:0] (RW)
 *
 * Shows the value of the upper 16 bits of the watchdog timer.
 */
/*@{*/
#define BP_WDOG_TMROUTH_TIMEROUTHIGH (0U)  /*!< Bit position for WDOG_TMROUTH_TIMEROUTHIGH. */
#define BM_WDOG_TMROUTH_TIMEROUTHIGH (0xFFFFU) /*!< Bit mask for WDOG_TMROUTH_TIMEROUTHIGH. */
#define BS_WDOG_TMROUTH_TIMEROUTHIGH (16U) /*!< Bit field size in bits for WDOG_TMROUTH_TIMEROUTHIGH. */

/*! @brief Read current value of the WDOG_TMROUTH_TIMEROUTHIGH field. */
#define BR_WDOG_TMROUTH_TIMEROUTHIGH(x) (HW_WDOG_TMROUTH(x).U)

/*! @brief Format value for bitfield WDOG_TMROUTH_TIMEROUTHIGH. */
#define BF_WDOG_TMROUTH_TIMEROUTHIGH(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_TMROUTH_TIMEROUTHIGH) & BM_WDOG_TMROUTH_TIMEROUTHIGH)

/*! @brief Set the TIMEROUTHIGH field to a new value. */
#define BW_WDOG_TMROUTH_TIMEROUTHIGH(x, v) (HW_WDOG_TMROUTH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_TMROUTL - Watchdog Timer Output Register Low
 ******************************************************************************/

/*!
 * @brief HW_WDOG_TMROUTL - Watchdog Timer Output Register Low (RW)
 *
 * Reset value: 0x0000U
 *
 * During Stop mode, the WDOG_TIMER_OUT will be caught at the pre-stop value of
 * the watchdog timer. After exiting Stop mode, a maximum delay of 1 WDOG_CLK
 * cycle + 3 bus clock cycles will occur before the WDOG_TIMER_OUT starts following
 * the watchdog timer.
 */
typedef union _hw_wdog_tmroutl
{
    uint16_t U;
    struct _hw_wdog_tmroutl_bitfields
    {
        uint16_t TIMEROUTLOW : 16;     /*!< [15:0]  */
    } B;
} hw_wdog_tmroutl_t;

/*!
 * @name Constants and macros for entire WDOG_TMROUTL register
 */
/*@{*/
#define HW_WDOG_TMROUTL_ADDR(x)  ((x) + 0x12U)

#define HW_WDOG_TMROUTL(x)       (*(__IO hw_wdog_tmroutl_t *) HW_WDOG_TMROUTL_ADDR(x))
#define HW_WDOG_TMROUTL_RD(x)    (ADDRESS_READ(hw_wdog_tmroutl_t, HW_WDOG_TMROUTL_ADDR(x)))
#define HW_WDOG_TMROUTL_WR(x, v) (ADDRESS_WRITE(hw_wdog_tmroutl_t, HW_WDOG_TMROUTL_ADDR(x), v))
#define HW_WDOG_TMROUTL_SET(x, v) (HW_WDOG_TMROUTL_WR(x, HW_WDOG_TMROUTL_RD(x) |  (v)))
#define HW_WDOG_TMROUTL_CLR(x, v) (HW_WDOG_TMROUTL_WR(x, HW_WDOG_TMROUTL_RD(x) & ~(v)))
#define HW_WDOG_TMROUTL_TOG(x, v) (HW_WDOG_TMROUTL_WR(x, HW_WDOG_TMROUTL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_TMROUTL bitfields
 */

/*!
 * @name Register WDOG_TMROUTL, field TIMEROUTLOW[15:0] (RW)
 *
 * Shows the value of the lower 16 bits of the watchdog timer.
 */
/*@{*/
#define BP_WDOG_TMROUTL_TIMEROUTLOW (0U)   /*!< Bit position for WDOG_TMROUTL_TIMEROUTLOW. */
#define BM_WDOG_TMROUTL_TIMEROUTLOW (0xFFFFU) /*!< Bit mask for WDOG_TMROUTL_TIMEROUTLOW. */
#define BS_WDOG_TMROUTL_TIMEROUTLOW (16U)  /*!< Bit field size in bits for WDOG_TMROUTL_TIMEROUTLOW. */

/*! @brief Read current value of the WDOG_TMROUTL_TIMEROUTLOW field. */
#define BR_WDOG_TMROUTL_TIMEROUTLOW(x) (HW_WDOG_TMROUTL(x).U)

/*! @brief Format value for bitfield WDOG_TMROUTL_TIMEROUTLOW. */
#define BF_WDOG_TMROUTL_TIMEROUTLOW(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_TMROUTL_TIMEROUTLOW) & BM_WDOG_TMROUTL_TIMEROUTLOW)

/*! @brief Set the TIMEROUTLOW field to a new value. */
#define BW_WDOG_TMROUTL_TIMEROUTLOW(x, v) (HW_WDOG_TMROUTL_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_RSTCNT - Watchdog Reset Count register
 ******************************************************************************/

/*!
 * @brief HW_WDOG_RSTCNT - Watchdog Reset Count register (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_wdog_rstcnt
{
    uint16_t U;
    struct _hw_wdog_rstcnt_bitfields
    {
        uint16_t RSTCNT : 16;          /*!< [15:0]  */
    } B;
} hw_wdog_rstcnt_t;

/*!
 * @name Constants and macros for entire WDOG_RSTCNT register
 */
/*@{*/
#define HW_WDOG_RSTCNT_ADDR(x)   ((x) + 0x14U)

#define HW_WDOG_RSTCNT(x)        (*(__IO hw_wdog_rstcnt_t *) HW_WDOG_RSTCNT_ADDR(x))
#define HW_WDOG_RSTCNT_RD(x)     (ADDRESS_READ(hw_wdog_rstcnt_t, HW_WDOG_RSTCNT_ADDR(x)))
#define HW_WDOG_RSTCNT_WR(x, v)  (ADDRESS_WRITE(hw_wdog_rstcnt_t, HW_WDOG_RSTCNT_ADDR(x), v))
#define HW_WDOG_RSTCNT_SET(x, v) (HW_WDOG_RSTCNT_WR(x, HW_WDOG_RSTCNT_RD(x) |  (v)))
#define HW_WDOG_RSTCNT_CLR(x, v) (HW_WDOG_RSTCNT_WR(x, HW_WDOG_RSTCNT_RD(x) & ~(v)))
#define HW_WDOG_RSTCNT_TOG(x, v) (HW_WDOG_RSTCNT_WR(x, HW_WDOG_RSTCNT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_RSTCNT bitfields
 */

/*!
 * @name Register WDOG_RSTCNT, field RSTCNT[15:0] (RW)
 *
 * Counts the number of times the watchdog resets the system. This register is
 * reset only on a POR. Writing 1 to the bit to be cleared enables you to clear
 * the contents of this register.
 */
/*@{*/
#define BP_WDOG_RSTCNT_RSTCNT (0U)         /*!< Bit position for WDOG_RSTCNT_RSTCNT. */
#define BM_WDOG_RSTCNT_RSTCNT (0xFFFFU)    /*!< Bit mask for WDOG_RSTCNT_RSTCNT. */
#define BS_WDOG_RSTCNT_RSTCNT (16U)        /*!< Bit field size in bits for WDOG_RSTCNT_RSTCNT. */

/*! @brief Read current value of the WDOG_RSTCNT_RSTCNT field. */
#define BR_WDOG_RSTCNT_RSTCNT(x) (HW_WDOG_RSTCNT(x).U)

/*! @brief Format value for bitfield WDOG_RSTCNT_RSTCNT. */
#define BF_WDOG_RSTCNT_RSTCNT(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_RSTCNT_RSTCNT) & BM_WDOG_RSTCNT_RSTCNT)

/*! @brief Set the RSTCNT field to a new value. */
#define BW_WDOG_RSTCNT_RSTCNT(x, v) (HW_WDOG_RSTCNT_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_WDOG_PRESC - Watchdog Prescaler register
 ******************************************************************************/

/*!
 * @brief HW_WDOG_PRESC - Watchdog Prescaler register (RW)
 *
 * Reset value: 0x0400U
 */
typedef union _hw_wdog_presc
{
    uint16_t U;
    struct _hw_wdog_presc_bitfields
    {
        uint16_t RESERVED0 : 8;        /*!< [7:0]  */
        uint16_t PRESCVAL : 3;         /*!< [10:8]  */
        uint16_t RESERVED1 : 5;        /*!< [15:11]  */
    } B;
} hw_wdog_presc_t;

/*!
 * @name Constants and macros for entire WDOG_PRESC register
 */
/*@{*/
#define HW_WDOG_PRESC_ADDR(x)    ((x) + 0x16U)

#define HW_WDOG_PRESC(x)         (*(__IO hw_wdog_presc_t *) HW_WDOG_PRESC_ADDR(x))
#define HW_WDOG_PRESC_RD(x)      (ADDRESS_READ(hw_wdog_presc_t, HW_WDOG_PRESC_ADDR(x)))
#define HW_WDOG_PRESC_WR(x, v)   (ADDRESS_WRITE(hw_wdog_presc_t, HW_WDOG_PRESC_ADDR(x), v))
#define HW_WDOG_PRESC_SET(x, v)  (HW_WDOG_PRESC_WR(x, HW_WDOG_PRESC_RD(x) |  (v)))
#define HW_WDOG_PRESC_CLR(x, v)  (HW_WDOG_PRESC_WR(x, HW_WDOG_PRESC_RD(x) & ~(v)))
#define HW_WDOG_PRESC_TOG(x, v)  (HW_WDOG_PRESC_WR(x, HW_WDOG_PRESC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual WDOG_PRESC bitfields
 */

/*!
 * @name Register WDOG_PRESC, field PRESCVAL[10:8] (RW)
 *
 * 3-bit prescaler for the watchdog clock source. A value of zero indicates no
 * division of the input WDOG clock. The watchdog clock is divided by (PRESCVAL +
 * 1) to provide the prescaled WDOG_CLK.
 */
/*@{*/
#define BP_WDOG_PRESC_PRESCVAL (8U)        /*!< Bit position for WDOG_PRESC_PRESCVAL. */
#define BM_WDOG_PRESC_PRESCVAL (0x0700U)   /*!< Bit mask for WDOG_PRESC_PRESCVAL. */
#define BS_WDOG_PRESC_PRESCVAL (3U)        /*!< Bit field size in bits for WDOG_PRESC_PRESCVAL. */

/*! @brief Read current value of the WDOG_PRESC_PRESCVAL field. */
#define BR_WDOG_PRESC_PRESCVAL(x) (UNION_READ(hw_wdog_presc_t, HW_WDOG_PRESC_ADDR(x), U, B.PRESCVAL))

/*! @brief Format value for bitfield WDOG_PRESC_PRESCVAL. */
#define BF_WDOG_PRESC_PRESCVAL(v) ((uint16_t)((uint16_t)(v) << BP_WDOG_PRESC_PRESCVAL) & BM_WDOG_PRESC_PRESCVAL)

/*! @brief Set the PRESCVAL field to a new value. */
#define BW_WDOG_PRESC_PRESCVAL(x, v) (HW_WDOG_PRESC_WR(x, (HW_WDOG_PRESC_RD(x) & ~BM_WDOG_PRESC_PRESCVAL) | BF_WDOG_PRESC_PRESCVAL(v)))
/*@}*/

/*******************************************************************************
 * hw_wdog_t - module struct
 ******************************************************************************/
/*!
 * @brief All WDOG module registers.
 */
#pragma pack(1)
typedef struct _hw_wdog
{
    __IO hw_wdog_stctrlh_t STCTRLH;        /*!< [0x0] Watchdog Status and Control Register High */
    __IO hw_wdog_stctrll_t STCTRLL;        /*!< [0x2] Watchdog Status and Control Register Low */
    __IO hw_wdog_tovalh_t TOVALH;          /*!< [0x4] Watchdog Time-out Value Register High */
    __IO hw_wdog_tovall_t TOVALL;          /*!< [0x6] Watchdog Time-out Value Register Low */
    __IO hw_wdog_winh_t WINH;              /*!< [0x8] Watchdog Window Register High */
    __IO hw_wdog_winl_t WINL;              /*!< [0xA] Watchdog Window Register Low */
    __IO hw_wdog_refresh_t REFRESH;        /*!< [0xC] Watchdog Refresh register */
    __IO hw_wdog_unlock_t UNLOCK;          /*!< [0xE] Watchdog Unlock register */
    __IO hw_wdog_tmrouth_t TMROUTH;        /*!< [0x10] Watchdog Timer Output Register High */
    __IO hw_wdog_tmroutl_t TMROUTL;        /*!< [0x12] Watchdog Timer Output Register Low */
    __IO hw_wdog_rstcnt_t RSTCNT;          /*!< [0x14] Watchdog Reset Count register */
    __IO hw_wdog_presc_t PRESC;            /*!< [0x16] Watchdog Prescaler register */
} hw_wdog_t;
#pragma pack()

/*! @brief Macro to access all WDOG registers. */
/*! @param x WDOG module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_WDOG(WDOG_BASE)</code>. */
#define HW_WDOG(x)     (*(hw_wdog_t *)(x))

#endif /* __HW_WDOG_REGISTERS_H__ */
/* EOF */
