/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     (C) COPYRIGHT 2015-2015 ARM Limited
**     ALL RIGHTS RESERVED
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2015-08-03) (ARM)
**         All accesses to memory are replaced by equivalent macros; this allows
**         memory read/write operations to be re-defined if needed (for example,
**         to implement new security features
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_LLWU_REGISTERS_H__
#define __HW_LLWU_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 LLWU
 *
 * Low leakage wakeup unit
 *
 * Registers defined in this header file:
 * - HW_LLWU_PE1 - LLWU Pin Enable 1 register
 * - HW_LLWU_PE2 - LLWU Pin Enable 2 register
 * - HW_LLWU_PE3 - LLWU Pin Enable 3 register
 * - HW_LLWU_PE4 - LLWU Pin Enable 4 register
 * - HW_LLWU_ME - LLWU Module Enable register
 * - HW_LLWU_F1 - LLWU Flag 1 register
 * - HW_LLWU_F2 - LLWU Flag 2 register
 * - HW_LLWU_F3 - LLWU Flag 3 register
 * - HW_LLWU_FILT1 - LLWU Pin Filter 1 register
 * - HW_LLWU_FILT2 - LLWU Pin Filter 2 register
 * - HW_LLWU_RST - LLWU Reset Enable register
 *
 * - hw_llwu_t - Struct containing all module registers.
 */

#define HW_LLWU_INSTANCE_COUNT (1U) /*!< Number of instances of the LLWU module. */

/*******************************************************************************
 * HW_LLWU_PE1 - LLWU Pin Enable 1 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_PE1 - LLWU Pin Enable 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE1 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P3-LLWU_P0. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe1
{
    uint8_t U;
    struct _hw_llwu_pe1_bitfields
    {
        uint8_t WUPE0 : 2;             /*!< [1:0] Wakeup Pin Enable For LLWU_P0 */
        uint8_t WUPE1 : 2;             /*!< [3:2] Wakeup Pin Enable For LLWU_P1 */
        uint8_t WUPE2 : 2;             /*!< [5:4] Wakeup Pin Enable For LLWU_P2 */
        uint8_t WUPE3 : 2;             /*!< [7:6] Wakeup Pin Enable For LLWU_P3 */
    } B;
} hw_llwu_pe1_t;

/*!
 * @name Constants and macros for entire LLWU_PE1 register
 */
/*@{*/
#define HW_LLWU_PE1_ADDR(x)      ((x) + 0x0U)

#define HW_LLWU_PE1(x)           (*(__IO hw_llwu_pe1_t *) HW_LLWU_PE1_ADDR(x))
#define HW_LLWU_PE1_RD(x)        (ADDRESS_READ(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x)))
#define HW_LLWU_PE1_WR(x, v)     (ADDRESS_WRITE(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x), v))
#define HW_LLWU_PE1_SET(x, v)    (HW_LLWU_PE1_WR(x, HW_LLWU_PE1_RD(x) |  (v)))
#define HW_LLWU_PE1_CLR(x, v)    (HW_LLWU_PE1_WR(x, HW_LLWU_PE1_RD(x) & ~(v)))
#define HW_LLWU_PE1_TOG(x, v)    (HW_LLWU_PE1_WR(x, HW_LLWU_PE1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE1 bitfields
 */

/*!
 * @name Register LLWU_PE1, field WUPE0[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE1_WUPE0    (0U)          /*!< Bit position for LLWU_PE1_WUPE0. */
#define BM_LLWU_PE1_WUPE0    (0x03U)       /*!< Bit mask for LLWU_PE1_WUPE0. */
#define BS_LLWU_PE1_WUPE0    (2U)          /*!< Bit field size in bits for LLWU_PE1_WUPE0. */

/*! @brief Read current value of the LLWU_PE1_WUPE0 field. */
#define BR_LLWU_PE1_WUPE0(x) (UNION_READ(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x), U, B.WUPE0))

/*! @brief Format value for bitfield LLWU_PE1_WUPE0. */
#define BF_LLWU_PE1_WUPE0(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE1_WUPE0) & BM_LLWU_PE1_WUPE0)

/*! @brief Set the WUPE0 field to a new value. */
#define BW_LLWU_PE1_WUPE0(x, v) (HW_LLWU_PE1_WR(x, (HW_LLWU_PE1_RD(x) & ~BM_LLWU_PE1_WUPE0) | BF_LLWU_PE1_WUPE0(v)))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE1[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE1_WUPE1    (2U)          /*!< Bit position for LLWU_PE1_WUPE1. */
#define BM_LLWU_PE1_WUPE1    (0x0CU)       /*!< Bit mask for LLWU_PE1_WUPE1. */
#define BS_LLWU_PE1_WUPE1    (2U)          /*!< Bit field size in bits for LLWU_PE1_WUPE1. */

/*! @brief Read current value of the LLWU_PE1_WUPE1 field. */
#define BR_LLWU_PE1_WUPE1(x) (UNION_READ(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x), U, B.WUPE1))

/*! @brief Format value for bitfield LLWU_PE1_WUPE1. */
#define BF_LLWU_PE1_WUPE1(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE1_WUPE1) & BM_LLWU_PE1_WUPE1)

/*! @brief Set the WUPE1 field to a new value. */
#define BW_LLWU_PE1_WUPE1(x, v) (HW_LLWU_PE1_WR(x, (HW_LLWU_PE1_RD(x) & ~BM_LLWU_PE1_WUPE1) | BF_LLWU_PE1_WUPE1(v)))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE2[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE1_WUPE2    (4U)          /*!< Bit position for LLWU_PE1_WUPE2. */
#define BM_LLWU_PE1_WUPE2    (0x30U)       /*!< Bit mask for LLWU_PE1_WUPE2. */
#define BS_LLWU_PE1_WUPE2    (2U)          /*!< Bit field size in bits for LLWU_PE1_WUPE2. */

/*! @brief Read current value of the LLWU_PE1_WUPE2 field. */
#define BR_LLWU_PE1_WUPE2(x) (UNION_READ(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x), U, B.WUPE2))

/*! @brief Format value for bitfield LLWU_PE1_WUPE2. */
#define BF_LLWU_PE1_WUPE2(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE1_WUPE2) & BM_LLWU_PE1_WUPE2)

/*! @brief Set the WUPE2 field to a new value. */
#define BW_LLWU_PE1_WUPE2(x, v) (HW_LLWU_PE1_WR(x, (HW_LLWU_PE1_RD(x) & ~BM_LLWU_PE1_WUPE2) | BF_LLWU_PE1_WUPE2(v)))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE3[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE1_WUPE3    (6U)          /*!< Bit position for LLWU_PE1_WUPE3. */
#define BM_LLWU_PE1_WUPE3    (0xC0U)       /*!< Bit mask for LLWU_PE1_WUPE3. */
#define BS_LLWU_PE1_WUPE3    (2U)          /*!< Bit field size in bits for LLWU_PE1_WUPE3. */

/*! @brief Read current value of the LLWU_PE1_WUPE3 field. */
#define BR_LLWU_PE1_WUPE3(x) (UNION_READ(hw_llwu_pe1_t, HW_LLWU_PE1_ADDR(x), U, B.WUPE3))

/*! @brief Format value for bitfield LLWU_PE1_WUPE3. */
#define BF_LLWU_PE1_WUPE3(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE1_WUPE3) & BM_LLWU_PE1_WUPE3)

/*! @brief Set the WUPE3 field to a new value. */
#define BW_LLWU_PE1_WUPE3(x, v) (HW_LLWU_PE1_WR(x, (HW_LLWU_PE1_RD(x) & ~BM_LLWU_PE1_WUPE3) | BF_LLWU_PE1_WUPE3(v)))
/*@}*/

/*******************************************************************************
 * HW_LLWU_PE2 - LLWU Pin Enable 2 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_PE2 - LLWU Pin Enable 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE2 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P7-LLWU_P4. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe2
{
    uint8_t U;
    struct _hw_llwu_pe2_bitfields
    {
        uint8_t WUPE4 : 2;             /*!< [1:0] Wakeup Pin Enable For LLWU_P4 */
        uint8_t WUPE5 : 2;             /*!< [3:2] Wakeup Pin Enable For LLWU_P5 */
        uint8_t WUPE6 : 2;             /*!< [5:4] Wakeup Pin Enable For LLWU_P6 */
        uint8_t WUPE7 : 2;             /*!< [7:6] Wakeup Pin Enable For LLWU_P7 */
    } B;
} hw_llwu_pe2_t;

/*!
 * @name Constants and macros for entire LLWU_PE2 register
 */
/*@{*/
#define HW_LLWU_PE2_ADDR(x)      ((x) + 0x1U)

#define HW_LLWU_PE2(x)           (*(__IO hw_llwu_pe2_t *) HW_LLWU_PE2_ADDR(x))
#define HW_LLWU_PE2_RD(x)        (ADDRESS_READ(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x)))
#define HW_LLWU_PE2_WR(x, v)     (ADDRESS_WRITE(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x), v))
#define HW_LLWU_PE2_SET(x, v)    (HW_LLWU_PE2_WR(x, HW_LLWU_PE2_RD(x) |  (v)))
#define HW_LLWU_PE2_CLR(x, v)    (HW_LLWU_PE2_WR(x, HW_LLWU_PE2_RD(x) & ~(v)))
#define HW_LLWU_PE2_TOG(x, v)    (HW_LLWU_PE2_WR(x, HW_LLWU_PE2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE2 bitfields
 */

/*!
 * @name Register LLWU_PE2, field WUPE4[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE2_WUPE4    (0U)          /*!< Bit position for LLWU_PE2_WUPE4. */
#define BM_LLWU_PE2_WUPE4    (0x03U)       /*!< Bit mask for LLWU_PE2_WUPE4. */
#define BS_LLWU_PE2_WUPE4    (2U)          /*!< Bit field size in bits for LLWU_PE2_WUPE4. */

/*! @brief Read current value of the LLWU_PE2_WUPE4 field. */
#define BR_LLWU_PE2_WUPE4(x) (UNION_READ(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x), U, B.WUPE4))

/*! @brief Format value for bitfield LLWU_PE2_WUPE4. */
#define BF_LLWU_PE2_WUPE4(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE2_WUPE4) & BM_LLWU_PE2_WUPE4)

/*! @brief Set the WUPE4 field to a new value. */
#define BW_LLWU_PE2_WUPE4(x, v) (HW_LLWU_PE2_WR(x, (HW_LLWU_PE2_RD(x) & ~BM_LLWU_PE2_WUPE4) | BF_LLWU_PE2_WUPE4(v)))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE5[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE2_WUPE5    (2U)          /*!< Bit position for LLWU_PE2_WUPE5. */
#define BM_LLWU_PE2_WUPE5    (0x0CU)       /*!< Bit mask for LLWU_PE2_WUPE5. */
#define BS_LLWU_PE2_WUPE5    (2U)          /*!< Bit field size in bits for LLWU_PE2_WUPE5. */

/*! @brief Read current value of the LLWU_PE2_WUPE5 field. */
#define BR_LLWU_PE2_WUPE5(x) (UNION_READ(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x), U, B.WUPE5))

/*! @brief Format value for bitfield LLWU_PE2_WUPE5. */
#define BF_LLWU_PE2_WUPE5(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE2_WUPE5) & BM_LLWU_PE2_WUPE5)

/*! @brief Set the WUPE5 field to a new value. */
#define BW_LLWU_PE2_WUPE5(x, v) (HW_LLWU_PE2_WR(x, (HW_LLWU_PE2_RD(x) & ~BM_LLWU_PE2_WUPE5) | BF_LLWU_PE2_WUPE5(v)))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE6[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE2_WUPE6    (4U)          /*!< Bit position for LLWU_PE2_WUPE6. */
#define BM_LLWU_PE2_WUPE6    (0x30U)       /*!< Bit mask for LLWU_PE2_WUPE6. */
#define BS_LLWU_PE2_WUPE6    (2U)          /*!< Bit field size in bits for LLWU_PE2_WUPE6. */

/*! @brief Read current value of the LLWU_PE2_WUPE6 field. */
#define BR_LLWU_PE2_WUPE6(x) (UNION_READ(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x), U, B.WUPE6))

/*! @brief Format value for bitfield LLWU_PE2_WUPE6. */
#define BF_LLWU_PE2_WUPE6(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE2_WUPE6) & BM_LLWU_PE2_WUPE6)

/*! @brief Set the WUPE6 field to a new value. */
#define BW_LLWU_PE2_WUPE6(x, v) (HW_LLWU_PE2_WR(x, (HW_LLWU_PE2_RD(x) & ~BM_LLWU_PE2_WUPE6) | BF_LLWU_PE2_WUPE6(v)))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE7[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE2_WUPE7    (6U)          /*!< Bit position for LLWU_PE2_WUPE7. */
#define BM_LLWU_PE2_WUPE7    (0xC0U)       /*!< Bit mask for LLWU_PE2_WUPE7. */
#define BS_LLWU_PE2_WUPE7    (2U)          /*!< Bit field size in bits for LLWU_PE2_WUPE7. */

/*! @brief Read current value of the LLWU_PE2_WUPE7 field. */
#define BR_LLWU_PE2_WUPE7(x) (UNION_READ(hw_llwu_pe2_t, HW_LLWU_PE2_ADDR(x), U, B.WUPE7))

/*! @brief Format value for bitfield LLWU_PE2_WUPE7. */
#define BF_LLWU_PE2_WUPE7(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE2_WUPE7) & BM_LLWU_PE2_WUPE7)

/*! @brief Set the WUPE7 field to a new value. */
#define BW_LLWU_PE2_WUPE7(x, v) (HW_LLWU_PE2_WR(x, (HW_LLWU_PE2_RD(x) & ~BM_LLWU_PE2_WUPE7) | BF_LLWU_PE2_WUPE7(v)))
/*@}*/

/*******************************************************************************
 * HW_LLWU_PE3 - LLWU Pin Enable 3 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_PE3 - LLWU Pin Enable 3 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE3 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P11-LLWU_P8. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe3
{
    uint8_t U;
    struct _hw_llwu_pe3_bitfields
    {
        uint8_t WUPE8 : 2;             /*!< [1:0] Wakeup Pin Enable For LLWU_P8 */
        uint8_t WUPE9 : 2;             /*!< [3:2] Wakeup Pin Enable For LLWU_P9 */
        uint8_t WUPE10 : 2;            /*!< [5:4] Wakeup Pin Enable For LLWU_P10 */
        uint8_t WUPE11 : 2;            /*!< [7:6] Wakeup Pin Enable For LLWU_P11 */
    } B;
} hw_llwu_pe3_t;

/*!
 * @name Constants and macros for entire LLWU_PE3 register
 */
/*@{*/
#define HW_LLWU_PE3_ADDR(x)      ((x) + 0x2U)

#define HW_LLWU_PE3(x)           (*(__IO hw_llwu_pe3_t *) HW_LLWU_PE3_ADDR(x))
#define HW_LLWU_PE3_RD(x)        (ADDRESS_READ(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x)))
#define HW_LLWU_PE3_WR(x, v)     (ADDRESS_WRITE(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x), v))
#define HW_LLWU_PE3_SET(x, v)    (HW_LLWU_PE3_WR(x, HW_LLWU_PE3_RD(x) |  (v)))
#define HW_LLWU_PE3_CLR(x, v)    (HW_LLWU_PE3_WR(x, HW_LLWU_PE3_RD(x) & ~(v)))
#define HW_LLWU_PE3_TOG(x, v)    (HW_LLWU_PE3_WR(x, HW_LLWU_PE3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE3 bitfields
 */

/*!
 * @name Register LLWU_PE3, field WUPE8[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE3_WUPE8    (0U)          /*!< Bit position for LLWU_PE3_WUPE8. */
#define BM_LLWU_PE3_WUPE8    (0x03U)       /*!< Bit mask for LLWU_PE3_WUPE8. */
#define BS_LLWU_PE3_WUPE8    (2U)          /*!< Bit field size in bits for LLWU_PE3_WUPE8. */

/*! @brief Read current value of the LLWU_PE3_WUPE8 field. */
#define BR_LLWU_PE3_WUPE8(x) (UNION_READ(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x), U, B.WUPE8))

/*! @brief Format value for bitfield LLWU_PE3_WUPE8. */
#define BF_LLWU_PE3_WUPE8(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE3_WUPE8) & BM_LLWU_PE3_WUPE8)

/*! @brief Set the WUPE8 field to a new value. */
#define BW_LLWU_PE3_WUPE8(x, v) (HW_LLWU_PE3_WR(x, (HW_LLWU_PE3_RD(x) & ~BM_LLWU_PE3_WUPE8) | BF_LLWU_PE3_WUPE8(v)))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE9[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE3_WUPE9    (2U)          /*!< Bit position for LLWU_PE3_WUPE9. */
#define BM_LLWU_PE3_WUPE9    (0x0CU)       /*!< Bit mask for LLWU_PE3_WUPE9. */
#define BS_LLWU_PE3_WUPE9    (2U)          /*!< Bit field size in bits for LLWU_PE3_WUPE9. */

/*! @brief Read current value of the LLWU_PE3_WUPE9 field. */
#define BR_LLWU_PE3_WUPE9(x) (UNION_READ(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x), U, B.WUPE9))

/*! @brief Format value for bitfield LLWU_PE3_WUPE9. */
#define BF_LLWU_PE3_WUPE9(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE3_WUPE9) & BM_LLWU_PE3_WUPE9)

/*! @brief Set the WUPE9 field to a new value. */
#define BW_LLWU_PE3_WUPE9(x, v) (HW_LLWU_PE3_WR(x, (HW_LLWU_PE3_RD(x) & ~BM_LLWU_PE3_WUPE9) | BF_LLWU_PE3_WUPE9(v)))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE10[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE3_WUPE10   (4U)          /*!< Bit position for LLWU_PE3_WUPE10. */
#define BM_LLWU_PE3_WUPE10   (0x30U)       /*!< Bit mask for LLWU_PE3_WUPE10. */
#define BS_LLWU_PE3_WUPE10   (2U)          /*!< Bit field size in bits for LLWU_PE3_WUPE10. */

/*! @brief Read current value of the LLWU_PE3_WUPE10 field. */
#define BR_LLWU_PE3_WUPE10(x) (UNION_READ(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x), U, B.WUPE10))

/*! @brief Format value for bitfield LLWU_PE3_WUPE10. */
#define BF_LLWU_PE3_WUPE10(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE3_WUPE10) & BM_LLWU_PE3_WUPE10)

/*! @brief Set the WUPE10 field to a new value. */
#define BW_LLWU_PE3_WUPE10(x, v) (HW_LLWU_PE3_WR(x, (HW_LLWU_PE3_RD(x) & ~BM_LLWU_PE3_WUPE10) | BF_LLWU_PE3_WUPE10(v)))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE11[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE3_WUPE11   (6U)          /*!< Bit position for LLWU_PE3_WUPE11. */
#define BM_LLWU_PE3_WUPE11   (0xC0U)       /*!< Bit mask for LLWU_PE3_WUPE11. */
#define BS_LLWU_PE3_WUPE11   (2U)          /*!< Bit field size in bits for LLWU_PE3_WUPE11. */

/*! @brief Read current value of the LLWU_PE3_WUPE11 field. */
#define BR_LLWU_PE3_WUPE11(x) (UNION_READ(hw_llwu_pe3_t, HW_LLWU_PE3_ADDR(x), U, B.WUPE11))

/*! @brief Format value for bitfield LLWU_PE3_WUPE11. */
#define BF_LLWU_PE3_WUPE11(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE3_WUPE11) & BM_LLWU_PE3_WUPE11)

/*! @brief Set the WUPE11 field to a new value. */
#define BW_LLWU_PE3_WUPE11(x, v) (HW_LLWU_PE3_WR(x, (HW_LLWU_PE3_RD(x) & ~BM_LLWU_PE3_WUPE11) | BF_LLWU_PE3_WUPE11(v)))
/*@}*/

/*******************************************************************************
 * HW_LLWU_PE4 - LLWU Pin Enable 4 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_PE4 - LLWU Pin Enable 4 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE4 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P15-LLWU_P12. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe4
{
    uint8_t U;
    struct _hw_llwu_pe4_bitfields
    {
        uint8_t WUPE12 : 2;            /*!< [1:0] Wakeup Pin Enable For LLWU_P12 */
        uint8_t WUPE13 : 2;            /*!< [3:2] Wakeup Pin Enable For LLWU_P13 */
        uint8_t WUPE14 : 2;            /*!< [5:4] Wakeup Pin Enable For LLWU_P14 */
        uint8_t WUPE15 : 2;            /*!< [7:6] Wakeup Pin Enable For LLWU_P15 */
    } B;
} hw_llwu_pe4_t;

/*!
 * @name Constants and macros for entire LLWU_PE4 register
 */
/*@{*/
#define HW_LLWU_PE4_ADDR(x)      ((x) + 0x3U)

#define HW_LLWU_PE4(x)           (*(__IO hw_llwu_pe4_t *) HW_LLWU_PE4_ADDR(x))
#define HW_LLWU_PE4_RD(x)        (ADDRESS_READ(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x)))
#define HW_LLWU_PE4_WR(x, v)     (ADDRESS_WRITE(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x), v))
#define HW_LLWU_PE4_SET(x, v)    (HW_LLWU_PE4_WR(x, HW_LLWU_PE4_RD(x) |  (v)))
#define HW_LLWU_PE4_CLR(x, v)    (HW_LLWU_PE4_WR(x, HW_LLWU_PE4_RD(x) & ~(v)))
#define HW_LLWU_PE4_TOG(x, v)    (HW_LLWU_PE4_WR(x, HW_LLWU_PE4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE4 bitfields
 */

/*!
 * @name Register LLWU_PE4, field WUPE12[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE4_WUPE12   (0U)          /*!< Bit position for LLWU_PE4_WUPE12. */
#define BM_LLWU_PE4_WUPE12   (0x03U)       /*!< Bit mask for LLWU_PE4_WUPE12. */
#define BS_LLWU_PE4_WUPE12   (2U)          /*!< Bit field size in bits for LLWU_PE4_WUPE12. */

/*! @brief Read current value of the LLWU_PE4_WUPE12 field. */
#define BR_LLWU_PE4_WUPE12(x) (UNION_READ(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x), U, B.WUPE12))

/*! @brief Format value for bitfield LLWU_PE4_WUPE12. */
#define BF_LLWU_PE4_WUPE12(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE4_WUPE12) & BM_LLWU_PE4_WUPE12)

/*! @brief Set the WUPE12 field to a new value. */
#define BW_LLWU_PE4_WUPE12(x, v) (HW_LLWU_PE4_WR(x, (HW_LLWU_PE4_RD(x) & ~BM_LLWU_PE4_WUPE12) | BF_LLWU_PE4_WUPE12(v)))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE13[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE4_WUPE13   (2U)          /*!< Bit position for LLWU_PE4_WUPE13. */
#define BM_LLWU_PE4_WUPE13   (0x0CU)       /*!< Bit mask for LLWU_PE4_WUPE13. */
#define BS_LLWU_PE4_WUPE13   (2U)          /*!< Bit field size in bits for LLWU_PE4_WUPE13. */

/*! @brief Read current value of the LLWU_PE4_WUPE13 field. */
#define BR_LLWU_PE4_WUPE13(x) (UNION_READ(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x), U, B.WUPE13))

/*! @brief Format value for bitfield LLWU_PE4_WUPE13. */
#define BF_LLWU_PE4_WUPE13(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE4_WUPE13) & BM_LLWU_PE4_WUPE13)

/*! @brief Set the WUPE13 field to a new value. */
#define BW_LLWU_PE4_WUPE13(x, v) (HW_LLWU_PE4_WR(x, (HW_LLWU_PE4_RD(x) & ~BM_LLWU_PE4_WUPE13) | BF_LLWU_PE4_WUPE13(v)))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE14[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE4_WUPE14   (4U)          /*!< Bit position for LLWU_PE4_WUPE14. */
#define BM_LLWU_PE4_WUPE14   (0x30U)       /*!< Bit mask for LLWU_PE4_WUPE14. */
#define BS_LLWU_PE4_WUPE14   (2U)          /*!< Bit field size in bits for LLWU_PE4_WUPE14. */

/*! @brief Read current value of the LLWU_PE4_WUPE14 field. */
#define BR_LLWU_PE4_WUPE14(x) (UNION_READ(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x), U, B.WUPE14))

/*! @brief Format value for bitfield LLWU_PE4_WUPE14. */
#define BF_LLWU_PE4_WUPE14(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE4_WUPE14) & BM_LLWU_PE4_WUPE14)

/*! @brief Set the WUPE14 field to a new value. */
#define BW_LLWU_PE4_WUPE14(x, v) (HW_LLWU_PE4_WR(x, (HW_LLWU_PE4_RD(x) & ~BM_LLWU_PE4_WUPE14) | BF_LLWU_PE4_WUPE14(v)))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE15[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
#define BP_LLWU_PE4_WUPE15   (6U)          /*!< Bit position for LLWU_PE4_WUPE15. */
#define BM_LLWU_PE4_WUPE15   (0xC0U)       /*!< Bit mask for LLWU_PE4_WUPE15. */
#define BS_LLWU_PE4_WUPE15   (2U)          /*!< Bit field size in bits for LLWU_PE4_WUPE15. */

/*! @brief Read current value of the LLWU_PE4_WUPE15 field. */
#define BR_LLWU_PE4_WUPE15(x) (UNION_READ(hw_llwu_pe4_t, HW_LLWU_PE4_ADDR(x), U, B.WUPE15))

/*! @brief Format value for bitfield LLWU_PE4_WUPE15. */
#define BF_LLWU_PE4_WUPE15(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_PE4_WUPE15) & BM_LLWU_PE4_WUPE15)

/*! @brief Set the WUPE15 field to a new value. */
#define BW_LLWU_PE4_WUPE15(x, v) (HW_LLWU_PE4_WR(x, (HW_LLWU_PE4_RD(x) & ~BM_LLWU_PE4_WUPE15) | BF_LLWU_PE4_WUPE15(v)))
/*@}*/

/*******************************************************************************
 * HW_LLWU_ME - LLWU Module Enable register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_ME - LLWU Module Enable register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_ME contains the bits to enable the internal module flag as a wakeup
 * input source for inputs MWUF7-MWUF0. This register is reset on Chip Reset not VLLS
 * and by reset types that trigger Chip Reset not VLLS. It is unaffected by
 * reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module (RCM). The
 * RCM implements many of the reset functions for the chip. See the chip's reset
 * chapter for more information. details for more information.
 */
typedef union _hw_llwu_me
{
    uint8_t U;
    struct _hw_llwu_me_bitfields
    {
        uint8_t WUME0 : 1;             /*!< [0] Wakeup Module Enable For Module 0 */
        uint8_t WUME1 : 1;             /*!< [1] Wakeup Module Enable for Module 1 */
        uint8_t WUME2 : 1;             /*!< [2] Wakeup Module Enable For Module 2 */
        uint8_t WUME3 : 1;             /*!< [3] Wakeup Module Enable For Module 3 */
        uint8_t WUME4 : 1;             /*!< [4] Wakeup Module Enable For Module 4 */
        uint8_t WUME5 : 1;             /*!< [5] Wakeup Module Enable For Module 5 */
        uint8_t WUME6 : 1;             /*!< [6] Wakeup Module Enable For Module 6 */
        uint8_t WUME7 : 1;             /*!< [7] Wakeup Module Enable For Module 7 */
    } B;
} hw_llwu_me_t;

/*!
 * @name Constants and macros for entire LLWU_ME register
 */
/*@{*/
#define HW_LLWU_ME_ADDR(x)       ((x) + 0x4U)

#define HW_LLWU_ME(x)            (*(__IO hw_llwu_me_t *) HW_LLWU_ME_ADDR(x))
#define HW_LLWU_ME_RD(x)         (ADDRESS_READ(hw_llwu_me_t, HW_LLWU_ME_ADDR(x)))
#define HW_LLWU_ME_WR(x, v)      (ADDRESS_WRITE(hw_llwu_me_t, HW_LLWU_ME_ADDR(x), v))
#define HW_LLWU_ME_SET(x, v)     (HW_LLWU_ME_WR(x, HW_LLWU_ME_RD(x) |  (v)))
#define HW_LLWU_ME_CLR(x, v)     (HW_LLWU_ME_WR(x, HW_LLWU_ME_RD(x) & ~(v)))
#define HW_LLWU_ME_TOG(x, v)     (HW_LLWU_ME_WR(x, HW_LLWU_ME_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_ME bitfields
 */

/*!
 * @name Register LLWU_ME, field WUME0[0] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME0     (0U)          /*!< Bit position for LLWU_ME_WUME0. */
#define BM_LLWU_ME_WUME0     (0x01U)       /*!< Bit mask for LLWU_ME_WUME0. */
#define BS_LLWU_ME_WUME0     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME0. */

/*! @brief Read current value of the LLWU_ME_WUME0 field. */
#define BR_LLWU_ME_WUME0(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME0)))

/*! @brief Format value for bitfield LLWU_ME_WUME0. */
#define BF_LLWU_ME_WUME0(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME0) & BM_LLWU_ME_WUME0)

/*! @brief Set the WUME0 field to a new value. */
#define BW_LLWU_ME_WUME0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME0), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME1[1] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME1     (1U)          /*!< Bit position for LLWU_ME_WUME1. */
#define BM_LLWU_ME_WUME1     (0x02U)       /*!< Bit mask for LLWU_ME_WUME1. */
#define BS_LLWU_ME_WUME1     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME1. */

/*! @brief Read current value of the LLWU_ME_WUME1 field. */
#define BR_LLWU_ME_WUME1(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME1)))

/*! @brief Format value for bitfield LLWU_ME_WUME1. */
#define BF_LLWU_ME_WUME1(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME1) & BM_LLWU_ME_WUME1)

/*! @brief Set the WUME1 field to a new value. */
#define BW_LLWU_ME_WUME1(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME1), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME2[2] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME2     (2U)          /*!< Bit position for LLWU_ME_WUME2. */
#define BM_LLWU_ME_WUME2     (0x04U)       /*!< Bit mask for LLWU_ME_WUME2. */
#define BS_LLWU_ME_WUME2     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME2. */

/*! @brief Read current value of the LLWU_ME_WUME2 field. */
#define BR_LLWU_ME_WUME2(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME2)))

/*! @brief Format value for bitfield LLWU_ME_WUME2. */
#define BF_LLWU_ME_WUME2(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME2) & BM_LLWU_ME_WUME2)

/*! @brief Set the WUME2 field to a new value. */
#define BW_LLWU_ME_WUME2(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME2), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME3[3] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME3     (3U)          /*!< Bit position for LLWU_ME_WUME3. */
#define BM_LLWU_ME_WUME3     (0x08U)       /*!< Bit mask for LLWU_ME_WUME3. */
#define BS_LLWU_ME_WUME3     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME3. */

/*! @brief Read current value of the LLWU_ME_WUME3 field. */
#define BR_LLWU_ME_WUME3(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME3)))

/*! @brief Format value for bitfield LLWU_ME_WUME3. */
#define BF_LLWU_ME_WUME3(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME3) & BM_LLWU_ME_WUME3)

/*! @brief Set the WUME3 field to a new value. */
#define BW_LLWU_ME_WUME3(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME3), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME4[4] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME4     (4U)          /*!< Bit position for LLWU_ME_WUME4. */
#define BM_LLWU_ME_WUME4     (0x10U)       /*!< Bit mask for LLWU_ME_WUME4. */
#define BS_LLWU_ME_WUME4     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME4. */

/*! @brief Read current value of the LLWU_ME_WUME4 field. */
#define BR_LLWU_ME_WUME4(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME4)))

/*! @brief Format value for bitfield LLWU_ME_WUME4. */
#define BF_LLWU_ME_WUME4(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME4) & BM_LLWU_ME_WUME4)

/*! @brief Set the WUME4 field to a new value. */
#define BW_LLWU_ME_WUME4(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME4), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME5[5] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME5     (5U)          /*!< Bit position for LLWU_ME_WUME5. */
#define BM_LLWU_ME_WUME5     (0x20U)       /*!< Bit mask for LLWU_ME_WUME5. */
#define BS_LLWU_ME_WUME5     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME5. */

/*! @brief Read current value of the LLWU_ME_WUME5 field. */
#define BR_LLWU_ME_WUME5(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME5)))

/*! @brief Format value for bitfield LLWU_ME_WUME5. */
#define BF_LLWU_ME_WUME5(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME5) & BM_LLWU_ME_WUME5)

/*! @brief Set the WUME5 field to a new value. */
#define BW_LLWU_ME_WUME5(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME5), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME6[6] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME6     (6U)          /*!< Bit position for LLWU_ME_WUME6. */
#define BM_LLWU_ME_WUME6     (0x40U)       /*!< Bit mask for LLWU_ME_WUME6. */
#define BS_LLWU_ME_WUME6     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME6. */

/*! @brief Read current value of the LLWU_ME_WUME6 field. */
#define BR_LLWU_ME_WUME6(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME6)))

/*! @brief Format value for bitfield LLWU_ME_WUME6. */
#define BF_LLWU_ME_WUME6(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME6) & BM_LLWU_ME_WUME6)

/*! @brief Set the WUME6 field to a new value. */
#define BW_LLWU_ME_WUME6(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME6), v))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME7[7] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
#define BP_LLWU_ME_WUME7     (7U)          /*!< Bit position for LLWU_ME_WUME7. */
#define BM_LLWU_ME_WUME7     (0x80U)       /*!< Bit mask for LLWU_ME_WUME7. */
#define BS_LLWU_ME_WUME7     (1U)          /*!< Bit field size in bits for LLWU_ME_WUME7. */

/*! @brief Read current value of the LLWU_ME_WUME7 field. */
#define BR_LLWU_ME_WUME7(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME7)))

/*! @brief Format value for bitfield LLWU_ME_WUME7. */
#define BF_LLWU_ME_WUME7(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_ME_WUME7) & BM_LLWU_ME_WUME7)

/*! @brief Set the WUME7 field to a new value. */
#define BW_LLWU_ME_WUME7(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_ME_ADDR(x), BP_LLWU_ME_WUME7), v))
/*@}*/

/*******************************************************************************
 * HW_LLWU_F1 - LLWU Flag 1 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_F1 - LLWU Flag 1 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F1 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_f1
{
    uint8_t U;
    struct _hw_llwu_f1_bitfields
    {
        uint8_t WUF0 : 1;              /*!< [0] Wakeup Flag For LLWU_P0 */
        uint8_t WUF1 : 1;              /*!< [1] Wakeup Flag For LLWU_P1 */
        uint8_t WUF2 : 1;              /*!< [2] Wakeup Flag For LLWU_P2 */
        uint8_t WUF3 : 1;              /*!< [3] Wakeup Flag For LLWU_P3 */
        uint8_t WUF4 : 1;              /*!< [4] Wakeup Flag For LLWU_P4 */
        uint8_t WUF5 : 1;              /*!< [5] Wakeup Flag For LLWU_P5 */
        uint8_t WUF6 : 1;              /*!< [6] Wakeup Flag For LLWU_P6 */
        uint8_t WUF7 : 1;              /*!< [7] Wakeup Flag For LLWU_P7 */
    } B;
} hw_llwu_f1_t;

/*!
 * @name Constants and macros for entire LLWU_F1 register
 */
/*@{*/
#define HW_LLWU_F1_ADDR(x)       ((x) + 0x5U)

#define HW_LLWU_F1(x)            (*(__IO hw_llwu_f1_t *) HW_LLWU_F1_ADDR(x))
#define HW_LLWU_F1_RD(x)         (ADDRESS_READ(hw_llwu_f1_t, HW_LLWU_F1_ADDR(x)))
#define HW_LLWU_F1_WR(x, v)      (ADDRESS_WRITE(hw_llwu_f1_t, HW_LLWU_F1_ADDR(x), v))
#define HW_LLWU_F1_SET(x, v)     (HW_LLWU_F1_WR(x, HW_LLWU_F1_RD(x) |  (v)))
#define HW_LLWU_F1_CLR(x, v)     (HW_LLWU_F1_WR(x, HW_LLWU_F1_RD(x) & ~(v)))
#define HW_LLWU_F1_TOG(x, v)     (HW_LLWU_F1_WR(x, HW_LLWU_F1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_F1 bitfields
 */

/*!
 * @name Register LLWU_F1, field WUF0[0] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF0.
 *
 * Values:
 * - 0 - LLWU_P0 input was not a wakeup source
 * - 1 - LLWU_P0 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF0      (0U)          /*!< Bit position for LLWU_F1_WUF0. */
#define BM_LLWU_F1_WUF0      (0x01U)       /*!< Bit mask for LLWU_F1_WUF0. */
#define BS_LLWU_F1_WUF0      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF0. */

/*! @brief Read current value of the LLWU_F1_WUF0 field. */
#define BR_LLWU_F1_WUF0(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF0)))

/*! @brief Format value for bitfield LLWU_F1_WUF0. */
#define BF_LLWU_F1_WUF0(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF0) & BM_LLWU_F1_WUF0)

/*! @brief Set the WUF0 field to a new value. */
#define BW_LLWU_F1_WUF0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF0), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF1[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF1.
 *
 * Values:
 * - 0 - LLWU_P1 input was not a wakeup source
 * - 1 - LLWU_P1 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF1      (1U)          /*!< Bit position for LLWU_F1_WUF1. */
#define BM_LLWU_F1_WUF1      (0x02U)       /*!< Bit mask for LLWU_F1_WUF1. */
#define BS_LLWU_F1_WUF1      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF1. */

/*! @brief Read current value of the LLWU_F1_WUF1 field. */
#define BR_LLWU_F1_WUF1(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF1)))

/*! @brief Format value for bitfield LLWU_F1_WUF1. */
#define BF_LLWU_F1_WUF1(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF1) & BM_LLWU_F1_WUF1)

/*! @brief Set the WUF1 field to a new value. */
#define BW_LLWU_F1_WUF1(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF1), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF2[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF2.
 *
 * Values:
 * - 0 - LLWU_P2 input was not a wakeup source
 * - 1 - LLWU_P2 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF2      (2U)          /*!< Bit position for LLWU_F1_WUF2. */
#define BM_LLWU_F1_WUF2      (0x04U)       /*!< Bit mask for LLWU_F1_WUF2. */
#define BS_LLWU_F1_WUF2      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF2. */

/*! @brief Read current value of the LLWU_F1_WUF2 field. */
#define BR_LLWU_F1_WUF2(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF2)))

/*! @brief Format value for bitfield LLWU_F1_WUF2. */
#define BF_LLWU_F1_WUF2(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF2) & BM_LLWU_F1_WUF2)

/*! @brief Set the WUF2 field to a new value. */
#define BW_LLWU_F1_WUF2(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF2), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF3[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF3.
 *
 * Values:
 * - 0 - LLWU_P3 input was not a wake-up source
 * - 1 - LLWU_P3 input was a wake-up source
 */
/*@{*/
#define BP_LLWU_F1_WUF3      (3U)          /*!< Bit position for LLWU_F1_WUF3. */
#define BM_LLWU_F1_WUF3      (0x08U)       /*!< Bit mask for LLWU_F1_WUF3. */
#define BS_LLWU_F1_WUF3      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF3. */

/*! @brief Read current value of the LLWU_F1_WUF3 field. */
#define BR_LLWU_F1_WUF3(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF3)))

/*! @brief Format value for bitfield LLWU_F1_WUF3. */
#define BF_LLWU_F1_WUF3(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF3) & BM_LLWU_F1_WUF3)

/*! @brief Set the WUF3 field to a new value. */
#define BW_LLWU_F1_WUF3(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF3), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF4[4] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF4.
 *
 * Values:
 * - 0 - LLWU_P4 input was not a wakeup source
 * - 1 - LLWU_P4 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF4      (4U)          /*!< Bit position for LLWU_F1_WUF4. */
#define BM_LLWU_F1_WUF4      (0x10U)       /*!< Bit mask for LLWU_F1_WUF4. */
#define BS_LLWU_F1_WUF4      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF4. */

/*! @brief Read current value of the LLWU_F1_WUF4 field. */
#define BR_LLWU_F1_WUF4(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF4)))

/*! @brief Format value for bitfield LLWU_F1_WUF4. */
#define BF_LLWU_F1_WUF4(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF4) & BM_LLWU_F1_WUF4)

/*! @brief Set the WUF4 field to a new value. */
#define BW_LLWU_F1_WUF4(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF4), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF5[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF5.
 *
 * Values:
 * - 0 - LLWU_P5 input was not a wakeup source
 * - 1 - LLWU_P5 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF5      (5U)          /*!< Bit position for LLWU_F1_WUF5. */
#define BM_LLWU_F1_WUF5      (0x20U)       /*!< Bit mask for LLWU_F1_WUF5. */
#define BS_LLWU_F1_WUF5      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF5. */

/*! @brief Read current value of the LLWU_F1_WUF5 field. */
#define BR_LLWU_F1_WUF5(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF5)))

/*! @brief Format value for bitfield LLWU_F1_WUF5. */
#define BF_LLWU_F1_WUF5(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF5) & BM_LLWU_F1_WUF5)

/*! @brief Set the WUF5 field to a new value. */
#define BW_LLWU_F1_WUF5(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF5), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF6[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF6.
 *
 * Values:
 * - 0 - LLWU_P6 input was not a wakeup source
 * - 1 - LLWU_P6 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF6      (6U)          /*!< Bit position for LLWU_F1_WUF6. */
#define BM_LLWU_F1_WUF6      (0x40U)       /*!< Bit mask for LLWU_F1_WUF6. */
#define BS_LLWU_F1_WUF6      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF6. */

/*! @brief Read current value of the LLWU_F1_WUF6 field. */
#define BR_LLWU_F1_WUF6(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF6)))

/*! @brief Format value for bitfield LLWU_F1_WUF6. */
#define BF_LLWU_F1_WUF6(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF6) & BM_LLWU_F1_WUF6)

/*! @brief Set the WUF6 field to a new value. */
#define BW_LLWU_F1_WUF6(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF6), v))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF7[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF7.
 *
 * Values:
 * - 0 - LLWU_P7 input was not a wakeup source
 * - 1 - LLWU_P7 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F1_WUF7      (7U)          /*!< Bit position for LLWU_F1_WUF7. */
#define BM_LLWU_F1_WUF7      (0x80U)       /*!< Bit mask for LLWU_F1_WUF7. */
#define BS_LLWU_F1_WUF7      (1U)          /*!< Bit field size in bits for LLWU_F1_WUF7. */

/*! @brief Read current value of the LLWU_F1_WUF7 field. */
#define BR_LLWU_F1_WUF7(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF7)))

/*! @brief Format value for bitfield LLWU_F1_WUF7. */
#define BF_LLWU_F1_WUF7(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F1_WUF7) & BM_LLWU_F1_WUF7)

/*! @brief Set the WUF7 field to a new value. */
#define BW_LLWU_F1_WUF7(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F1_ADDR(x), BP_LLWU_F1_WUF7), v))
/*@}*/

/*******************************************************************************
 * HW_LLWU_F2 - LLWU Flag 2 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_F2 - LLWU Flag 2 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F2 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_f2
{
    uint8_t U;
    struct _hw_llwu_f2_bitfields
    {
        uint8_t WUF8 : 1;              /*!< [0] Wakeup Flag For LLWU_P8 */
        uint8_t WUF9 : 1;              /*!< [1] Wakeup Flag For LLWU_P9 */
        uint8_t WUF10 : 1;             /*!< [2] Wakeup Flag For LLWU_P10 */
        uint8_t WUF11 : 1;             /*!< [3] Wakeup Flag For LLWU_P11 */
        uint8_t WUF12 : 1;             /*!< [4] Wakeup Flag For LLWU_P12 */
        uint8_t WUF13 : 1;             /*!< [5] Wakeup Flag For LLWU_P13 */
        uint8_t WUF14 : 1;             /*!< [6] Wakeup Flag For LLWU_P14 */
        uint8_t WUF15 : 1;             /*!< [7] Wakeup Flag For LLWU_P15 */
    } B;
} hw_llwu_f2_t;

/*!
 * @name Constants and macros for entire LLWU_F2 register
 */
/*@{*/
#define HW_LLWU_F2_ADDR(x)       ((x) + 0x6U)

#define HW_LLWU_F2(x)            (*(__IO hw_llwu_f2_t *) HW_LLWU_F2_ADDR(x))
#define HW_LLWU_F2_RD(x)         (ADDRESS_READ(hw_llwu_f2_t, HW_LLWU_F2_ADDR(x)))
#define HW_LLWU_F2_WR(x, v)      (ADDRESS_WRITE(hw_llwu_f2_t, HW_LLWU_F2_ADDR(x), v))
#define HW_LLWU_F2_SET(x, v)     (HW_LLWU_F2_WR(x, HW_LLWU_F2_RD(x) |  (v)))
#define HW_LLWU_F2_CLR(x, v)     (HW_LLWU_F2_WR(x, HW_LLWU_F2_RD(x) & ~(v)))
#define HW_LLWU_F2_TOG(x, v)     (HW_LLWU_F2_WR(x, HW_LLWU_F2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_F2 bitfields
 */

/*!
 * @name Register LLWU_F2, field WUF8[0] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF8.
 *
 * Values:
 * - 0 - LLWU_P8 input was not a wakeup source
 * - 1 - LLWU_P8 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF8      (0U)          /*!< Bit position for LLWU_F2_WUF8. */
#define BM_LLWU_F2_WUF8      (0x01U)       /*!< Bit mask for LLWU_F2_WUF8. */
#define BS_LLWU_F2_WUF8      (1U)          /*!< Bit field size in bits for LLWU_F2_WUF8. */

/*! @brief Read current value of the LLWU_F2_WUF8 field. */
#define BR_LLWU_F2_WUF8(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF8)))

/*! @brief Format value for bitfield LLWU_F2_WUF8. */
#define BF_LLWU_F2_WUF8(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF8) & BM_LLWU_F2_WUF8)

/*! @brief Set the WUF8 field to a new value. */
#define BW_LLWU_F2_WUF8(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF8), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF9[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF9.
 *
 * Values:
 * - 0 - LLWU_P9 input was not a wakeup source
 * - 1 - LLWU_P9 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF9      (1U)          /*!< Bit position for LLWU_F2_WUF9. */
#define BM_LLWU_F2_WUF9      (0x02U)       /*!< Bit mask for LLWU_F2_WUF9. */
#define BS_LLWU_F2_WUF9      (1U)          /*!< Bit field size in bits for LLWU_F2_WUF9. */

/*! @brief Read current value of the LLWU_F2_WUF9 field. */
#define BR_LLWU_F2_WUF9(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF9)))

/*! @brief Format value for bitfield LLWU_F2_WUF9. */
#define BF_LLWU_F2_WUF9(v)   ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF9) & BM_LLWU_F2_WUF9)

/*! @brief Set the WUF9 field to a new value. */
#define BW_LLWU_F2_WUF9(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF9), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF10[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF10.
 *
 * Values:
 * - 0 - LLWU_P10 input was not a wakeup source
 * - 1 - LLWU_P10 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF10     (2U)          /*!< Bit position for LLWU_F2_WUF10. */
#define BM_LLWU_F2_WUF10     (0x04U)       /*!< Bit mask for LLWU_F2_WUF10. */
#define BS_LLWU_F2_WUF10     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF10. */

/*! @brief Read current value of the LLWU_F2_WUF10 field. */
#define BR_LLWU_F2_WUF10(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF10)))

/*! @brief Format value for bitfield LLWU_F2_WUF10. */
#define BF_LLWU_F2_WUF10(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF10) & BM_LLWU_F2_WUF10)

/*! @brief Set the WUF10 field to a new value. */
#define BW_LLWU_F2_WUF10(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF10), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF11[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF11.
 *
 * Values:
 * - 0 - LLWU_P11 input was not a wakeup source
 * - 1 - LLWU_P11 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF11     (3U)          /*!< Bit position for LLWU_F2_WUF11. */
#define BM_LLWU_F2_WUF11     (0x08U)       /*!< Bit mask for LLWU_F2_WUF11. */
#define BS_LLWU_F2_WUF11     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF11. */

/*! @brief Read current value of the LLWU_F2_WUF11 field. */
#define BR_LLWU_F2_WUF11(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF11)))

/*! @brief Format value for bitfield LLWU_F2_WUF11. */
#define BF_LLWU_F2_WUF11(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF11) & BM_LLWU_F2_WUF11)

/*! @brief Set the WUF11 field to a new value. */
#define BW_LLWU_F2_WUF11(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF11), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF12[4] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF12.
 *
 * Values:
 * - 0 - LLWU_P12 input was not a wakeup source
 * - 1 - LLWU_P12 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF12     (4U)          /*!< Bit position for LLWU_F2_WUF12. */
#define BM_LLWU_F2_WUF12     (0x10U)       /*!< Bit mask for LLWU_F2_WUF12. */
#define BS_LLWU_F2_WUF12     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF12. */

/*! @brief Read current value of the LLWU_F2_WUF12 field. */
#define BR_LLWU_F2_WUF12(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF12)))

/*! @brief Format value for bitfield LLWU_F2_WUF12. */
#define BF_LLWU_F2_WUF12(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF12) & BM_LLWU_F2_WUF12)

/*! @brief Set the WUF12 field to a new value. */
#define BW_LLWU_F2_WUF12(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF12), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF13[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF13.
 *
 * Values:
 * - 0 - LLWU_P13 input was not a wakeup source
 * - 1 - LLWU_P13 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF13     (5U)          /*!< Bit position for LLWU_F2_WUF13. */
#define BM_LLWU_F2_WUF13     (0x20U)       /*!< Bit mask for LLWU_F2_WUF13. */
#define BS_LLWU_F2_WUF13     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF13. */

/*! @brief Read current value of the LLWU_F2_WUF13 field. */
#define BR_LLWU_F2_WUF13(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF13)))

/*! @brief Format value for bitfield LLWU_F2_WUF13. */
#define BF_LLWU_F2_WUF13(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF13) & BM_LLWU_F2_WUF13)

/*! @brief Set the WUF13 field to a new value. */
#define BW_LLWU_F2_WUF13(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF13), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF14[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF14.
 *
 * Values:
 * - 0 - LLWU_P14 input was not a wakeup source
 * - 1 - LLWU_P14 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF14     (6U)          /*!< Bit position for LLWU_F2_WUF14. */
#define BM_LLWU_F2_WUF14     (0x40U)       /*!< Bit mask for LLWU_F2_WUF14. */
#define BS_LLWU_F2_WUF14     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF14. */

/*! @brief Read current value of the LLWU_F2_WUF14 field. */
#define BR_LLWU_F2_WUF14(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF14)))

/*! @brief Format value for bitfield LLWU_F2_WUF14. */
#define BF_LLWU_F2_WUF14(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF14) & BM_LLWU_F2_WUF14)

/*! @brief Set the WUF14 field to a new value. */
#define BW_LLWU_F2_WUF14(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF14), v))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF15[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF15.
 *
 * Values:
 * - 0 - LLWU_P15 input was not a wakeup source
 * - 1 - LLWU_P15 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F2_WUF15     (7U)          /*!< Bit position for LLWU_F2_WUF15. */
#define BM_LLWU_F2_WUF15     (0x80U)       /*!< Bit mask for LLWU_F2_WUF15. */
#define BS_LLWU_F2_WUF15     (1U)          /*!< Bit field size in bits for LLWU_F2_WUF15. */

/*! @brief Read current value of the LLWU_F2_WUF15 field. */
#define BR_LLWU_F2_WUF15(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF15)))

/*! @brief Format value for bitfield LLWU_F2_WUF15. */
#define BF_LLWU_F2_WUF15(v)  ((uint8_t)((uint8_t)(v) << BP_LLWU_F2_WUF15) & BM_LLWU_F2_WUF15)

/*! @brief Set the WUF15 field to a new value. */
#define BW_LLWU_F2_WUF15(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F2_ADDR(x), BP_LLWU_F2_WUF15), v))
/*@}*/

/*******************************************************************************
 * HW_LLWU_F3 - LLWU Flag 3 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_F3 - LLWU Flag 3 register (RO)
 *
 * Reset value: 0x00U
 *
 * LLWU_F3 contains the wakeup flags indicating which internal wakeup source
 * caused the MCU to exit LLS or VLLS mode. For LLS, this is the source causing the
 * CPU interrupt flow. For VLLS, this is the source causing the MCU reset flow.
 * For internal peripherals that are capable of running in a low-leakage power
 * mode, such as a real time clock module or CMP module, the flag from the
 * associated peripheral is accessible as the MWUFx bit. The flag will need to be cleared
 * in the peripheral instead of writing a 1 to the MWUFx bit. This register is
 * reset on Chip Reset not VLLS and by reset types that trigger Chip Reset not
 * VLLS. It is unaffected by reset types that do not trigger Chip Reset not VLLS. See
 * the IntroductionInformation found here describes the registers of the Reset
 * Control Module (RCM). The RCM implements many of the reset functions for the
 * chip. See the chip's reset chapter for more information. details for more
 * information.
 */
typedef union _hw_llwu_f3
{
    uint8_t U;
    struct _hw_llwu_f3_bitfields
    {
        uint8_t MWUF0 : 1;             /*!< [0] Wakeup flag For module 0 */
        uint8_t MWUF1 : 1;             /*!< [1] Wakeup flag For module 1 */
        uint8_t MWUF2 : 1;             /*!< [2] Wakeup flag For module 2 */
        uint8_t MWUF3 : 1;             /*!< [3] Wakeup flag For module 3 */
        uint8_t MWUF4 : 1;             /*!< [4] Wakeup flag For module 4 */
        uint8_t MWUF5 : 1;             /*!< [5] Wakeup flag For module 5 */
        uint8_t MWUF6 : 1;             /*!< [6] Wakeup flag For module 6 */
        uint8_t MWUF7 : 1;             /*!< [7] Wakeup flag For module 7 */
    } B;
} hw_llwu_f3_t;

/*!
 * @name Constants and macros for entire LLWU_F3 register
 */
/*@{*/
#define HW_LLWU_F3_ADDR(x)       ((x) + 0x7U)

#define HW_LLWU_F3(x)            (*(__I hw_llwu_f3_t *) HW_LLWU_F3_ADDR(x))
#define HW_LLWU_F3_RD(x)         (ADDRESS_READ(hw_llwu_f3_t, HW_LLWU_F3_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual LLWU_F3 bitfields
 */

/*!
 * @name Register LLWU_F3, field MWUF0[0] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 0 input was not a wakeup source
 * - 1 - Module 0 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF0     (0U)          /*!< Bit position for LLWU_F3_MWUF0. */
#define BM_LLWU_F3_MWUF0     (0x01U)       /*!< Bit mask for LLWU_F3_MWUF0. */
#define BS_LLWU_F3_MWUF0     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF0. */

/*! @brief Read current value of the LLWU_F3_MWUF0 field. */
#define BR_LLWU_F3_MWUF0(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF0)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF1[1] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 1 input was not a wakeup source
 * - 1 - Module 1 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF1     (1U)          /*!< Bit position for LLWU_F3_MWUF1. */
#define BM_LLWU_F3_MWUF1     (0x02U)       /*!< Bit mask for LLWU_F3_MWUF1. */
#define BS_LLWU_F3_MWUF1     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF1. */

/*! @brief Read current value of the LLWU_F3_MWUF1 field. */
#define BR_LLWU_F3_MWUF1(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF1)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF2[2] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 2 input was not a wakeup source
 * - 1 - Module 2 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF2     (2U)          /*!< Bit position for LLWU_F3_MWUF2. */
#define BM_LLWU_F3_MWUF2     (0x04U)       /*!< Bit mask for LLWU_F3_MWUF2. */
#define BS_LLWU_F3_MWUF2     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF2. */

/*! @brief Read current value of the LLWU_F3_MWUF2 field. */
#define BR_LLWU_F3_MWUF2(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF2)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF3[3] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 3 input was not a wakeup source
 * - 1 - Module 3 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF3     (3U)          /*!< Bit position for LLWU_F3_MWUF3. */
#define BM_LLWU_F3_MWUF3     (0x08U)       /*!< Bit mask for LLWU_F3_MWUF3. */
#define BS_LLWU_F3_MWUF3     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF3. */

/*! @brief Read current value of the LLWU_F3_MWUF3 field. */
#define BR_LLWU_F3_MWUF3(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF3)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF4[4] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 4 input was not a wakeup source
 * - 1 - Module 4 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF4     (4U)          /*!< Bit position for LLWU_F3_MWUF4. */
#define BM_LLWU_F3_MWUF4     (0x10U)       /*!< Bit mask for LLWU_F3_MWUF4. */
#define BS_LLWU_F3_MWUF4     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF4. */

/*! @brief Read current value of the LLWU_F3_MWUF4 field. */
#define BR_LLWU_F3_MWUF4(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF4)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF5[5] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 5 input was not a wakeup source
 * - 1 - Module 5 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF5     (5U)          /*!< Bit position for LLWU_F3_MWUF5. */
#define BM_LLWU_F3_MWUF5     (0x20U)       /*!< Bit mask for LLWU_F3_MWUF5. */
#define BS_LLWU_F3_MWUF5     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF5. */

/*! @brief Read current value of the LLWU_F3_MWUF5 field. */
#define BR_LLWU_F3_MWUF5(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF5)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF6[6] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 6 input was not a wakeup source
 * - 1 - Module 6 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF6     (6U)          /*!< Bit position for LLWU_F3_MWUF6. */
#define BM_LLWU_F3_MWUF6     (0x40U)       /*!< Bit mask for LLWU_F3_MWUF6. */
#define BS_LLWU_F3_MWUF6     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF6. */

/*! @brief Read current value of the LLWU_F3_MWUF6 field. */
#define BR_LLWU_F3_MWUF6(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF6)))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF7[7] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 7 input was not a wakeup source
 * - 1 - Module 7 input was a wakeup source
 */
/*@{*/
#define BP_LLWU_F3_MWUF7     (7U)          /*!< Bit position for LLWU_F3_MWUF7. */
#define BM_LLWU_F3_MWUF7     (0x80U)       /*!< Bit mask for LLWU_F3_MWUF7. */
#define BS_LLWU_F3_MWUF7     (1U)          /*!< Bit field size in bits for LLWU_F3_MWUF7. */

/*! @brief Read current value of the LLWU_F3_MWUF7 field. */
#define BR_LLWU_F3_MWUF7(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_F3_ADDR(x), BP_LLWU_F3_MWUF7)))
/*@}*/

/*******************************************************************************
 * HW_LLWU_FILT1 - LLWU Pin Filter 1 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_FILT1 - LLWU Pin Filter 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT1 is a control and status register that is used to enable/disable
 * the digital filter 1 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_filt1
{
    uint8_t U;
    struct _hw_llwu_filt1_bitfields
    {
        uint8_t FILTSEL : 4;           /*!< [3:0] Filter Pin Select */
        uint8_t RESERVED0 : 1;         /*!< [4]  */
        uint8_t FILTE : 2;             /*!< [6:5] Digital Filter On External Pin */
        uint8_t FILTF : 1;             /*!< [7] Filter Detect Flag */
    } B;
} hw_llwu_filt1_t;

/*!
 * @name Constants and macros for entire LLWU_FILT1 register
 */
/*@{*/
#define HW_LLWU_FILT1_ADDR(x)    ((x) + 0x8U)

#define HW_LLWU_FILT1(x)         (*(__IO hw_llwu_filt1_t *) HW_LLWU_FILT1_ADDR(x))
#define HW_LLWU_FILT1_RD(x)      (ADDRESS_READ(hw_llwu_filt1_t, HW_LLWU_FILT1_ADDR(x)))
#define HW_LLWU_FILT1_WR(x, v)   (ADDRESS_WRITE(hw_llwu_filt1_t, HW_LLWU_FILT1_ADDR(x), v))
#define HW_LLWU_FILT1_SET(x, v)  (HW_LLWU_FILT1_WR(x, HW_LLWU_FILT1_RD(x) |  (v)))
#define HW_LLWU_FILT1_CLR(x, v)  (HW_LLWU_FILT1_WR(x, HW_LLWU_FILT1_RD(x) & ~(v)))
#define HW_LLWU_FILT1_TOG(x, v)  (HW_LLWU_FILT1_WR(x, HW_LLWU_FILT1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_FILT1 bitfields
 */

/*!
 * @name Register LLWU_FILT1, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
/*@{*/
#define BP_LLWU_FILT1_FILTSEL (0U)         /*!< Bit position for LLWU_FILT1_FILTSEL. */
#define BM_LLWU_FILT1_FILTSEL (0x0FU)      /*!< Bit mask for LLWU_FILT1_FILTSEL. */
#define BS_LLWU_FILT1_FILTSEL (4U)         /*!< Bit field size in bits for LLWU_FILT1_FILTSEL. */

/*! @brief Read current value of the LLWU_FILT1_FILTSEL field. */
#define BR_LLWU_FILT1_FILTSEL(x) (UNION_READ(hw_llwu_filt1_t, HW_LLWU_FILT1_ADDR(x), U, B.FILTSEL))

/*! @brief Format value for bitfield LLWU_FILT1_FILTSEL. */
#define BF_LLWU_FILT1_FILTSEL(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT1_FILTSEL) & BM_LLWU_FILT1_FILTSEL)

/*! @brief Set the FILTSEL field to a new value. */
#define BW_LLWU_FILT1_FILTSEL(x, v) (HW_LLWU_FILT1_WR(x, (HW_LLWU_FILT1_RD(x) & ~BM_LLWU_FILT1_FILTSEL) | BF_LLWU_FILT1_FILTSEL(v)))
/*@}*/

/*!
 * @name Register LLWU_FILT1, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
/*@{*/
#define BP_LLWU_FILT1_FILTE  (5U)          /*!< Bit position for LLWU_FILT1_FILTE. */
#define BM_LLWU_FILT1_FILTE  (0x60U)       /*!< Bit mask for LLWU_FILT1_FILTE. */
#define BS_LLWU_FILT1_FILTE  (2U)          /*!< Bit field size in bits for LLWU_FILT1_FILTE. */

/*! @brief Read current value of the LLWU_FILT1_FILTE field. */
#define BR_LLWU_FILT1_FILTE(x) (UNION_READ(hw_llwu_filt1_t, HW_LLWU_FILT1_ADDR(x), U, B.FILTE))

/*! @brief Format value for bitfield LLWU_FILT1_FILTE. */
#define BF_LLWU_FILT1_FILTE(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT1_FILTE) & BM_LLWU_FILT1_FILTE)

/*! @brief Set the FILTE field to a new value. */
#define BW_LLWU_FILT1_FILTE(x, v) (HW_LLWU_FILT1_WR(x, (HW_LLWU_FILT1_RD(x) & ~BM_LLWU_FILT1_FILTE) | BF_LLWU_FILT1_FILTE(v)))
/*@}*/

/*!
 * @name Register LLWU_FILT1, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 1 was not a wakeup source
 * - 1 - Pin Filter 1 was a wakeup source
 */
/*@{*/
#define BP_LLWU_FILT1_FILTF  (7U)          /*!< Bit position for LLWU_FILT1_FILTF. */
#define BM_LLWU_FILT1_FILTF  (0x80U)       /*!< Bit mask for LLWU_FILT1_FILTF. */
#define BS_LLWU_FILT1_FILTF  (1U)          /*!< Bit field size in bits for LLWU_FILT1_FILTF. */

/*! @brief Read current value of the LLWU_FILT1_FILTF field. */
#define BR_LLWU_FILT1_FILTF(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_FILT1_ADDR(x), BP_LLWU_FILT1_FILTF)))

/*! @brief Format value for bitfield LLWU_FILT1_FILTF. */
#define BF_LLWU_FILT1_FILTF(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT1_FILTF) & BM_LLWU_FILT1_FILTF)

/*! @brief Set the FILTF field to a new value. */
#define BW_LLWU_FILT1_FILTF(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_FILT1_ADDR(x), BP_LLWU_FILT1_FILTF), v))
/*@}*/

/*******************************************************************************
 * HW_LLWU_FILT2 - LLWU Pin Filter 2 register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_FILT2 - LLWU Pin Filter 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT2 is a control and status register that is used to enable/disable
 * the digital filter 2 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_filt2
{
    uint8_t U;
    struct _hw_llwu_filt2_bitfields
    {
        uint8_t FILTSEL : 4;           /*!< [3:0] Filter Pin Select */
        uint8_t RESERVED0 : 1;         /*!< [4]  */
        uint8_t FILTE : 2;             /*!< [6:5] Digital Filter On External Pin */
        uint8_t FILTF : 1;             /*!< [7] Filter Detect Flag */
    } B;
} hw_llwu_filt2_t;

/*!
 * @name Constants and macros for entire LLWU_FILT2 register
 */
/*@{*/
#define HW_LLWU_FILT2_ADDR(x)    ((x) + 0x9U)

#define HW_LLWU_FILT2(x)         (*(__IO hw_llwu_filt2_t *) HW_LLWU_FILT2_ADDR(x))
#define HW_LLWU_FILT2_RD(x)      (ADDRESS_READ(hw_llwu_filt2_t, HW_LLWU_FILT2_ADDR(x)))
#define HW_LLWU_FILT2_WR(x, v)   (ADDRESS_WRITE(hw_llwu_filt2_t, HW_LLWU_FILT2_ADDR(x), v))
#define HW_LLWU_FILT2_SET(x, v)  (HW_LLWU_FILT2_WR(x, HW_LLWU_FILT2_RD(x) |  (v)))
#define HW_LLWU_FILT2_CLR(x, v)  (HW_LLWU_FILT2_WR(x, HW_LLWU_FILT2_RD(x) & ~(v)))
#define HW_LLWU_FILT2_TOG(x, v)  (HW_LLWU_FILT2_WR(x, HW_LLWU_FILT2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_FILT2 bitfields
 */

/*!
 * @name Register LLWU_FILT2, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
/*@{*/
#define BP_LLWU_FILT2_FILTSEL (0U)         /*!< Bit position for LLWU_FILT2_FILTSEL. */
#define BM_LLWU_FILT2_FILTSEL (0x0FU)      /*!< Bit mask for LLWU_FILT2_FILTSEL. */
#define BS_LLWU_FILT2_FILTSEL (4U)         /*!< Bit field size in bits for LLWU_FILT2_FILTSEL. */

/*! @brief Read current value of the LLWU_FILT2_FILTSEL field. */
#define BR_LLWU_FILT2_FILTSEL(x) (UNION_READ(hw_llwu_filt2_t, HW_LLWU_FILT2_ADDR(x), U, B.FILTSEL))

/*! @brief Format value for bitfield LLWU_FILT2_FILTSEL. */
#define BF_LLWU_FILT2_FILTSEL(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT2_FILTSEL) & BM_LLWU_FILT2_FILTSEL)

/*! @brief Set the FILTSEL field to a new value. */
#define BW_LLWU_FILT2_FILTSEL(x, v) (HW_LLWU_FILT2_WR(x, (HW_LLWU_FILT2_RD(x) & ~BM_LLWU_FILT2_FILTSEL) | BF_LLWU_FILT2_FILTSEL(v)))
/*@}*/

/*!
 * @name Register LLWU_FILT2, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
/*@{*/
#define BP_LLWU_FILT2_FILTE  (5U)          /*!< Bit position for LLWU_FILT2_FILTE. */
#define BM_LLWU_FILT2_FILTE  (0x60U)       /*!< Bit mask for LLWU_FILT2_FILTE. */
#define BS_LLWU_FILT2_FILTE  (2U)          /*!< Bit field size in bits for LLWU_FILT2_FILTE. */

/*! @brief Read current value of the LLWU_FILT2_FILTE field. */
#define BR_LLWU_FILT2_FILTE(x) (UNION_READ(hw_llwu_filt2_t, HW_LLWU_FILT2_ADDR(x), U, B.FILTE))

/*! @brief Format value for bitfield LLWU_FILT2_FILTE. */
#define BF_LLWU_FILT2_FILTE(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT2_FILTE) & BM_LLWU_FILT2_FILTE)

/*! @brief Set the FILTE field to a new value. */
#define BW_LLWU_FILT2_FILTE(x, v) (HW_LLWU_FILT2_WR(x, (HW_LLWU_FILT2_RD(x) & ~BM_LLWU_FILT2_FILTE) | BF_LLWU_FILT2_FILTE(v)))
/*@}*/

/*!
 * @name Register LLWU_FILT2, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 2 was not a wakeup source
 * - 1 - Pin Filter 2 was a wakeup source
 */
/*@{*/
#define BP_LLWU_FILT2_FILTF  (7U)          /*!< Bit position for LLWU_FILT2_FILTF. */
#define BM_LLWU_FILT2_FILTF  (0x80U)       /*!< Bit mask for LLWU_FILT2_FILTF. */
#define BS_LLWU_FILT2_FILTF  (1U)          /*!< Bit field size in bits for LLWU_FILT2_FILTF. */

/*! @brief Read current value of the LLWU_FILT2_FILTF field. */
#define BR_LLWU_FILT2_FILTF(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_FILT2_ADDR(x), BP_LLWU_FILT2_FILTF)))

/*! @brief Format value for bitfield LLWU_FILT2_FILTF. */
#define BF_LLWU_FILT2_FILTF(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_FILT2_FILTF) & BM_LLWU_FILT2_FILTF)

/*! @brief Set the FILTF field to a new value. */
#define BW_LLWU_FILT2_FILTF(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_FILT2_ADDR(x), BP_LLWU_FILT2_FILTF), v))
/*@}*/

/*******************************************************************************
 * HW_LLWU_RST - LLWU Reset Enable register
 ******************************************************************************/

/*!
 * @brief HW_LLWU_RST - LLWU Reset Enable register (RW)
 *
 * Reset value: 0x02U
 *
 * LLWU_RST is a control register that is used to enable/disable the digital
 * filter for the external pin detect and RESET pin. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_rst
{
    uint8_t U;
    struct _hw_llwu_rst_bitfields
    {
        uint8_t RSTFILT : 1;           /*!< [0] Digital Filter On RESET Pin */
        uint8_t LLRSTE : 1;            /*!< [1] Low-Leakage Mode RESET Enable */
        uint8_t RESERVED0 : 6;         /*!< [7:2]  */
    } B;
} hw_llwu_rst_t;

/*!
 * @name Constants and macros for entire LLWU_RST register
 */
/*@{*/
#define HW_LLWU_RST_ADDR(x)      ((x) + 0xAU)

#define HW_LLWU_RST(x)           (*(__IO hw_llwu_rst_t *) HW_LLWU_RST_ADDR(x))
#define HW_LLWU_RST_RD(x)        (ADDRESS_READ(hw_llwu_rst_t, HW_LLWU_RST_ADDR(x)))
#define HW_LLWU_RST_WR(x, v)     (ADDRESS_WRITE(hw_llwu_rst_t, HW_LLWU_RST_ADDR(x), v))
#define HW_LLWU_RST_SET(x, v)    (HW_LLWU_RST_WR(x, HW_LLWU_RST_RD(x) |  (v)))
#define HW_LLWU_RST_CLR(x, v)    (HW_LLWU_RST_WR(x, HW_LLWU_RST_RD(x) & ~(v)))
#define HW_LLWU_RST_TOG(x, v)    (HW_LLWU_RST_WR(x, HW_LLWU_RST_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LLWU_RST bitfields
 */

/*!
 * @name Register LLWU_RST, field RSTFILT[0] (RW)
 *
 * Enables the digital filter for the RESET pin during LLS, VLLS3, VLLS2, or
 * VLLS1 modes.
 *
 * Values:
 * - 0 - Filter not enabled
 * - 1 - Filter enabled
 */
/*@{*/
#define BP_LLWU_RST_RSTFILT  (0U)          /*!< Bit position for LLWU_RST_RSTFILT. */
#define BM_LLWU_RST_RSTFILT  (0x01U)       /*!< Bit mask for LLWU_RST_RSTFILT. */
#define BS_LLWU_RST_RSTFILT  (1U)          /*!< Bit field size in bits for LLWU_RST_RSTFILT. */

/*! @brief Read current value of the LLWU_RST_RSTFILT field. */
#define BR_LLWU_RST_RSTFILT(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_RST_ADDR(x), BP_LLWU_RST_RSTFILT)))

/*! @brief Format value for bitfield LLWU_RST_RSTFILT. */
#define BF_LLWU_RST_RSTFILT(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_RST_RSTFILT) & BM_LLWU_RST_RSTFILT)

/*! @brief Set the RSTFILT field to a new value. */
#define BW_LLWU_RST_RSTFILT(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_RST_ADDR(x), BP_LLWU_RST_RSTFILT), v))
/*@}*/

/*!
 * @name Register LLWU_RST, field LLRSTE[1] (RW)
 *
 * This bit must be set to allow the device to be reset while in a low-leakage
 * power mode. On devices where Reset is not a dedicated pin, the RESET pin must
 * also be enabled in the explicit port mux control.
 *
 * Values:
 * - 0 - RESET pin not enabled as a leakage mode exit source
 * - 1 - RESET pin enabled as a low leakage mode exit source
 */
/*@{*/
#define BP_LLWU_RST_LLRSTE   (1U)          /*!< Bit position for LLWU_RST_LLRSTE. */
#define BM_LLWU_RST_LLRSTE   (0x02U)       /*!< Bit mask for LLWU_RST_LLRSTE. */
#define BS_LLWU_RST_LLRSTE   (1U)          /*!< Bit field size in bits for LLWU_RST_LLRSTE. */

/*! @brief Read current value of the LLWU_RST_LLRSTE field. */
#define BR_LLWU_RST_LLRSTE(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_LLWU_RST_ADDR(x), BP_LLWU_RST_LLRSTE)))

/*! @brief Format value for bitfield LLWU_RST_LLRSTE. */
#define BF_LLWU_RST_LLRSTE(v) ((uint8_t)((uint8_t)(v) << BP_LLWU_RST_LLRSTE) & BM_LLWU_RST_LLRSTE)

/*! @brief Set the LLRSTE field to a new value. */
#define BW_LLWU_RST_LLRSTE(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_LLWU_RST_ADDR(x), BP_LLWU_RST_LLRSTE), v))
/*@}*/

/*******************************************************************************
 * hw_llwu_t - module struct
 ******************************************************************************/
/*!
 * @brief All LLWU module registers.
 */
#pragma pack(1)
typedef struct _hw_llwu
{
    __IO hw_llwu_pe1_t PE1;                /*!< [0x0] LLWU Pin Enable 1 register */
    __IO hw_llwu_pe2_t PE2;                /*!< [0x1] LLWU Pin Enable 2 register */
    __IO hw_llwu_pe3_t PE3;                /*!< [0x2] LLWU Pin Enable 3 register */
    __IO hw_llwu_pe4_t PE4;                /*!< [0x3] LLWU Pin Enable 4 register */
    __IO hw_llwu_me_t ME;                  /*!< [0x4] LLWU Module Enable register */
    __IO hw_llwu_f1_t F1;                  /*!< [0x5] LLWU Flag 1 register */
    __IO hw_llwu_f2_t F2;                  /*!< [0x6] LLWU Flag 2 register */
    __I hw_llwu_f3_t F3;                   /*!< [0x7] LLWU Flag 3 register */
    __IO hw_llwu_filt1_t FILT1;            /*!< [0x8] LLWU Pin Filter 1 register */
    __IO hw_llwu_filt2_t FILT2;            /*!< [0x9] LLWU Pin Filter 2 register */
    __IO hw_llwu_rst_t RST;                /*!< [0xA] LLWU Reset Enable register */
} hw_llwu_t;
#pragma pack()

/*! @brief Macro to access all LLWU registers. */
/*! @param x LLWU module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_LLWU(LLWU_BASE)</code>. */
#define HW_LLWU(x)     (*(hw_llwu_t *)(x))

#endif /* __HW_LLWU_REGISTERS_H__ */
/* EOF */
