/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     (C) COPYRIGHT 2015-2015 ARM Limited
**     ALL RIGHTS RESERVED
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2015-08-03) (ARM)
**         All accesses to memory are replaced by equivalent macros; this allows
**         memory read/write operations to be re-defined if needed (for example,
**         to implement new security features
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MCG_REGISTERS_H__
#define __HW_MCG_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 MCG
 *
 * Multipurpose Clock Generator module
 *
 * Registers defined in this header file:
 * - HW_MCG_C1 - MCG Control 1 Register
 * - HW_MCG_C2 - MCG Control 2 Register
 * - HW_MCG_C3 - MCG Control 3 Register
 * - HW_MCG_C4 - MCG Control 4 Register
 * - HW_MCG_C5 - MCG Control 5 Register
 * - HW_MCG_C6 - MCG Control 6 Register
 * - HW_MCG_S - MCG Status Register
 * - HW_MCG_SC - MCG Status and Control Register
 * - HW_MCG_ATCVH - MCG Auto Trim Compare Value High Register
 * - HW_MCG_ATCVL - MCG Auto Trim Compare Value Low Register
 * - HW_MCG_C7 - MCG Control 7 Register
 * - HW_MCG_C8 - MCG Control 8 Register
 *
 * - hw_mcg_t - Struct containing all module registers.
 */

#define HW_MCG_INSTANCE_COUNT (1U) /*!< Number of instances of the MCG module. */

/*******************************************************************************
 * HW_MCG_C1 - MCG Control 1 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C1 - MCG Control 1 Register (RW)
 *
 * Reset value: 0x04U
 */
typedef union _hw_mcg_c1
{
    uint8_t U;
    struct _hw_mcg_c1_bitfields
    {
        uint8_t IREFSTEN : 1;          /*!< [0] Internal Reference Stop Enable */
        uint8_t IRCLKEN : 1;           /*!< [1] Internal Reference Clock Enable */
        uint8_t IREFS : 1;             /*!< [2] Internal Reference Select */
        uint8_t FRDIV : 3;             /*!< [5:3] FLL External Reference Divider */
        uint8_t CLKS : 2;              /*!< [7:6] Clock Source Select */
    } B;
} hw_mcg_c1_t;

/*!
 * @name Constants and macros for entire MCG_C1 register
 */
/*@{*/
#define HW_MCG_C1_ADDR(x)        ((x) + 0x0U)

#define HW_MCG_C1(x)             (*(__IO hw_mcg_c1_t *) HW_MCG_C1_ADDR(x))
#define HW_MCG_C1_RD(x)          (ADDRESS_READ(hw_mcg_c1_t, HW_MCG_C1_ADDR(x)))
#define HW_MCG_C1_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c1_t, HW_MCG_C1_ADDR(x), v))
#define HW_MCG_C1_SET(x, v)      (HW_MCG_C1_WR(x, HW_MCG_C1_RD(x) |  (v)))
#define HW_MCG_C1_CLR(x, v)      (HW_MCG_C1_WR(x, HW_MCG_C1_RD(x) & ~(v)))
#define HW_MCG_C1_TOG(x, v)      (HW_MCG_C1_WR(x, HW_MCG_C1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C1 bitfields
 */

/*!
 * @name Register MCG_C1, field IREFSTEN[0] (RW)
 *
 * Controls whether or not the internal reference clock remains enabled when the
 * MCG enters Stop mode.
 *
 * Values:
 * - 0 - Internal reference clock is disabled in Stop mode.
 * - 1 - Internal reference clock is enabled in Stop mode if IRCLKEN is set or
 *     if MCG is in FEI, FBI, or BLPI modes before entering Stop mode.
 */
/*@{*/
#define BP_MCG_C1_IREFSTEN   (0U)          /*!< Bit position for MCG_C1_IREFSTEN. */
#define BM_MCG_C1_IREFSTEN   (0x01U)       /*!< Bit mask for MCG_C1_IREFSTEN. */
#define BS_MCG_C1_IREFSTEN   (1U)          /*!< Bit field size in bits for MCG_C1_IREFSTEN. */

/*! @brief Read current value of the MCG_C1_IREFSTEN field. */
#define BR_MCG_C1_IREFSTEN(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IREFSTEN)))

/*! @brief Format value for bitfield MCG_C1_IREFSTEN. */
#define BF_MCG_C1_IREFSTEN(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C1_IREFSTEN) & BM_MCG_C1_IREFSTEN)

/*! @brief Set the IREFSTEN field to a new value. */
#define BW_MCG_C1_IREFSTEN(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IREFSTEN), v))
/*@}*/

/*!
 * @name Register MCG_C1, field IRCLKEN[1] (RW)
 *
 * Enables the internal reference clock for use as MCGIRCLK.
 *
 * Values:
 * - 0 - MCGIRCLK inactive.
 * - 1 - MCGIRCLK active.
 */
/*@{*/
#define BP_MCG_C1_IRCLKEN    (1U)          /*!< Bit position for MCG_C1_IRCLKEN. */
#define BM_MCG_C1_IRCLKEN    (0x02U)       /*!< Bit mask for MCG_C1_IRCLKEN. */
#define BS_MCG_C1_IRCLKEN    (1U)          /*!< Bit field size in bits for MCG_C1_IRCLKEN. */

/*! @brief Read current value of the MCG_C1_IRCLKEN field. */
#define BR_MCG_C1_IRCLKEN(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IRCLKEN)))

/*! @brief Format value for bitfield MCG_C1_IRCLKEN. */
#define BF_MCG_C1_IRCLKEN(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C1_IRCLKEN) & BM_MCG_C1_IRCLKEN)

/*! @brief Set the IRCLKEN field to a new value. */
#define BW_MCG_C1_IRCLKEN(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IRCLKEN), v))
/*@}*/

/*!
 * @name Register MCG_C1, field IREFS[2] (RW)
 *
 * Selects the reference clock source for the FLL.
 *
 * Values:
 * - 0 - External reference clock is selected.
 * - 1 - The slow internal reference clock is selected.
 */
/*@{*/
#define BP_MCG_C1_IREFS      (2U)          /*!< Bit position for MCG_C1_IREFS. */
#define BM_MCG_C1_IREFS      (0x04U)       /*!< Bit mask for MCG_C1_IREFS. */
#define BS_MCG_C1_IREFS      (1U)          /*!< Bit field size in bits for MCG_C1_IREFS. */

/*! @brief Read current value of the MCG_C1_IREFS field. */
#define BR_MCG_C1_IREFS(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IREFS)))

/*! @brief Format value for bitfield MCG_C1_IREFS. */
#define BF_MCG_C1_IREFS(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C1_IREFS) & BM_MCG_C1_IREFS)

/*! @brief Set the IREFS field to a new value. */
#define BW_MCG_C1_IREFS(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C1_ADDR(x), BP_MCG_C1_IREFS), v))
/*@}*/

/*!
 * @name Register MCG_C1, field FRDIV[5:3] (RW)
 *
 * Selects the amount to divide down the external reference clock for the FLL.
 * The resulting frequency must be in the range 31.25 kHz to 39.0625 kHz (This is
 * required when FLL/DCO is the clock source for MCGOUTCLK . In FBE mode, it is
 * not required to meet this range, but it is recommended in the cases when trying
 * to enter a FLL mode from FBE).
 *
 * Values:
 * - 000 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 1; for all other RANGE
 *     values, Divide Factor is 32.
 * - 001 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 2; for all other RANGE
 *     values, Divide Factor is 64.
 * - 010 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 4; for all other RANGE
 *     values, Divide Factor is 128.
 * - 011 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 8; for all other RANGE
 *     values, Divide Factor is 256.
 * - 100 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 16; for all other RANGE
 *     values, Divide Factor is 512.
 * - 101 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 32; for all other RANGE
 *     values, Divide Factor is 1024.
 * - 110 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 64; for all other RANGE
 *     values, Divide Factor is 1280 .
 * - 111 - If RANGE = 0 or OSCSEL=1 , Divide Factor is 128; for all other RANGE
 *     values, Divide Factor is 1536 .
 */
/*@{*/
#define BP_MCG_C1_FRDIV      (3U)          /*!< Bit position for MCG_C1_FRDIV. */
#define BM_MCG_C1_FRDIV      (0x38U)       /*!< Bit mask for MCG_C1_FRDIV. */
#define BS_MCG_C1_FRDIV      (3U)          /*!< Bit field size in bits for MCG_C1_FRDIV. */

/*! @brief Read current value of the MCG_C1_FRDIV field. */
#define BR_MCG_C1_FRDIV(x)   (UNION_READ(hw_mcg_c1_t, HW_MCG_C1_ADDR(x), U, B.FRDIV))

/*! @brief Format value for bitfield MCG_C1_FRDIV. */
#define BF_MCG_C1_FRDIV(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C1_FRDIV) & BM_MCG_C1_FRDIV)

/*! @brief Set the FRDIV field to a new value. */
#define BW_MCG_C1_FRDIV(x, v) (HW_MCG_C1_WR(x, (HW_MCG_C1_RD(x) & ~BM_MCG_C1_FRDIV) | BF_MCG_C1_FRDIV(v)))
/*@}*/

/*!
 * @name Register MCG_C1, field CLKS[7:6] (RW)
 *
 * Selects the clock source for MCGOUTCLK .
 *
 * Values:
 * - 00 - Encoding 0 - Output of FLL or PLL is selected (depends on PLLS control
 *     bit).
 * - 01 - Encoding 1 - Internal reference clock is selected.
 * - 10 - Encoding 2 - External reference clock is selected.
 * - 11 - Encoding 3 - Reserved.
 */
/*@{*/
#define BP_MCG_C1_CLKS       (6U)          /*!< Bit position for MCG_C1_CLKS. */
#define BM_MCG_C1_CLKS       (0xC0U)       /*!< Bit mask for MCG_C1_CLKS. */
#define BS_MCG_C1_CLKS       (2U)          /*!< Bit field size in bits for MCG_C1_CLKS. */

/*! @brief Read current value of the MCG_C1_CLKS field. */
#define BR_MCG_C1_CLKS(x)    (UNION_READ(hw_mcg_c1_t, HW_MCG_C1_ADDR(x), U, B.CLKS))

/*! @brief Format value for bitfield MCG_C1_CLKS. */
#define BF_MCG_C1_CLKS(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_C1_CLKS) & BM_MCG_C1_CLKS)

/*! @brief Set the CLKS field to a new value. */
#define BW_MCG_C1_CLKS(x, v) (HW_MCG_C1_WR(x, (HW_MCG_C1_RD(x) & ~BM_MCG_C1_CLKS) | BF_MCG_C1_CLKS(v)))
/*@}*/

/*******************************************************************************
 * HW_MCG_C2 - MCG Control 2 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C2 - MCG Control 2 Register (RW)
 *
 * Reset value: 0x80U
 */
typedef union _hw_mcg_c2
{
    uint8_t U;
    struct _hw_mcg_c2_bitfields
    {
        uint8_t IRCS : 1;              /*!< [0] Internal Reference Clock Select */
        uint8_t LP : 1;                /*!< [1] Low Power Select */
        uint8_t EREFS : 1;             /*!< [2] External Reference Select */
        uint8_t HGO : 1;               /*!< [3] High Gain Oscillator Select */
        uint8_t RANGE : 2;             /*!< [5:4] Frequency Range Select */
        uint8_t FCFTRIM : 1;           /*!< [6] Fast Internal Reference Clock Fine Trim
                                        * */
        uint8_t LOCRE0 : 1;            /*!< [7] Loss of Clock Reset Enable */
    } B;
} hw_mcg_c2_t;

/*!
 * @name Constants and macros for entire MCG_C2 register
 */
/*@{*/
#define HW_MCG_C2_ADDR(x)        ((x) + 0x1U)

#define HW_MCG_C2(x)             (*(__IO hw_mcg_c2_t *) HW_MCG_C2_ADDR(x))
#define HW_MCG_C2_RD(x)          (ADDRESS_READ(hw_mcg_c2_t, HW_MCG_C2_ADDR(x)))
#define HW_MCG_C2_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c2_t, HW_MCG_C2_ADDR(x), v))
#define HW_MCG_C2_SET(x, v)      (HW_MCG_C2_WR(x, HW_MCG_C2_RD(x) |  (v)))
#define HW_MCG_C2_CLR(x, v)      (HW_MCG_C2_WR(x, HW_MCG_C2_RD(x) & ~(v)))
#define HW_MCG_C2_TOG(x, v)      (HW_MCG_C2_WR(x, HW_MCG_C2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C2 bitfields
 */

/*!
 * @name Register MCG_C2, field IRCS[0] (RW)
 *
 * Selects between the fast or slow internal reference clock source.
 *
 * Values:
 * - 0 - Slow internal reference clock selected.
 * - 1 - Fast internal reference clock selected.
 */
/*@{*/
#define BP_MCG_C2_IRCS       (0U)          /*!< Bit position for MCG_C2_IRCS. */
#define BM_MCG_C2_IRCS       (0x01U)       /*!< Bit mask for MCG_C2_IRCS. */
#define BS_MCG_C2_IRCS       (1U)          /*!< Bit field size in bits for MCG_C2_IRCS. */

/*! @brief Read current value of the MCG_C2_IRCS field. */
#define BR_MCG_C2_IRCS(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_IRCS)))

/*! @brief Format value for bitfield MCG_C2_IRCS. */
#define BF_MCG_C2_IRCS(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_C2_IRCS) & BM_MCG_C2_IRCS)

/*! @brief Set the IRCS field to a new value. */
#define BW_MCG_C2_IRCS(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_IRCS), v))
/*@}*/

/*!
 * @name Register MCG_C2, field LP[1] (RW)
 *
 * Controls whether the FLL or PLL is disabled in BLPI and BLPE modes. In FBE or
 * PBE modes, setting this bit to 1 will transition the MCG into BLPE mode; in
 * FBI mode, setting this bit to 1 will transition the MCG into BLPI mode. In any
 * other MCG mode, LP bit has no affect.
 *
 * Values:
 * - 0 - FLL or PLL is not disabled in bypass modes.
 * - 1 - FLL or PLL is disabled in bypass modes (lower power)
 */
/*@{*/
#define BP_MCG_C2_LP         (1U)          /*!< Bit position for MCG_C2_LP. */
#define BM_MCG_C2_LP         (0x02U)       /*!< Bit mask for MCG_C2_LP. */
#define BS_MCG_C2_LP         (1U)          /*!< Bit field size in bits for MCG_C2_LP. */

/*! @brief Read current value of the MCG_C2_LP field. */
#define BR_MCG_C2_LP(x)      (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_LP)))

/*! @brief Format value for bitfield MCG_C2_LP. */
#define BF_MCG_C2_LP(v)      ((uint8_t)((uint8_t)(v) << BP_MCG_C2_LP) & BM_MCG_C2_LP)

/*! @brief Set the LP field to a new value. */
#define BW_MCG_C2_LP(x, v)   (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_LP), v))
/*@}*/

/*!
 * @name Register MCG_C2, field EREFS[2] (RW)
 *
 * Selects the source for the external reference clock. See the Oscillator (OSC)
 * chapter for more details.
 *
 * Values:
 * - 0 - External reference clock requested.
 * - 1 - Oscillator requested.
 */
/*@{*/
#define BP_MCG_C2_EREFS      (2U)          /*!< Bit position for MCG_C2_EREFS. */
#define BM_MCG_C2_EREFS      (0x04U)       /*!< Bit mask for MCG_C2_EREFS. */
#define BS_MCG_C2_EREFS      (1U)          /*!< Bit field size in bits for MCG_C2_EREFS. */

/*! @brief Read current value of the MCG_C2_EREFS field. */
#define BR_MCG_C2_EREFS(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_EREFS)))

/*! @brief Format value for bitfield MCG_C2_EREFS. */
#define BF_MCG_C2_EREFS(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C2_EREFS) & BM_MCG_C2_EREFS)

/*! @brief Set the EREFS field to a new value. */
#define BW_MCG_C2_EREFS(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_EREFS), v))
/*@}*/

/*!
 * @name Register MCG_C2, field HGO[3] (RW)
 *
 * Controls the crystal oscillator mode of operation. See the Oscillator (OSC)
 * chapter for more details.
 *
 * Values:
 * - 0 - Configure crystal oscillator for low-power operation.
 * - 1 - Configure crystal oscillator for high-gain operation.
 */
/*@{*/
#define BP_MCG_C2_HGO        (3U)          /*!< Bit position for MCG_C2_HGO. */
#define BM_MCG_C2_HGO        (0x08U)       /*!< Bit mask for MCG_C2_HGO. */
#define BS_MCG_C2_HGO        (1U)          /*!< Bit field size in bits for MCG_C2_HGO. */

/*! @brief Read current value of the MCG_C2_HGO field. */
#define BR_MCG_C2_HGO(x)     (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_HGO)))

/*! @brief Format value for bitfield MCG_C2_HGO. */
#define BF_MCG_C2_HGO(v)     ((uint8_t)((uint8_t)(v) << BP_MCG_C2_HGO) & BM_MCG_C2_HGO)

/*! @brief Set the HGO field to a new value. */
#define BW_MCG_C2_HGO(x, v)  (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_HGO), v))
/*@}*/

/*!
 * @name Register MCG_C2, field RANGE[5:4] (RW)
 *
 * Selects the frequency range for the crystal oscillator or external clock
 * source. See the Oscillator (OSC) chapter for more details and the device data
 * sheet for the frequency ranges used.
 *
 * Values:
 * - 00 - Encoding 0 - Low frequency range selected for the crystal oscillator .
 * - 01 - Encoding 1 - High frequency range selected for the crystal oscillator .
 */
/*@{*/
#define BP_MCG_C2_RANGE      (4U)          /*!< Bit position for MCG_C2_RANGE. */
#define BM_MCG_C2_RANGE      (0x30U)       /*!< Bit mask for MCG_C2_RANGE. */
#define BS_MCG_C2_RANGE      (2U)          /*!< Bit field size in bits for MCG_C2_RANGE. */

/*! @brief Read current value of the MCG_C2_RANGE field. */
#define BR_MCG_C2_RANGE(x)   (UNION_READ(hw_mcg_c2_t, HW_MCG_C2_ADDR(x), U, B.RANGE))

/*! @brief Format value for bitfield MCG_C2_RANGE. */
#define BF_MCG_C2_RANGE(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C2_RANGE) & BM_MCG_C2_RANGE)

/*! @brief Set the RANGE field to a new value. */
#define BW_MCG_C2_RANGE(x, v) (HW_MCG_C2_WR(x, (HW_MCG_C2_RD(x) & ~BM_MCG_C2_RANGE) | BF_MCG_C2_RANGE(v)))
/*@}*/

/*!
 * @name Register MCG_C2, field FCFTRIM[6] (RW)
 *
 * FCFTRIM controls the smallest adjustment of the fast internal reference clock
 * frequency. Setting FCFTRIM increases the period and clearing FCFTRIM
 * decreases the period by the smallest amount possible. If an FCFTRIM value stored in
 * nonvolatile memory is to be used, it is your responsibility to copy that value
 * from the nonvolatile memory location to this bit.
 */
/*@{*/
#define BP_MCG_C2_FCFTRIM    (6U)          /*!< Bit position for MCG_C2_FCFTRIM. */
#define BM_MCG_C2_FCFTRIM    (0x40U)       /*!< Bit mask for MCG_C2_FCFTRIM. */
#define BS_MCG_C2_FCFTRIM    (1U)          /*!< Bit field size in bits for MCG_C2_FCFTRIM. */

/*! @brief Read current value of the MCG_C2_FCFTRIM field. */
#define BR_MCG_C2_FCFTRIM(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_FCFTRIM)))

/*! @brief Format value for bitfield MCG_C2_FCFTRIM. */
#define BF_MCG_C2_FCFTRIM(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C2_FCFTRIM) & BM_MCG_C2_FCFTRIM)

/*! @brief Set the FCFTRIM field to a new value. */
#define BW_MCG_C2_FCFTRIM(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_FCFTRIM), v))
/*@}*/

/*!
 * @name Register MCG_C2, field LOCRE0[7] (RW)
 *
 * Determines whether an interrupt or a reset request is made following a loss
 * of OSC0 external reference clock. The LOCRE0 only has an affect when CME0 is
 * set.
 *
 * Values:
 * - 0 - Interrupt request is generated on a loss of OSC0 external reference
 *     clock.
 * - 1 - Generate a reset request on a loss of OSC0 external reference clock.
 */
/*@{*/
#define BP_MCG_C2_LOCRE0     (7U)          /*!< Bit position for MCG_C2_LOCRE0. */
#define BM_MCG_C2_LOCRE0     (0x80U)       /*!< Bit mask for MCG_C2_LOCRE0. */
#define BS_MCG_C2_LOCRE0     (1U)          /*!< Bit field size in bits for MCG_C2_LOCRE0. */

/*! @brief Read current value of the MCG_C2_LOCRE0 field. */
#define BR_MCG_C2_LOCRE0(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_LOCRE0)))

/*! @brief Format value for bitfield MCG_C2_LOCRE0. */
#define BF_MCG_C2_LOCRE0(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C2_LOCRE0) & BM_MCG_C2_LOCRE0)

/*! @brief Set the LOCRE0 field to a new value. */
#define BW_MCG_C2_LOCRE0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C2_ADDR(x), BP_MCG_C2_LOCRE0), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_C3 - MCG Control 3 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C3 - MCG Control 3 Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_c3
{
    uint8_t U;
    struct _hw_mcg_c3_bitfields
    {
        uint8_t SCTRIM : 8;            /*!< [7:0] Slow Internal Reference Clock Trim
                                        * Setting */
    } B;
} hw_mcg_c3_t;

/*!
 * @name Constants and macros for entire MCG_C3 register
 */
/*@{*/
#define HW_MCG_C3_ADDR(x)        ((x) + 0x2U)

#define HW_MCG_C3(x)             (*(__IO hw_mcg_c3_t *) HW_MCG_C3_ADDR(x))
#define HW_MCG_C3_RD(x)          (ADDRESS_READ(hw_mcg_c3_t, HW_MCG_C3_ADDR(x)))
#define HW_MCG_C3_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c3_t, HW_MCG_C3_ADDR(x), v))
#define HW_MCG_C3_SET(x, v)      (HW_MCG_C3_WR(x, HW_MCG_C3_RD(x) |  (v)))
#define HW_MCG_C3_CLR(x, v)      (HW_MCG_C3_WR(x, HW_MCG_C3_RD(x) & ~(v)))
#define HW_MCG_C3_TOG(x, v)      (HW_MCG_C3_WR(x, HW_MCG_C3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C3 bitfields
 */

/*!
 * @name Register MCG_C3, field SCTRIM[7:0] (RW)
 *
 * SCTRIM A value for SCTRIM is loaded during reset from a factory programmed
 * location. controls the slow internal reference clock frequency by controlling
 * the slow internal reference clock period. The SCTRIM bits are binary weighted,
 * that is, bit 1 adjusts twice as much as bit 0. Increasing the binary value
 * increases the period, and decreasing the value decreases the period. An additional
 * fine trim bit is available in C4 register as the SCFTRIM bit. Upon reset,
 * this value is loaded with a factory trim value. If an SCTRIM value stored in
 * nonvolatile memory is to be used, it is your responsibility to copy that value
 * from the nonvolatile memory location to this register.
 */
/*@{*/
#define BP_MCG_C3_SCTRIM     (0U)          /*!< Bit position for MCG_C3_SCTRIM. */
#define BM_MCG_C3_SCTRIM     (0xFFU)       /*!< Bit mask for MCG_C3_SCTRIM. */
#define BS_MCG_C3_SCTRIM     (8U)          /*!< Bit field size in bits for MCG_C3_SCTRIM. */

/*! @brief Read current value of the MCG_C3_SCTRIM field. */
#define BR_MCG_C3_SCTRIM(x)  (HW_MCG_C3(x).U)

/*! @brief Format value for bitfield MCG_C3_SCTRIM. */
#define BF_MCG_C3_SCTRIM(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C3_SCTRIM) & BM_MCG_C3_SCTRIM)

/*! @brief Set the SCTRIM field to a new value. */
#define BW_MCG_C3_SCTRIM(x, v) (HW_MCG_C3_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_MCG_C4 - MCG Control 4 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C4 - MCG Control 4 Register (RW)
 *
 * Reset value: 0x00U
 *
 * Reset values for DRST and DMX32 bits are 0.
 */
typedef union _hw_mcg_c4
{
    uint8_t U;
    struct _hw_mcg_c4_bitfields
    {
        uint8_t SCFTRIM : 1;           /*!< [0] Slow Internal Reference Clock Fine Trim
                                        * */
        uint8_t FCTRIM : 4;            /*!< [4:1] Fast Internal Reference Clock Trim
                                        * Setting */
        uint8_t DRST_DRS : 2;          /*!< [6:5] DCO Range Select */
        uint8_t DMX32 : 1;             /*!< [7] DCO Maximum Frequency with 32.768 kHz
                                        * Reference */
    } B;
} hw_mcg_c4_t;

/*!
 * @name Constants and macros for entire MCG_C4 register
 */
/*@{*/
#define HW_MCG_C4_ADDR(x)        ((x) + 0x3U)

#define HW_MCG_C4(x)             (*(__IO hw_mcg_c4_t *) HW_MCG_C4_ADDR(x))
#define HW_MCG_C4_RD(x)          (ADDRESS_READ(hw_mcg_c4_t, HW_MCG_C4_ADDR(x)))
#define HW_MCG_C4_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c4_t, HW_MCG_C4_ADDR(x), v))
#define HW_MCG_C4_SET(x, v)      (HW_MCG_C4_WR(x, HW_MCG_C4_RD(x) |  (v)))
#define HW_MCG_C4_CLR(x, v)      (HW_MCG_C4_WR(x, HW_MCG_C4_RD(x) & ~(v)))
#define HW_MCG_C4_TOG(x, v)      (HW_MCG_C4_WR(x, HW_MCG_C4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C4 bitfields
 */

/*!
 * @name Register MCG_C4, field SCFTRIM[0] (RW)
 *
 * SCFTRIM A value for SCFTRIM is loaded during reset from a factory programmed
 * location . controls the smallest adjustment of the slow internal reference
 * clock frequency. Setting SCFTRIM increases the period and clearing SCFTRIM
 * decreases the period by the smallest amount possible. If an SCFTRIM value stored in
 * nonvolatile memory is to be used, it is your responsibility to copy that value
 * from the nonvolatile memory location to this bit.
 */
/*@{*/
#define BP_MCG_C4_SCFTRIM    (0U)          /*!< Bit position for MCG_C4_SCFTRIM. */
#define BM_MCG_C4_SCFTRIM    (0x01U)       /*!< Bit mask for MCG_C4_SCFTRIM. */
#define BS_MCG_C4_SCFTRIM    (1U)          /*!< Bit field size in bits for MCG_C4_SCFTRIM. */

/*! @brief Read current value of the MCG_C4_SCFTRIM field. */
#define BR_MCG_C4_SCFTRIM(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C4_ADDR(x), BP_MCG_C4_SCFTRIM)))

/*! @brief Format value for bitfield MCG_C4_SCFTRIM. */
#define BF_MCG_C4_SCFTRIM(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C4_SCFTRIM) & BM_MCG_C4_SCFTRIM)

/*! @brief Set the SCFTRIM field to a new value. */
#define BW_MCG_C4_SCFTRIM(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C4_ADDR(x), BP_MCG_C4_SCFTRIM), v))
/*@}*/

/*!
 * @name Register MCG_C4, field FCTRIM[4:1] (RW)
 *
 * FCTRIM A value for FCTRIM is loaded during reset from a factory programmed
 * location. controls the fast internal reference clock frequency by controlling
 * the fast internal reference clock period. The FCTRIM bits are binary weighted,
 * that is, bit 1 adjusts twice as much as bit 0. Increasing the binary value
 * increases the period, and decreasing the value decreases the period. If an
 * FCTRIM[3:0] value stored in nonvolatile memory is to be used, it is your
 * responsibility to copy that value from the nonvolatile memory location to this register.
 */
/*@{*/
#define BP_MCG_C4_FCTRIM     (1U)          /*!< Bit position for MCG_C4_FCTRIM. */
#define BM_MCG_C4_FCTRIM     (0x1EU)       /*!< Bit mask for MCG_C4_FCTRIM. */
#define BS_MCG_C4_FCTRIM     (4U)          /*!< Bit field size in bits for MCG_C4_FCTRIM. */

/*! @brief Read current value of the MCG_C4_FCTRIM field. */
#define BR_MCG_C4_FCTRIM(x)  (UNION_READ(hw_mcg_c4_t, HW_MCG_C4_ADDR(x), U, B.FCTRIM))

/*! @brief Format value for bitfield MCG_C4_FCTRIM. */
#define BF_MCG_C4_FCTRIM(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C4_FCTRIM) & BM_MCG_C4_FCTRIM)

/*! @brief Set the FCTRIM field to a new value. */
#define BW_MCG_C4_FCTRIM(x, v) (HW_MCG_C4_WR(x, (HW_MCG_C4_RD(x) & ~BM_MCG_C4_FCTRIM) | BF_MCG_C4_FCTRIM(v)))
/*@}*/

/*!
 * @name Register MCG_C4, field DRST_DRS[6:5] (RW)
 *
 * The DRS bits select the frequency range for the FLL output, DCOOUT. When the
 * LP bit is set, writes to the DRS bits are ignored. The DRST read field
 * indicates the current frequency range for DCOOUT. The DRST field does not update
 * immediately after a write to the DRS field due to internal synchronization between
 * clock domains. See the DCO Frequency Range table for more details.
 *
 * Values:
 * - 00 - Encoding 0 - Low range (reset default).
 * - 01 - Encoding 1 - Mid range.
 * - 10 - Encoding 2 - Mid-high range.
 * - 11 - Encoding 3 - High range.
 */
/*@{*/
#define BP_MCG_C4_DRST_DRS   (5U)          /*!< Bit position for MCG_C4_DRST_DRS. */
#define BM_MCG_C4_DRST_DRS   (0x60U)       /*!< Bit mask for MCG_C4_DRST_DRS. */
#define BS_MCG_C4_DRST_DRS   (2U)          /*!< Bit field size in bits for MCG_C4_DRST_DRS. */

/*! @brief Read current value of the MCG_C4_DRST_DRS field. */
#define BR_MCG_C4_DRST_DRS(x) (UNION_READ(hw_mcg_c4_t, HW_MCG_C4_ADDR(x), U, B.DRST_DRS))

/*! @brief Format value for bitfield MCG_C4_DRST_DRS. */
#define BF_MCG_C4_DRST_DRS(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C4_DRST_DRS) & BM_MCG_C4_DRST_DRS)

/*! @brief Set the DRST_DRS field to a new value. */
#define BW_MCG_C4_DRST_DRS(x, v) (HW_MCG_C4_WR(x, (HW_MCG_C4_RD(x) & ~BM_MCG_C4_DRST_DRS) | BF_MCG_C4_DRST_DRS(v)))
/*@}*/

/*!
 * @name Register MCG_C4, field DMX32[7] (RW)
 *
 * The DMX32 bit controls whether the DCO frequency range is narrowed to its
 * maximum frequency with a 32.768 kHz reference. The following table identifies
 * settings for the DCO frequency range. The system clocks derived from this source
 * should not exceed their specified maximums. DRST_DRS DMX32 Reference Range FLL
 * Factor DCO Range 00 0 31.25-39.0625 kHz 640 20-25 MHz 1 32.768 kHz 732 24 MHz
 * 01 0 31.25-39.0625 kHz 1280 40-50 MHz 1 32.768 kHz 1464 48 MHz 10 0
 * 31.25-39.0625 kHz 1920 60-75 MHz 1 32.768 kHz 2197 72 MHz 11 0 31.25-39.0625 kHz 2560
 * 80-100 MHz 1 32.768 kHz 2929 96 MHz
 *
 * Values:
 * - 0 - DCO has a default range of 25%.
 * - 1 - DCO is fine-tuned for maximum frequency with 32.768 kHz reference.
 */
/*@{*/
#define BP_MCG_C4_DMX32      (7U)          /*!< Bit position for MCG_C4_DMX32. */
#define BM_MCG_C4_DMX32      (0x80U)       /*!< Bit mask for MCG_C4_DMX32. */
#define BS_MCG_C4_DMX32      (1U)          /*!< Bit field size in bits for MCG_C4_DMX32. */

/*! @brief Read current value of the MCG_C4_DMX32 field. */
#define BR_MCG_C4_DMX32(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C4_ADDR(x), BP_MCG_C4_DMX32)))

/*! @brief Format value for bitfield MCG_C4_DMX32. */
#define BF_MCG_C4_DMX32(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C4_DMX32) & BM_MCG_C4_DMX32)

/*! @brief Set the DMX32 field to a new value. */
#define BW_MCG_C4_DMX32(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C4_ADDR(x), BP_MCG_C4_DMX32), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_C5 - MCG Control 5 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C5 - MCG Control 5 Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_c5
{
    uint8_t U;
    struct _hw_mcg_c5_bitfields
    {
        uint8_t PRDIV0 : 5;            /*!< [4:0] PLL External Reference Divider */
        uint8_t PLLSTEN0 : 1;          /*!< [5] PLL Stop Enable */
        uint8_t PLLCLKEN0 : 1;         /*!< [6] PLL Clock Enable */
        uint8_t RESERVED0 : 1;         /*!< [7]  */
    } B;
} hw_mcg_c5_t;

/*!
 * @name Constants and macros for entire MCG_C5 register
 */
/*@{*/
#define HW_MCG_C5_ADDR(x)        ((x) + 0x4U)

#define HW_MCG_C5(x)             (*(__IO hw_mcg_c5_t *) HW_MCG_C5_ADDR(x))
#define HW_MCG_C5_RD(x)          (ADDRESS_READ(hw_mcg_c5_t, HW_MCG_C5_ADDR(x)))
#define HW_MCG_C5_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c5_t, HW_MCG_C5_ADDR(x), v))
#define HW_MCG_C5_SET(x, v)      (HW_MCG_C5_WR(x, HW_MCG_C5_RD(x) |  (v)))
#define HW_MCG_C5_CLR(x, v)      (HW_MCG_C5_WR(x, HW_MCG_C5_RD(x) & ~(v)))
#define HW_MCG_C5_TOG(x, v)      (HW_MCG_C5_WR(x, HW_MCG_C5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C5 bitfields
 */

/*!
 * @name Register MCG_C5, field PRDIV0[4:0] (RW)
 *
 * Selects the amount to divide down the external reference clock for the PLL.
 * The resulting frequency must be in the range of 2 MHz to 4 MHz. After the PLL
 * is enabled (by setting either PLLCLKEN 0 or PLLS), the PRDIV 0 value must not
 * be changed when LOCK0 is zero. PLL External Reference Divide Factor PRDIV 0
 * Divide Factor PRDIV 0 Divide Factor PRDIV 0 Divide Factor PRDIV 0 Divide Factor
 * 00000 1 01000 9 10000 17 11000 25 00001 2 01001 10 10001 18 11001 Reserved
 * 00010 3 01010 11 10010 19 11010 Reserved 00011 4 01011 12 10011 20 11011 Reserved
 * 00100 5 01100 13 10100 21 11100 Reserved 00101 6 01101 14 10101 22 11101
 * Reserved 00110 7 01110 15 10110 23 11110 Reserved 00111 8 01111 16 10111 24 11111
 * Reserved
 */
/*@{*/
#define BP_MCG_C5_PRDIV0     (0U)          /*!< Bit position for MCG_C5_PRDIV0. */
#define BM_MCG_C5_PRDIV0     (0x1FU)       /*!< Bit mask for MCG_C5_PRDIV0. */
#define BS_MCG_C5_PRDIV0     (5U)          /*!< Bit field size in bits for MCG_C5_PRDIV0. */

/*! @brief Read current value of the MCG_C5_PRDIV0 field. */
#define BR_MCG_C5_PRDIV0(x)  (UNION_READ(hw_mcg_c5_t, HW_MCG_C5_ADDR(x), U, B.PRDIV0))

/*! @brief Format value for bitfield MCG_C5_PRDIV0. */
#define BF_MCG_C5_PRDIV0(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C5_PRDIV0) & BM_MCG_C5_PRDIV0)

/*! @brief Set the PRDIV0 field to a new value. */
#define BW_MCG_C5_PRDIV0(x, v) (HW_MCG_C5_WR(x, (HW_MCG_C5_RD(x) & ~BM_MCG_C5_PRDIV0) | BF_MCG_C5_PRDIV0(v)))
/*@}*/

/*!
 * @name Register MCG_C5, field PLLSTEN0[5] (RW)
 *
 * Enables the PLL Clock during Normal Stop. In Low Power Stop mode, the PLL
 * clock gets disabled even if PLLSTEN 0 =1. All other power modes, PLLSTEN 0 bit
 * has no affect and does not enable the PLL Clock to run if it is written to 1.
 *
 * Values:
 * - 0 - MCGPLLCLK is disabled in any of the Stop modes.
 * - 1 - MCGPLLCLK is enabled if system is in Normal Stop mode.
 */
/*@{*/
#define BP_MCG_C5_PLLSTEN0   (5U)          /*!< Bit position for MCG_C5_PLLSTEN0. */
#define BM_MCG_C5_PLLSTEN0   (0x20U)       /*!< Bit mask for MCG_C5_PLLSTEN0. */
#define BS_MCG_C5_PLLSTEN0   (1U)          /*!< Bit field size in bits for MCG_C5_PLLSTEN0. */

/*! @brief Read current value of the MCG_C5_PLLSTEN0 field. */
#define BR_MCG_C5_PLLSTEN0(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C5_ADDR(x), BP_MCG_C5_PLLSTEN0)))

/*! @brief Format value for bitfield MCG_C5_PLLSTEN0. */
#define BF_MCG_C5_PLLSTEN0(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C5_PLLSTEN0) & BM_MCG_C5_PLLSTEN0)

/*! @brief Set the PLLSTEN0 field to a new value. */
#define BW_MCG_C5_PLLSTEN0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C5_ADDR(x), BP_MCG_C5_PLLSTEN0), v))
/*@}*/

/*!
 * @name Register MCG_C5, field PLLCLKEN0[6] (RW)
 *
 * Enables the PLL independent of PLLS and enables the PLL clock for use as
 * MCGPLLCLK. (PRDIV 0 needs to be programmed to the correct divider to generate a
 * PLL reference clock in the range of 2 - 4 MHz range prior to setting the
 * PLLCLKEN 0 bit). Setting PLLCLKEN 0 will enable the external oscillator if not
 * already enabled. Whenever the PLL is being enabled by means of the PLLCLKEN 0 bit,
 * and the external oscillator is being used as the reference clock, the OSCINIT 0
 * bit should be checked to make sure it is set.
 *
 * Values:
 * - 0 - MCGPLLCLK is inactive.
 * - 1 - MCGPLLCLK is active.
 */
/*@{*/
#define BP_MCG_C5_PLLCLKEN0  (6U)          /*!< Bit position for MCG_C5_PLLCLKEN0. */
#define BM_MCG_C5_PLLCLKEN0  (0x40U)       /*!< Bit mask for MCG_C5_PLLCLKEN0. */
#define BS_MCG_C5_PLLCLKEN0  (1U)          /*!< Bit field size in bits for MCG_C5_PLLCLKEN0. */

/*! @brief Read current value of the MCG_C5_PLLCLKEN0 field. */
#define BR_MCG_C5_PLLCLKEN0(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C5_ADDR(x), BP_MCG_C5_PLLCLKEN0)))

/*! @brief Format value for bitfield MCG_C5_PLLCLKEN0. */
#define BF_MCG_C5_PLLCLKEN0(v) ((uint8_t)((uint8_t)(v) << BP_MCG_C5_PLLCLKEN0) & BM_MCG_C5_PLLCLKEN0)

/*! @brief Set the PLLCLKEN0 field to a new value. */
#define BW_MCG_C5_PLLCLKEN0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C5_ADDR(x), BP_MCG_C5_PLLCLKEN0), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_C6 - MCG Control 6 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C6 - MCG Control 6 Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_c6
{
    uint8_t U;
    struct _hw_mcg_c6_bitfields
    {
        uint8_t VDIV0 : 5;             /*!< [4:0] VCO 0 Divider */
        uint8_t CME0 : 1;              /*!< [5] Clock Monitor Enable */
        uint8_t PLLS : 1;              /*!< [6] PLL Select */
        uint8_t LOLIE0 : 1;            /*!< [7] Loss of Lock Interrrupt Enable */
    } B;
} hw_mcg_c6_t;

/*!
 * @name Constants and macros for entire MCG_C6 register
 */
/*@{*/
#define HW_MCG_C6_ADDR(x)        ((x) + 0x5U)

#define HW_MCG_C6(x)             (*(__IO hw_mcg_c6_t *) HW_MCG_C6_ADDR(x))
#define HW_MCG_C6_RD(x)          (ADDRESS_READ(hw_mcg_c6_t, HW_MCG_C6_ADDR(x)))
#define HW_MCG_C6_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c6_t, HW_MCG_C6_ADDR(x), v))
#define HW_MCG_C6_SET(x, v)      (HW_MCG_C6_WR(x, HW_MCG_C6_RD(x) |  (v)))
#define HW_MCG_C6_CLR(x, v)      (HW_MCG_C6_WR(x, HW_MCG_C6_RD(x) & ~(v)))
#define HW_MCG_C6_TOG(x, v)      (HW_MCG_C6_WR(x, HW_MCG_C6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C6 bitfields
 */

/*!
 * @name Register MCG_C6, field VDIV0[4:0] (RW)
 *
 * Selects the amount to divide the VCO output of the PLL. The VDIV 0 bits
 * establish the multiplication factor (M) applied to the reference clock frequency.
 * After the PLL is enabled (by setting either PLLCLKEN 0 or PLLS), the VDIV 0
 * value must not be changed when LOCK 0 is zero. PLL VCO Divide Factor VDIV 0
 * Multiply Factor VDIV 0 Multiply Factor VDIV 0 Multiply Factor VDIV 0 Multiply
 * Factor 00000 24 01000 32 10000 40 11000 48 00001 25 01001 33 10001 41 11001 49
 * 00010 26 01010 34 10010 42 11010 50 00011 27 01011 35 10011 43 11011 51 00100 28
 * 01100 36 10100 44 11100 52 00101 29 01101 37 10101 45 11101 53 00110 30 01110
 * 38 10110 46 11110 54 00111 31 01111 39 10111 47 11111 55
 */
/*@{*/
#define BP_MCG_C6_VDIV0      (0U)          /*!< Bit position for MCG_C6_VDIV0. */
#define BM_MCG_C6_VDIV0      (0x1FU)       /*!< Bit mask for MCG_C6_VDIV0. */
#define BS_MCG_C6_VDIV0      (5U)          /*!< Bit field size in bits for MCG_C6_VDIV0. */

/*! @brief Read current value of the MCG_C6_VDIV0 field. */
#define BR_MCG_C6_VDIV0(x)   (UNION_READ(hw_mcg_c6_t, HW_MCG_C6_ADDR(x), U, B.VDIV0))

/*! @brief Format value for bitfield MCG_C6_VDIV0. */
#define BF_MCG_C6_VDIV0(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C6_VDIV0) & BM_MCG_C6_VDIV0)

/*! @brief Set the VDIV0 field to a new value. */
#define BW_MCG_C6_VDIV0(x, v) (HW_MCG_C6_WR(x, (HW_MCG_C6_RD(x) & ~BM_MCG_C6_VDIV0) | BF_MCG_C6_VDIV0(v)))
/*@}*/

/*!
 * @name Register MCG_C6, field CME0[5] (RW)
 *
 * Enables the loss of clock monitoring circuit for the OSC0 external reference
 * mux select. The LOCRE0 bit will determine if a interrupt or a reset request is
 * generated following a loss of OSC0 indication. The CME0 bit must only be set
 * to a logic 1 when the MCG is in an operational mode that uses the external
 * clock (FEE, FBE, PEE, PBE, or BLPE) . Whenever the CME0 bit is set to a logic 1,
 * the value of the RANGE0 bits in the C2 register should not be changed. CME0
 * bit should be set to a logic 0 before the MCG enters any Stop mode. Otherwise, a
 * reset request may occur while in Stop mode. CME0 should also be set to a
 * logic 0 before entering VLPR or VLPW power modes if the MCG is in BLPE mode.
 *
 * Values:
 * - 0 - External clock monitor is disabled for OSC0.
 * - 1 - External clock monitor is enabled for OSC0.
 */
/*@{*/
#define BP_MCG_C6_CME0       (5U)          /*!< Bit position for MCG_C6_CME0. */
#define BM_MCG_C6_CME0       (0x20U)       /*!< Bit mask for MCG_C6_CME0. */
#define BS_MCG_C6_CME0       (1U)          /*!< Bit field size in bits for MCG_C6_CME0. */

/*! @brief Read current value of the MCG_C6_CME0 field. */
#define BR_MCG_C6_CME0(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_CME0)))

/*! @brief Format value for bitfield MCG_C6_CME0. */
#define BF_MCG_C6_CME0(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_C6_CME0) & BM_MCG_C6_CME0)

/*! @brief Set the CME0 field to a new value. */
#define BW_MCG_C6_CME0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_CME0), v))
/*@}*/

/*!
 * @name Register MCG_C6, field PLLS[6] (RW)
 *
 * Controls whether the PLL or FLL output is selected as the MCG source when
 * CLKS[1:0]=00. If the PLLS bit is cleared and PLLCLKEN 0 is not set, the PLL is
 * disabled in all modes. If the PLLS is set, the FLL is disabled in all modes.
 *
 * Values:
 * - 0 - FLL is selected.
 * - 1 - PLL is selected (PRDIV 0 need to be programmed to the correct divider
 *     to generate a PLL reference clock in the range of 2-4 MHz prior to setting
 *     the PLLS bit).
 */
/*@{*/
#define BP_MCG_C6_PLLS       (6U)          /*!< Bit position for MCG_C6_PLLS. */
#define BM_MCG_C6_PLLS       (0x40U)       /*!< Bit mask for MCG_C6_PLLS. */
#define BS_MCG_C6_PLLS       (1U)          /*!< Bit field size in bits for MCG_C6_PLLS. */

/*! @brief Read current value of the MCG_C6_PLLS field. */
#define BR_MCG_C6_PLLS(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_PLLS)))

/*! @brief Format value for bitfield MCG_C6_PLLS. */
#define BF_MCG_C6_PLLS(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_C6_PLLS) & BM_MCG_C6_PLLS)

/*! @brief Set the PLLS field to a new value. */
#define BW_MCG_C6_PLLS(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_PLLS), v))
/*@}*/

/*!
 * @name Register MCG_C6, field LOLIE0[7] (RW)
 *
 * Determines if an interrupt request is made following a loss of lock
 * indication. This bit only has an effect when LOLS 0 is set.
 *
 * Values:
 * - 0 - No interrupt request is generated on loss of lock.
 * - 1 - Generate an interrupt request on loss of lock.
 */
/*@{*/
#define BP_MCG_C6_LOLIE0     (7U)          /*!< Bit position for MCG_C6_LOLIE0. */
#define BM_MCG_C6_LOLIE0     (0x80U)       /*!< Bit mask for MCG_C6_LOLIE0. */
#define BS_MCG_C6_LOLIE0     (1U)          /*!< Bit field size in bits for MCG_C6_LOLIE0. */

/*! @brief Read current value of the MCG_C6_LOLIE0 field. */
#define BR_MCG_C6_LOLIE0(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_LOLIE0)))

/*! @brief Format value for bitfield MCG_C6_LOLIE0. */
#define BF_MCG_C6_LOLIE0(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C6_LOLIE0) & BM_MCG_C6_LOLIE0)

/*! @brief Set the LOLIE0 field to a new value. */
#define BW_MCG_C6_LOLIE0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C6_ADDR(x), BP_MCG_C6_LOLIE0), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_S - MCG Status Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_S - MCG Status Register (RW)
 *
 * Reset value: 0x10U
 */
typedef union _hw_mcg_s
{
    uint8_t U;
    struct _hw_mcg_s_bitfields
    {
        uint8_t IRCST : 1;             /*!< [0] Internal Reference Clock Status */
        uint8_t OSCINIT0 : 1;          /*!< [1] OSC Initialization */
        uint8_t CLKST : 2;             /*!< [3:2] Clock Mode Status */
        uint8_t IREFST : 1;            /*!< [4] Internal Reference Status */
        uint8_t PLLST : 1;             /*!< [5] PLL Select Status */
        uint8_t LOCK0 : 1;             /*!< [6] Lock Status */
        uint8_t LOLS0 : 1;             /*!< [7] Loss of Lock Status */
    } B;
} hw_mcg_s_t;

/*!
 * @name Constants and macros for entire MCG_S register
 */
/*@{*/
#define HW_MCG_S_ADDR(x)         ((x) + 0x6U)

#define HW_MCG_S(x)              (*(__IO hw_mcg_s_t *) HW_MCG_S_ADDR(x))
#define HW_MCG_S_RD(x)           (ADDRESS_READ(hw_mcg_s_t, HW_MCG_S_ADDR(x)))
#define HW_MCG_S_WR(x, v)        (ADDRESS_WRITE(hw_mcg_s_t, HW_MCG_S_ADDR(x), v))
#define HW_MCG_S_SET(x, v)       (HW_MCG_S_WR(x, HW_MCG_S_RD(x) |  (v)))
#define HW_MCG_S_CLR(x, v)       (HW_MCG_S_WR(x, HW_MCG_S_RD(x) & ~(v)))
#define HW_MCG_S_TOG(x, v)       (HW_MCG_S_WR(x, HW_MCG_S_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_S bitfields
 */

/*!
 * @name Register MCG_S, field IRCST[0] (RO)
 *
 * The IRCST bit indicates the current source for the internal reference clock
 * select clock (IRCSCLK). The IRCST bit does not update immediately after a write
 * to the IRCS bit due to internal synchronization between clock domains. The
 * IRCST bit will only be updated if the internal reference clock is enabled,
 * either by the MCG being in a mode that uses the IRC or by setting the C1[IRCLKEN]
 * bit .
 *
 * Values:
 * - 0 - Source of internal reference clock is the slow clock (32 kHz IRC).
 * - 1 - Source of internal reference clock is the fast clock (4 MHz IRC).
 */
/*@{*/
#define BP_MCG_S_IRCST       (0U)          /*!< Bit position for MCG_S_IRCST. */
#define BM_MCG_S_IRCST       (0x01U)       /*!< Bit mask for MCG_S_IRCST. */
#define BS_MCG_S_IRCST       (1U)          /*!< Bit field size in bits for MCG_S_IRCST. */

/*! @brief Read current value of the MCG_S_IRCST field. */
#define BR_MCG_S_IRCST(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_IRCST)))
/*@}*/

/*!
 * @name Register MCG_S, field OSCINIT0[1] (RO)
 *
 * This bit, which resets to 0, is set to 1 after the initialization cycles of
 * the crystal oscillator clock have completed. After being set, the bit is
 * cleared to 0 if the OSC is subsequently disabled. See the OSC module's detailed
 * description for more information.
 */
/*@{*/
#define BP_MCG_S_OSCINIT0    (1U)          /*!< Bit position for MCG_S_OSCINIT0. */
#define BM_MCG_S_OSCINIT0    (0x02U)       /*!< Bit mask for MCG_S_OSCINIT0. */
#define BS_MCG_S_OSCINIT0    (1U)          /*!< Bit field size in bits for MCG_S_OSCINIT0. */

/*! @brief Read current value of the MCG_S_OSCINIT0 field. */
#define BR_MCG_S_OSCINIT0(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_OSCINIT0)))
/*@}*/

/*!
 * @name Register MCG_S, field CLKST[3:2] (RO)
 *
 * These bits indicate the current clock mode. The CLKST bits do not update
 * immediately after a write to the CLKS bits due to internal synchronization between
 * clock domains.
 *
 * Values:
 * - 00 - Encoding 0 - Output of the FLL is selected (reset default).
 * - 01 - Encoding 1 - Internal reference clock is selected.
 * - 10 - Encoding 2 - External reference clock is selected.
 * - 11 - Encoding 3 - Output of the PLL is selected.
 */
/*@{*/
#define BP_MCG_S_CLKST       (2U)          /*!< Bit position for MCG_S_CLKST. */
#define BM_MCG_S_CLKST       (0x0CU)       /*!< Bit mask for MCG_S_CLKST. */
#define BS_MCG_S_CLKST       (2U)          /*!< Bit field size in bits for MCG_S_CLKST. */

/*! @brief Read current value of the MCG_S_CLKST field. */
#define BR_MCG_S_CLKST(x)    (UNION_READ(hw_mcg_s_t, HW_MCG_S_ADDR(x), U, B.CLKST))
/*@}*/

/*!
 * @name Register MCG_S, field IREFST[4] (RO)
 *
 * This bit indicates the current source for the FLL reference clock. The IREFST
 * bit does not update immediately after a write to the IREFS bit due to
 * internal synchronization between clock domains.
 *
 * Values:
 * - 0 - Source of FLL reference clock is the external reference clock.
 * - 1 - Source of FLL reference clock is the internal reference clock.
 */
/*@{*/
#define BP_MCG_S_IREFST      (4U)          /*!< Bit position for MCG_S_IREFST. */
#define BM_MCG_S_IREFST      (0x10U)       /*!< Bit mask for MCG_S_IREFST. */
#define BS_MCG_S_IREFST      (1U)          /*!< Bit field size in bits for MCG_S_IREFST. */

/*! @brief Read current value of the MCG_S_IREFST field. */
#define BR_MCG_S_IREFST(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_IREFST)))
/*@}*/

/*!
 * @name Register MCG_S, field PLLST[5] (RO)
 *
 * This bit indicates the clock source selected by PLLS . The PLLST bit does not
 * update immediately after a write to the PLLS bit due to internal
 * synchronization between clock domains.
 *
 * Values:
 * - 0 - Source of PLLS clock is FLL clock.
 * - 1 - Source of PLLS clock is PLL output clock.
 */
/*@{*/
#define BP_MCG_S_PLLST       (5U)          /*!< Bit position for MCG_S_PLLST. */
#define BM_MCG_S_PLLST       (0x20U)       /*!< Bit mask for MCG_S_PLLST. */
#define BS_MCG_S_PLLST       (1U)          /*!< Bit field size in bits for MCG_S_PLLST. */

/*! @brief Read current value of the MCG_S_PLLST field. */
#define BR_MCG_S_PLLST(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_PLLST)))
/*@}*/

/*!
 * @name Register MCG_S, field LOCK0[6] (RO)
 *
 * This bit indicates whether the PLL has acquired lock. Lock detection is only
 * enabled when the PLL is enabled (either through clock mode selection or
 * PLLCLKEN0=1 setting). While the PLL clock is locking to the desired frequency, the
 * MCG PLL clock (MCGPLLCLK) will be gated off until the LOCK bit gets asserted.
 * If the lock status bit is set, changing the value of the PRDIV0 [4:0] bits in
 * the C5 register or the VDIV0[4:0] bits in the C6 register causes the lock
 * status bit to clear and stay cleared until the PLL has reacquired lock. Loss of PLL
 * reference clock will also cause the LOCK0 bit to clear until the PLL has
 * reacquired lock. Entry into LLS, VLPS, or regular Stop with PLLSTEN=0 also causes
 * the lock status bit to clear and stay cleared until the Stop mode is exited
 * and the PLL has reacquired lock. Any time the PLL is enabled and the LOCK0 bit
 * is cleared, the MCGPLLCLK will be gated off until the LOCK0 bit is asserted
 * again.
 *
 * Values:
 * - 0 - PLL is currently unlocked.
 * - 1 - PLL is currently locked.
 */
/*@{*/
#define BP_MCG_S_LOCK0       (6U)          /*!< Bit position for MCG_S_LOCK0. */
#define BM_MCG_S_LOCK0       (0x40U)       /*!< Bit mask for MCG_S_LOCK0. */
#define BS_MCG_S_LOCK0       (1U)          /*!< Bit field size in bits for MCG_S_LOCK0. */

/*! @brief Read current value of the MCG_S_LOCK0 field. */
#define BR_MCG_S_LOCK0(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_LOCK0)))
/*@}*/

/*!
 * @name Register MCG_S, field LOLS0[7] (W1C)
 *
 * This bit is a sticky bit indicating the lock status for the PLL. LOLS is set
 * if after acquiring lock, the PLL output frequency has fallen outside the lock
 * exit frequency tolerance, D unl . LOLIE determines whether an interrupt
 * request is made when LOLS is set. LOLRE determines whether a reset request is made
 * when LOLS is set. This bit is cleared by reset or by writing a logic 1 to it
 * when set. Writing a logic 0 to this bit has no effect.
 *
 * Values:
 * - 0 - PLL has not lost lock since LOLS 0 was last cleared.
 * - 1 - PLL has lost lock since LOLS 0 was last cleared.
 */
/*@{*/
#define BP_MCG_S_LOLS0       (7U)          /*!< Bit position for MCG_S_LOLS0. */
#define BM_MCG_S_LOLS0       (0x80U)       /*!< Bit mask for MCG_S_LOLS0. */
#define BS_MCG_S_LOLS0       (1U)          /*!< Bit field size in bits for MCG_S_LOLS0. */

/*! @brief Read current value of the MCG_S_LOLS0 field. */
#define BR_MCG_S_LOLS0(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_LOLS0)))

/*! @brief Format value for bitfield MCG_S_LOLS0. */
#define BF_MCG_S_LOLS0(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_S_LOLS0) & BM_MCG_S_LOLS0)

/*! @brief Set the LOLS0 field to a new value. */
#define BW_MCG_S_LOLS0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_S_ADDR(x), BP_MCG_S_LOLS0), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_SC - MCG Status and Control Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_SC - MCG Status and Control Register (RW)
 *
 * Reset value: 0x02U
 */
typedef union _hw_mcg_sc
{
    uint8_t U;
    struct _hw_mcg_sc_bitfields
    {
        uint8_t LOCS0 : 1;             /*!< [0] OSC0 Loss of Clock Status */
        uint8_t FCRDIV : 3;            /*!< [3:1] Fast Clock Internal Reference Divider
                                        * */
        uint8_t FLTPRSRV : 1;          /*!< [4] FLL Filter Preserve Enable */
        uint8_t ATMF : 1;              /*!< [5] Automatic Trim Machine Fail Flag */
        uint8_t ATMS : 1;              /*!< [6] Automatic Trim Machine Select */
        uint8_t ATME : 1;              /*!< [7] Automatic Trim Machine Enable */
    } B;
} hw_mcg_sc_t;

/*!
 * @name Constants and macros for entire MCG_SC register
 */
/*@{*/
#define HW_MCG_SC_ADDR(x)        ((x) + 0x8U)

#define HW_MCG_SC(x)             (*(__IO hw_mcg_sc_t *) HW_MCG_SC_ADDR(x))
#define HW_MCG_SC_RD(x)          (ADDRESS_READ(hw_mcg_sc_t, HW_MCG_SC_ADDR(x)))
#define HW_MCG_SC_WR(x, v)       (ADDRESS_WRITE(hw_mcg_sc_t, HW_MCG_SC_ADDR(x), v))
#define HW_MCG_SC_SET(x, v)      (HW_MCG_SC_WR(x, HW_MCG_SC_RD(x) |  (v)))
#define HW_MCG_SC_CLR(x, v)      (HW_MCG_SC_WR(x, HW_MCG_SC_RD(x) & ~(v)))
#define HW_MCG_SC_TOG(x, v)      (HW_MCG_SC_WR(x, HW_MCG_SC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_SC bitfields
 */

/*!
 * @name Register MCG_SC, field LOCS0[0] (W1C)
 *
 * The LOCS0 indicates when a loss of OSC0 reference clock has occurred. The
 * LOCS0 bit only has an effect when CME0 is set. This bit is cleared by writing a
 * logic 1 to it when set.
 *
 * Values:
 * - 0 - Loss of OSC0 has not occurred.
 * - 1 - Loss of OSC0 has occurred.
 */
/*@{*/
#define BP_MCG_SC_LOCS0      (0U)          /*!< Bit position for MCG_SC_LOCS0. */
#define BM_MCG_SC_LOCS0      (0x01U)       /*!< Bit mask for MCG_SC_LOCS0. */
#define BS_MCG_SC_LOCS0      (1U)          /*!< Bit field size in bits for MCG_SC_LOCS0. */

/*! @brief Read current value of the MCG_SC_LOCS0 field. */
#define BR_MCG_SC_LOCS0(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_LOCS0)))

/*! @brief Format value for bitfield MCG_SC_LOCS0. */
#define BF_MCG_SC_LOCS0(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_SC_LOCS0) & BM_MCG_SC_LOCS0)

/*! @brief Set the LOCS0 field to a new value. */
#define BW_MCG_SC_LOCS0(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_LOCS0), v))
/*@}*/

/*!
 * @name Register MCG_SC, field FCRDIV[3:1] (RW)
 *
 * Selects the amount to divide down the fast internal reference clock. The
 * resulting frequency will be in the range 31.25 kHz to 4 MHz (Note: Changing the
 * divider when the Fast IRC is enabled is not supported).
 *
 * Values:
 * - 000 - Divide Factor is 1
 * - 001 - Divide Factor is 2.
 * - 010 - Divide Factor is 4.
 * - 011 - Divide Factor is 8.
 * - 100 - Divide Factor is 16
 * - 101 - Divide Factor is 32
 * - 110 - Divide Factor is 64
 * - 111 - Divide Factor is 128.
 */
/*@{*/
#define BP_MCG_SC_FCRDIV     (1U)          /*!< Bit position for MCG_SC_FCRDIV. */
#define BM_MCG_SC_FCRDIV     (0x0EU)       /*!< Bit mask for MCG_SC_FCRDIV. */
#define BS_MCG_SC_FCRDIV     (3U)          /*!< Bit field size in bits for MCG_SC_FCRDIV. */

/*! @brief Read current value of the MCG_SC_FCRDIV field. */
#define BR_MCG_SC_FCRDIV(x)  (UNION_READ(hw_mcg_sc_t, HW_MCG_SC_ADDR(x), U, B.FCRDIV))

/*! @brief Format value for bitfield MCG_SC_FCRDIV. */
#define BF_MCG_SC_FCRDIV(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_SC_FCRDIV) & BM_MCG_SC_FCRDIV)

/*! @brief Set the FCRDIV field to a new value. */
#define BW_MCG_SC_FCRDIV(x, v) (HW_MCG_SC_WR(x, (HW_MCG_SC_RD(x) & ~BM_MCG_SC_FCRDIV) | BF_MCG_SC_FCRDIV(v)))
/*@}*/

/*!
 * @name Register MCG_SC, field FLTPRSRV[4] (RW)
 *
 * This bit will prevent the FLL filter values from resetting allowing the FLL
 * output frequency to remain the same during clock mode changes where the FLL/DCO
 * output is still valid. (Note: This requires that the FLL reference frequency
 * to remain the same as what it was prior to the new clock mode switch.
 * Otherwise FLL filter and frequency values will change.)
 *
 * Values:
 * - 0 - FLL filter and FLL frequency will reset on changes to currect clock
 *     mode.
 * - 1 - Fll filter and FLL frequency retain their previous values during new
 *     clock mode change.
 */
/*@{*/
#define BP_MCG_SC_FLTPRSRV   (4U)          /*!< Bit position for MCG_SC_FLTPRSRV. */
#define BM_MCG_SC_FLTPRSRV   (0x10U)       /*!< Bit mask for MCG_SC_FLTPRSRV. */
#define BS_MCG_SC_FLTPRSRV   (1U)          /*!< Bit field size in bits for MCG_SC_FLTPRSRV. */

/*! @brief Read current value of the MCG_SC_FLTPRSRV field. */
#define BR_MCG_SC_FLTPRSRV(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_FLTPRSRV)))

/*! @brief Format value for bitfield MCG_SC_FLTPRSRV. */
#define BF_MCG_SC_FLTPRSRV(v) ((uint8_t)((uint8_t)(v) << BP_MCG_SC_FLTPRSRV) & BM_MCG_SC_FLTPRSRV)

/*! @brief Set the FLTPRSRV field to a new value. */
#define BW_MCG_SC_FLTPRSRV(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_FLTPRSRV), v))
/*@}*/

/*!
 * @name Register MCG_SC, field ATMF[5] (RW)
 *
 * Fail flag for the Automatic Trim Machine (ATM). This bit asserts when the
 * Automatic Trim Machine is enabled, ATME=1, and a write to the C1, C3, C4, and SC
 * registers is detected or the MCG enters into any Stop mode. A write to ATMF
 * clears the flag.
 *
 * Values:
 * - 0 - Automatic Trim Machine completed normally.
 * - 1 - Automatic Trim Machine failed.
 */
/*@{*/
#define BP_MCG_SC_ATMF       (5U)          /*!< Bit position for MCG_SC_ATMF. */
#define BM_MCG_SC_ATMF       (0x20U)       /*!< Bit mask for MCG_SC_ATMF. */
#define BS_MCG_SC_ATMF       (1U)          /*!< Bit field size in bits for MCG_SC_ATMF. */

/*! @brief Read current value of the MCG_SC_ATMF field. */
#define BR_MCG_SC_ATMF(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATMF)))

/*! @brief Format value for bitfield MCG_SC_ATMF. */
#define BF_MCG_SC_ATMF(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_SC_ATMF) & BM_MCG_SC_ATMF)

/*! @brief Set the ATMF field to a new value. */
#define BW_MCG_SC_ATMF(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATMF), v))
/*@}*/

/*!
 * @name Register MCG_SC, field ATMS[6] (RW)
 *
 * Selects the IRCS clock for Auto Trim Test.
 *
 * Values:
 * - 0 - 32 kHz Internal Reference Clock selected.
 * - 1 - 4 MHz Internal Reference Clock selected.
 */
/*@{*/
#define BP_MCG_SC_ATMS       (6U)          /*!< Bit position for MCG_SC_ATMS. */
#define BM_MCG_SC_ATMS       (0x40U)       /*!< Bit mask for MCG_SC_ATMS. */
#define BS_MCG_SC_ATMS       (1U)          /*!< Bit field size in bits for MCG_SC_ATMS. */

/*! @brief Read current value of the MCG_SC_ATMS field. */
#define BR_MCG_SC_ATMS(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATMS)))

/*! @brief Format value for bitfield MCG_SC_ATMS. */
#define BF_MCG_SC_ATMS(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_SC_ATMS) & BM_MCG_SC_ATMS)

/*! @brief Set the ATMS field to a new value. */
#define BW_MCG_SC_ATMS(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATMS), v))
/*@}*/

/*!
 * @name Register MCG_SC, field ATME[7] (RW)
 *
 * Enables the Auto Trim Machine to start automatically trimming the selected
 * Internal Reference Clock. ATME deasserts after the Auto Trim Machine has
 * completed trimming all trim bits of the IRCS clock selected by the ATMS bit. Writing
 * to C1, C3, C4, and SC registers or entering Stop mode aborts the auto trim
 * operation and clears this bit.
 *
 * Values:
 * - 0 - Auto Trim Machine disabled.
 * - 1 - Auto Trim Machine enabled.
 */
/*@{*/
#define BP_MCG_SC_ATME       (7U)          /*!< Bit position for MCG_SC_ATME. */
#define BM_MCG_SC_ATME       (0x80U)       /*!< Bit mask for MCG_SC_ATME. */
#define BS_MCG_SC_ATME       (1U)          /*!< Bit field size in bits for MCG_SC_ATME. */

/*! @brief Read current value of the MCG_SC_ATME field. */
#define BR_MCG_SC_ATME(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATME)))

/*! @brief Format value for bitfield MCG_SC_ATME. */
#define BF_MCG_SC_ATME(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_SC_ATME) & BM_MCG_SC_ATME)

/*! @brief Set the ATME field to a new value. */
#define BW_MCG_SC_ATME(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_SC_ADDR(x), BP_MCG_SC_ATME), v))
/*@}*/

/*******************************************************************************
 * HW_MCG_ATCVH - MCG Auto Trim Compare Value High Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_ATCVH - MCG Auto Trim Compare Value High Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_atcvh
{
    uint8_t U;
    struct _hw_mcg_atcvh_bitfields
    {
        uint8_t ATCVH : 8;             /*!< [7:0] ATM Compare Value High */
    } B;
} hw_mcg_atcvh_t;

/*!
 * @name Constants and macros for entire MCG_ATCVH register
 */
/*@{*/
#define HW_MCG_ATCVH_ADDR(x)     ((x) + 0xAU)

#define HW_MCG_ATCVH(x)          (*(__IO hw_mcg_atcvh_t *) HW_MCG_ATCVH_ADDR(x))
#define HW_MCG_ATCVH_RD(x)       (ADDRESS_READ(hw_mcg_atcvh_t, HW_MCG_ATCVH_ADDR(x)))
#define HW_MCG_ATCVH_WR(x, v)    (ADDRESS_WRITE(hw_mcg_atcvh_t, HW_MCG_ATCVH_ADDR(x), v))
#define HW_MCG_ATCVH_SET(x, v)   (HW_MCG_ATCVH_WR(x, HW_MCG_ATCVH_RD(x) |  (v)))
#define HW_MCG_ATCVH_CLR(x, v)   (HW_MCG_ATCVH_WR(x, HW_MCG_ATCVH_RD(x) & ~(v)))
#define HW_MCG_ATCVH_TOG(x, v)   (HW_MCG_ATCVH_WR(x, HW_MCG_ATCVH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_ATCVH bitfields
 */

/*!
 * @name Register MCG_ATCVH, field ATCVH[7:0] (RW)
 *
 * Values are used by Auto Trim Machine to compare and adjust Internal Reference
 * trim values during ATM SAR conversion.
 */
/*@{*/
#define BP_MCG_ATCVH_ATCVH   (0U)          /*!< Bit position for MCG_ATCVH_ATCVH. */
#define BM_MCG_ATCVH_ATCVH   (0xFFU)       /*!< Bit mask for MCG_ATCVH_ATCVH. */
#define BS_MCG_ATCVH_ATCVH   (8U)          /*!< Bit field size in bits for MCG_ATCVH_ATCVH. */

/*! @brief Read current value of the MCG_ATCVH_ATCVH field. */
#define BR_MCG_ATCVH_ATCVH(x) (HW_MCG_ATCVH(x).U)

/*! @brief Format value for bitfield MCG_ATCVH_ATCVH. */
#define BF_MCG_ATCVH_ATCVH(v) ((uint8_t)((uint8_t)(v) << BP_MCG_ATCVH_ATCVH) & BM_MCG_ATCVH_ATCVH)

/*! @brief Set the ATCVH field to a new value. */
#define BW_MCG_ATCVH_ATCVH(x, v) (HW_MCG_ATCVH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_MCG_ATCVL - MCG Auto Trim Compare Value Low Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_ATCVL - MCG Auto Trim Compare Value Low Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_atcvl
{
    uint8_t U;
    struct _hw_mcg_atcvl_bitfields
    {
        uint8_t ATCVL : 8;             /*!< [7:0] ATM Compare Value Low */
    } B;
} hw_mcg_atcvl_t;

/*!
 * @name Constants and macros for entire MCG_ATCVL register
 */
/*@{*/
#define HW_MCG_ATCVL_ADDR(x)     ((x) + 0xBU)

#define HW_MCG_ATCVL(x)          (*(__IO hw_mcg_atcvl_t *) HW_MCG_ATCVL_ADDR(x))
#define HW_MCG_ATCVL_RD(x)       (ADDRESS_READ(hw_mcg_atcvl_t, HW_MCG_ATCVL_ADDR(x)))
#define HW_MCG_ATCVL_WR(x, v)    (ADDRESS_WRITE(hw_mcg_atcvl_t, HW_MCG_ATCVL_ADDR(x), v))
#define HW_MCG_ATCVL_SET(x, v)   (HW_MCG_ATCVL_WR(x, HW_MCG_ATCVL_RD(x) |  (v)))
#define HW_MCG_ATCVL_CLR(x, v)   (HW_MCG_ATCVL_WR(x, HW_MCG_ATCVL_RD(x) & ~(v)))
#define HW_MCG_ATCVL_TOG(x, v)   (HW_MCG_ATCVL_WR(x, HW_MCG_ATCVL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_ATCVL bitfields
 */

/*!
 * @name Register MCG_ATCVL, field ATCVL[7:0] (RW)
 *
 * Values are used by Auto Trim Machine to compare and adjust Internal Reference
 * trim values during ATM SAR conversion.
 */
/*@{*/
#define BP_MCG_ATCVL_ATCVL   (0U)          /*!< Bit position for MCG_ATCVL_ATCVL. */
#define BM_MCG_ATCVL_ATCVL   (0xFFU)       /*!< Bit mask for MCG_ATCVL_ATCVL. */
#define BS_MCG_ATCVL_ATCVL   (8U)          /*!< Bit field size in bits for MCG_ATCVL_ATCVL. */

/*! @brief Read current value of the MCG_ATCVL_ATCVL field. */
#define BR_MCG_ATCVL_ATCVL(x) (HW_MCG_ATCVL(x).U)

/*! @brief Format value for bitfield MCG_ATCVL_ATCVL. */
#define BF_MCG_ATCVL_ATCVL(v) ((uint8_t)((uint8_t)(v) << BP_MCG_ATCVL_ATCVL) & BM_MCG_ATCVL_ATCVL)

/*! @brief Set the ATCVL field to a new value. */
#define BW_MCG_ATCVL_ATCVL(x, v) (HW_MCG_ATCVL_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_MCG_C7 - MCG Control 7 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C7 - MCG Control 7 Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_mcg_c7
{
    uint8_t U;
    struct _hw_mcg_c7_bitfields
    {
        uint8_t OSCSEL : 2;            /*!< [1:0] MCG OSC Clock Select */
        uint8_t RESERVED0 : 6;         /*!< [7:2]  */
    } B;
} hw_mcg_c7_t;

/*!
 * @name Constants and macros for entire MCG_C7 register
 */
/*@{*/
#define HW_MCG_C7_ADDR(x)        ((x) + 0xCU)

#define HW_MCG_C7(x)             (*(__IO hw_mcg_c7_t *) HW_MCG_C7_ADDR(x))
#define HW_MCG_C7_RD(x)          (ADDRESS_READ(hw_mcg_c7_t, HW_MCG_C7_ADDR(x)))
#define HW_MCG_C7_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c7_t, HW_MCG_C7_ADDR(x), v))
#define HW_MCG_C7_SET(x, v)      (HW_MCG_C7_WR(x, HW_MCG_C7_RD(x) |  (v)))
#define HW_MCG_C7_CLR(x, v)      (HW_MCG_C7_WR(x, HW_MCG_C7_RD(x) & ~(v)))
#define HW_MCG_C7_TOG(x, v)      (HW_MCG_C7_WR(x, HW_MCG_C7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C7 bitfields
 */

/*!
 * @name Register MCG_C7, field OSCSEL[1:0] (RW)
 *
 * Selects the MCG FLL external reference clock
 *
 * Values:
 * - 00 - Selects Oscillator (OSCCLK0).
 * - 01 - Selects 32 kHz RTC Oscillator.
 * - 10 - Selects Oscillator (OSCCLK1).
 * - 11 - RESERVED
 */
/*@{*/
#define BP_MCG_C7_OSCSEL     (0U)          /*!< Bit position for MCG_C7_OSCSEL. */
#define BM_MCG_C7_OSCSEL     (0x03U)       /*!< Bit mask for MCG_C7_OSCSEL. */
#define BS_MCG_C7_OSCSEL     (2U)          /*!< Bit field size in bits for MCG_C7_OSCSEL. */

/*! @brief Read current value of the MCG_C7_OSCSEL field. */
#define BR_MCG_C7_OSCSEL(x)  (UNION_READ(hw_mcg_c7_t, HW_MCG_C7_ADDR(x), U, B.OSCSEL))

/*! @brief Format value for bitfield MCG_C7_OSCSEL. */
#define BF_MCG_C7_OSCSEL(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C7_OSCSEL) & BM_MCG_C7_OSCSEL)

/*! @brief Set the OSCSEL field to a new value. */
#define BW_MCG_C7_OSCSEL(x, v) (HW_MCG_C7_WR(x, (HW_MCG_C7_RD(x) & ~BM_MCG_C7_OSCSEL) | BF_MCG_C7_OSCSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_MCG_C8 - MCG Control 8 Register
 ******************************************************************************/

/*!
 * @brief HW_MCG_C8 - MCG Control 8 Register (RW)
 *
 * Reset value: 0x80U
 */
typedef union _hw_mcg_c8
{
    uint8_t U;
    struct _hw_mcg_c8_bitfields
    {
        uint8_t LOCS1 : 1;             /*!< [0] RTC Loss of Clock Status */
        uint8_t RESERVED0 : 4;         /*!< [4:1]  */
        uint8_t CME1 : 1;              /*!< [5] Clock Monitor Enable1 */
        uint8_t LOLRE : 1;             /*!< [6] PLL Loss of Lock Reset Enable */
        uint8_t LOCRE1 : 1;            /*!< [7] Loss of Clock Reset Enable */
    } B;
} hw_mcg_c8_t;

/*!
 * @name Constants and macros for entire MCG_C8 register
 */
/*@{*/
#define HW_MCG_C8_ADDR(x)        ((x) + 0xDU)

#define HW_MCG_C8(x)             (*(__IO hw_mcg_c8_t *) HW_MCG_C8_ADDR(x))
#define HW_MCG_C8_RD(x)          (ADDRESS_READ(hw_mcg_c8_t, HW_MCG_C8_ADDR(x)))
#define HW_MCG_C8_WR(x, v)       (ADDRESS_WRITE(hw_mcg_c8_t, HW_MCG_C8_ADDR(x), v))
#define HW_MCG_C8_SET(x, v)      (HW_MCG_C8_WR(x, HW_MCG_C8_RD(x) |  (v)))
#define HW_MCG_C8_CLR(x, v)      (HW_MCG_C8_WR(x, HW_MCG_C8_RD(x) & ~(v)))
#define HW_MCG_C8_TOG(x, v)      (HW_MCG_C8_WR(x, HW_MCG_C8_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCG_C8 bitfields
 */

/*!
 * @name Register MCG_C8, field LOCS1[0] (W1C)
 *
 * This bit indicates when a loss of clock has occurred. This bit is cleared by
 * writing a logic 1 to it when set.
 *
 * Values:
 * - 0 - Loss of RTC has not occur.
 * - 1 - Loss of RTC has occur
 */
/*@{*/
#define BP_MCG_C8_LOCS1      (0U)          /*!< Bit position for MCG_C8_LOCS1. */
#define BM_MCG_C8_LOCS1      (0x01U)       /*!< Bit mask for MCG_C8_LOCS1. */
#define BS_MCG_C8_LOCS1      (1U)          /*!< Bit field size in bits for MCG_C8_LOCS1. */

/*! @brief Read current value of the MCG_C8_LOCS1 field. */
#define BR_MCG_C8_LOCS1(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOCS1)))

/*! @brief Format value for bitfield MCG_C8_LOCS1. */
#define BF_MCG_C8_LOCS1(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C8_LOCS1) & BM_MCG_C8_LOCS1)

/*! @brief Set the LOCS1 field to a new value. */
#define BW_MCG_C8_LOCS1(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOCS1), v))
/*@}*/

/*!
 * @name Register MCG_C8, field CME1[5] (RW)
 *
 * Enables the loss of clock monitoring circuit for the output of the RTC
 * external reference clock. The LOCRE1 bit will determine whether an interrupt or a
 * reset request is generated following a loss of RTC clock indication. The CME1
 * bit should be set to a logic 1 when the MCG is in an operational mode that uses
 * the RTC as its external reference clock or if the RTC is operational. CME1 bit
 * must be set to a logic 0 before the MCG enters any Stop mode. Otherwise, a
 * reset request may occur when in Stop mode. CME1 should also be set to a logic 0
 * before entering VLPR or VLPW power modes.
 *
 * Values:
 * - 0 - External clock monitor is disabled for RTC clock.
 * - 1 - External clock monitor is enabled for RTC clock.
 */
/*@{*/
#define BP_MCG_C8_CME1       (5U)          /*!< Bit position for MCG_C8_CME1. */
#define BM_MCG_C8_CME1       (0x20U)       /*!< Bit mask for MCG_C8_CME1. */
#define BS_MCG_C8_CME1       (1U)          /*!< Bit field size in bits for MCG_C8_CME1. */

/*! @brief Read current value of the MCG_C8_CME1 field. */
#define BR_MCG_C8_CME1(x)    (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_CME1)))

/*! @brief Format value for bitfield MCG_C8_CME1. */
#define BF_MCG_C8_CME1(v)    ((uint8_t)((uint8_t)(v) << BP_MCG_C8_CME1) & BM_MCG_C8_CME1)

/*! @brief Set the CME1 field to a new value. */
#define BW_MCG_C8_CME1(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_CME1), v))
/*@}*/

/*!
 * @name Register MCG_C8, field LOLRE[6] (RW)
 *
 * Determines if an interrupt or a reset request is made following a PLL loss of
 * lock.
 *
 * Values:
 * - 0 - Interrupt request is generated on a PLL loss of lock indication. The
 *     PLL loss of lock interrupt enable bit must also be set to generate the
 *     interrupt request.
 * - 1 - Generate a reset request on a PLL loss of lock indication.
 */
/*@{*/
#define BP_MCG_C8_LOLRE      (6U)          /*!< Bit position for MCG_C8_LOLRE. */
#define BM_MCG_C8_LOLRE      (0x40U)       /*!< Bit mask for MCG_C8_LOLRE. */
#define BS_MCG_C8_LOLRE      (1U)          /*!< Bit field size in bits for MCG_C8_LOLRE. */

/*! @brief Read current value of the MCG_C8_LOLRE field. */
#define BR_MCG_C8_LOLRE(x)   (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOLRE)))

/*! @brief Format value for bitfield MCG_C8_LOLRE. */
#define BF_MCG_C8_LOLRE(v)   ((uint8_t)((uint8_t)(v) << BP_MCG_C8_LOLRE) & BM_MCG_C8_LOLRE)

/*! @brief Set the LOLRE field to a new value. */
#define BW_MCG_C8_LOLRE(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOLRE), v))
/*@}*/

/*!
 * @name Register MCG_C8, field LOCRE1[7] (RW)
 *
 * Determines if a interrupt or a reset request is made following a loss of RTC
 * external reference clock. The LOCRE1 only has an affect when CME1 is set.
 *
 * Values:
 * - 0 - Interrupt request is generated on a loss of RTC external reference
 *     clock.
 * - 1 - Generate a reset request on a loss of RTC external reference clock
 */
/*@{*/
#define BP_MCG_C8_LOCRE1     (7U)          /*!< Bit position for MCG_C8_LOCRE1. */
#define BM_MCG_C8_LOCRE1     (0x80U)       /*!< Bit mask for MCG_C8_LOCRE1. */
#define BS_MCG_C8_LOCRE1     (1U)          /*!< Bit field size in bits for MCG_C8_LOCRE1. */

/*! @brief Read current value of the MCG_C8_LOCRE1 field. */
#define BR_MCG_C8_LOCRE1(x)  (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOCRE1)))

/*! @brief Format value for bitfield MCG_C8_LOCRE1. */
#define BF_MCG_C8_LOCRE1(v)  ((uint8_t)((uint8_t)(v) << BP_MCG_C8_LOCRE1) & BM_MCG_C8_LOCRE1)

/*! @brief Set the LOCRE1 field to a new value. */
#define BW_MCG_C8_LOCRE1(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_MCG_C8_ADDR(x), BP_MCG_C8_LOCRE1), v))
/*@}*/

/*******************************************************************************
 * hw_mcg_t - module struct
 ******************************************************************************/
/*!
 * @brief All MCG module registers.
 */
#pragma pack(1)
typedef struct _hw_mcg
{
    __IO hw_mcg_c1_t C1;                   /*!< [0x0] MCG Control 1 Register */
    __IO hw_mcg_c2_t C2;                   /*!< [0x1] MCG Control 2 Register */
    __IO hw_mcg_c3_t C3;                   /*!< [0x2] MCG Control 3 Register */
    __IO hw_mcg_c4_t C4;                   /*!< [0x3] MCG Control 4 Register */
    __IO hw_mcg_c5_t C5;                   /*!< [0x4] MCG Control 5 Register */
    __IO hw_mcg_c6_t C6;                   /*!< [0x5] MCG Control 6 Register */
    __IO hw_mcg_s_t S;                     /*!< [0x6] MCG Status Register */
    uint8_t _reserved0[1];
    __IO hw_mcg_sc_t SC;                   /*!< [0x8] MCG Status and Control Register */
    uint8_t _reserved1[1];
    __IO hw_mcg_atcvh_t ATCVH;             /*!< [0xA] MCG Auto Trim Compare Value High Register */
    __IO hw_mcg_atcvl_t ATCVL;             /*!< [0xB] MCG Auto Trim Compare Value Low Register */
    __IO hw_mcg_c7_t C7;                   /*!< [0xC] MCG Control 7 Register */
    __IO hw_mcg_c8_t C8;                   /*!< [0xD] MCG Control 8 Register */
} hw_mcg_t;
#pragma pack()

/*! @brief Macro to access all MCG registers. */
/*! @param x MCG module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_MCG(MCG_BASE)</code>. */
#define HW_MCG(x)      (*(hw_mcg_t *)(x))

#endif /* __HW_MCG_REGISTERS_H__ */
/* EOF */
