/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     (C) COPYRIGHT 2015-2015 ARM Limited
**     ALL RIGHTS RESERVED
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2015-08-03) (ARM)
**         All accesses to memory are replaced by equivalent macros; this allows
**         memory read/write operations to be re-defined if needed (for example,
**         to implement new security features
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_FTFE_REGISTERS_H__
#define __HW_FTFE_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 FTFE
 *
 * Flash Memory Interface
 *
 * Registers defined in this header file:
 * - HW_FTFE_FSTAT - Flash Status Register
 * - HW_FTFE_FCNFG - Flash Configuration Register
 * - HW_FTFE_FSEC - Flash Security Register
 * - HW_FTFE_FOPT - Flash Option Register
 * - HW_FTFE_FCCOB3 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB2 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB1 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB0 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB7 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB6 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB5 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB4 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOBB - Flash Common Command Object Registers
 * - HW_FTFE_FCCOBA - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB9 - Flash Common Command Object Registers
 * - HW_FTFE_FCCOB8 - Flash Common Command Object Registers
 * - HW_FTFE_FPROT3 - Program Flash Protection Registers
 * - HW_FTFE_FPROT2 - Program Flash Protection Registers
 * - HW_FTFE_FPROT1 - Program Flash Protection Registers
 * - HW_FTFE_FPROT0 - Program Flash Protection Registers
 * - HW_FTFE_FEPROT - EEPROM Protection Register
 * - HW_FTFE_FDPROT - Data Flash Protection Register
 *
 * - hw_ftfe_t - Struct containing all module registers.
 */

#define HW_FTFE_INSTANCE_COUNT (1U) /*!< Number of instances of the FTFE module. */

/*******************************************************************************
 * HW_FTFE_FSTAT - Flash Status Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FSTAT - Flash Status Register (RW)
 *
 * Reset value: 0x00U
 *
 * The FSTAT register reports the operational status of the FTFE module. The
 * CCIF, RDCOLERR, ACCERR, and FPVIOL bits are readable and writable. The MGSTAT0
 * bit is read only. The unassigned bits read 0 and are not writable. When set, the
 * Access Error (ACCERR) and Flash Protection Violation (FPVIOL) bits in this
 * register prevent the launch of any more commands or writes to the FlexRAM (when
 * EEERDY is set) until the flag is cleared (by writing a one to it).
 */
typedef union _hw_ftfe_fstat
{
    uint8_t U;
    struct _hw_ftfe_fstat_bitfields
    {
        uint8_t MGSTAT0 : 1;           /*!< [0] Memory Controller Command Completion
                                        * Status Flag */
        uint8_t RESERVED0 : 3;         /*!< [3:1]  */
        uint8_t FPVIOL : 1;            /*!< [4] Flash Protection Violation Flag */
        uint8_t ACCERR : 1;            /*!< [5] Flash Access Error Flag */
        uint8_t RDCOLERR : 1;          /*!< [6] FTFE Read Collision Error Flag */
        uint8_t CCIF : 1;              /*!< [7] Command Complete Interrupt Flag */
    } B;
} hw_ftfe_fstat_t;

/*!
 * @name Constants and macros for entire FTFE_FSTAT register
 */
/*@{*/
#define HW_FTFE_FSTAT_ADDR(x)    ((x) + 0x0U)

#define HW_FTFE_FSTAT(x)         (*(__IO hw_ftfe_fstat_t *) HW_FTFE_FSTAT_ADDR(x))
#define HW_FTFE_FSTAT_RD(x)      (ADDRESS_READ(hw_ftfe_fstat_t, HW_FTFE_FSTAT_ADDR(x)))
#define HW_FTFE_FSTAT_WR(x, v)   (ADDRESS_WRITE(hw_ftfe_fstat_t, HW_FTFE_FSTAT_ADDR(x), v))
#define HW_FTFE_FSTAT_SET(x, v)  (HW_FTFE_FSTAT_WR(x, HW_FTFE_FSTAT_RD(x) |  (v)))
#define HW_FTFE_FSTAT_CLR(x, v)  (HW_FTFE_FSTAT_WR(x, HW_FTFE_FSTAT_RD(x) & ~(v)))
#define HW_FTFE_FSTAT_TOG(x, v)  (HW_FTFE_FSTAT_WR(x, HW_FTFE_FSTAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FSTAT bitfields
 */

/*!
 * @name Register FTFE_FSTAT, field MGSTAT0[0] (RO)
 *
 * The MGSTAT0 status flag is set if an error is detected during execution of an
 * FTFE command or during the flash reset sequence. As a status flag, this bit
 * cannot (and need not) be cleared by the user like the other error flags in this
 * register. The value of the MGSTAT0 bit for "command-N" is valid only at the
 * end of the "command-N" execution when CCIF=1 and before the next command has
 * been launched. At some point during the execution of "command-N+1," the previous
 * result is discarded and any previous error is cleared.
 */
/*@{*/
#define BP_FTFE_FSTAT_MGSTAT0 (0U)         /*!< Bit position for FTFE_FSTAT_MGSTAT0. */
#define BM_FTFE_FSTAT_MGSTAT0 (0x01U)      /*!< Bit mask for FTFE_FSTAT_MGSTAT0. */
#define BS_FTFE_FSTAT_MGSTAT0 (1U)         /*!< Bit field size in bits for FTFE_FSTAT_MGSTAT0. */

/*! @brief Read current value of the FTFE_FSTAT_MGSTAT0 field. */
#define BR_FTFE_FSTAT_MGSTAT0(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_MGSTAT0)))
/*@}*/

/*!
 * @name Register FTFE_FSTAT, field FPVIOL[4] (W1C)
 *
 * The FPVIOL error bit indicates an attempt was made to program or erase an
 * address in a protected area of program flash or data flash memory during a
 * command write sequence or a write was attempted to a protected area of the FlexRAM
 * while enabled for EEPROM. While FPVIOL is set, the CCIF flag cannot be cleared
 * to launch a command. The FPVIOL bit is cleared by writing a 1 to it. Writing a
 * 0 to the FPVIOL bit has no effect.
 *
 * Values:
 * - 0 - No protection violation detected
 * - 1 - Protection violation detected
 */
/*@{*/
#define BP_FTFE_FSTAT_FPVIOL (4U)          /*!< Bit position for FTFE_FSTAT_FPVIOL. */
#define BM_FTFE_FSTAT_FPVIOL (0x10U)       /*!< Bit mask for FTFE_FSTAT_FPVIOL. */
#define BS_FTFE_FSTAT_FPVIOL (1U)          /*!< Bit field size in bits for FTFE_FSTAT_FPVIOL. */

/*! @brief Read current value of the FTFE_FSTAT_FPVIOL field. */
#define BR_FTFE_FSTAT_FPVIOL(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_FPVIOL)))

/*! @brief Format value for bitfield FTFE_FSTAT_FPVIOL. */
#define BF_FTFE_FSTAT_FPVIOL(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FSTAT_FPVIOL) & BM_FTFE_FSTAT_FPVIOL)

/*! @brief Set the FPVIOL field to a new value. */
#define BW_FTFE_FSTAT_FPVIOL(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_FPVIOL), v))
/*@}*/

/*!
 * @name Register FTFE_FSTAT, field ACCERR[5] (W1C)
 *
 * The ACCERR error bit indicates an illegal access has occurred to an FTFE
 * resource caused by a violation of the command write sequence or issuing an illegal
 * FTFE command. While ACCERR is set, the CCIF flag cannot be cleared to launch
 * a command. The ACCERR bit is cleared by writing a 1 to it. Writing a 0 to the
 * ACCERR bit has no effect.
 *
 * Values:
 * - 0 - No access error detected
 * - 1 - Access error detected
 */
/*@{*/
#define BP_FTFE_FSTAT_ACCERR (5U)          /*!< Bit position for FTFE_FSTAT_ACCERR. */
#define BM_FTFE_FSTAT_ACCERR (0x20U)       /*!< Bit mask for FTFE_FSTAT_ACCERR. */
#define BS_FTFE_FSTAT_ACCERR (1U)          /*!< Bit field size in bits for FTFE_FSTAT_ACCERR. */

/*! @brief Read current value of the FTFE_FSTAT_ACCERR field. */
#define BR_FTFE_FSTAT_ACCERR(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_ACCERR)))

/*! @brief Format value for bitfield FTFE_FSTAT_ACCERR. */
#define BF_FTFE_FSTAT_ACCERR(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FSTAT_ACCERR) & BM_FTFE_FSTAT_ACCERR)

/*! @brief Set the ACCERR field to a new value. */
#define BW_FTFE_FSTAT_ACCERR(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_ACCERR), v))
/*@}*/

/*!
 * @name Register FTFE_FSTAT, field RDCOLERR[6] (W1C)
 *
 * The RDCOLERR error bit indicates that the MCU attempted a read from an FTFE
 * resource that was being manipulated by an FTFE command (CCIF=0). Any
 * simultaneous access is detected as a collision error by the block arbitration logic. The
 * read data in this case cannot be guaranteed. The RDCOLERR bit is cleared by
 * writing a 1 to it. Writing a 0 to RDCOLERR has no effect.
 *
 * Values:
 * - 0 - No collision error detected
 * - 1 - Collision error detected
 */
/*@{*/
#define BP_FTFE_FSTAT_RDCOLERR (6U)        /*!< Bit position for FTFE_FSTAT_RDCOLERR. */
#define BM_FTFE_FSTAT_RDCOLERR (0x40U)     /*!< Bit mask for FTFE_FSTAT_RDCOLERR. */
#define BS_FTFE_FSTAT_RDCOLERR (1U)        /*!< Bit field size in bits for FTFE_FSTAT_RDCOLERR. */

/*! @brief Read current value of the FTFE_FSTAT_RDCOLERR field. */
#define BR_FTFE_FSTAT_RDCOLERR(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_RDCOLERR)))

/*! @brief Format value for bitfield FTFE_FSTAT_RDCOLERR. */
#define BF_FTFE_FSTAT_RDCOLERR(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FSTAT_RDCOLERR) & BM_FTFE_FSTAT_RDCOLERR)

/*! @brief Set the RDCOLERR field to a new value. */
#define BW_FTFE_FSTAT_RDCOLERR(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_RDCOLERR), v))
/*@}*/

/*!
 * @name Register FTFE_FSTAT, field CCIF[7] (W1C)
 *
 * The CCIF flag indicates that a FTFE command or EEPROM file system operation
 * has completed. The CCIF flag is cleared by writing a 1 to CCIF to launch a
 * command, and CCIF stays low until command completion or command violation. The
 * CCIF flag is also cleared by a successful write to FlexRAM while enabled for EEE,
 * and CCIF stays low until the EEPROM file system has created the associated
 * EEPROM data record. The CCIF bit is reset to 0 but is set to 1 by the memory
 * controller at the end of the reset initialization sequence. Depending on how
 * quickly the read occurs after reset release, the user may or may not see the 0
 * hardware reset value.
 *
 * Values:
 * - 0 - FTFE command or EEPROM file system operation in progress
 * - 1 - FTFE command or EEPROM file system operation has completed
 */
/*@{*/
#define BP_FTFE_FSTAT_CCIF   (7U)          /*!< Bit position for FTFE_FSTAT_CCIF. */
#define BM_FTFE_FSTAT_CCIF   (0x80U)       /*!< Bit mask for FTFE_FSTAT_CCIF. */
#define BS_FTFE_FSTAT_CCIF   (1U)          /*!< Bit field size in bits for FTFE_FSTAT_CCIF. */

/*! @brief Read current value of the FTFE_FSTAT_CCIF field. */
#define BR_FTFE_FSTAT_CCIF(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_CCIF)))

/*! @brief Format value for bitfield FTFE_FSTAT_CCIF. */
#define BF_FTFE_FSTAT_CCIF(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FSTAT_CCIF) & BM_FTFE_FSTAT_CCIF)

/*! @brief Set the CCIF field to a new value. */
#define BW_FTFE_FSTAT_CCIF(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FSTAT_ADDR(x), BP_FTFE_FSTAT_CCIF), v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCNFG - Flash Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCNFG - Flash Configuration Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides information on the current functional state of the
 * FTFE module. The erase control bits (ERSAREQ and ERSSUSP) have write
 * restrictions. SWAP, PFLSH, RAMRDY, and EEERDY are read-only status bits. The unassigned
 * bits read as noted and are not writable. The reset values for the SWAP, PFLSH,
 * RAMRDY, and EEERDY bits are determined during the reset sequence.
 */
typedef union _hw_ftfe_fcnfg
{
    uint8_t U;
    struct _hw_ftfe_fcnfg_bitfields
    {
        uint8_t EEERDY : 1;            /*!< [0]  */
        uint8_t RAMRDY : 1;            /*!< [1] RAM Ready */
        uint8_t PFLSH : 1;             /*!< [2] FTFE configuration */
        uint8_t SWAP : 1;              /*!< [3] Swap */
        uint8_t ERSSUSP : 1;           /*!< [4] Erase Suspend */
        uint8_t ERSAREQ : 1;           /*!< [5] Erase All Request */
        uint8_t RDCOLLIE : 1;          /*!< [6] Read Collision Error Interrupt Enable
                                        * */
        uint8_t CCIE : 1;              /*!< [7] Command Complete Interrupt Enable */
    } B;
} hw_ftfe_fcnfg_t;

/*!
 * @name Constants and macros for entire FTFE_FCNFG register
 */
/*@{*/
#define HW_FTFE_FCNFG_ADDR(x)    ((x) + 0x1U)

#define HW_FTFE_FCNFG(x)         (*(__IO hw_ftfe_fcnfg_t *) HW_FTFE_FCNFG_ADDR(x))
#define HW_FTFE_FCNFG_RD(x)      (ADDRESS_READ(hw_ftfe_fcnfg_t, HW_FTFE_FCNFG_ADDR(x)))
#define HW_FTFE_FCNFG_WR(x, v)   (ADDRESS_WRITE(hw_ftfe_fcnfg_t, HW_FTFE_FCNFG_ADDR(x), v))
#define HW_FTFE_FCNFG_SET(x, v)  (HW_FTFE_FCNFG_WR(x, HW_FTFE_FCNFG_RD(x) |  (v)))
#define HW_FTFE_FCNFG_CLR(x, v)  (HW_FTFE_FCNFG_WR(x, HW_FTFE_FCNFG_RD(x) & ~(v)))
#define HW_FTFE_FCNFG_TOG(x, v)  (HW_FTFE_FCNFG_WR(x, HW_FTFE_FCNFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCNFG bitfields
 */

/*!
 * @name Register FTFE_FCNFG, field EEERDY[0] (RO)
 *
 * For devices with FlexNVM: This flag indicates if the EEPROM backup data has
 * been copied to the FlexRAM and is therefore available for read access. During
 * the reset sequence, the EEERDY flag remains clear while CCIF=0 and only sets if
 * the FlexNVM block is partitioned for EEPROM. For devices without FlexNVM:
 * This bit is reserved.
 *
 * Values:
 * - 0 - For devices with FlexNVM: FlexRAM is not available for EEPROM operation.
 * - 1 - For devices with FlexNVM: FlexRAM is available for EEPROM operations
 *     where: reads from the FlexRAM return data previously written to the FlexRAM
 *     in EEPROM mode and writes launch an EEPROM operation to store the written
 *     data in the FlexRAM and EEPROM backup.
 */
/*@{*/
#define BP_FTFE_FCNFG_EEERDY (0U)          /*!< Bit position for FTFE_FCNFG_EEERDY. */
#define BM_FTFE_FCNFG_EEERDY (0x01U)       /*!< Bit mask for FTFE_FCNFG_EEERDY. */
#define BS_FTFE_FCNFG_EEERDY (1U)          /*!< Bit field size in bits for FTFE_FCNFG_EEERDY. */

/*! @brief Read current value of the FTFE_FCNFG_EEERDY field. */
#define BR_FTFE_FCNFG_EEERDY(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_EEERDY)))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field RAMRDY[1] (RO)
 *
 * This flag indicates the current status of the FlexRAM/ programming
 * acceleration RAM. For devices with FlexNVM: The state of the RAMRDY flag is normally
 * controlled by the Set FlexRAM Function command. During the reset sequence, the
 * RAMRDY flag is cleared if the FlexNVM block is partitioned for EEPROM and will
 * be set if the FlexNVM block is not partitioned for EEPROM . The RAMRDY flag is
 * cleared if the Program Partition command is run to partition the FlexNVM block
 * for EEPROM. The RAMRDY flag sets after completion of the Erase All Blocks
 * command or execution of the erase-all operation triggered external to the FTFE.
 * For devices without FlexNVM: This bit should always be set.
 *
 * Values:
 * - 0 - For devices with FlexNVM: FlexRAM is not available for traditional RAM
 *     access. For devices without FlexNVM: Programming acceleration RAM is not
 *     available.
 * - 1 - For devices with FlexNVM: FlexRAM is available as traditional RAM only;
 *     writes to the FlexRAM do not trigger EEPROM operations. For devices
 *     without FlexNVM: Programming acceleration RAM is available.
 */
/*@{*/
#define BP_FTFE_FCNFG_RAMRDY (1U)          /*!< Bit position for FTFE_FCNFG_RAMRDY. */
#define BM_FTFE_FCNFG_RAMRDY (0x02U)       /*!< Bit mask for FTFE_FCNFG_RAMRDY. */
#define BS_FTFE_FCNFG_RAMRDY (1U)          /*!< Bit field size in bits for FTFE_FCNFG_RAMRDY. */

/*! @brief Read current value of the FTFE_FCNFG_RAMRDY field. */
#define BR_FTFE_FCNFG_RAMRDY(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_RAMRDY)))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field PFLSH[2] (RO)
 *
 * Values:
 * - 0 - For devices with FlexNVM: FTFE configuration supports two program flash
 *     blocks and two FlexNVM blocks For devices with program flash only:
 *     Reserved
 * - 1 - For devices with FlexNVM: Reserved For devices with program flash only:
 *     FTFE configuration supports four program flash blocks
 */
/*@{*/
#define BP_FTFE_FCNFG_PFLSH  (2U)          /*!< Bit position for FTFE_FCNFG_PFLSH. */
#define BM_FTFE_FCNFG_PFLSH  (0x04U)       /*!< Bit mask for FTFE_FCNFG_PFLSH. */
#define BS_FTFE_FCNFG_PFLSH  (1U)          /*!< Bit field size in bits for FTFE_FCNFG_PFLSH. */

/*! @brief Read current value of the FTFE_FCNFG_PFLSH field. */
#define BR_FTFE_FCNFG_PFLSH(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_PFLSH)))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field SWAP[3] (RO)
 *
 * The SWAP flag indicates which half of the program flash space is located at
 * relative address 0x0000. The state of the SWAP flag is set by the FTFE during
 * the reset sequence. See for information on swap management.
 *
 * Values:
 * - 0 - For devices with FlexNVM: Program flash 0 block is located at relative
 *     address 0x0000 For devices with program flash only: Program flash 0 block
 *     is located at relative address 0x0000
 * - 1 - For devices with FlexNVM: Reserved For devices with program flash only:
 *     Program flash 1 block is located at relative address 0x0000
 */
/*@{*/
#define BP_FTFE_FCNFG_SWAP   (3U)          /*!< Bit position for FTFE_FCNFG_SWAP. */
#define BM_FTFE_FCNFG_SWAP   (0x08U)       /*!< Bit mask for FTFE_FCNFG_SWAP. */
#define BS_FTFE_FCNFG_SWAP   (1U)          /*!< Bit field size in bits for FTFE_FCNFG_SWAP. */

/*! @brief Read current value of the FTFE_FCNFG_SWAP field. */
#define BR_FTFE_FCNFG_SWAP(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_SWAP)))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field ERSSUSP[4] (RW)
 *
 * The ERSSUSP bit allows the user to suspend (interrupt) the Erase Flash Sector
 * command while it is executing.
 *
 * Values:
 * - 0 - No suspend requested
 * - 1 - Suspend the current Erase Flash Sector command execution.
 */
/*@{*/
#define BP_FTFE_FCNFG_ERSSUSP (4U)         /*!< Bit position for FTFE_FCNFG_ERSSUSP. */
#define BM_FTFE_FCNFG_ERSSUSP (0x10U)      /*!< Bit mask for FTFE_FCNFG_ERSSUSP. */
#define BS_FTFE_FCNFG_ERSSUSP (1U)         /*!< Bit field size in bits for FTFE_FCNFG_ERSSUSP. */

/*! @brief Read current value of the FTFE_FCNFG_ERSSUSP field. */
#define BR_FTFE_FCNFG_ERSSUSP(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_ERSSUSP)))

/*! @brief Format value for bitfield FTFE_FCNFG_ERSSUSP. */
#define BF_FTFE_FCNFG_ERSSUSP(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCNFG_ERSSUSP) & BM_FTFE_FCNFG_ERSSUSP)

/*! @brief Set the ERSSUSP field to a new value. */
#define BW_FTFE_FCNFG_ERSSUSP(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_ERSSUSP), v))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field ERSAREQ[5] (RO)
 *
 * This bit issues a request to the memory controller to execute the Erase All
 * Blocks command and release security. ERSAREQ is not directly writable but is
 * under indirect user control. Refer to the device's Chip Configuration details on
 * how to request this command. The ERSAREQ bit sets when an erase all request
 * is triggered external to the FTFE and CCIF is set (no command is currently
 * being executed). ERSAREQ is cleared by the FTFE when the operation completes.
 *
 * Values:
 * - 0 - No request or request complete
 * - 1 - Request to: run the Erase All Blocks command, verify the erased state,
 *     program the security byte in the Flash Configuration Field to the unsecure
 *     state, and release MCU security by setting the FSEC[SEC] field to the
 *     unsecure state.
 */
/*@{*/
#define BP_FTFE_FCNFG_ERSAREQ (5U)         /*!< Bit position for FTFE_FCNFG_ERSAREQ. */
#define BM_FTFE_FCNFG_ERSAREQ (0x20U)      /*!< Bit mask for FTFE_FCNFG_ERSAREQ. */
#define BS_FTFE_FCNFG_ERSAREQ (1U)         /*!< Bit field size in bits for FTFE_FCNFG_ERSAREQ. */

/*! @brief Read current value of the FTFE_FCNFG_ERSAREQ field. */
#define BR_FTFE_FCNFG_ERSAREQ(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_ERSAREQ)))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field RDCOLLIE[6] (RW)
 *
 * The RDCOLLIE bit controls interrupt generation when an FTFE read collision
 * error occurs.
 *
 * Values:
 * - 0 - Read collision error interrupt disabled
 * - 1 - Read collision error interrupt enabled. An interrupt request is
 *     generated whenever an FTFE read collision error is detected (see the description
 *     of FSTAT[RDCOLERR]).
 */
/*@{*/
#define BP_FTFE_FCNFG_RDCOLLIE (6U)        /*!< Bit position for FTFE_FCNFG_RDCOLLIE. */
#define BM_FTFE_FCNFG_RDCOLLIE (0x40U)     /*!< Bit mask for FTFE_FCNFG_RDCOLLIE. */
#define BS_FTFE_FCNFG_RDCOLLIE (1U)        /*!< Bit field size in bits for FTFE_FCNFG_RDCOLLIE. */

/*! @brief Read current value of the FTFE_FCNFG_RDCOLLIE field. */
#define BR_FTFE_FCNFG_RDCOLLIE(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_RDCOLLIE)))

/*! @brief Format value for bitfield FTFE_FCNFG_RDCOLLIE. */
#define BF_FTFE_FCNFG_RDCOLLIE(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCNFG_RDCOLLIE) & BM_FTFE_FCNFG_RDCOLLIE)

/*! @brief Set the RDCOLLIE field to a new value. */
#define BW_FTFE_FCNFG_RDCOLLIE(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_RDCOLLIE), v))
/*@}*/

/*!
 * @name Register FTFE_FCNFG, field CCIE[7] (RW)
 *
 * The CCIE bit controls interrupt generation when an FTFE command completes.
 *
 * Values:
 * - 0 - Command complete interrupt disabled
 * - 1 - Command complete interrupt enabled. An interrupt request is generated
 *     whenever the FSTAT[CCIF] flag is set.
 */
/*@{*/
#define BP_FTFE_FCNFG_CCIE   (7U)          /*!< Bit position for FTFE_FCNFG_CCIE. */
#define BM_FTFE_FCNFG_CCIE   (0x80U)       /*!< Bit mask for FTFE_FCNFG_CCIE. */
#define BS_FTFE_FCNFG_CCIE   (1U)          /*!< Bit field size in bits for FTFE_FCNFG_CCIE. */

/*! @brief Read current value of the FTFE_FCNFG_CCIE field. */
#define BR_FTFE_FCNFG_CCIE(x) (ADDRESS_READ(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_CCIE)))

/*! @brief Format value for bitfield FTFE_FCNFG_CCIE. */
#define BF_FTFE_FCNFG_CCIE(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCNFG_CCIE) & BM_FTFE_FCNFG_CCIE)

/*! @brief Set the CCIE field to a new value. */
#define BW_FTFE_FCNFG_CCIE(x, v) (ADDRESS_WRITE(uint8_t, BITBAND_ADDRESS8(HW_FTFE_FCNFG_ADDR(x), BP_FTFE_FCNFG_CCIE), v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FSEC - Flash Security Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FSEC - Flash Security Register (RO)
 *
 * Reset value: 0x00U
 *
 * This read-only register holds all bits associated with the security of the
 * MCU and FTFE module. During the reset sequence, the register is loaded with the
 * contents of the flash security byte in the Flash Configuration Field located
 * in program flash memory. The Flash basis for the values is signified by X in
 * the reset value.
 */
typedef union _hw_ftfe_fsec
{
    uint8_t U;
    struct _hw_ftfe_fsec_bitfields
    {
        uint8_t SEC : 2;               /*!< [1:0] Flash Security */
        uint8_t FSLACC : 2;            /*!< [3:2] Freescale Failure Analysis Access Code
                                        * */
        uint8_t MEEN : 2;              /*!< [5:4] Mass Erase Enable Bits */
        uint8_t KEYEN : 2;             /*!< [7:6] Backdoor Key Security Enable */
    } B;
} hw_ftfe_fsec_t;

/*!
 * @name Constants and macros for entire FTFE_FSEC register
 */
/*@{*/
#define HW_FTFE_FSEC_ADDR(x)     ((x) + 0x2U)

#define HW_FTFE_FSEC(x)          (*(__I hw_ftfe_fsec_t *) HW_FTFE_FSEC_ADDR(x))
#define HW_FTFE_FSEC_RD(x)       (ADDRESS_READ(hw_ftfe_fsec_t, HW_FTFE_FSEC_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FSEC bitfields
 */

/*!
 * @name Register FTFE_FSEC, field SEC[1:0] (RO)
 *
 * These bits define the security state of the MCU. In the secure state, the MCU
 * limits access to FTFE module resources. The limitations are defined per
 * device and are detailed in the Chip Configuration details. If the FTFE module is
 * unsecured using backdoor key access, the SEC bits are forced to 10b.
 *
 * Values:
 * - 00 - MCU security status is secure
 * - 01 - MCU security status is secure
 * - 10 - MCU security status is unsecure (The standard shipping condition of
 *     the FTFE is unsecure.)
 * - 11 - MCU security status is secure
 */
/*@{*/
#define BP_FTFE_FSEC_SEC     (0U)          /*!< Bit position for FTFE_FSEC_SEC. */
#define BM_FTFE_FSEC_SEC     (0x03U)       /*!< Bit mask for FTFE_FSEC_SEC. */
#define BS_FTFE_FSEC_SEC     (2U)          /*!< Bit field size in bits for FTFE_FSEC_SEC. */

/*! @brief Read current value of the FTFE_FSEC_SEC field. */
#define BR_FTFE_FSEC_SEC(x)  (UNION_READ(hw_ftfe_fsec_t, HW_FTFE_FSEC_ADDR(x), U, B.SEC))
/*@}*/

/*!
 * @name Register FTFE_FSEC, field FSLACC[3:2] (RO)
 *
 * These bits enable or disable access to the flash memory contents during
 * returned part failure analysis at Freescale. When SEC is secure and FSLACC is
 * denied, access to the program flash contents is denied and any failure analysis
 * performed by Freescale factory test must begin with a full erase to unsecure the
 * part. When access is granted (SEC is unsecure, or SEC is secure and FSLACC is
 * granted), Freescale factory testing has visibility of the current flash
 * contents. The state of the FSLACC bits is only relevant when the SEC bits are set to
 * secure. When the SEC field is set to unsecure, the FSLACC setting does not
 * matter.
 *
 * Values:
 * - 00 - Freescale factory access granted
 * - 01 - Freescale factory access denied
 * - 10 - Freescale factory access denied
 * - 11 - Freescale factory access granted
 */
/*@{*/
#define BP_FTFE_FSEC_FSLACC  (2U)          /*!< Bit position for FTFE_FSEC_FSLACC. */
#define BM_FTFE_FSEC_FSLACC  (0x0CU)       /*!< Bit mask for FTFE_FSEC_FSLACC. */
#define BS_FTFE_FSEC_FSLACC  (2U)          /*!< Bit field size in bits for FTFE_FSEC_FSLACC. */

/*! @brief Read current value of the FTFE_FSEC_FSLACC field. */
#define BR_FTFE_FSEC_FSLACC(x) (UNION_READ(hw_ftfe_fsec_t, HW_FTFE_FSEC_ADDR(x), U, B.FSLACC))
/*@}*/

/*!
 * @name Register FTFE_FSEC, field MEEN[5:4] (RO)
 *
 * Enables and disables mass erase capability of the FTFE module. The state of
 * the MEEN bits is only relevant when the SEC bits are set to secure outside of
 * NVM Normal Mode. When the SEC field is set to unsecure, the MEEN setting does
 * not matter.
 *
 * Values:
 * - 00 - Mass erase is enabled
 * - 01 - Mass erase is enabled
 * - 10 - Mass erase is disabled
 * - 11 - Mass erase is enabled
 */
/*@{*/
#define BP_FTFE_FSEC_MEEN    (4U)          /*!< Bit position for FTFE_FSEC_MEEN. */
#define BM_FTFE_FSEC_MEEN    (0x30U)       /*!< Bit mask for FTFE_FSEC_MEEN. */
#define BS_FTFE_FSEC_MEEN    (2U)          /*!< Bit field size in bits for FTFE_FSEC_MEEN. */

/*! @brief Read current value of the FTFE_FSEC_MEEN field. */
#define BR_FTFE_FSEC_MEEN(x) (UNION_READ(hw_ftfe_fsec_t, HW_FTFE_FSEC_ADDR(x), U, B.MEEN))
/*@}*/

/*!
 * @name Register FTFE_FSEC, field KEYEN[7:6] (RO)
 *
 * These bits enable and disable backdoor key access to the FTFE module.
 *
 * Values:
 * - 00 - Backdoor key access disabled
 * - 01 - Backdoor key access disabled (preferred KEYEN state to disable
 *     backdoor key access)
 * - 10 - Backdoor key access enabled
 * - 11 - Backdoor key access disabled
 */
/*@{*/
#define BP_FTFE_FSEC_KEYEN   (6U)          /*!< Bit position for FTFE_FSEC_KEYEN. */
#define BM_FTFE_FSEC_KEYEN   (0xC0U)       /*!< Bit mask for FTFE_FSEC_KEYEN. */
#define BS_FTFE_FSEC_KEYEN   (2U)          /*!< Bit field size in bits for FTFE_FSEC_KEYEN. */

/*! @brief Read current value of the FTFE_FSEC_KEYEN field. */
#define BR_FTFE_FSEC_KEYEN(x) (UNION_READ(hw_ftfe_fsec_t, HW_FTFE_FSEC_ADDR(x), U, B.KEYEN))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FOPT - Flash Option Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FOPT - Flash Option Register (RO)
 *
 * Reset value: 0x00U
 *
 * The flash option register allows the MCU to customize its operations by
 * examining the state of these read-only bits, which are loaded from NVM at reset.
 * The function of the bits is defined in the device's Chip Configuration details.
 * All bits in the register are read-only. During the reset sequence, the
 * register is loaded from the flash nonvolatile option byte in the Flash Configuration
 * Field located in program flash memory. The flash basis for the values is
 * signified by X in the reset value.
 */
typedef union _hw_ftfe_fopt
{
    uint8_t U;
    struct _hw_ftfe_fopt_bitfields
    {
        uint8_t OPT : 8;               /*!< [7:0] Nonvolatile Option */
    } B;
} hw_ftfe_fopt_t;

/*!
 * @name Constants and macros for entire FTFE_FOPT register
 */
/*@{*/
#define HW_FTFE_FOPT_ADDR(x)     ((x) + 0x3U)

#define HW_FTFE_FOPT(x)          (*(__I hw_ftfe_fopt_t *) HW_FTFE_FOPT_ADDR(x))
#define HW_FTFE_FOPT_RD(x)       (ADDRESS_READ(hw_ftfe_fopt_t, HW_FTFE_FOPT_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FOPT bitfields
 */

/*!
 * @name Register FTFE_FOPT, field OPT[7:0] (RO)
 *
 * These bits are loaded from flash to this register at reset. Refer to the
 * device's Chip Configuration details for the definition and use of these bits.
 */
/*@{*/
#define BP_FTFE_FOPT_OPT     (0U)          /*!< Bit position for FTFE_FOPT_OPT. */
#define BM_FTFE_FOPT_OPT     (0xFFU)       /*!< Bit mask for FTFE_FOPT_OPT. */
#define BS_FTFE_FOPT_OPT     (8U)          /*!< Bit field size in bits for FTFE_FOPT_OPT. */

/*! @brief Read current value of the FTFE_FOPT_OPT field. */
#define BR_FTFE_FOPT_OPT(x)  (HW_FTFE_FOPT(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB3 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB3 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob3
{
    uint8_t U;
    struct _hw_ftfe_fccob3_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob3_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB3 register
 */
/*@{*/
#define HW_FTFE_FCCOB3_ADDR(x)   ((x) + 0x4U)

#define HW_FTFE_FCCOB3(x)        (*(__IO hw_ftfe_fccob3_t *) HW_FTFE_FCCOB3_ADDR(x))
#define HW_FTFE_FCCOB3_RD(x)     (ADDRESS_READ(hw_ftfe_fccob3_t, HW_FTFE_FCCOB3_ADDR(x)))
#define HW_FTFE_FCCOB3_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob3_t, HW_FTFE_FCCOB3_ADDR(x), v))
#define HW_FTFE_FCCOB3_SET(x, v) (HW_FTFE_FCCOB3_WR(x, HW_FTFE_FCCOB3_RD(x) |  (v)))
#define HW_FTFE_FCCOB3_CLR(x, v) (HW_FTFE_FCCOB3_WR(x, HW_FTFE_FCCOB3_RD(x) & ~(v)))
#define HW_FTFE_FCCOB3_TOG(x, v) (HW_FTFE_FCCOB3_WR(x, HW_FTFE_FCCOB3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB3 bitfields
 */

/*!
 * @name Register FTFE_FCCOB3, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB3_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB3_CCOBn. */
#define BM_FTFE_FCCOB3_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB3_CCOBn. */
#define BS_FTFE_FCCOB3_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB3_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB3_CCOBn field. */
#define BR_FTFE_FCCOB3_CCOBn(x) (HW_FTFE_FCCOB3(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB3_CCOBn. */
#define BF_FTFE_FCCOB3_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB3_CCOBn) & BM_FTFE_FCCOB3_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB3_CCOBn(x, v) (HW_FTFE_FCCOB3_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB2 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB2 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob2
{
    uint8_t U;
    struct _hw_ftfe_fccob2_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob2_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB2 register
 */
/*@{*/
#define HW_FTFE_FCCOB2_ADDR(x)   ((x) + 0x5U)

#define HW_FTFE_FCCOB2(x)        (*(__IO hw_ftfe_fccob2_t *) HW_FTFE_FCCOB2_ADDR(x))
#define HW_FTFE_FCCOB2_RD(x)     (ADDRESS_READ(hw_ftfe_fccob2_t, HW_FTFE_FCCOB2_ADDR(x)))
#define HW_FTFE_FCCOB2_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob2_t, HW_FTFE_FCCOB2_ADDR(x), v))
#define HW_FTFE_FCCOB2_SET(x, v) (HW_FTFE_FCCOB2_WR(x, HW_FTFE_FCCOB2_RD(x) |  (v)))
#define HW_FTFE_FCCOB2_CLR(x, v) (HW_FTFE_FCCOB2_WR(x, HW_FTFE_FCCOB2_RD(x) & ~(v)))
#define HW_FTFE_FCCOB2_TOG(x, v) (HW_FTFE_FCCOB2_WR(x, HW_FTFE_FCCOB2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB2 bitfields
 */

/*!
 * @name Register FTFE_FCCOB2, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB2_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB2_CCOBn. */
#define BM_FTFE_FCCOB2_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB2_CCOBn. */
#define BS_FTFE_FCCOB2_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB2_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB2_CCOBn field. */
#define BR_FTFE_FCCOB2_CCOBn(x) (HW_FTFE_FCCOB2(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB2_CCOBn. */
#define BF_FTFE_FCCOB2_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB2_CCOBn) & BM_FTFE_FCCOB2_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB2_CCOBn(x, v) (HW_FTFE_FCCOB2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB1 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB1 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob1
{
    uint8_t U;
    struct _hw_ftfe_fccob1_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob1_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB1 register
 */
/*@{*/
#define HW_FTFE_FCCOB1_ADDR(x)   ((x) + 0x6U)

#define HW_FTFE_FCCOB1(x)        (*(__IO hw_ftfe_fccob1_t *) HW_FTFE_FCCOB1_ADDR(x))
#define HW_FTFE_FCCOB1_RD(x)     (ADDRESS_READ(hw_ftfe_fccob1_t, HW_FTFE_FCCOB1_ADDR(x)))
#define HW_FTFE_FCCOB1_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob1_t, HW_FTFE_FCCOB1_ADDR(x), v))
#define HW_FTFE_FCCOB1_SET(x, v) (HW_FTFE_FCCOB1_WR(x, HW_FTFE_FCCOB1_RD(x) |  (v)))
#define HW_FTFE_FCCOB1_CLR(x, v) (HW_FTFE_FCCOB1_WR(x, HW_FTFE_FCCOB1_RD(x) & ~(v)))
#define HW_FTFE_FCCOB1_TOG(x, v) (HW_FTFE_FCCOB1_WR(x, HW_FTFE_FCCOB1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB1 bitfields
 */

/*!
 * @name Register FTFE_FCCOB1, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB1_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB1_CCOBn. */
#define BM_FTFE_FCCOB1_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB1_CCOBn. */
#define BS_FTFE_FCCOB1_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB1_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB1_CCOBn field. */
#define BR_FTFE_FCCOB1_CCOBn(x) (HW_FTFE_FCCOB1(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB1_CCOBn. */
#define BF_FTFE_FCCOB1_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB1_CCOBn) & BM_FTFE_FCCOB1_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB1_CCOBn(x, v) (HW_FTFE_FCCOB1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB0 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB0 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob0
{
    uint8_t U;
    struct _hw_ftfe_fccob0_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob0_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB0 register
 */
/*@{*/
#define HW_FTFE_FCCOB0_ADDR(x)   ((x) + 0x7U)

#define HW_FTFE_FCCOB0(x)        (*(__IO hw_ftfe_fccob0_t *) HW_FTFE_FCCOB0_ADDR(x))
#define HW_FTFE_FCCOB0_RD(x)     (ADDRESS_READ(hw_ftfe_fccob0_t, HW_FTFE_FCCOB0_ADDR(x)))
#define HW_FTFE_FCCOB0_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob0_t, HW_FTFE_FCCOB0_ADDR(x), v))
#define HW_FTFE_FCCOB0_SET(x, v) (HW_FTFE_FCCOB0_WR(x, HW_FTFE_FCCOB0_RD(x) |  (v)))
#define HW_FTFE_FCCOB0_CLR(x, v) (HW_FTFE_FCCOB0_WR(x, HW_FTFE_FCCOB0_RD(x) & ~(v)))
#define HW_FTFE_FCCOB0_TOG(x, v) (HW_FTFE_FCCOB0_WR(x, HW_FTFE_FCCOB0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB0 bitfields
 */

/*!
 * @name Register FTFE_FCCOB0, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB0_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB0_CCOBn. */
#define BM_FTFE_FCCOB0_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB0_CCOBn. */
#define BS_FTFE_FCCOB0_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB0_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB0_CCOBn field. */
#define BR_FTFE_FCCOB0_CCOBn(x) (HW_FTFE_FCCOB0(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB0_CCOBn. */
#define BF_FTFE_FCCOB0_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB0_CCOBn) & BM_FTFE_FCCOB0_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB0_CCOBn(x, v) (HW_FTFE_FCCOB0_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB7 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB7 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob7
{
    uint8_t U;
    struct _hw_ftfe_fccob7_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob7_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB7 register
 */
/*@{*/
#define HW_FTFE_FCCOB7_ADDR(x)   ((x) + 0x8U)

#define HW_FTFE_FCCOB7(x)        (*(__IO hw_ftfe_fccob7_t *) HW_FTFE_FCCOB7_ADDR(x))
#define HW_FTFE_FCCOB7_RD(x)     (ADDRESS_READ(hw_ftfe_fccob7_t, HW_FTFE_FCCOB7_ADDR(x)))
#define HW_FTFE_FCCOB7_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob7_t, HW_FTFE_FCCOB7_ADDR(x), v))
#define HW_FTFE_FCCOB7_SET(x, v) (HW_FTFE_FCCOB7_WR(x, HW_FTFE_FCCOB7_RD(x) |  (v)))
#define HW_FTFE_FCCOB7_CLR(x, v) (HW_FTFE_FCCOB7_WR(x, HW_FTFE_FCCOB7_RD(x) & ~(v)))
#define HW_FTFE_FCCOB7_TOG(x, v) (HW_FTFE_FCCOB7_WR(x, HW_FTFE_FCCOB7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB7 bitfields
 */

/*!
 * @name Register FTFE_FCCOB7, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB7_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB7_CCOBn. */
#define BM_FTFE_FCCOB7_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB7_CCOBn. */
#define BS_FTFE_FCCOB7_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB7_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB7_CCOBn field. */
#define BR_FTFE_FCCOB7_CCOBn(x) (HW_FTFE_FCCOB7(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB7_CCOBn. */
#define BF_FTFE_FCCOB7_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB7_CCOBn) & BM_FTFE_FCCOB7_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB7_CCOBn(x, v) (HW_FTFE_FCCOB7_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB6 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB6 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob6
{
    uint8_t U;
    struct _hw_ftfe_fccob6_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob6_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB6 register
 */
/*@{*/
#define HW_FTFE_FCCOB6_ADDR(x)   ((x) + 0x9U)

#define HW_FTFE_FCCOB6(x)        (*(__IO hw_ftfe_fccob6_t *) HW_FTFE_FCCOB6_ADDR(x))
#define HW_FTFE_FCCOB6_RD(x)     (ADDRESS_READ(hw_ftfe_fccob6_t, HW_FTFE_FCCOB6_ADDR(x)))
#define HW_FTFE_FCCOB6_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob6_t, HW_FTFE_FCCOB6_ADDR(x), v))
#define HW_FTFE_FCCOB6_SET(x, v) (HW_FTFE_FCCOB6_WR(x, HW_FTFE_FCCOB6_RD(x) |  (v)))
#define HW_FTFE_FCCOB6_CLR(x, v) (HW_FTFE_FCCOB6_WR(x, HW_FTFE_FCCOB6_RD(x) & ~(v)))
#define HW_FTFE_FCCOB6_TOG(x, v) (HW_FTFE_FCCOB6_WR(x, HW_FTFE_FCCOB6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB6 bitfields
 */

/*!
 * @name Register FTFE_FCCOB6, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB6_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB6_CCOBn. */
#define BM_FTFE_FCCOB6_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB6_CCOBn. */
#define BS_FTFE_FCCOB6_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB6_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB6_CCOBn field. */
#define BR_FTFE_FCCOB6_CCOBn(x) (HW_FTFE_FCCOB6(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB6_CCOBn. */
#define BF_FTFE_FCCOB6_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB6_CCOBn) & BM_FTFE_FCCOB6_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB6_CCOBn(x, v) (HW_FTFE_FCCOB6_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB5 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB5 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob5
{
    uint8_t U;
    struct _hw_ftfe_fccob5_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob5_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB5 register
 */
/*@{*/
#define HW_FTFE_FCCOB5_ADDR(x)   ((x) + 0xAU)

#define HW_FTFE_FCCOB5(x)        (*(__IO hw_ftfe_fccob5_t *) HW_FTFE_FCCOB5_ADDR(x))
#define HW_FTFE_FCCOB5_RD(x)     (ADDRESS_READ(hw_ftfe_fccob5_t, HW_FTFE_FCCOB5_ADDR(x)))
#define HW_FTFE_FCCOB5_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob5_t, HW_FTFE_FCCOB5_ADDR(x), v))
#define HW_FTFE_FCCOB5_SET(x, v) (HW_FTFE_FCCOB5_WR(x, HW_FTFE_FCCOB5_RD(x) |  (v)))
#define HW_FTFE_FCCOB5_CLR(x, v) (HW_FTFE_FCCOB5_WR(x, HW_FTFE_FCCOB5_RD(x) & ~(v)))
#define HW_FTFE_FCCOB5_TOG(x, v) (HW_FTFE_FCCOB5_WR(x, HW_FTFE_FCCOB5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB5 bitfields
 */

/*!
 * @name Register FTFE_FCCOB5, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB5_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB5_CCOBn. */
#define BM_FTFE_FCCOB5_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB5_CCOBn. */
#define BS_FTFE_FCCOB5_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB5_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB5_CCOBn field. */
#define BR_FTFE_FCCOB5_CCOBn(x) (HW_FTFE_FCCOB5(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB5_CCOBn. */
#define BF_FTFE_FCCOB5_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB5_CCOBn) & BM_FTFE_FCCOB5_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB5_CCOBn(x, v) (HW_FTFE_FCCOB5_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB4 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB4 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob4
{
    uint8_t U;
    struct _hw_ftfe_fccob4_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob4_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB4 register
 */
/*@{*/
#define HW_FTFE_FCCOB4_ADDR(x)   ((x) + 0xBU)

#define HW_FTFE_FCCOB4(x)        (*(__IO hw_ftfe_fccob4_t *) HW_FTFE_FCCOB4_ADDR(x))
#define HW_FTFE_FCCOB4_RD(x)     (ADDRESS_READ(hw_ftfe_fccob4_t, HW_FTFE_FCCOB4_ADDR(x)))
#define HW_FTFE_FCCOB4_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob4_t, HW_FTFE_FCCOB4_ADDR(x), v))
#define HW_FTFE_FCCOB4_SET(x, v) (HW_FTFE_FCCOB4_WR(x, HW_FTFE_FCCOB4_RD(x) |  (v)))
#define HW_FTFE_FCCOB4_CLR(x, v) (HW_FTFE_FCCOB4_WR(x, HW_FTFE_FCCOB4_RD(x) & ~(v)))
#define HW_FTFE_FCCOB4_TOG(x, v) (HW_FTFE_FCCOB4_WR(x, HW_FTFE_FCCOB4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB4 bitfields
 */

/*!
 * @name Register FTFE_FCCOB4, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB4_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB4_CCOBn. */
#define BM_FTFE_FCCOB4_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB4_CCOBn. */
#define BS_FTFE_FCCOB4_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB4_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB4_CCOBn field. */
#define BR_FTFE_FCCOB4_CCOBn(x) (HW_FTFE_FCCOB4(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB4_CCOBn. */
#define BF_FTFE_FCCOB4_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB4_CCOBn) & BM_FTFE_FCCOB4_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB4_CCOBn(x, v) (HW_FTFE_FCCOB4_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOBB - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOBB - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccobb
{
    uint8_t U;
    struct _hw_ftfe_fccobb_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccobb_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOBB register
 */
/*@{*/
#define HW_FTFE_FCCOBB_ADDR(x)   ((x) + 0xCU)

#define HW_FTFE_FCCOBB(x)        (*(__IO hw_ftfe_fccobb_t *) HW_FTFE_FCCOBB_ADDR(x))
#define HW_FTFE_FCCOBB_RD(x)     (ADDRESS_READ(hw_ftfe_fccobb_t, HW_FTFE_FCCOBB_ADDR(x)))
#define HW_FTFE_FCCOBB_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccobb_t, HW_FTFE_FCCOBB_ADDR(x), v))
#define HW_FTFE_FCCOBB_SET(x, v) (HW_FTFE_FCCOBB_WR(x, HW_FTFE_FCCOBB_RD(x) |  (v)))
#define HW_FTFE_FCCOBB_CLR(x, v) (HW_FTFE_FCCOBB_WR(x, HW_FTFE_FCCOBB_RD(x) & ~(v)))
#define HW_FTFE_FCCOBB_TOG(x, v) (HW_FTFE_FCCOBB_WR(x, HW_FTFE_FCCOBB_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOBB bitfields
 */

/*!
 * @name Register FTFE_FCCOBB, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOBB_CCOBn (0U)          /*!< Bit position for FTFE_FCCOBB_CCOBn. */
#define BM_FTFE_FCCOBB_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOBB_CCOBn. */
#define BS_FTFE_FCCOBB_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOBB_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOBB_CCOBn field. */
#define BR_FTFE_FCCOBB_CCOBn(x) (HW_FTFE_FCCOBB(x).U)

/*! @brief Format value for bitfield FTFE_FCCOBB_CCOBn. */
#define BF_FTFE_FCCOBB_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOBB_CCOBn) & BM_FTFE_FCCOBB_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOBB_CCOBn(x, v) (HW_FTFE_FCCOBB_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOBA - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOBA - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccoba
{
    uint8_t U;
    struct _hw_ftfe_fccoba_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccoba_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOBA register
 */
/*@{*/
#define HW_FTFE_FCCOBA_ADDR(x)   ((x) + 0xDU)

#define HW_FTFE_FCCOBA(x)        (*(__IO hw_ftfe_fccoba_t *) HW_FTFE_FCCOBA_ADDR(x))
#define HW_FTFE_FCCOBA_RD(x)     (ADDRESS_READ(hw_ftfe_fccoba_t, HW_FTFE_FCCOBA_ADDR(x)))
#define HW_FTFE_FCCOBA_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccoba_t, HW_FTFE_FCCOBA_ADDR(x), v))
#define HW_FTFE_FCCOBA_SET(x, v) (HW_FTFE_FCCOBA_WR(x, HW_FTFE_FCCOBA_RD(x) |  (v)))
#define HW_FTFE_FCCOBA_CLR(x, v) (HW_FTFE_FCCOBA_WR(x, HW_FTFE_FCCOBA_RD(x) & ~(v)))
#define HW_FTFE_FCCOBA_TOG(x, v) (HW_FTFE_FCCOBA_WR(x, HW_FTFE_FCCOBA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOBA bitfields
 */

/*!
 * @name Register FTFE_FCCOBA, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOBA_CCOBn (0U)          /*!< Bit position for FTFE_FCCOBA_CCOBn. */
#define BM_FTFE_FCCOBA_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOBA_CCOBn. */
#define BS_FTFE_FCCOBA_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOBA_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOBA_CCOBn field. */
#define BR_FTFE_FCCOBA_CCOBn(x) (HW_FTFE_FCCOBA(x).U)

/*! @brief Format value for bitfield FTFE_FCCOBA_CCOBn. */
#define BF_FTFE_FCCOBA_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOBA_CCOBn) & BM_FTFE_FCCOBA_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOBA_CCOBn(x, v) (HW_FTFE_FCCOBA_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB9 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB9 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob9
{
    uint8_t U;
    struct _hw_ftfe_fccob9_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob9_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB9 register
 */
/*@{*/
#define HW_FTFE_FCCOB9_ADDR(x)   ((x) + 0xEU)

#define HW_FTFE_FCCOB9(x)        (*(__IO hw_ftfe_fccob9_t *) HW_FTFE_FCCOB9_ADDR(x))
#define HW_FTFE_FCCOB9_RD(x)     (ADDRESS_READ(hw_ftfe_fccob9_t, HW_FTFE_FCCOB9_ADDR(x)))
#define HW_FTFE_FCCOB9_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob9_t, HW_FTFE_FCCOB9_ADDR(x), v))
#define HW_FTFE_FCCOB9_SET(x, v) (HW_FTFE_FCCOB9_WR(x, HW_FTFE_FCCOB9_RD(x) |  (v)))
#define HW_FTFE_FCCOB9_CLR(x, v) (HW_FTFE_FCCOB9_WR(x, HW_FTFE_FCCOB9_RD(x) & ~(v)))
#define HW_FTFE_FCCOB9_TOG(x, v) (HW_FTFE_FCCOB9_WR(x, HW_FTFE_FCCOB9_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB9 bitfields
 */

/*!
 * @name Register FTFE_FCCOB9, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB9_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB9_CCOBn. */
#define BM_FTFE_FCCOB9_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB9_CCOBn. */
#define BS_FTFE_FCCOB9_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB9_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB9_CCOBn field. */
#define BR_FTFE_FCCOB9_CCOBn(x) (HW_FTFE_FCCOB9(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB9_CCOBn. */
#define BF_FTFE_FCCOB9_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB9_CCOBn) & BM_FTFE_FCCOB9_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB9_CCOBn(x, v) (HW_FTFE_FCCOB9_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FCCOB8 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FCCOB8 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfe_fccob8
{
    uint8_t U;
    struct _hw_ftfe_fccob8_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfe_fccob8_t;

/*!
 * @name Constants and macros for entire FTFE_FCCOB8 register
 */
/*@{*/
#define HW_FTFE_FCCOB8_ADDR(x)   ((x) + 0xFU)

#define HW_FTFE_FCCOB8(x)        (*(__IO hw_ftfe_fccob8_t *) HW_FTFE_FCCOB8_ADDR(x))
#define HW_FTFE_FCCOB8_RD(x)     (ADDRESS_READ(hw_ftfe_fccob8_t, HW_FTFE_FCCOB8_ADDR(x)))
#define HW_FTFE_FCCOB8_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fccob8_t, HW_FTFE_FCCOB8_ADDR(x), v))
#define HW_FTFE_FCCOB8_SET(x, v) (HW_FTFE_FCCOB8_WR(x, HW_FTFE_FCCOB8_RD(x) |  (v)))
#define HW_FTFE_FCCOB8_CLR(x, v) (HW_FTFE_FCCOB8_WR(x, HW_FTFE_FCCOB8_RD(x) & ~(v)))
#define HW_FTFE_FCCOB8_TOG(x, v) (HW_FTFE_FCCOB8_WR(x, HW_FTFE_FCCOB8_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FCCOB8 bitfields
 */

/*!
 * @name Register FTFE_FCCOB8, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic FTFE command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific FTFE command,
 * typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register address.
 * FCCOB NumberRefers to FCCOB register name, not register address Typical
 * Command Parameter Contents [7:0] 0 FCMD (a code that defines the FTFE command) 1
 * Flash address [23:16] 2 Flash address [15:8] 3 Flash address [7:0] 4 Data Byte 0
 * 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8 Data Byte 4 9 Data Byte 5 A Data
 * Byte 6 B Data Byte 7 FCCOB Endianness and Multi-Byte Access: The FCCOB
 * register group uses a big endian addressing convention. For all command parameter
 * fields larger than 1 byte, the most significant data resides in the lowest FCCOB
 * register number. The FCCOB register group may be read and written as
 * individual bytes, aligned words (2 bytes) or aligned longwords (4 bytes).
 */
/*@{*/
#define BP_FTFE_FCCOB8_CCOBn (0U)          /*!< Bit position for FTFE_FCCOB8_CCOBn. */
#define BM_FTFE_FCCOB8_CCOBn (0xFFU)       /*!< Bit mask for FTFE_FCCOB8_CCOBn. */
#define BS_FTFE_FCCOB8_CCOBn (8U)          /*!< Bit field size in bits for FTFE_FCCOB8_CCOBn. */

/*! @brief Read current value of the FTFE_FCCOB8_CCOBn field. */
#define BR_FTFE_FCCOB8_CCOBn(x) (HW_FTFE_FCCOB8(x).U)

/*! @brief Format value for bitfield FTFE_FCCOB8_CCOBn. */
#define BF_FTFE_FCCOB8_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FCCOB8_CCOBn) & BM_FTFE_FCCOB8_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFE_FCCOB8_CCOBn(x, v) (HW_FTFE_FCCOB8_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FPROT3 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FPROT3 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any FTFE command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions of equal
 * memory size. Program flash protection register Program flash protection bits
 * FPROT0 PROT[31:24] FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During
 * the reset sequence, the FPROT registers are loaded with the contents of the
 * program flash protection bytes in the Flash Configuration Field as indicated in
 * the following table. Program flash protection register Flash Configuration Field
 * offset address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To
 * change the program flash protection that is loaded during the reset sequence,
 * unprotect the sector of program flash memory that contains the Flash
 * Configuration Field. Then, reprogram the program flash protection byte.
 */
typedef union _hw_ftfe_fprot3
{
    uint8_t U;
    struct _hw_ftfe_fprot3_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfe_fprot3_t;

/*!
 * @name Constants and macros for entire FTFE_FPROT3 register
 */
/*@{*/
#define HW_FTFE_FPROT3_ADDR(x)   ((x) + 0x10U)

#define HW_FTFE_FPROT3(x)        (*(__IO hw_ftfe_fprot3_t *) HW_FTFE_FPROT3_ADDR(x))
#define HW_FTFE_FPROT3_RD(x)     (ADDRESS_READ(hw_ftfe_fprot3_t, HW_FTFE_FPROT3_ADDR(x)))
#define HW_FTFE_FPROT3_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fprot3_t, HW_FTFE_FPROT3_ADDR(x), v))
#define HW_FTFE_FPROT3_SET(x, v) (HW_FTFE_FPROT3_WR(x, HW_FTFE_FPROT3_RD(x) |  (v)))
#define HW_FTFE_FPROT3_CLR(x, v) (HW_FTFE_FPROT3_WR(x, HW_FTFE_FPROT3_RD(x) & ~(v)))
#define HW_FTFE_FPROT3_TOG(x, v) (HW_FTFE_FPROT3_WR(x, HW_FTFE_FPROT3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FPROT3 bitfields
 */

/*!
 * @name Register FTFE_FPROT3, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFE_FPROT3_PROT  (0U)          /*!< Bit position for FTFE_FPROT3_PROT. */
#define BM_FTFE_FPROT3_PROT  (0xFFU)       /*!< Bit mask for FTFE_FPROT3_PROT. */
#define BS_FTFE_FPROT3_PROT  (8U)          /*!< Bit field size in bits for FTFE_FPROT3_PROT. */

/*! @brief Read current value of the FTFE_FPROT3_PROT field. */
#define BR_FTFE_FPROT3_PROT(x) (HW_FTFE_FPROT3(x).U)

/*! @brief Format value for bitfield FTFE_FPROT3_PROT. */
#define BF_FTFE_FPROT3_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FPROT3_PROT) & BM_FTFE_FPROT3_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFE_FPROT3_PROT(x, v) (HW_FTFE_FPROT3_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FPROT2 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FPROT2 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any FTFE command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions of equal
 * memory size. Program flash protection register Program flash protection bits
 * FPROT0 PROT[31:24] FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During
 * the reset sequence, the FPROT registers are loaded with the contents of the
 * program flash protection bytes in the Flash Configuration Field as indicated in
 * the following table. Program flash protection register Flash Configuration Field
 * offset address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To
 * change the program flash protection that is loaded during the reset sequence,
 * unprotect the sector of program flash memory that contains the Flash
 * Configuration Field. Then, reprogram the program flash protection byte.
 */
typedef union _hw_ftfe_fprot2
{
    uint8_t U;
    struct _hw_ftfe_fprot2_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfe_fprot2_t;

/*!
 * @name Constants and macros for entire FTFE_FPROT2 register
 */
/*@{*/
#define HW_FTFE_FPROT2_ADDR(x)   ((x) + 0x11U)

#define HW_FTFE_FPROT2(x)        (*(__IO hw_ftfe_fprot2_t *) HW_FTFE_FPROT2_ADDR(x))
#define HW_FTFE_FPROT2_RD(x)     (ADDRESS_READ(hw_ftfe_fprot2_t, HW_FTFE_FPROT2_ADDR(x)))
#define HW_FTFE_FPROT2_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fprot2_t, HW_FTFE_FPROT2_ADDR(x), v))
#define HW_FTFE_FPROT2_SET(x, v) (HW_FTFE_FPROT2_WR(x, HW_FTFE_FPROT2_RD(x) |  (v)))
#define HW_FTFE_FPROT2_CLR(x, v) (HW_FTFE_FPROT2_WR(x, HW_FTFE_FPROT2_RD(x) & ~(v)))
#define HW_FTFE_FPROT2_TOG(x, v) (HW_FTFE_FPROT2_WR(x, HW_FTFE_FPROT2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FPROT2 bitfields
 */

/*!
 * @name Register FTFE_FPROT2, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFE_FPROT2_PROT  (0U)          /*!< Bit position for FTFE_FPROT2_PROT. */
#define BM_FTFE_FPROT2_PROT  (0xFFU)       /*!< Bit mask for FTFE_FPROT2_PROT. */
#define BS_FTFE_FPROT2_PROT  (8U)          /*!< Bit field size in bits for FTFE_FPROT2_PROT. */

/*! @brief Read current value of the FTFE_FPROT2_PROT field. */
#define BR_FTFE_FPROT2_PROT(x) (HW_FTFE_FPROT2(x).U)

/*! @brief Format value for bitfield FTFE_FPROT2_PROT. */
#define BF_FTFE_FPROT2_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FPROT2_PROT) & BM_FTFE_FPROT2_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFE_FPROT2_PROT(x, v) (HW_FTFE_FPROT2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FPROT1 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FPROT1 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any FTFE command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions of equal
 * memory size. Program flash protection register Program flash protection bits
 * FPROT0 PROT[31:24] FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During
 * the reset sequence, the FPROT registers are loaded with the contents of the
 * program flash protection bytes in the Flash Configuration Field as indicated in
 * the following table. Program flash protection register Flash Configuration Field
 * offset address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To
 * change the program flash protection that is loaded during the reset sequence,
 * unprotect the sector of program flash memory that contains the Flash
 * Configuration Field. Then, reprogram the program flash protection byte.
 */
typedef union _hw_ftfe_fprot1
{
    uint8_t U;
    struct _hw_ftfe_fprot1_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfe_fprot1_t;

/*!
 * @name Constants and macros for entire FTFE_FPROT1 register
 */
/*@{*/
#define HW_FTFE_FPROT1_ADDR(x)   ((x) + 0x12U)

#define HW_FTFE_FPROT1(x)        (*(__IO hw_ftfe_fprot1_t *) HW_FTFE_FPROT1_ADDR(x))
#define HW_FTFE_FPROT1_RD(x)     (ADDRESS_READ(hw_ftfe_fprot1_t, HW_FTFE_FPROT1_ADDR(x)))
#define HW_FTFE_FPROT1_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fprot1_t, HW_FTFE_FPROT1_ADDR(x), v))
#define HW_FTFE_FPROT1_SET(x, v) (HW_FTFE_FPROT1_WR(x, HW_FTFE_FPROT1_RD(x) |  (v)))
#define HW_FTFE_FPROT1_CLR(x, v) (HW_FTFE_FPROT1_WR(x, HW_FTFE_FPROT1_RD(x) & ~(v)))
#define HW_FTFE_FPROT1_TOG(x, v) (HW_FTFE_FPROT1_WR(x, HW_FTFE_FPROT1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FPROT1 bitfields
 */

/*!
 * @name Register FTFE_FPROT1, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFE_FPROT1_PROT  (0U)          /*!< Bit position for FTFE_FPROT1_PROT. */
#define BM_FTFE_FPROT1_PROT  (0xFFU)       /*!< Bit mask for FTFE_FPROT1_PROT. */
#define BS_FTFE_FPROT1_PROT  (8U)          /*!< Bit field size in bits for FTFE_FPROT1_PROT. */

/*! @brief Read current value of the FTFE_FPROT1_PROT field. */
#define BR_FTFE_FPROT1_PROT(x) (HW_FTFE_FPROT1(x).U)

/*! @brief Format value for bitfield FTFE_FPROT1_PROT. */
#define BF_FTFE_FPROT1_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FPROT1_PROT) & BM_FTFE_FPROT1_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFE_FPROT1_PROT(x, v) (HW_FTFE_FPROT1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FPROT0 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FPROT0 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any FTFE command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions of equal
 * memory size. Program flash protection register Program flash protection bits
 * FPROT0 PROT[31:24] FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During
 * the reset sequence, the FPROT registers are loaded with the contents of the
 * program flash protection bytes in the Flash Configuration Field as indicated in
 * the following table. Program flash protection register Flash Configuration Field
 * offset address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To
 * change the program flash protection that is loaded during the reset sequence,
 * unprotect the sector of program flash memory that contains the Flash
 * Configuration Field. Then, reprogram the program flash protection byte.
 */
typedef union _hw_ftfe_fprot0
{
    uint8_t U;
    struct _hw_ftfe_fprot0_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfe_fprot0_t;

/*!
 * @name Constants and macros for entire FTFE_FPROT0 register
 */
/*@{*/
#define HW_FTFE_FPROT0_ADDR(x)   ((x) + 0x13U)

#define HW_FTFE_FPROT0(x)        (*(__IO hw_ftfe_fprot0_t *) HW_FTFE_FPROT0_ADDR(x))
#define HW_FTFE_FPROT0_RD(x)     (ADDRESS_READ(hw_ftfe_fprot0_t, HW_FTFE_FPROT0_ADDR(x)))
#define HW_FTFE_FPROT0_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fprot0_t, HW_FTFE_FPROT0_ADDR(x), v))
#define HW_FTFE_FPROT0_SET(x, v) (HW_FTFE_FPROT0_WR(x, HW_FTFE_FPROT0_RD(x) |  (v)))
#define HW_FTFE_FPROT0_CLR(x, v) (HW_FTFE_FPROT0_WR(x, HW_FTFE_FPROT0_RD(x) & ~(v)))
#define HW_FTFE_FPROT0_TOG(x, v) (HW_FTFE_FPROT0_WR(x, HW_FTFE_FPROT0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FPROT0 bitfields
 */

/*!
 * @name Register FTFE_FPROT0, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFE_FPROT0_PROT  (0U)          /*!< Bit position for FTFE_FPROT0_PROT. */
#define BM_FTFE_FPROT0_PROT  (0xFFU)       /*!< Bit mask for FTFE_FPROT0_PROT. */
#define BS_FTFE_FPROT0_PROT  (8U)          /*!< Bit field size in bits for FTFE_FPROT0_PROT. */

/*! @brief Read current value of the FTFE_FPROT0_PROT field. */
#define BR_FTFE_FPROT0_PROT(x) (HW_FTFE_FPROT0(x).U)

/*! @brief Format value for bitfield FTFE_FPROT0_PROT. */
#define BF_FTFE_FPROT0_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FPROT0_PROT) & BM_FTFE_FPROT0_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFE_FPROT0_PROT(x, v) (HW_FTFE_FPROT0_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FEPROT - EEPROM Protection Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FEPROT - EEPROM Protection Register (RW)
 *
 * Reset value: 0x00U
 *
 * For devices with FlexNVM: The FEPROT register defines which EEPROM regions of
 * the FlexRAM are protected against program and erase operations. Protected
 * EEPROM regions cannot have their content changed by writing to it. Unprotected
 * regions can be changed by writing to the FlexRAM. For devices with program flash
 * only: This register is reserved and not used.
 */
typedef union _hw_ftfe_feprot
{
    uint8_t U;
    struct _hw_ftfe_feprot_bitfields
    {
        uint8_t EPROT : 8;             /*!< [7:0] EEPROM Region Protect */
    } B;
} hw_ftfe_feprot_t;

/*!
 * @name Constants and macros for entire FTFE_FEPROT register
 */
/*@{*/
#define HW_FTFE_FEPROT_ADDR(x)   ((x) + 0x16U)

#define HW_FTFE_FEPROT(x)        (*(__IO hw_ftfe_feprot_t *) HW_FTFE_FEPROT_ADDR(x))
#define HW_FTFE_FEPROT_RD(x)     (ADDRESS_READ(hw_ftfe_feprot_t, HW_FTFE_FEPROT_ADDR(x)))
#define HW_FTFE_FEPROT_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_feprot_t, HW_FTFE_FEPROT_ADDR(x), v))
#define HW_FTFE_FEPROT_SET(x, v) (HW_FTFE_FEPROT_WR(x, HW_FTFE_FEPROT_RD(x) |  (v)))
#define HW_FTFE_FEPROT_CLR(x, v) (HW_FTFE_FEPROT_WR(x, HW_FTFE_FEPROT_RD(x) & ~(v)))
#define HW_FTFE_FEPROT_TOG(x, v) (HW_FTFE_FEPROT_WR(x, HW_FTFE_FEPROT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FEPROT bitfields
 */

/*!
 * @name Register FTFE_FEPROT, field EPROT[7:0] (RW)
 *
 * For devices with program flash only: Reserved For devices with FlexNVM:
 * Individual EEPROM regions can be protected from alteration by setting the
 * associated EPROT bit. The EPROT bits are not used when the FlexNVM Partition Code is
 * set to data flash only. When the FlexNVM Partition Code is set to data flash and
 * EEPROM or EEPROM only, each EPROT bit covers one-eighth of the configured
 * EEPROM data (see the EEPROM Data Set Size parameter description). In NVM Normal
 * mode: The protection can only be increased. This means that
 * currently-unprotected memory can be protected, but currently-protected memory cannot be
 * unprotected. Since unprotected regions are marked with a 1 and protected regions use a
 * 0, only writes changing 1s to 0s are accepted. This 1-to-0 transition check is
 * performed on a bit-by-bit basis. Those FEPROT bits with 1-to-0 transitions
 * are accepted while all bits with 0-to-1 transitions are ignored. In NVM Special
 * mode: All bits of the FEPROT register are writable without restriction.
 * Unprotected areas can be protected and protected areas can be unprotected. Never
 * write to the FEPROT register while a command is running (CCIF=0). Reset: During
 * the reset sequence, the FEPROT register is loaded with the contents of the
 * FlexRAM protection byte in the Flash Configuration Field located in program flash.
 * The flash basis for the reset values is signified by X in the register
 * diagram. To change the EEPROM protection that will be loaded during the reset
 * sequence, the sector of program flash that contains the Flash Configuration Field
 * must be unprotected; then the EEPROM protection byte must be erased and
 * reprogrammed. Trying to alter data by writing to any protected area in the EEPROM
 * results in a protection violation error and sets the FSTAT[FPVIOL] bit.
 *
 * Values:
 * - 0 - For devices with program flash only: Reserved For devices with FlexNVM:
 *     EEPROM region is protected
 * - 1 - For devices with program flash only: Reserved For devices with FlexNVM:
 *     EEPROM region is not protected
 */
/*@{*/
#define BP_FTFE_FEPROT_EPROT (0U)          /*!< Bit position for FTFE_FEPROT_EPROT. */
#define BM_FTFE_FEPROT_EPROT (0xFFU)       /*!< Bit mask for FTFE_FEPROT_EPROT. */
#define BS_FTFE_FEPROT_EPROT (8U)          /*!< Bit field size in bits for FTFE_FEPROT_EPROT. */

/*! @brief Read current value of the FTFE_FEPROT_EPROT field. */
#define BR_FTFE_FEPROT_EPROT(x) (HW_FTFE_FEPROT(x).U)

/*! @brief Format value for bitfield FTFE_FEPROT_EPROT. */
#define BF_FTFE_FEPROT_EPROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FEPROT_EPROT) & BM_FTFE_FEPROT_EPROT)

/*! @brief Set the EPROT field to a new value. */
#define BW_FTFE_FEPROT_EPROT(x, v) (HW_FTFE_FEPROT_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFE_FDPROT - Data Flash Protection Register
 ******************************************************************************/

/*!
 * @brief HW_FTFE_FDPROT - Data Flash Protection Register (RW)
 *
 * Reset value: 0x00U
 *
 * The FDPROT register defines which data flash regions are protected against
 * program and erase operations. Protected Flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any FTFE command. Unprotected regions can be changed by both program and erase
 * operations.
 */
typedef union _hw_ftfe_fdprot
{
    uint8_t U;
    struct _hw_ftfe_fdprot_bitfields
    {
        uint8_t DPROT : 8;             /*!< [7:0] Data Flash Region Protect */
    } B;
} hw_ftfe_fdprot_t;

/*!
 * @name Constants and macros for entire FTFE_FDPROT register
 */
/*@{*/
#define HW_FTFE_FDPROT_ADDR(x)   ((x) + 0x17U)

#define HW_FTFE_FDPROT(x)        (*(__IO hw_ftfe_fdprot_t *) HW_FTFE_FDPROT_ADDR(x))
#define HW_FTFE_FDPROT_RD(x)     (ADDRESS_READ(hw_ftfe_fdprot_t, HW_FTFE_FDPROT_ADDR(x)))
#define HW_FTFE_FDPROT_WR(x, v)  (ADDRESS_WRITE(hw_ftfe_fdprot_t, HW_FTFE_FDPROT_ADDR(x), v))
#define HW_FTFE_FDPROT_SET(x, v) (HW_FTFE_FDPROT_WR(x, HW_FTFE_FDPROT_RD(x) |  (v)))
#define HW_FTFE_FDPROT_CLR(x, v) (HW_FTFE_FDPROT_WR(x, HW_FTFE_FDPROT_RD(x) & ~(v)))
#define HW_FTFE_FDPROT_TOG(x, v) (HW_FTFE_FDPROT_WR(x, HW_FTFE_FDPROT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFE_FDPROT bitfields
 */

/*!
 * @name Register FTFE_FDPROT, field DPROT[7:0] (RW)
 *
 * Individual data flash regions can be protected from program and erase
 * operations by setting the associated DPROT bit. Each DPROT bit protects one-eighth of
 * the partitioned data flash memory space. The granularity of data flash
 * protection cannot be less than the data flash sector size. If an unused DPROT bit is
 * set, the Erase all Blocks command does not execute and sets the FSTAT[FPVIOL]
 * bit. In NVM Normal mode: The protection can only be increased, meaning that
 * currently unprotected memory can be protected but currently protected memory
 * cannot be unprotected. Since unprotected regions are marked with a 1 and
 * protected regions use a 0, only writes changing 1s to 0s are accepted. This 1-to-0
 * transition check is performed on a bit-by-bit basis. Those FDPROT bits with
 * 1-to-0 transitions are accepted while all bits with 0-to-1 transitions are
 * ignored. In NVM Special mode: All bits of the FDPROT register are writable without
 * restriction. Unprotected areas can be protected and protected areas can be
 * unprotected. The user must never write to the FDPROT register while a command is
 * running (CCIF=0). Reset: During the reset sequence, the FDPROT register is
 * loaded with the contents of the data flash protection byte in the Flash
 * Configuration Field located in program flash memory. The flash basis for the reset values
 * is signified by X in the register diagram. To change the data flash
 * protection that will be loaded during the reset sequence, unprotect the sector of
 * program flash that contains the Flash Configuration Field. Then, erase and
 * reprogram the data flash protection byte. Trying to alter data with the program and
 * erase commands in any protected area in the data flash memory results in a
 * protection violation error and sets the FSTAT[FPVIOL] bit. A block erase of any
 * data flash memory block (see the Erase Flash Block command description) is not
 * possible if the data flash block contains any protected region or if the FlexNVM
 * memory has been partitioned for EEPROM.
 *
 * Values:
 * - 0 - Data Flash region is protected
 * - 1 - Data Flash region is not protected
 */
/*@{*/
#define BP_FTFE_FDPROT_DPROT (0U)          /*!< Bit position for FTFE_FDPROT_DPROT. */
#define BM_FTFE_FDPROT_DPROT (0xFFU)       /*!< Bit mask for FTFE_FDPROT_DPROT. */
#define BS_FTFE_FDPROT_DPROT (8U)          /*!< Bit field size in bits for FTFE_FDPROT_DPROT. */

/*! @brief Read current value of the FTFE_FDPROT_DPROT field. */
#define BR_FTFE_FDPROT_DPROT(x) (HW_FTFE_FDPROT(x).U)

/*! @brief Format value for bitfield FTFE_FDPROT_DPROT. */
#define BF_FTFE_FDPROT_DPROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFE_FDPROT_DPROT) & BM_FTFE_FDPROT_DPROT)

/*! @brief Set the DPROT field to a new value. */
#define BW_FTFE_FDPROT_DPROT(x, v) (HW_FTFE_FDPROT_WR(x, v))
/*@}*/

/*******************************************************************************
 * hw_ftfe_t - module struct
 ******************************************************************************/
/*!
 * @brief All FTFE module registers.
 */
#pragma pack(1)
typedef struct _hw_ftfe
{
    __IO hw_ftfe_fstat_t FSTAT;            /*!< [0x0] Flash Status Register */
    __IO hw_ftfe_fcnfg_t FCNFG;            /*!< [0x1] Flash Configuration Register */
    __I hw_ftfe_fsec_t FSEC;               /*!< [0x2] Flash Security Register */
    __I hw_ftfe_fopt_t FOPT;               /*!< [0x3] Flash Option Register */
    __IO hw_ftfe_fccob3_t FCCOB3;          /*!< [0x4] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob2_t FCCOB2;          /*!< [0x5] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob1_t FCCOB1;          /*!< [0x6] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob0_t FCCOB0;          /*!< [0x7] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob7_t FCCOB7;          /*!< [0x8] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob6_t FCCOB6;          /*!< [0x9] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob5_t FCCOB5;          /*!< [0xA] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob4_t FCCOB4;          /*!< [0xB] Flash Common Command Object Registers */
    __IO hw_ftfe_fccobb_t FCCOBB;          /*!< [0xC] Flash Common Command Object Registers */
    __IO hw_ftfe_fccoba_t FCCOBA;          /*!< [0xD] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob9_t FCCOB9;          /*!< [0xE] Flash Common Command Object Registers */
    __IO hw_ftfe_fccob8_t FCCOB8;          /*!< [0xF] Flash Common Command Object Registers */
    __IO hw_ftfe_fprot3_t FPROT3;          /*!< [0x10] Program Flash Protection Registers */
    __IO hw_ftfe_fprot2_t FPROT2;          /*!< [0x11] Program Flash Protection Registers */
    __IO hw_ftfe_fprot1_t FPROT1;          /*!< [0x12] Program Flash Protection Registers */
    __IO hw_ftfe_fprot0_t FPROT0;          /*!< [0x13] Program Flash Protection Registers */
    uint8_t _reserved0[2];
    __IO hw_ftfe_feprot_t FEPROT;          /*!< [0x16] EEPROM Protection Register */
    __IO hw_ftfe_fdprot_t FDPROT;          /*!< [0x17] Data Flash Protection Register */
} hw_ftfe_t;
#pragma pack()

/*! @brief Macro to access all FTFE registers. */
/*! @param x FTFE module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_FTFE(FTFE_BASE)</code>. */
#define HW_FTFE(x)     (*(hw_ftfe_t *)(x))

#endif /* __HW_FTFE_REGISTERS_H__ */
/* EOF */
