/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     (C) COPYRIGHT 2015-2015 ARM Limited
**     ALL RIGHTS RESERVED
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2015-08-03) (ARM)
**         All accesses to memory are replaced by equivalent macros; this allows
**         memory read/write operations to be re-defined if needed (for example,
**         to implement new security features
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CAN_REGISTERS_H__
#define __HW_CAN_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 CAN
 *
 * Flex Controller Area Network module
 *
 * Registers defined in this header file:
 * - HW_CAN_MCR - Module Configuration Register
 * - HW_CAN_CTRL1 - Control 1 register
 * - HW_CAN_TIMER - Free Running Timer
 * - HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 * - HW_CAN_RX14MASK - Rx 14 Mask register
 * - HW_CAN_RX15MASK - Rx 15 Mask register
 * - HW_CAN_ECR - Error Counter
 * - HW_CAN_ESR1 - Error and Status 1 register
 * - HW_CAN_IMASK1 - Interrupt Masks 1 register
 * - HW_CAN_IFLAG1 - Interrupt Flags 1 register
 * - HW_CAN_CTRL2 - Control 2 register
 * - HW_CAN_ESR2 - Error and Status 2 register
 * - HW_CAN_CRCR - CRC Register
 * - HW_CAN_RXFGMASK - Rx FIFO Global Mask register
 * - HW_CAN_RXFIR - Rx FIFO Information Register
 * - HW_CAN_CSn - Message Buffer 0 CS Register
 * - HW_CAN_IDn - Message Buffer 0 ID Register
 * - HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 * - HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 * - HW_CAN_RXIMRn - Rx Individual Mask Registers
 *
 * - hw_can_t - Struct containing all module registers.
 */

#define HW_CAN_INSTANCE_COUNT (1U) /*!< Number of instances of the CAN module. */

/*******************************************************************************
 * HW_CAN_MCR - Module Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_MCR - Module Configuration Register (RW)
 *
 * Reset value: 0xD890000FU
 *
 * This register defines global system configurations, such as the module
 * operation modes and the maximum message buffer configuration.
 */
typedef union _hw_can_mcr
{
    uint32_t U;
    struct _hw_can_mcr_bitfields
    {
        uint32_t MAXMB : 7;            /*!< [6:0] Number Of The Last Message Buffer */
        uint32_t RESERVED0 : 1;        /*!< [7]  */
        uint32_t IDAM : 2;             /*!< [9:8] ID Acceptance Mode */
        uint32_t RESERVED1 : 2;        /*!< [11:10]  */
        uint32_t AEN : 1;              /*!< [12] Abort Enable */
        uint32_t LPRIOEN : 1;          /*!< [13] Local Priority Enable */
        uint32_t RESERVED2 : 2;        /*!< [15:14]  */
        uint32_t IRMQ : 1;             /*!< [16] Individual Rx Masking And Queue Enable */
        uint32_t SRXDIS : 1;           /*!< [17] Self Reception Disable */
        uint32_t RESERVED3 : 1;        /*!< [18]  */
        uint32_t WAKSRC : 1;           /*!< [19] Wake Up Source */
        uint32_t LPMACK : 1;           /*!< [20] Low-Power Mode Acknowledge */
        uint32_t WRNEN : 1;            /*!< [21] Warning Interrupt Enable */
        uint32_t SLFWAK : 1;           /*!< [22] Self Wake Up */
        uint32_t SUPV : 1;             /*!< [23] Supervisor Mode */
        uint32_t FRZACK : 1;           /*!< [24] Freeze Mode Acknowledge */
        uint32_t SOFTRST : 1;          /*!< [25] Soft Reset */
        uint32_t WAKMSK : 1;           /*!< [26] Wake Up Interrupt Mask */
        uint32_t NOTRDY : 1;           /*!< [27] FlexCAN Not Ready */
        uint32_t HALT : 1;             /*!< [28] Halt FlexCAN */
        uint32_t RFEN : 1;             /*!< [29] Rx FIFO Enable */
        uint32_t FRZ : 1;              /*!< [30] Freeze Enable */
        uint32_t MDIS : 1;             /*!< [31] Module Disable */
    } B;
} hw_can_mcr_t;

/*!
 * @name Constants and macros for entire CAN_MCR register
 */
/*@{*/
#define HW_CAN_MCR_ADDR(x)       ((x) + 0x0U)

#define HW_CAN_MCR(x)            (*(__IO hw_can_mcr_t *) HW_CAN_MCR_ADDR(x))
#define HW_CAN_MCR_RD(x)         (ADDRESS_READ(hw_can_mcr_t, HW_CAN_MCR_ADDR(x)))
#define HW_CAN_MCR_WR(x, v)      (ADDRESS_WRITE(hw_can_mcr_t, HW_CAN_MCR_ADDR(x), v))
#define HW_CAN_MCR_SET(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) |  (v)))
#define HW_CAN_MCR_CLR(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) & ~(v)))
#define HW_CAN_MCR_TOG(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_MCR bitfields
 */

/*!
 * @name Register CAN_MCR, field MAXMB[6:0] (RW)
 *
 * This 7-bit field defines the number of the last Message Buffers that will
 * take part in the matching and arbitration processes. The reset value (0x0F) is
 * equivalent to a 16 MB configuration. This field can be written only in Freeze
 * mode because it is blocked by hardware in other modes. Number of the last MB =
 * MAXMB MAXMB must be programmed with a value smaller than the parameter
 * NUMBER_OF_MB, otherwise the number of the last effective Message Buffer will be:
 * (NUMBER_OF_MB - 1) Additionally, the value of MAXMB must encompass the FIFO size
 * defined by CTRL2[RFFN]. MAXMB also impacts the definition of the minimum number
 * of peripheral clocks per CAN bit as described in Table "Minimum Ratio Between
 * Peripheral Clock Frequency and CAN Bit Rate" (in Section "Arbitration and
 * Matching Timing").
 */
/*@{*/
#define BP_CAN_MCR_MAXMB     (0U)          /*!< Bit position for CAN_MCR_MAXMB. */
#define BM_CAN_MCR_MAXMB     (0x0000007FU) /*!< Bit mask for CAN_MCR_MAXMB. */
#define BS_CAN_MCR_MAXMB     (7U)          /*!< Bit field size in bits for CAN_MCR_MAXMB. */

/*! @brief Read current value of the CAN_MCR_MAXMB field. */
#define BR_CAN_MCR_MAXMB(x)  (UNION_READ(hw_can_mcr_t, HW_CAN_MCR_ADDR(x), U, B.MAXMB))

/*! @brief Format value for bitfield CAN_MCR_MAXMB. */
#define BF_CAN_MCR_MAXMB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MAXMB) & BM_CAN_MCR_MAXMB)

/*! @brief Set the MAXMB field to a new value. */
#define BW_CAN_MCR_MAXMB(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_MAXMB) | BF_CAN_MCR_MAXMB(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field IDAM[9:8] (RW)
 *
 * This 2-bit field identifies the format of the Rx FIFO ID Filter Table
 * elements. Note that all elements of the table are configured at the same time by this
 * field (they are all the same format). See Section "Rx FIFO Structure". This
 * field can be written only in Freeze mode because it is blocked by hardware in
 * other modes.
 *
 * Values:
 * - 00 - Format A: One full ID (standard and extended) per ID Filter Table
 *     element.
 * - 01 - Format B: Two full standard IDs or two partial 14-bit (standard and
 *     extended) IDs per ID Filter Table element.
 * - 10 - Format C: Four partial 8-bit Standard IDs per ID Filter Table element.
 * - 11 - Format D: All frames rejected.
 */
/*@{*/
#define BP_CAN_MCR_IDAM      (8U)          /*!< Bit position for CAN_MCR_IDAM. */
#define BM_CAN_MCR_IDAM      (0x00000300U) /*!< Bit mask for CAN_MCR_IDAM. */
#define BS_CAN_MCR_IDAM      (2U)          /*!< Bit field size in bits for CAN_MCR_IDAM. */

/*! @brief Read current value of the CAN_MCR_IDAM field. */
#define BR_CAN_MCR_IDAM(x)   (UNION_READ(hw_can_mcr_t, HW_CAN_MCR_ADDR(x), U, B.IDAM))

/*! @brief Format value for bitfield CAN_MCR_IDAM. */
#define BF_CAN_MCR_IDAM(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IDAM) & BM_CAN_MCR_IDAM)

/*! @brief Set the IDAM field to a new value. */
#define BW_CAN_MCR_IDAM(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_IDAM) | BF_CAN_MCR_IDAM(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field AEN[12] (RW)
 *
 * This bit is supplied for backwards compatibility with legacy applications.
 * When asserted, it enables the Tx abort mechanism. This mechanism guarantees a
 * safe procedure for aborting a pending transmission, so that no frame is sent in
 * the CAN bus without notification. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes. When MCR[AEN] is asserted,
 * only the abort mechanism (see Section "Transmission Abort Mechanism") must be
 * used for updating Mailboxes configured for transmission. Writing the Abort code
 * into Rx Mailboxes can cause unpredictable results when the MCR[AEN] is
 * asserted.
 *
 * Values:
 * - 0 - Abort disabled.
 * - 1 - Abort enabled.
 */
/*@{*/
#define BP_CAN_MCR_AEN       (12U)         /*!< Bit position for CAN_MCR_AEN. */
#define BM_CAN_MCR_AEN       (0x00001000U) /*!< Bit mask for CAN_MCR_AEN. */
#define BS_CAN_MCR_AEN       (1U)          /*!< Bit field size in bits for CAN_MCR_AEN. */

/*! @brief Read current value of the CAN_MCR_AEN field. */
#define BR_CAN_MCR_AEN(x)    (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_AEN)))

/*! @brief Format value for bitfield CAN_MCR_AEN. */
#define BF_CAN_MCR_AEN(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_AEN) & BM_CAN_MCR_AEN)

/*! @brief Set the AEN field to a new value. */
#define BW_CAN_MCR_AEN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_AEN), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPRIOEN[13] (RW)
 *
 * This bit is provided for backwards compatibility with legacy applications. It
 * controls whether the local priority feature is enabled or not. It is used to
 * expand the ID used during the arbitration process. With this expanded ID
 * concept, the arbitration process is done based on the full 32-bit word, but the
 * actual transmitted ID still has 11-bit for standard frames and 29-bit for
 * extended frames. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 0 - Local Priority disabled.
 * - 1 - Local Priority enabled.
 */
/*@{*/
#define BP_CAN_MCR_LPRIOEN   (13U)         /*!< Bit position for CAN_MCR_LPRIOEN. */
#define BM_CAN_MCR_LPRIOEN   (0x00002000U) /*!< Bit mask for CAN_MCR_LPRIOEN. */
#define BS_CAN_MCR_LPRIOEN   (1U)          /*!< Bit field size in bits for CAN_MCR_LPRIOEN. */

/*! @brief Read current value of the CAN_MCR_LPRIOEN field. */
#define BR_CAN_MCR_LPRIOEN(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_LPRIOEN)))

/*! @brief Format value for bitfield CAN_MCR_LPRIOEN. */
#define BF_CAN_MCR_LPRIOEN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_LPRIOEN) & BM_CAN_MCR_LPRIOEN)

/*! @brief Set the LPRIOEN field to a new value. */
#define BW_CAN_MCR_LPRIOEN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_LPRIOEN), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field IRMQ[16] (RW)
 *
 * This bit indicates whether Rx matching process will be based either on
 * individual masking and queue or on masking scheme with RXMGMASK, RX14MASK and
 * RX15MASK, RXFGMASK. This bit can be written only in Freeze mode because it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Individual Rx masking and queue feature are disabled. For backward
 *     compatibility with legacy applications, the reading of C/S word locks the MB
 *     even if it is EMPTY.
 * - 1 - Individual Rx masking and queue feature are enabled.
 */
/*@{*/
#define BP_CAN_MCR_IRMQ      (16U)         /*!< Bit position for CAN_MCR_IRMQ. */
#define BM_CAN_MCR_IRMQ      (0x00010000U) /*!< Bit mask for CAN_MCR_IRMQ. */
#define BS_CAN_MCR_IRMQ      (1U)          /*!< Bit field size in bits for CAN_MCR_IRMQ. */

/*! @brief Read current value of the CAN_MCR_IRMQ field. */
#define BR_CAN_MCR_IRMQ(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_IRMQ)))

/*! @brief Format value for bitfield CAN_MCR_IRMQ. */
#define BF_CAN_MCR_IRMQ(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IRMQ) & BM_CAN_MCR_IRMQ)

/*! @brief Set the IRMQ field to a new value. */
#define BW_CAN_MCR_IRMQ(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_IRMQ), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field SRXDIS[17] (RW)
 *
 * This bit defines whether FlexCAN is allowed to receive frames transmitted by
 * itself. If this bit is asserted, frames transmitted by the module will not be
 * stored in any MB, regardless if the MB is programmed with an ID that matches
 * the transmitted frame, and no interrupt flag or interrupt signal will be
 * generated due to the frame reception. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Self reception enabled.
 * - 1 - Self reception disabled.
 */
/*@{*/
#define BP_CAN_MCR_SRXDIS    (17U)         /*!< Bit position for CAN_MCR_SRXDIS. */
#define BM_CAN_MCR_SRXDIS    (0x00020000U) /*!< Bit mask for CAN_MCR_SRXDIS. */
#define BS_CAN_MCR_SRXDIS    (1U)          /*!< Bit field size in bits for CAN_MCR_SRXDIS. */

/*! @brief Read current value of the CAN_MCR_SRXDIS field. */
#define BR_CAN_MCR_SRXDIS(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SRXDIS)))

/*! @brief Format value for bitfield CAN_MCR_SRXDIS. */
#define BF_CAN_MCR_SRXDIS(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SRXDIS) & BM_CAN_MCR_SRXDIS)

/*! @brief Set the SRXDIS field to a new value. */
#define BW_CAN_MCR_SRXDIS(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SRXDIS), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAKSRC[19] (RW)
 *
 * This bit defines whether the integrated low-pass filter is applied to protect
 * the Rx CAN input from spurious wake up. This bit can be written only in
 * Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - FlexCAN uses the unfiltered Rx input to detect recessive to dominant
 *     edges on the CAN bus.
 * - 1 - FlexCAN uses the filtered Rx input to detect recessive to dominant
 *     edges on the CAN bus.
 */
/*@{*/
#define BP_CAN_MCR_WAKSRC    (19U)         /*!< Bit position for CAN_MCR_WAKSRC. */
#define BM_CAN_MCR_WAKSRC    (0x00080000U) /*!< Bit mask for CAN_MCR_WAKSRC. */
#define BS_CAN_MCR_WAKSRC    (1U)          /*!< Bit field size in bits for CAN_MCR_WAKSRC. */

/*! @brief Read current value of the CAN_MCR_WAKSRC field. */
#define BR_CAN_MCR_WAKSRC(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WAKSRC)))

/*! @brief Format value for bitfield CAN_MCR_WAKSRC. */
#define BF_CAN_MCR_WAKSRC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAKSRC) & BM_CAN_MCR_WAKSRC)

/*! @brief Set the WAKSRC field to a new value. */
#define BW_CAN_MCR_WAKSRC(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WAKSRC), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPMACK[20] (RO)
 *
 * This read-only bit indicates that FlexCAN is in a low-power mode (Disable
 * mode , Stop mode ). A low-power mode cannot be entered until all current
 * transmission or reception processes have finished, so the CPU can poll the LPMACK bit
 * to know when FlexCAN has actually entered low power mode. LPMACK will be
 * asserted within 180 CAN bits from the low-power mode request by the CPU, and
 * negated within 2 CAN bits after the low-power mode request removal (see Section
 * "Protocol Timing").
 *
 * Values:
 * - 0 - FlexCAN is not in a low-power mode.
 * - 1 - FlexCAN is in a low-power mode.
 */
/*@{*/
#define BP_CAN_MCR_LPMACK    (20U)         /*!< Bit position for CAN_MCR_LPMACK. */
#define BM_CAN_MCR_LPMACK    (0x00100000U) /*!< Bit mask for CAN_MCR_LPMACK. */
#define BS_CAN_MCR_LPMACK    (1U)          /*!< Bit field size in bits for CAN_MCR_LPMACK. */

/*! @brief Read current value of the CAN_MCR_LPMACK field. */
#define BR_CAN_MCR_LPMACK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_LPMACK)))
/*@}*/

/*!
 * @name Register CAN_MCR, field WRNEN[21] (RW)
 *
 * When asserted, this bit enables the generation of the TWRNINT and RWRNINT
 * flags in the Error and Status Register. If WRNEN is negated, the TWRNINT and
 * RWRNINT flags will always be zero, independent of the values of the error
 * counters, and no warning interrupt will ever be generated. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - TWRNINT and RWRNINT bits are zero, independent of the values in the
 *     error counters.
 * - 1 - TWRNINT and RWRNINT bits are set when the respective error counter
 *     transitions from less than 96 to greater than or equal to 96.
 */
/*@{*/
#define BP_CAN_MCR_WRNEN     (21U)         /*!< Bit position for CAN_MCR_WRNEN. */
#define BM_CAN_MCR_WRNEN     (0x00200000U) /*!< Bit mask for CAN_MCR_WRNEN. */
#define BS_CAN_MCR_WRNEN     (1U)          /*!< Bit field size in bits for CAN_MCR_WRNEN. */

/*! @brief Read current value of the CAN_MCR_WRNEN field. */
#define BR_CAN_MCR_WRNEN(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WRNEN)))

/*! @brief Format value for bitfield CAN_MCR_WRNEN. */
#define BF_CAN_MCR_WRNEN(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WRNEN) & BM_CAN_MCR_WRNEN)

/*! @brief Set the WRNEN field to a new value. */
#define BW_CAN_MCR_WRNEN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WRNEN), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field SLFWAK[22] (RW)
 *
 * This bit enables the Self Wake Up feature when FlexCAN is in a low-power mode
 * other than Disable mode. When this feature is enabled, the FlexCAN module
 * monitors the bus for wake up event, that is, a recessive-to-dominant transition.
 * If a wake up event is detected during Stop mode, then FlexCAN generates, if
 * enabled to do so, a Wake Up interrupt to the CPU so that it can exit Stop mode
 * globally and FlexCAN can request to resume the clocks. When FlexCAN is in a
 * low-power mode other than Disable mode, this bit cannot be written as it is
 * blocked by hardware.
 *
 * Values:
 * - 0 - FlexCAN Self Wake Up feature is disabled.
 * - 1 - FlexCAN Self Wake Up feature is enabled.
 */
/*@{*/
#define BP_CAN_MCR_SLFWAK    (22U)         /*!< Bit position for CAN_MCR_SLFWAK. */
#define BM_CAN_MCR_SLFWAK    (0x00400000U) /*!< Bit mask for CAN_MCR_SLFWAK. */
#define BS_CAN_MCR_SLFWAK    (1U)          /*!< Bit field size in bits for CAN_MCR_SLFWAK. */

/*! @brief Read current value of the CAN_MCR_SLFWAK field. */
#define BR_CAN_MCR_SLFWAK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SLFWAK)))

/*! @brief Format value for bitfield CAN_MCR_SLFWAK. */
#define BF_CAN_MCR_SLFWAK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SLFWAK) & BM_CAN_MCR_SLFWAK)

/*! @brief Set the SLFWAK field to a new value. */
#define BW_CAN_MCR_SLFWAK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SLFWAK), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field SUPV[23] (RW)
 *
 * This bit configures the FlexCAN to be either in Supervisor or User mode. The
 * registers affected by this bit are marked as S/U in the Access Type column of
 * the module memory map. Reset value of this bit is 1, so the affected registers
 * start with Supervisor access allowance only . This bit can be written only in
 * Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - FlexCAN is in User mode. Affected registers allow both Supervisor and
 *     Unrestricted accesses .
 * - 1 - FlexCAN is in Supervisor mode. Affected registers allow only Supervisor
 *     access. Unrestricted access behaves as though the access was done to an
 *     unimplemented register location .
 */
/*@{*/
#define BP_CAN_MCR_SUPV      (23U)         /*!< Bit position for CAN_MCR_SUPV. */
#define BM_CAN_MCR_SUPV      (0x00800000U) /*!< Bit mask for CAN_MCR_SUPV. */
#define BS_CAN_MCR_SUPV      (1U)          /*!< Bit field size in bits for CAN_MCR_SUPV. */

/*! @brief Read current value of the CAN_MCR_SUPV field. */
#define BR_CAN_MCR_SUPV(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SUPV)))

/*! @brief Format value for bitfield CAN_MCR_SUPV. */
#define BF_CAN_MCR_SUPV(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SUPV) & BM_CAN_MCR_SUPV)

/*! @brief Set the SUPV field to a new value. */
#define BW_CAN_MCR_SUPV(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SUPV), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZACK[24] (RO)
 *
 * This read-only bit indicates that FlexCAN is in Freeze mode and its prescaler
 * is stopped. The Freeze mode request cannot be granted until current
 * transmission or reception processes have finished. Therefore the software can poll the
 * FRZACK bit to know when FlexCAN has actually entered Freeze mode. If Freeze
 * Mode request is negated, then this bit is negated after the FlexCAN prescaler is
 * running again. If Freeze mode is requested while FlexCAN is in a low power
 * mode, then the FRZACK bit will be set only when the low-power mode is exited.
 * See Section "Freeze Mode". FRZACK will be asserted within 178 CAN bits from the
 * freeze mode request by the CPU, and negated within 2 CAN bits after the freeze
 * mode request removal (see Section "Protocol Timing").
 *
 * Values:
 * - 0 - FlexCAN not in Freeze mode, prescaler running.
 * - 1 - FlexCAN in Freeze mode, prescaler stopped.
 */
/*@{*/
#define BP_CAN_MCR_FRZACK    (24U)         /*!< Bit position for CAN_MCR_FRZACK. */
#define BM_CAN_MCR_FRZACK    (0x01000000U) /*!< Bit mask for CAN_MCR_FRZACK. */
#define BS_CAN_MCR_FRZACK    (1U)          /*!< Bit field size in bits for CAN_MCR_FRZACK. */

/*! @brief Read current value of the CAN_MCR_FRZACK field. */
#define BR_CAN_MCR_FRZACK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_FRZACK)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SOFTRST[25] (RW)
 *
 * When this bit is asserted, FlexCAN resets its internal state machines and
 * some of the memory mapped registers. The following registers are reset: MCR
 * (except the MDIS bit), TIMER , ECR, ESR1, ESR2, IMASK1, IMASK2, IFLAG1, IFLAG2 and
 * CRCR. Configuration registers that control the interface to the CAN bus are
 * not affected by soft reset. The following registers are unaffected: CTRL1,
 * CTRL2, all RXIMR registers, RXMGMASK, RX14MASK, RX15MASK, RXFGMASK, RXFIR, all
 * Message Buffers . The SOFTRST bit can be asserted directly by the CPU when it
 * writes to the MCR Register, but it is also asserted when global soft reset is
 * requested at MCU level . Because soft reset is synchronous and has to follow a
 * request/acknowledge procedure across clock domains, it may take some time to
 * fully propagate its effect. The SOFTRST bit remains asserted while reset is
 * pending, and is automatically negated when reset completes. Therefore, software can
 * poll this bit to know when the soft reset has completed. Soft reset cannot be
 * applied while clocks are shut down in a low power mode. The module should be
 * first removed from low power mode, and then soft reset can be applied.
 *
 * Values:
 * - 0 - No reset request.
 * - 1 - Resets the registers affected by soft reset.
 */
/*@{*/
#define BP_CAN_MCR_SOFTRST   (25U)         /*!< Bit position for CAN_MCR_SOFTRST. */
#define BM_CAN_MCR_SOFTRST   (0x02000000U) /*!< Bit mask for CAN_MCR_SOFTRST. */
#define BS_CAN_MCR_SOFTRST   (1U)          /*!< Bit field size in bits for CAN_MCR_SOFTRST. */

/*! @brief Read current value of the CAN_MCR_SOFTRST field. */
#define BR_CAN_MCR_SOFTRST(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SOFTRST)))

/*! @brief Format value for bitfield CAN_MCR_SOFTRST. */
#define BF_CAN_MCR_SOFTRST(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SOFTRST) & BM_CAN_MCR_SOFTRST)

/*! @brief Set the SOFTRST field to a new value. */
#define BW_CAN_MCR_SOFTRST(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_SOFTRST), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAKMSK[26] (RW)
 *
 * This bit enables the Wake Up Interrupt generation under Self Wake Up
 * mechanism.
 *
 * Values:
 * - 0 - Wake Up Interrupt is disabled.
 * - 1 - Wake Up Interrupt is enabled.
 */
/*@{*/
#define BP_CAN_MCR_WAKMSK    (26U)         /*!< Bit position for CAN_MCR_WAKMSK. */
#define BM_CAN_MCR_WAKMSK    (0x04000000U) /*!< Bit mask for CAN_MCR_WAKMSK. */
#define BS_CAN_MCR_WAKMSK    (1U)          /*!< Bit field size in bits for CAN_MCR_WAKMSK. */

/*! @brief Read current value of the CAN_MCR_WAKMSK field. */
#define BR_CAN_MCR_WAKMSK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WAKMSK)))

/*! @brief Format value for bitfield CAN_MCR_WAKMSK. */
#define BF_CAN_MCR_WAKMSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAKMSK) & BM_CAN_MCR_WAKMSK)

/*! @brief Set the WAKMSK field to a new value. */
#define BW_CAN_MCR_WAKMSK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_WAKMSK), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field NOTRDY[27] (RO)
 *
 * This read-only bit indicates that FlexCAN is either in Disable mode , Stop
 * mode or Freeze mode. It is negated once FlexCAN has exited these modes.
 *
 * Values:
 * - 0 - FlexCAN module is either in Normal mode, Listen-Only mode or Loop-Back
 *     mode.
 * - 1 - FlexCAN module is either in Disable mode , Stop mode or Freeze mode.
 */
/*@{*/
#define BP_CAN_MCR_NOTRDY    (27U)         /*!< Bit position for CAN_MCR_NOTRDY. */
#define BM_CAN_MCR_NOTRDY    (0x08000000U) /*!< Bit mask for CAN_MCR_NOTRDY. */
#define BS_CAN_MCR_NOTRDY    (1U)          /*!< Bit field size in bits for CAN_MCR_NOTRDY. */

/*! @brief Read current value of the CAN_MCR_NOTRDY field. */
#define BR_CAN_MCR_NOTRDY(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_NOTRDY)))
/*@}*/

/*!
 * @name Register CAN_MCR, field HALT[28] (RW)
 *
 * Assertion of this bit puts the FlexCAN module into Freeze mode. The CPU
 * should clear it after initializing the Message Buffers and Control Register. No
 * reception or transmission is performed by FlexCAN before this bit is cleared.
 * Freeze mode cannot be entered while FlexCAN is in a low power mode.
 *
 * Values:
 * - 0 - No Freeze mode request.
 * - 1 - Enters Freeze mode if the FRZ bit is asserted.
 */
/*@{*/
#define BP_CAN_MCR_HALT      (28U)         /*!< Bit position for CAN_MCR_HALT. */
#define BM_CAN_MCR_HALT      (0x10000000U) /*!< Bit mask for CAN_MCR_HALT. */
#define BS_CAN_MCR_HALT      (1U)          /*!< Bit field size in bits for CAN_MCR_HALT. */

/*! @brief Read current value of the CAN_MCR_HALT field. */
#define BR_CAN_MCR_HALT(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_HALT)))

/*! @brief Format value for bitfield CAN_MCR_HALT. */
#define BF_CAN_MCR_HALT(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_HALT) & BM_CAN_MCR_HALT)

/*! @brief Set the HALT field to a new value. */
#define BW_CAN_MCR_HALT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_HALT), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field RFEN[29] (RW)
 *
 * This bit controls whether the Rx FIFO feature is enabled or not. When RFEN is
 * set, MBs 0 to 5 cannot be used for normal reception and transmission because
 * the corresponding memory region (0x80-0xDC) is used by the FIFO engine as well
 * as additional MBs (up to 32, depending on CTRL2[RFFN] setting) which are used
 * as Rx FIFO ID Filter Table elements. RFEN also impacts the definition of the
 * minimum number of peripheral clocks per CAN bit as described in the table
 * "Minimum Ratio Between Peripheral Clock Frequency and CAN Bit Rate" (in section
 * "Arbitration and Matching Timing"). This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Rx FIFO not enabled.
 * - 1 - Rx FIFO enabled.
 */
/*@{*/
#define BP_CAN_MCR_RFEN      (29U)         /*!< Bit position for CAN_MCR_RFEN. */
#define BM_CAN_MCR_RFEN      (0x20000000U) /*!< Bit mask for CAN_MCR_RFEN. */
#define BS_CAN_MCR_RFEN      (1U)          /*!< Bit field size in bits for CAN_MCR_RFEN. */

/*! @brief Read current value of the CAN_MCR_RFEN field. */
#define BR_CAN_MCR_RFEN(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_RFEN)))

/*! @brief Format value for bitfield CAN_MCR_RFEN. */
#define BF_CAN_MCR_RFEN(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_RFEN) & BM_CAN_MCR_RFEN)

/*! @brief Set the RFEN field to a new value. */
#define BW_CAN_MCR_RFEN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_RFEN), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ[30] (RW)
 *
 * The FRZ bit specifies the FlexCAN behavior when the HALT bit in the MCR
 * Register is set or when Debug mode is requested at MCU level . When FRZ is
 * asserted, FlexCAN is enabled to enter Freeze mode. Negation of this bit field causes
 * FlexCAN to exit from Freeze mode.
 *
 * Values:
 * - 0 - Not enabled to enter Freeze mode.
 * - 1 - Enabled to enter Freeze mode.
 */
/*@{*/
#define BP_CAN_MCR_FRZ       (30U)         /*!< Bit position for CAN_MCR_FRZ. */
#define BM_CAN_MCR_FRZ       (0x40000000U) /*!< Bit mask for CAN_MCR_FRZ. */
#define BS_CAN_MCR_FRZ       (1U)          /*!< Bit field size in bits for CAN_MCR_FRZ. */

/*! @brief Read current value of the CAN_MCR_FRZ field. */
#define BR_CAN_MCR_FRZ(x)    (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_FRZ)))

/*! @brief Format value for bitfield CAN_MCR_FRZ. */
#define BF_CAN_MCR_FRZ(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_FRZ) & BM_CAN_MCR_FRZ)

/*! @brief Set the FRZ field to a new value. */
#define BW_CAN_MCR_FRZ(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_FRZ), v))
/*@}*/

/*!
 * @name Register CAN_MCR, field MDIS[31] (RW)
 *
 * This bit controls whether FlexCAN is enabled or not. When disabled, FlexCAN
 * disables the clocks to the CAN Protocol Engine and Controller Host Interface
 * sub-modules. This is the only bit within this register not affected by soft
 * reset.
 *
 * Values:
 * - 0 - Enable the FlexCAN module.
 * - 1 - Disable the FlexCAN module.
 */
/*@{*/
#define BP_CAN_MCR_MDIS      (31U)         /*!< Bit position for CAN_MCR_MDIS. */
#define BM_CAN_MCR_MDIS      (0x80000000U) /*!< Bit mask for CAN_MCR_MDIS. */
#define BS_CAN_MCR_MDIS      (1U)          /*!< Bit field size in bits for CAN_MCR_MDIS. */

/*! @brief Read current value of the CAN_MCR_MDIS field. */
#define BR_CAN_MCR_MDIS(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_MDIS)))

/*! @brief Format value for bitfield CAN_MCR_MDIS. */
#define BF_CAN_MCR_MDIS(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MDIS) & BM_CAN_MCR_MDIS)

/*! @brief Set the MDIS field to a new value. */
#define BW_CAN_MCR_MDIS(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_MCR_ADDR(x), BP_CAN_MCR_MDIS), v))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL1 - Control 1 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL1 - Control 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is defined for specific FlexCAN control features related to the
 * CAN bus, such as bit-rate, programmable sampling point within an Rx bit, Loop
 * Back mode, Listen-Only mode, Bus Off recovery behavior and interrupt enabling
 * (Bus-Off, Error, Warning). It also determines the Division Factor for the
 * clock prescaler.
 */
typedef union _hw_can_ctrl1
{
    uint32_t U;
    struct _hw_can_ctrl1_bitfields
    {
        uint32_t PROPSEG : 3;          /*!< [2:0] Propagation Segment */
        uint32_t LOM : 1;              /*!< [3] Listen-Only Mode */
        uint32_t LBUF : 1;             /*!< [4] Lowest Buffer Transmitted First */
        uint32_t TSYN : 1;             /*!< [5] Timer Sync */
        uint32_t BOFFREC : 1;          /*!< [6] Bus Off Recovery */
        uint32_t SMP : 1;              /*!< [7] CAN Bit Sampling */
        uint32_t RESERVED0 : 2;        /*!< [9:8]  */
        uint32_t RWRNMSK : 1;          /*!< [10] Rx Warning Interrupt Mask */
        uint32_t TWRNMSK : 1;          /*!< [11] Tx Warning Interrupt Mask */
        uint32_t LPB : 1;              /*!< [12] Loop Back Mode */
        uint32_t CLKSRC : 1;           /*!< [13] CAN Engine Clock Source */
        uint32_t ERRMSK : 1;           /*!< [14] Error Mask */
        uint32_t BOFFMSK : 1;          /*!< [15] Bus Off Mask */
        uint32_t PSEG2 : 3;            /*!< [18:16] Phase Segment 2 */
        uint32_t PSEG1 : 3;            /*!< [21:19] Phase Segment 1 */
        uint32_t RJW : 2;              /*!< [23:22] Resync Jump Width */
        uint32_t PRESDIV : 8;          /*!< [31:24] Prescaler Division Factor */
    } B;
} hw_can_ctrl1_t;

/*!
 * @name Constants and macros for entire CAN_CTRL1 register
 */
/*@{*/
#define HW_CAN_CTRL1_ADDR(x)     ((x) + 0x4U)

#define HW_CAN_CTRL1(x)          (*(__IO hw_can_ctrl1_t *) HW_CAN_CTRL1_ADDR(x))
#define HW_CAN_CTRL1_RD(x)       (ADDRESS_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x)))
#define HW_CAN_CTRL1_WR(x, v)    (ADDRESS_WRITE(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), v))
#define HW_CAN_CTRL1_SET(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) |  (v)))
#define HW_CAN_CTRL1_CLR(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) & ~(v)))
#define HW_CAN_CTRL1_TOG(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL1 bitfields
 */

/*!
 * @name Register CAN_CTRL1, field PROPSEG[2:0] (RW)
 *
 * This 3-bit field defines the length of the Propagation Segment in the bit
 * time. The valid programmable values are 0-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Propagation
 * Segment Time = (PROPSEG + 1) * Time-Quanta. Time-Quantum = one Sclock period.
 */
/*@{*/
#define BP_CAN_CTRL1_PROPSEG (0U)          /*!< Bit position for CAN_CTRL1_PROPSEG. */
#define BM_CAN_CTRL1_PROPSEG (0x00000007U) /*!< Bit mask for CAN_CTRL1_PROPSEG. */
#define BS_CAN_CTRL1_PROPSEG (3U)          /*!< Bit field size in bits for CAN_CTRL1_PROPSEG. */

/*! @brief Read current value of the CAN_CTRL1_PROPSEG field. */
#define BR_CAN_CTRL1_PROPSEG(x) (UNION_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), U, B.PROPSEG))

/*! @brief Format value for bitfield CAN_CTRL1_PROPSEG. */
#define BF_CAN_CTRL1_PROPSEG(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PROPSEG) & BM_CAN_CTRL1_PROPSEG)

/*! @brief Set the PROPSEG field to a new value. */
#define BW_CAN_CTRL1_PROPSEG(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PROPSEG) | BF_CAN_CTRL1_PROPSEG(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LOM[3] (RW)
 *
 * This bit configures FlexCAN to operate in Listen-Only mode. In this mode,
 * transmission is disabled, all error counters are frozen and the module operates
 * in a CAN Error Passive mode. Only messages acknowledged by another CAN station
 * will be received. If FlexCAN detects a message that has not been acknowledged,
 * it will flag a BIT0 error without changing the REC, as if it was trying to
 * acknowledge the message. Listen-Only mode acknowledgement can be obtained by the
 * state of ESR1[FLTCONF] field which is Passive Error when Listen-Only mode is
 * entered. There can be some delay between the Listen-Only mode request and
 * acknowledge. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 0 - Listen-Only mode is deactivated.
 * - 1 - FlexCAN module operates in Listen-Only mode.
 */
/*@{*/
#define BP_CAN_CTRL1_LOM     (3U)          /*!< Bit position for CAN_CTRL1_LOM. */
#define BM_CAN_CTRL1_LOM     (0x00000008U) /*!< Bit mask for CAN_CTRL1_LOM. */
#define BS_CAN_CTRL1_LOM     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LOM. */

/*! @brief Read current value of the CAN_CTRL1_LOM field. */
#define BR_CAN_CTRL1_LOM(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LOM)))

/*! @brief Format value for bitfield CAN_CTRL1_LOM. */
#define BF_CAN_CTRL1_LOM(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LOM) & BM_CAN_CTRL1_LOM)

/*! @brief Set the LOM field to a new value. */
#define BW_CAN_CTRL1_LOM(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LOM), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LBUF[4] (RW)
 *
 * This bit defines the ordering mechanism for Message Buffer transmission. When
 * asserted, the LPRIOEN bit does not affect the priority arbitration. This bit
 * can be written only in Freeze mode because it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 0 - Buffer with highest priority is transmitted first.
 * - 1 - Lowest number buffer is transmitted first.
 */
/*@{*/
#define BP_CAN_CTRL1_LBUF    (4U)          /*!< Bit position for CAN_CTRL1_LBUF. */
#define BM_CAN_CTRL1_LBUF    (0x00000010U) /*!< Bit mask for CAN_CTRL1_LBUF. */
#define BS_CAN_CTRL1_LBUF    (1U)          /*!< Bit field size in bits for CAN_CTRL1_LBUF. */

/*! @brief Read current value of the CAN_CTRL1_LBUF field. */
#define BR_CAN_CTRL1_LBUF(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LBUF)))

/*! @brief Format value for bitfield CAN_CTRL1_LBUF. */
#define BF_CAN_CTRL1_LBUF(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LBUF) & BM_CAN_CTRL1_LBUF)

/*! @brief Set the LBUF field to a new value. */
#define BW_CAN_CTRL1_LBUF(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LBUF), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TSYN[5] (RW)
 *
 * This bit enables a mechanism that resets the free-running timer each time a
 * message is received in Message Buffer 0. This feature provides means to
 * synchronize multiple FlexCAN stations with a special "SYNC" message, that is, global
 * network time. If the RFEN bit in MCR is set (Rx FIFO enabled), the first
 * available Mailbox, according to CTRL2[RFFN] setting, is used for timer
 * synchronization instead of MB0. This bit can be written only in Freeze mode because it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Timer Sync feature disabled
 * - 1 - Timer Sync feature enabled
 */
/*@{*/
#define BP_CAN_CTRL1_TSYN    (5U)          /*!< Bit position for CAN_CTRL1_TSYN. */
#define BM_CAN_CTRL1_TSYN    (0x00000020U) /*!< Bit mask for CAN_CTRL1_TSYN. */
#define BS_CAN_CTRL1_TSYN    (1U)          /*!< Bit field size in bits for CAN_CTRL1_TSYN. */

/*! @brief Read current value of the CAN_CTRL1_TSYN field. */
#define BR_CAN_CTRL1_TSYN(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_TSYN)))

/*! @brief Format value for bitfield CAN_CTRL1_TSYN. */
#define BF_CAN_CTRL1_TSYN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TSYN) & BM_CAN_CTRL1_TSYN)

/*! @brief Set the TSYN field to a new value. */
#define BW_CAN_CTRL1_TSYN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_TSYN), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFFREC[6] (RW)
 *
 * This bit defines how FlexCAN recovers from Bus Off state. If this bit is
 * negated, automatic recovering from Bus Off state occurs according to the CAN
 * Specification 2.0B. If the bit is asserted, automatic recovering from Bus Off is
 * disabled and the module remains in Bus Off state until the bit is negated by the
 * user. If the negation occurs before 128 sequences of 11 recessive bits are
 * detected on the CAN bus, then Bus Off recovery happens as if the BOFFREC bit had
 * never been asserted. If the negation occurs after 128 sequences of 11
 * recessive bits occurred, then FlexCAN will re-synchronize to the bus by waiting for
 * 11 recessive bits before joining the bus. After negation, the BOFFREC bit can
 * be re-asserted again during Bus Off, but it will be effective only the next
 * time the module enters Bus Off. If BOFFREC was negated when the module entered
 * Bus Off, asserting it during Bus Off will not be effective for the current Bus
 * Off recovery.
 *
 * Values:
 * - 0 - Automatic recovering from Bus Off state enabled, according to CAN Spec
 *     2.0 part B.
 * - 1 - Automatic recovering from Bus Off state disabled.
 */
/*@{*/
#define BP_CAN_CTRL1_BOFFREC (6U)          /*!< Bit position for CAN_CTRL1_BOFFREC. */
#define BM_CAN_CTRL1_BOFFREC (0x00000040U) /*!< Bit mask for CAN_CTRL1_BOFFREC. */
#define BS_CAN_CTRL1_BOFFREC (1U)          /*!< Bit field size in bits for CAN_CTRL1_BOFFREC. */

/*! @brief Read current value of the CAN_CTRL1_BOFFREC field. */
#define BR_CAN_CTRL1_BOFFREC(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_BOFFREC)))

/*! @brief Format value for bitfield CAN_CTRL1_BOFFREC. */
#define BF_CAN_CTRL1_BOFFREC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFFREC) & BM_CAN_CTRL1_BOFFREC)

/*! @brief Set the BOFFREC field to a new value. */
#define BW_CAN_CTRL1_BOFFREC(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_BOFFREC), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field SMP[7] (RW)
 *
 * This bit defines the sampling mode of CAN bits at the Rx input. This bit can
 * be written only in Freeze mode because it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 0 - Just one sample is used to determine the bit value.
 * - 1 - Three samples are used to determine the value of the received bit: the
 *     regular one (sample point) and 2 preceding samples; a majority rule is
 *     used.
 */
/*@{*/
#define BP_CAN_CTRL1_SMP     (7U)          /*!< Bit position for CAN_CTRL1_SMP. */
#define BM_CAN_CTRL1_SMP     (0x00000080U) /*!< Bit mask for CAN_CTRL1_SMP. */
#define BS_CAN_CTRL1_SMP     (1U)          /*!< Bit field size in bits for CAN_CTRL1_SMP. */

/*! @brief Read current value of the CAN_CTRL1_SMP field. */
#define BR_CAN_CTRL1_SMP(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_SMP)))

/*! @brief Format value for bitfield CAN_CTRL1_SMP. */
#define BF_CAN_CTRL1_SMP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_SMP) & BM_CAN_CTRL1_SMP)

/*! @brief Set the SMP field to a new value. */
#define BW_CAN_CTRL1_SMP(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_SMP), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RWRNMSK[10] (RW)
 *
 * This bit provides a mask for the Rx Warning Interrupt associated with the
 * RWRNINT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRNEN] bit is negated. This bit can be written only if MCR[WRNEN] bit is
 * asserted.
 *
 * Values:
 * - 0 - Rx Warning Interrupt disabled.
 * - 1 - Rx Warning Interrupt enabled.
 */
/*@{*/
#define BP_CAN_CTRL1_RWRNMSK (10U)         /*!< Bit position for CAN_CTRL1_RWRNMSK. */
#define BM_CAN_CTRL1_RWRNMSK (0x00000400U) /*!< Bit mask for CAN_CTRL1_RWRNMSK. */
#define BS_CAN_CTRL1_RWRNMSK (1U)          /*!< Bit field size in bits for CAN_CTRL1_RWRNMSK. */

/*! @brief Read current value of the CAN_CTRL1_RWRNMSK field. */
#define BR_CAN_CTRL1_RWRNMSK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_RWRNMSK)))

/*! @brief Format value for bitfield CAN_CTRL1_RWRNMSK. */
#define BF_CAN_CTRL1_RWRNMSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RWRNMSK) & BM_CAN_CTRL1_RWRNMSK)

/*! @brief Set the RWRNMSK field to a new value. */
#define BW_CAN_CTRL1_RWRNMSK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_RWRNMSK), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TWRNMSK[11] (RW)
 *
 * This bit provides a mask for the Tx Warning Interrupt associated with the
 * TWRNINT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRNEN] bit is negated. This bit can be written only if MCR[WRNEN] bit is
 * asserted.
 *
 * Values:
 * - 0 - Tx Warning Interrupt disabled.
 * - 1 - Tx Warning Interrupt enabled.
 */
/*@{*/
#define BP_CAN_CTRL1_TWRNMSK (11U)         /*!< Bit position for CAN_CTRL1_TWRNMSK. */
#define BM_CAN_CTRL1_TWRNMSK (0x00000800U) /*!< Bit mask for CAN_CTRL1_TWRNMSK. */
#define BS_CAN_CTRL1_TWRNMSK (1U)          /*!< Bit field size in bits for CAN_CTRL1_TWRNMSK. */

/*! @brief Read current value of the CAN_CTRL1_TWRNMSK field. */
#define BR_CAN_CTRL1_TWRNMSK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_TWRNMSK)))

/*! @brief Format value for bitfield CAN_CTRL1_TWRNMSK. */
#define BF_CAN_CTRL1_TWRNMSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TWRNMSK) & BM_CAN_CTRL1_TWRNMSK)

/*! @brief Set the TWRNMSK field to a new value. */
#define BW_CAN_CTRL1_TWRNMSK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_TWRNMSK), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LPB[12] (RW)
 *
 * This bit configures FlexCAN to operate in Loop-Back mode. In this mode,
 * FlexCAN performs an internal loop back that can be used for self test operation.
 * The bit stream output of the transmitter is fed back internally to the receiver
 * input. The Rx CAN input pin is ignored and the Tx CAN output goes to the
 * recessive state (logic 1). FlexCAN behaves as it normally does when transmitting,
 * and treats its own transmitted message as a message received from a remote
 * node. In this mode, FlexCAN ignores the bit sent during the ACK slot in the CAN
 * frame acknowledge field, generating an internal acknowledge bit to ensure proper
 * reception of its own message. Both transmit and receive interrupts are
 * generated. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes. In this mode, the MCR[SRXDIS] cannot be asserted because
 * this will impede the self reception of a transmitted message.
 *
 * Values:
 * - 0 - Loop Back disabled.
 * - 1 - Loop Back enabled.
 */
/*@{*/
#define BP_CAN_CTRL1_LPB     (12U)         /*!< Bit position for CAN_CTRL1_LPB. */
#define BM_CAN_CTRL1_LPB     (0x00001000U) /*!< Bit mask for CAN_CTRL1_LPB. */
#define BS_CAN_CTRL1_LPB     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LPB. */

/*! @brief Read current value of the CAN_CTRL1_LPB field. */
#define BR_CAN_CTRL1_LPB(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LPB)))

/*! @brief Format value for bitfield CAN_CTRL1_LPB. */
#define BF_CAN_CTRL1_LPB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LPB) & BM_CAN_CTRL1_LPB)

/*! @brief Set the LPB field to a new value. */
#define BW_CAN_CTRL1_LPB(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_LPB), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field CLKSRC[13] (RW)
 *
 * This bit selects the clock source to the CAN Protocol Engine (PE) to be
 * either the peripheral clock (driven by the PLL) or the crystal oscillator clock.
 * The selected clock is the one fed to the prescaler to generate the Serial Clock
 * (Sclock). In order to guarantee reliable operation, this bit can be written
 * only in Disable mode because it is blocked by hardware in other modes. See
 * Section "Protocol Timing".
 *
 * Values:
 * - 0 - The CAN engine clock source is the oscillator clock. Under this
 *     condition, the oscillator clock frequency must be lower than the bus clock.
 * - 1 - The CAN engine clock source is the peripheral clock.
 */
/*@{*/
#define BP_CAN_CTRL1_CLKSRC  (13U)         /*!< Bit position for CAN_CTRL1_CLKSRC. */
#define BM_CAN_CTRL1_CLKSRC  (0x00002000U) /*!< Bit mask for CAN_CTRL1_CLKSRC. */
#define BS_CAN_CTRL1_CLKSRC  (1U)          /*!< Bit field size in bits for CAN_CTRL1_CLKSRC. */

/*! @brief Read current value of the CAN_CTRL1_CLKSRC field. */
#define BR_CAN_CTRL1_CLKSRC(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_CLKSRC)))

/*! @brief Format value for bitfield CAN_CTRL1_CLKSRC. */
#define BF_CAN_CTRL1_CLKSRC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_CLKSRC) & BM_CAN_CTRL1_CLKSRC)

/*! @brief Set the CLKSRC field to a new value. */
#define BW_CAN_CTRL1_CLKSRC(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_CLKSRC), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field ERRMSK[14] (RW)
 *
 * This bit provides a mask for the Error Interrupt.
 *
 * Values:
 * - 0 - Error interrupt disabled.
 * - 1 - Error interrupt enabled.
 */
/*@{*/
#define BP_CAN_CTRL1_ERRMSK  (14U)         /*!< Bit position for CAN_CTRL1_ERRMSK. */
#define BM_CAN_CTRL1_ERRMSK  (0x00004000U) /*!< Bit mask for CAN_CTRL1_ERRMSK. */
#define BS_CAN_CTRL1_ERRMSK  (1U)          /*!< Bit field size in bits for CAN_CTRL1_ERRMSK. */

/*! @brief Read current value of the CAN_CTRL1_ERRMSK field. */
#define BR_CAN_CTRL1_ERRMSK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_ERRMSK)))

/*! @brief Format value for bitfield CAN_CTRL1_ERRMSK. */
#define BF_CAN_CTRL1_ERRMSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_ERRMSK) & BM_CAN_CTRL1_ERRMSK)

/*! @brief Set the ERRMSK field to a new value. */
#define BW_CAN_CTRL1_ERRMSK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_ERRMSK), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFFMSK[15] (RW)
 *
 * This bit provides a mask for the Bus Off Interrupt.
 *
 * Values:
 * - 0 - Bus Off interrupt disabled.
 * - 1 - Bus Off interrupt enabled.
 */
/*@{*/
#define BP_CAN_CTRL1_BOFFMSK (15U)         /*!< Bit position for CAN_CTRL1_BOFFMSK. */
#define BM_CAN_CTRL1_BOFFMSK (0x00008000U) /*!< Bit mask for CAN_CTRL1_BOFFMSK. */
#define BS_CAN_CTRL1_BOFFMSK (1U)          /*!< Bit field size in bits for CAN_CTRL1_BOFFMSK. */

/*! @brief Read current value of the CAN_CTRL1_BOFFMSK field. */
#define BR_CAN_CTRL1_BOFFMSK(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_BOFFMSK)))

/*! @brief Format value for bitfield CAN_CTRL1_BOFFMSK. */
#define BF_CAN_CTRL1_BOFFMSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFFMSK) & BM_CAN_CTRL1_BOFFMSK)

/*! @brief Set the BOFFMSK field to a new value. */
#define BW_CAN_CTRL1_BOFFMSK(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL1_ADDR(x), BP_CAN_CTRL1_BOFFMSK), v))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG2[18:16] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 2 in the bit
 * time. The valid programmable values are 1-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Phase Buffer
 * Segment 2 = (PSEG2 + 1) * Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG2   (16U)         /*!< Bit position for CAN_CTRL1_PSEG2. */
#define BM_CAN_CTRL1_PSEG2   (0x00070000U) /*!< Bit mask for CAN_CTRL1_PSEG2. */
#define BS_CAN_CTRL1_PSEG2   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG2. */

/*! @brief Read current value of the CAN_CTRL1_PSEG2 field. */
#define BR_CAN_CTRL1_PSEG2(x) (UNION_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), U, B.PSEG2))

/*! @brief Format value for bitfield CAN_CTRL1_PSEG2. */
#define BF_CAN_CTRL1_PSEG2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG2) & BM_CAN_CTRL1_PSEG2)

/*! @brief Set the PSEG2 field to a new value. */
#define BW_CAN_CTRL1_PSEG2(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG2) | BF_CAN_CTRL1_PSEG2(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG1[21:19] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 1 in the bit
 * time. The valid programmable values are 0-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Phase Buffer
 * Segment 1 = (PSEG1 + 1) * Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG1   (19U)         /*!< Bit position for CAN_CTRL1_PSEG1. */
#define BM_CAN_CTRL1_PSEG1   (0x00380000U) /*!< Bit mask for CAN_CTRL1_PSEG1. */
#define BS_CAN_CTRL1_PSEG1   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG1. */

/*! @brief Read current value of the CAN_CTRL1_PSEG1 field. */
#define BR_CAN_CTRL1_PSEG1(x) (UNION_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), U, B.PSEG1))

/*! @brief Format value for bitfield CAN_CTRL1_PSEG1. */
#define BF_CAN_CTRL1_PSEG1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG1) & BM_CAN_CTRL1_PSEG1)

/*! @brief Set the PSEG1 field to a new value. */
#define BW_CAN_CTRL1_PSEG1(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG1) | BF_CAN_CTRL1_PSEG1(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RJW[23:22] (RW)
 *
 * This 2-bit field defines the maximum number of time quanta that a bit time
 * can be changed by one re-synchronization. One time quantum is equal to the
 * Sclock period. The valid programmable values are 0-3. This field can be written
 * only in Freeze mode because it is blocked by hardware in other modes. Resync Jump
 * Width = RJW + 1.
 */
/*@{*/
#define BP_CAN_CTRL1_RJW     (22U)         /*!< Bit position for CAN_CTRL1_RJW. */
#define BM_CAN_CTRL1_RJW     (0x00C00000U) /*!< Bit mask for CAN_CTRL1_RJW. */
#define BS_CAN_CTRL1_RJW     (2U)          /*!< Bit field size in bits for CAN_CTRL1_RJW. */

/*! @brief Read current value of the CAN_CTRL1_RJW field. */
#define BR_CAN_CTRL1_RJW(x)  (UNION_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), U, B.RJW))

/*! @brief Format value for bitfield CAN_CTRL1_RJW. */
#define BF_CAN_CTRL1_RJW(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RJW) & BM_CAN_CTRL1_RJW)

/*! @brief Set the RJW field to a new value. */
#define BW_CAN_CTRL1_RJW(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_RJW) | BF_CAN_CTRL1_RJW(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PRESDIV[31:24] (RW)
 *
 * This 8-bit field defines the ratio between the PE clock frequency and the
 * Serial Clock (Sclock) frequency. The Sclock period defines the time quantum of
 * the CAN protocol. For the reset value, the Sclock frequency is equal to the PE
 * clock frequency. The Maximum value of this field is 0xFF, that gives a minimum
 * Sclock frequency equal to the PE clock frequency divided by 256. See Section
 * "Protocol Timing". This field can be written only in Freeze mode because it is
 * blocked by hardware in other modes. Sclock frequency = PE clock frequency /
 * (PRESDIV + 1)
 */
/*@{*/
#define BP_CAN_CTRL1_PRESDIV (24U)         /*!< Bit position for CAN_CTRL1_PRESDIV. */
#define BM_CAN_CTRL1_PRESDIV (0xFF000000U) /*!< Bit mask for CAN_CTRL1_PRESDIV. */
#define BS_CAN_CTRL1_PRESDIV (8U)          /*!< Bit field size in bits for CAN_CTRL1_PRESDIV. */

/*! @brief Read current value of the CAN_CTRL1_PRESDIV field. */
#define BR_CAN_CTRL1_PRESDIV(x) (UNION_READ(hw_can_ctrl1_t, HW_CAN_CTRL1_ADDR(x), U, B.PRESDIV))

/*! @brief Format value for bitfield CAN_CTRL1_PRESDIV. */
#define BF_CAN_CTRL1_PRESDIV(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PRESDIV) & BM_CAN_CTRL1_PRESDIV)

/*! @brief Set the PRESDIV field to a new value. */
#define BW_CAN_CTRL1_PRESDIV(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PRESDIV) | BF_CAN_CTRL1_PRESDIV(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_TIMER - Free Running Timer
 ******************************************************************************/

/*!
 * @brief HW_CAN_TIMER - Free Running Timer (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register represents a 16-bit free running counter that can be read and
 * written by the CPU. The timer starts from 0x0 after Reset, counts linearly to
 * 0xFFFF, and wraps around. The timer is clocked by the FlexCAN bit-clock, which
 * defines the baud rate on the CAN bus. During a message transmission/reception,
 * it increments by one for each bit that is received or transmitted. When there
 * is no message on the bus, it counts using the previously programmed baud
 * rate. The timer is not incremented during Disable , Stop, and Freeze modes. The
 * timer value is captured when the second bit of the identifier field of any frame
 * is on the CAN bus. This captured value is written into the Time Stamp entry
 * in a message buffer after a successful reception or transmission of a message.
 * If bit CTRL1[TSYN] is asserted, the Timer is reset whenever a message is
 * received in the first available Mailbox, according to CTRL2[RFFN] setting. The CPU
 * can write to this register anytime. However, if the write occurs at the same
 * time that the Timer is being reset by a reception in the first Mailbox, then
 * the write value is discarded. Reading this register affects the Mailbox
 * Unlocking procedure; see Section "Mailbox Lock Mechanism".
 */
typedef union _hw_can_timer
{
    uint32_t U;
    struct _hw_can_timer_bitfields
    {
        uint32_t TIMER : 16;           /*!< [15:0] Timer Value */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_timer_t;

/*!
 * @name Constants and macros for entire CAN_TIMER register
 */
/*@{*/
#define HW_CAN_TIMER_ADDR(x)     ((x) + 0x8U)

#define HW_CAN_TIMER(x)          (*(__IO hw_can_timer_t *) HW_CAN_TIMER_ADDR(x))
#define HW_CAN_TIMER_RD(x)       (ADDRESS_READ(hw_can_timer_t, HW_CAN_TIMER_ADDR(x)))
#define HW_CAN_TIMER_WR(x, v)    (ADDRESS_WRITE(hw_can_timer_t, HW_CAN_TIMER_ADDR(x), v))
#define HW_CAN_TIMER_SET(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) |  (v)))
#define HW_CAN_TIMER_CLR(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) & ~(v)))
#define HW_CAN_TIMER_TOG(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_TIMER bitfields
 */

/*!
 * @name Register CAN_TIMER, field TIMER[15:0] (RW)
 *
 * Contains the free-running counter value.
 */
/*@{*/
#define BP_CAN_TIMER_TIMER   (0U)          /*!< Bit position for CAN_TIMER_TIMER. */
#define BM_CAN_TIMER_TIMER   (0x0000FFFFU) /*!< Bit mask for CAN_TIMER_TIMER. */
#define BS_CAN_TIMER_TIMER   (16U)         /*!< Bit field size in bits for CAN_TIMER_TIMER. */

/*! @brief Read current value of the CAN_TIMER_TIMER field. */
#define BR_CAN_TIMER_TIMER(x) (UNION_READ(hw_can_timer_t, HW_CAN_TIMER_ADDR(x), U, B.TIMER))

/*! @brief Format value for bitfield CAN_TIMER_TIMER. */
#define BF_CAN_TIMER_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_CAN_TIMER_TIMER) & BM_CAN_TIMER_TIMER)

/*! @brief Set the TIMER field to a new value. */
#define BW_CAN_TIMER_TIMER(x, v) (HW_CAN_TIMER_WR(x, (HW_CAN_TIMER_RD(x) & ~BM_CAN_TIMER_TIMER) | BF_CAN_TIMER_TIMER(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RXMGMASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is negated, RXMGMASK is always in effect. When
 * the MCR[IRMQ] bit is asserted, RXMGMASK has no effect. RXMGMASK is used to
 * mask the filter fields of all Rx MBs, excluding MBs 14-15, which have individual
 * mask registers. This register can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 */
typedef union _hw_can_rxmgmask
{
    uint32_t U;
    struct _hw_can_rxmgmask_bitfields
    {
        uint32_t MG : 32;              /*!< [31:0] Rx Mailboxes Global Mask Bits */
    } B;
} hw_can_rxmgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXMGMASK register
 */
/*@{*/
#define HW_CAN_RXMGMASK_ADDR(x)  ((x) + 0x10U)

#define HW_CAN_RXMGMASK(x)       (*(__IO hw_can_rxmgmask_t *) HW_CAN_RXMGMASK_ADDR(x))
#define HW_CAN_RXMGMASK_RD(x)    (ADDRESS_READ(hw_can_rxmgmask_t, HW_CAN_RXMGMASK_ADDR(x)))
#define HW_CAN_RXMGMASK_WR(x, v) (ADDRESS_WRITE(hw_can_rxmgmask_t, HW_CAN_RXMGMASK_ADDR(x), v))
#define HW_CAN_RXMGMASK_SET(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) |  (v)))
#define HW_CAN_RXMGMASK_CLR(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) & ~(v)))
#define HW_CAN_RXMGMASK_TOG(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXMGMASK bitfields
 */

/*!
 * @name Register CAN_RXMGMASK, field MG[31:0] (RW)
 *
 * These bits mask the Mailbox filter bits. Note that the alignment with the ID
 * word of the Mailbox is not perfect as the two most significant MG bits affect
 * the fields RTR and IDE, which are located in the Control and Status word of
 * the Mailbox. The following table shows in detail which MG bits mask each Mailbox
 * filter field. SMB[RTR] RTR bit of the Incoming Frame. It is saved into an
 * auxiliary MB called Rx Serial Message Buffer (Rx SMB). CTRL2[RRS] CTRL2[EACEN]
 * Mailbox filter fields MB[RTR] MB[IDE] MB[ID] Reserved 0 - 0 note If the
 * CTRL2[EACEN] bit is negated, the RTR bit of Mailbox is never compared with the RTR bit
 * of the incoming frame. note If the CTRL2[EACEN] bit is negated, the IDE bit
 * of Mailbox is always compared with the IDE bit of the incoming frame. MG[28:0]
 * MG[31:29] 0 - 1 MG[31] MG[30] MG[28:0] MG[29] 1 0 - - - - MG[31:0] 1 1 0 - -
 * MG[28:0] MG[31:29] 1 1 1 MG[31] MG[30] MG[28:0] MG[29]
 *
 * Values:
 * - 0 - The corresponding bit in the filter is "don't care."
 * - 1 - The corresponding bit in the filter is checked.
 */
/*@{*/
#define BP_CAN_RXMGMASK_MG   (0U)          /*!< Bit position for CAN_RXMGMASK_MG. */
#define BM_CAN_RXMGMASK_MG   (0xFFFFFFFFU) /*!< Bit mask for CAN_RXMGMASK_MG. */
#define BS_CAN_RXMGMASK_MG   (32U)         /*!< Bit field size in bits for CAN_RXMGMASK_MG. */

/*! @brief Read current value of the CAN_RXMGMASK_MG field. */
#define BR_CAN_RXMGMASK_MG(x) (HW_CAN_RXMGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXMGMASK_MG. */
#define BF_CAN_RXMGMASK_MG(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXMGMASK_MG) & BM_CAN_RXMGMASK_MG)

/*! @brief Set the MG field to a new value. */
#define BW_CAN_RXMGMASK_MG(x, v) (HW_CAN_RXMGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX14MASK - Rx 14 Mask register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX14MASK - Rx 14 Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RX14MASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is asserted, RX14MASK has no effect. RX14MASK
 * is used to mask the filter fields of Message Buffer 14. This register can only
 * be programmed while the module is in Freeze mode as it is blocked by hardware
 * in other modes.
 */
typedef union _hw_can_rx14mask
{
    uint32_t U;
    struct _hw_can_rx14mask_bitfields
    {
        uint32_t RX14M : 32;           /*!< [31:0] Rx Buffer 14 Mask Bits */
    } B;
} hw_can_rx14mask_t;

/*!
 * @name Constants and macros for entire CAN_RX14MASK register
 */
/*@{*/
#define HW_CAN_RX14MASK_ADDR(x)  ((x) + 0x14U)

#define HW_CAN_RX14MASK(x)       (*(__IO hw_can_rx14mask_t *) HW_CAN_RX14MASK_ADDR(x))
#define HW_CAN_RX14MASK_RD(x)    (ADDRESS_READ(hw_can_rx14mask_t, HW_CAN_RX14MASK_ADDR(x)))
#define HW_CAN_RX14MASK_WR(x, v) (ADDRESS_WRITE(hw_can_rx14mask_t, HW_CAN_RX14MASK_ADDR(x), v))
#define HW_CAN_RX14MASK_SET(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) |  (v)))
#define HW_CAN_RX14MASK_CLR(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) & ~(v)))
#define HW_CAN_RX14MASK_TOG(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX14MASK bitfields
 */

/*!
 * @name Register CAN_RX14MASK, field RX14M[31:0] (RW)
 *
 * Each mask bit masks the corresponding Mailbox 14 filter field in the same way
 * that RXMGMASK masks other Mailboxes' filters. See the description of the
 * CAN_RXMGMASK register.
 *
 * Values:
 * - 0 - The corresponding bit in the filter is "don't care."
 * - 1 - The corresponding bit in the filter is checked.
 */
/*@{*/
#define BP_CAN_RX14MASK_RX14M (0U)         /*!< Bit position for CAN_RX14MASK_RX14M. */
#define BM_CAN_RX14MASK_RX14M (0xFFFFFFFFU) /*!< Bit mask for CAN_RX14MASK_RX14M. */
#define BS_CAN_RX14MASK_RX14M (32U)        /*!< Bit field size in bits for CAN_RX14MASK_RX14M. */

/*! @brief Read current value of the CAN_RX14MASK_RX14M field. */
#define BR_CAN_RX14MASK_RX14M(x) (HW_CAN_RX14MASK(x).U)

/*! @brief Format value for bitfield CAN_RX14MASK_RX14M. */
#define BF_CAN_RX14MASK_RX14M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX14MASK_RX14M) & BM_CAN_RX14MASK_RX14M)

/*! @brief Set the RX14M field to a new value. */
#define BW_CAN_RX14MASK_RX14M(x, v) (HW_CAN_RX14MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX15MASK - Rx 15 Mask register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX15MASK - Rx 15 Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RX15MASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is asserted, RX15MASK has no effect. RX15MASK
 * is used to mask the filter fields of Message Buffer 15. This register can be
 * programmed only while the module is in Freeze mode because it is blocked by
 * hardware in other modes.
 */
typedef union _hw_can_rx15mask
{
    uint32_t U;
    struct _hw_can_rx15mask_bitfields
    {
        uint32_t RX15M : 32;           /*!< [31:0] Rx Buffer 15 Mask Bits */
    } B;
} hw_can_rx15mask_t;

/*!
 * @name Constants and macros for entire CAN_RX15MASK register
 */
/*@{*/
#define HW_CAN_RX15MASK_ADDR(x)  ((x) + 0x18U)

#define HW_CAN_RX15MASK(x)       (*(__IO hw_can_rx15mask_t *) HW_CAN_RX15MASK_ADDR(x))
#define HW_CAN_RX15MASK_RD(x)    (ADDRESS_READ(hw_can_rx15mask_t, HW_CAN_RX15MASK_ADDR(x)))
#define HW_CAN_RX15MASK_WR(x, v) (ADDRESS_WRITE(hw_can_rx15mask_t, HW_CAN_RX15MASK_ADDR(x), v))
#define HW_CAN_RX15MASK_SET(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) |  (v)))
#define HW_CAN_RX15MASK_CLR(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) & ~(v)))
#define HW_CAN_RX15MASK_TOG(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX15MASK bitfields
 */

/*!
 * @name Register CAN_RX15MASK, field RX15M[31:0] (RW)
 *
 * Each mask bit masks the corresponding Mailbox 15 filter field in the same way
 * that RXMGMASK masks other Mailboxes' filters. See the description of the
 * CAN_RXMGMASK register.
 *
 * Values:
 * - 0 - The corresponding bit in the filter is "don't care."
 * - 1 - The corresponding bit in the filter is checked.
 */
/*@{*/
#define BP_CAN_RX15MASK_RX15M (0U)         /*!< Bit position for CAN_RX15MASK_RX15M. */
#define BM_CAN_RX15MASK_RX15M (0xFFFFFFFFU) /*!< Bit mask for CAN_RX15MASK_RX15M. */
#define BS_CAN_RX15MASK_RX15M (32U)        /*!< Bit field size in bits for CAN_RX15MASK_RX15M. */

/*! @brief Read current value of the CAN_RX15MASK_RX15M field. */
#define BR_CAN_RX15MASK_RX15M(x) (HW_CAN_RX15MASK(x).U)

/*! @brief Format value for bitfield CAN_RX15MASK_RX15M. */
#define BF_CAN_RX15MASK_RX15M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX15MASK_RX15M) & BM_CAN_RX15MASK_RX15M)

/*! @brief Set the RX15M field to a new value. */
#define BW_CAN_RX15MASK_RX15M(x, v) (HW_CAN_RX15MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_ECR - Error Counter
 ******************************************************************************/

/*!
 * @brief HW_CAN_ECR - Error Counter (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register has two 8-bit fields reflecting the value of two FlexCAN error
 * counters: Transmit Error Counter (TXERRCNT field) and Receive Error Counter
 * (RXERRCNT field). The rules for increasing and decreasing these counters are
 * described in the CAN protocol and are completely implemented in the FlexCAN
 * module. Both counters are read-only except in Freeze mode, where they can be
 * written by the CPU. FlexCAN responds to any bus state as described in the protocol,
 * for example, transmit Error Active or Error Passive flag, delay its
 * transmission start time (Error Passive) and avoid any influence on the bus when in Bus
 * Off state. The following are the basic rules for FlexCAN bus state transitions:
 * If the value of TXERRCNT or RXERRCNT increases to be greater than or equal to
 * 128, the FLTCONF field in the Error and Status Register is updated to reflect
 * 'Error Passive' state. If the FlexCAN state is 'Error Passive', and either
 * TXERRCNT or RXERRCNT decrements to a value less than or equal to 127 while the
 * other already satisfies this condition, the FLTCONF field in the Error and
 * Status Register is updated to reflect 'Error Active' state. If the value of
 * TXERRCNT increases to be greater than 255, the FLTCONF field in the Error and Status
 * Register is updated to reflect 'Bus Off' state, and an interrupt may be
 * issued. The value of TXERRCNT is then reset to zero. If FlexCAN is in 'Bus Off'
 * state, then TXERRCNT is cascaded together with another internal counter to count
 * the 128th occurrences of 11 consecutive recessive bits on the bus. Hence,
 * TXERRCNT is reset to zero and counts in a manner where the internal counter counts
 * 11 such bits and then wraps around while incrementing the TXERRCNT. When
 * TXERRCNT reaches the value of 128, the FLTCONF field in the Error and Status
 * Register is updated to be 'Error Active' and both error counters are reset to zero.
 * At any instance of dominant bit following a stream of less than 11
 * consecutive recessive bits, the internal counter resets itself to zero without affecting
 * the TXERRCNT value. If during system start-up, only one node is operating,
 * then its TXERRCNT increases in each message it is trying to transmit, as a
 * result of acknowledge errors (indicated by the ACKERR bit in the Error and Status
 * Register). After the transition to 'Error Passive' state, the TXERRCNT does not
 * increment anymore by acknowledge errors. Therefore the device never goes to
 * the 'Bus Off' state. If the RXERRCNT increases to a value greater than 127, it
 * is not incremented further, even if more errors are detected while being a
 * receiver. At the next successful message reception, the counter is set to a value
 * between 119 and 127 to resume to 'Error Active' state.
 */
typedef union _hw_can_ecr
{
    uint32_t U;
    struct _hw_can_ecr_bitfields
    {
        uint32_t TXERRCNT : 8;         /*!< [7:0] Transmit Error Counter */
        uint32_t RXERRCNT : 8;         /*!< [15:8] Receive Error Counter */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_ecr_t;

/*!
 * @name Constants and macros for entire CAN_ECR register
 */
/*@{*/
#define HW_CAN_ECR_ADDR(x)       ((x) + 0x1CU)

#define HW_CAN_ECR(x)            (*(__IO hw_can_ecr_t *) HW_CAN_ECR_ADDR(x))
#define HW_CAN_ECR_RD(x)         (ADDRESS_READ(hw_can_ecr_t, HW_CAN_ECR_ADDR(x)))
#define HW_CAN_ECR_WR(x, v)      (ADDRESS_WRITE(hw_can_ecr_t, HW_CAN_ECR_ADDR(x), v))
#define HW_CAN_ECR_SET(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) |  (v)))
#define HW_CAN_ECR_CLR(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) & ~(v)))
#define HW_CAN_ECR_TOG(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ECR bitfields
 */

/*!
 * @name Register CAN_ECR, field TXERRCNT[7:0] (RW)
 */
/*@{*/
#define BP_CAN_ECR_TXERRCNT  (0U)          /*!< Bit position for CAN_ECR_TXERRCNT. */
#define BM_CAN_ECR_TXERRCNT  (0x000000FFU) /*!< Bit mask for CAN_ECR_TXERRCNT. */
#define BS_CAN_ECR_TXERRCNT  (8U)          /*!< Bit field size in bits for CAN_ECR_TXERRCNT. */

/*! @brief Read current value of the CAN_ECR_TXERRCNT field. */
#define BR_CAN_ECR_TXERRCNT(x) (UNION_READ(hw_can_ecr_t, HW_CAN_ECR_ADDR(x), U, B.TXERRCNT))

/*! @brief Format value for bitfield CAN_ECR_TXERRCNT. */
#define BF_CAN_ECR_TXERRCNT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_TXERRCNT) & BM_CAN_ECR_TXERRCNT)

/*! @brief Set the TXERRCNT field to a new value. */
#define BW_CAN_ECR_TXERRCNT(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_TXERRCNT) | BF_CAN_ECR_TXERRCNT(v)))
/*@}*/

/*!
 * @name Register CAN_ECR, field RXERRCNT[15:8] (RW)
 */
/*@{*/
#define BP_CAN_ECR_RXERRCNT  (8U)          /*!< Bit position for CAN_ECR_RXERRCNT. */
#define BM_CAN_ECR_RXERRCNT  (0x0000FF00U) /*!< Bit mask for CAN_ECR_RXERRCNT. */
#define BS_CAN_ECR_RXERRCNT  (8U)          /*!< Bit field size in bits for CAN_ECR_RXERRCNT. */

/*! @brief Read current value of the CAN_ECR_RXERRCNT field. */
#define BR_CAN_ECR_RXERRCNT(x) (UNION_READ(hw_can_ecr_t, HW_CAN_ECR_ADDR(x), U, B.RXERRCNT))

/*! @brief Format value for bitfield CAN_ECR_RXERRCNT. */
#define BF_CAN_ECR_RXERRCNT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_RXERRCNT) & BM_CAN_ECR_RXERRCNT)

/*! @brief Set the RXERRCNT field to a new value. */
#define BW_CAN_ECR_RXERRCNT(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_RXERRCNT) | BF_CAN_ECR_RXERRCNT(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR1 - Error and Status 1 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR1 - Error and Status 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various error conditions, some general status of the
 * device and it is the source of interrupts to the CPU. The CPU read action
 * clears bits 15-10. Therefore the reported error conditions (bits 15-10) are those
 * that occurred since the last time the CPU read this register. Bits 9-3 are
 * status bits. The following table shows the FlexCAN state variables and their
 * meanings. Other combinations not shown in the table are reserved. SYNCH IDLE TX RX
 * FlexCAN State 0 0 0 0 Not synchronized to CAN bus 1 1 x x Idle 1 0 1 0
 * Transmitting 1 0 0 1 Receiving
 */
typedef union _hw_can_esr1
{
    uint32_t U;
    struct _hw_can_esr1_bitfields
    {
        uint32_t WAKINT : 1;           /*!< [0] Wake-Up Interrupt */
        uint32_t ERRINT : 1;           /*!< [1] Error Interrupt */
        uint32_t BOFFINT : 1;          /*!< [2] Bus Off Interrupt */
        uint32_t RX : 1;               /*!< [3] FlexCAN In Reception */
        uint32_t FLTCONF : 2;          /*!< [5:4] Fault Confinement State */
        uint32_t TX : 1;               /*!< [6] FlexCAN In Transmission */
        uint32_t IDLE : 1;             /*!< [7]  */
        uint32_t RXWRN : 1;            /*!< [8] Rx Error Warning */
        uint32_t TXWRN : 1;            /*!< [9] TX Error Warning */
        uint32_t STFERR : 1;           /*!< [10] Stuffing Error */
        uint32_t FRMERR : 1;           /*!< [11] Form Error */
        uint32_t CRCERR : 1;           /*!< [12] Cyclic Redundancy Check Error */
        uint32_t ACKERR : 1;           /*!< [13] Acknowledge Error */
        uint32_t BIT0ERR : 1;          /*!< [14] Bit0 Error */
        uint32_t BIT1ERR : 1;          /*!< [15] Bit1 Error */
        uint32_t RWRNINT : 1;          /*!< [16] Rx Warning Interrupt Flag */
        uint32_t TWRNINT : 1;          /*!< [17] Tx Warning Interrupt Flag */
        uint32_t SYNCH : 1;            /*!< [18] CAN Synchronization Status */
        uint32_t RESERVED0 : 13;       /*!< [31:19]  */
    } B;
} hw_can_esr1_t;

/*!
 * @name Constants and macros for entire CAN_ESR1 register
 */
/*@{*/
#define HW_CAN_ESR1_ADDR(x)      ((x) + 0x20U)

#define HW_CAN_ESR1(x)           (*(__IO hw_can_esr1_t *) HW_CAN_ESR1_ADDR(x))
#define HW_CAN_ESR1_RD(x)        (ADDRESS_READ(hw_can_esr1_t, HW_CAN_ESR1_ADDR(x)))
#define HW_CAN_ESR1_WR(x, v)     (ADDRESS_WRITE(hw_can_esr1_t, HW_CAN_ESR1_ADDR(x), v))
#define HW_CAN_ESR1_SET(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) |  (v)))
#define HW_CAN_ESR1_CLR(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) & ~(v)))
#define HW_CAN_ESR1_TOG(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR1 bitfields
 */

/*!
 * @name Register CAN_ESR1, field WAKINT[0] (W1C)
 *
 * This field applies when FlexCAN is in low-power mode under Self Wake Up
 * mechanism: Stop mode When a recessive-to-dominant transition is detected on the CAN
 * bus and if the MCR[WAKMSK] bit is set, an interrupt is generated to the CPU.
 * This bit is cleared by writing it to 1. When MCR[SLFWAK] is negated, this flag
 * is masked. The CPU must clear this flag before disabling the bit. Otherwise
 * it will be set when the SLFWAK is set again. Writing 0 has no effect.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - Indicates a recessive to dominant transition was received on the CAN
 *     bus.
 */
/*@{*/
#define BP_CAN_ESR1_WAKINT   (0U)          /*!< Bit position for CAN_ESR1_WAKINT. */
#define BM_CAN_ESR1_WAKINT   (0x00000001U) /*!< Bit mask for CAN_ESR1_WAKINT. */
#define BS_CAN_ESR1_WAKINT   (1U)          /*!< Bit field size in bits for CAN_ESR1_WAKINT. */

/*! @brief Read current value of the CAN_ESR1_WAKINT field. */
#define BR_CAN_ESR1_WAKINT(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_WAKINT)))

/*! @brief Format value for bitfield CAN_ESR1_WAKINT. */
#define BF_CAN_ESR1_WAKINT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_WAKINT) & BM_CAN_ESR1_WAKINT)

/*! @brief Set the WAKINT field to a new value. */
#define BW_CAN_ESR1_WAKINT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_WAKINT), v))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ERRINT[1] (W1C)
 *
 * This bit indicates that at least one of the Error Bits (bits 15-10) is set.
 * If the corresponding mask bit CTRL1[ERRMSK] is set, an interrupt is generated
 * to the CPU. This bit is cleared by writing it to 1. Writing 0 has no effect.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - Indicates setting of any Error Bit in the Error and Status Register.
 */
/*@{*/
#define BP_CAN_ESR1_ERRINT   (1U)          /*!< Bit position for CAN_ESR1_ERRINT. */
#define BM_CAN_ESR1_ERRINT   (0x00000002U) /*!< Bit mask for CAN_ESR1_ERRINT. */
#define BS_CAN_ESR1_ERRINT   (1U)          /*!< Bit field size in bits for CAN_ESR1_ERRINT. */

/*! @brief Read current value of the CAN_ESR1_ERRINT field. */
#define BR_CAN_ESR1_ERRINT(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_ERRINT)))

/*! @brief Format value for bitfield CAN_ESR1_ERRINT. */
#define BF_CAN_ESR1_ERRINT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_ERRINT) & BM_CAN_ESR1_ERRINT)

/*! @brief Set the ERRINT field to a new value. */
#define BW_CAN_ESR1_ERRINT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_ERRINT), v))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BOFFINT[2] (W1C)
 *
 * This bit is set when FlexCAN enters 'Bus Off' state. If the corresponding
 * mask bit in the Control Register (BOFFMSK) is set, an interrupt is generated to
 * the CPU. This bit is cleared by writing it to 1. Writing 0 has no effect.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - FlexCAN module entered Bus Off state.
 */
/*@{*/
#define BP_CAN_ESR1_BOFFINT  (2U)          /*!< Bit position for CAN_ESR1_BOFFINT. */
#define BM_CAN_ESR1_BOFFINT  (0x00000004U) /*!< Bit mask for CAN_ESR1_BOFFINT. */
#define BS_CAN_ESR1_BOFFINT  (1U)          /*!< Bit field size in bits for CAN_ESR1_BOFFINT. */

/*! @brief Read current value of the CAN_ESR1_BOFFINT field. */
#define BR_CAN_ESR1_BOFFINT(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_BOFFINT)))

/*! @brief Format value for bitfield CAN_ESR1_BOFFINT. */
#define BF_CAN_ESR1_BOFFINT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_BOFFINT) & BM_CAN_ESR1_BOFFINT)

/*! @brief Set the BOFFINT field to a new value. */
#define BW_CAN_ESR1_BOFFINT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_BOFFINT), v))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX[3] (RO)
 *
 * This bit indicates if FlexCAN is receiving a message. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0 - FlexCAN is not receiving a message.
 * - 1 - FlexCAN is receiving a message.
 */
/*@{*/
#define BP_CAN_ESR1_RX       (3U)          /*!< Bit position for CAN_ESR1_RX. */
#define BM_CAN_ESR1_RX       (0x00000008U) /*!< Bit mask for CAN_ESR1_RX. */
#define BS_CAN_ESR1_RX       (1U)          /*!< Bit field size in bits for CAN_ESR1_RX. */

/*! @brief Read current value of the CAN_ESR1_RX field. */
#define BR_CAN_ESR1_RX(x)    (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_RX)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field FLTCONF[5:4] (RO)
 *
 * This 2-bit field indicates the Confinement State of the FlexCAN module. If
 * the LOM bit in the Control Register is asserted, after some delay that depends
 * on the CAN bit timing the FLTCONF field will indicate "Error Passive". The very
 * same delay affects the way how FLTCONF reflects an update to ECR register by
 * the CPU. It may be necessary up to one CAN bit time to get them coherent
 * again. Because the Control Register is not affected by soft reset, the FLTCONF
 * field will not be affected by soft reset if the LOM bit is asserted.
 *
 * Values:
 * - 00 - Error Active
 * - 01 - Error Passive
 * - 1x - Bus Off
 */
/*@{*/
#define BP_CAN_ESR1_FLTCONF  (4U)          /*!< Bit position for CAN_ESR1_FLTCONF. */
#define BM_CAN_ESR1_FLTCONF  (0x00000030U) /*!< Bit mask for CAN_ESR1_FLTCONF. */
#define BS_CAN_ESR1_FLTCONF  (2U)          /*!< Bit field size in bits for CAN_ESR1_FLTCONF. */

/*! @brief Read current value of the CAN_ESR1_FLTCONF field. */
#define BR_CAN_ESR1_FLTCONF(x) (UNION_READ(hw_can_esr1_t, HW_CAN_ESR1_ADDR(x), U, B.FLTCONF))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX[6] (RO)
 *
 * This bit indicates if FlexCAN is transmitting a message. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0 - FlexCAN is not transmitting a message.
 * - 1 - FlexCAN is transmitting a message.
 */
/*@{*/
#define BP_CAN_ESR1_TX       (6U)          /*!< Bit position for CAN_ESR1_TX. */
#define BM_CAN_ESR1_TX       (0x00000040U) /*!< Bit mask for CAN_ESR1_TX. */
#define BS_CAN_ESR1_TX       (1U)          /*!< Bit field size in bits for CAN_ESR1_TX. */

/*! @brief Read current value of the CAN_ESR1_TX field. */
#define BR_CAN_ESR1_TX(x)    (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_TX)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field IDLE[7] (RO)
 *
 * This bit indicates when CAN bus is in IDLE state. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - CAN bus is now IDLE.
 */
/*@{*/
#define BP_CAN_ESR1_IDLE     (7U)          /*!< Bit position for CAN_ESR1_IDLE. */
#define BM_CAN_ESR1_IDLE     (0x00000080U) /*!< Bit mask for CAN_ESR1_IDLE. */
#define BS_CAN_ESR1_IDLE     (1U)          /*!< Bit field size in bits for CAN_ESR1_IDLE. */

/*! @brief Read current value of the CAN_ESR1_IDLE field. */
#define BR_CAN_ESR1_IDLE(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_IDLE)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RXWRN[8] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * reception. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - RXERRCNT is greater than or equal to 96.
 */
/*@{*/
#define BP_CAN_ESR1_RXWRN    (8U)          /*!< Bit position for CAN_ESR1_RXWRN. */
#define BM_CAN_ESR1_RXWRN    (0x00000100U) /*!< Bit mask for CAN_ESR1_RXWRN. */
#define BS_CAN_ESR1_RXWRN    (1U)          /*!< Bit field size in bits for CAN_ESR1_RXWRN. */

/*! @brief Read current value of the CAN_ESR1_RXWRN field. */
#define BR_CAN_ESR1_RXWRN(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_RXWRN)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TXWRN[9] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * transmission. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - TXERRCNT is greater than or equal to 96.
 */
/*@{*/
#define BP_CAN_ESR1_TXWRN    (9U)          /*!< Bit position for CAN_ESR1_TXWRN. */
#define BM_CAN_ESR1_TXWRN    (0x00000200U) /*!< Bit mask for CAN_ESR1_TXWRN. */
#define BS_CAN_ESR1_TXWRN    (1U)          /*!< Bit field size in bits for CAN_ESR1_TXWRN. */

/*! @brief Read current value of the CAN_ESR1_TXWRN field. */
#define BR_CAN_ESR1_TXWRN(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_TXWRN)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field STFERR[10] (RO)
 *
 * This bit indicates that a Stuffing Error has been etected.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - A Stuffing Error occurred since last read of this register.
 */
/*@{*/
#define BP_CAN_ESR1_STFERR   (10U)         /*!< Bit position for CAN_ESR1_STFERR. */
#define BM_CAN_ESR1_STFERR   (0x00000400U) /*!< Bit mask for CAN_ESR1_STFERR. */
#define BS_CAN_ESR1_STFERR   (1U)          /*!< Bit field size in bits for CAN_ESR1_STFERR. */

/*! @brief Read current value of the CAN_ESR1_STFERR field. */
#define BR_CAN_ESR1_STFERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_STFERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field FRMERR[11] (RO)
 *
 * This bit indicates that a Form Error has been detected by the receiver node,
 * that is, a fixed-form bit field contains at least one illegal bit.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - A Form Error occurred since last read of this register.
 */
/*@{*/
#define BP_CAN_ESR1_FRMERR   (11U)         /*!< Bit position for CAN_ESR1_FRMERR. */
#define BM_CAN_ESR1_FRMERR   (0x00000800U) /*!< Bit mask for CAN_ESR1_FRMERR. */
#define BS_CAN_ESR1_FRMERR   (1U)          /*!< Bit field size in bits for CAN_ESR1_FRMERR. */

/*! @brief Read current value of the CAN_ESR1_FRMERR field. */
#define BR_CAN_ESR1_FRMERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_FRMERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field CRCERR[12] (RO)
 *
 * This bit indicates that a CRC Error has been detected by the receiver node,
 * that is, the calculated CRC is different from the received.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - A CRC error occurred since last read of this register.
 */
/*@{*/
#define BP_CAN_ESR1_CRCERR   (12U)         /*!< Bit position for CAN_ESR1_CRCERR. */
#define BM_CAN_ESR1_CRCERR   (0x00001000U) /*!< Bit mask for CAN_ESR1_CRCERR. */
#define BS_CAN_ESR1_CRCERR   (1U)          /*!< Bit field size in bits for CAN_ESR1_CRCERR. */

/*! @brief Read current value of the CAN_ESR1_CRCERR field. */
#define BR_CAN_ESR1_CRCERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_CRCERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ACKERR[13] (RO)
 *
 * This bit indicates that an Acknowledge Error has been detected by the
 * transmitter node, that is, a dominant bit has not been detected during the ACK SLOT.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - An ACK error occurred since last read of this register.
 */
/*@{*/
#define BP_CAN_ESR1_ACKERR   (13U)         /*!< Bit position for CAN_ESR1_ACKERR. */
#define BM_CAN_ESR1_ACKERR   (0x00002000U) /*!< Bit mask for CAN_ESR1_ACKERR. */
#define BS_CAN_ESR1_ACKERR   (1U)          /*!< Bit field size in bits for CAN_ESR1_ACKERR. */

/*! @brief Read current value of the CAN_ESR1_ACKERR field. */
#define BR_CAN_ESR1_ACKERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_ACKERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT0ERR[14] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - At least one bit sent as dominant is received as recessive.
 */
/*@{*/
#define BP_CAN_ESR1_BIT0ERR  (14U)         /*!< Bit position for CAN_ESR1_BIT0ERR. */
#define BM_CAN_ESR1_BIT0ERR  (0x00004000U) /*!< Bit mask for CAN_ESR1_BIT0ERR. */
#define BS_CAN_ESR1_BIT0ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT0ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT0ERR field. */
#define BR_CAN_ESR1_BIT0ERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_BIT0ERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT1ERR[15] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message. This bit is not set by a transmitter in case of
 * arbitration field or ACK slot, or in case of a node sending a passive error
 * flag that detects dominant bits.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - At least one bit sent as recessive is received as dominant.
 */
/*@{*/
#define BP_CAN_ESR1_BIT1ERR  (15U)         /*!< Bit position for CAN_ESR1_BIT1ERR. */
#define BM_CAN_ESR1_BIT1ERR  (0x00008000U) /*!< Bit mask for CAN_ESR1_BIT1ERR. */
#define BS_CAN_ESR1_BIT1ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT1ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT1ERR field. */
#define BR_CAN_ESR1_BIT1ERR(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_BIT1ERR)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RWRNINT[16] (W1C)
 *
 * If the WRNEN bit in MCR is asserted, the RWRNINT bit is set when the RXWRN
 * flag transitions from 0 to 1, meaning that the Rx error counters reached 96. If
 * the corresponding mask bit in the Control Register (RWRNMSK) is set, an
 * interrupt is generated to the CPU. This bit is cleared by writing it to 1. When
 * WRNEN is negated, this flag is masked. CPU must clear this flag before disabling
 * the bit. Otherwise it will be set when the WRNEN is set again. Writing 0 has no
 * effect. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - The Rx error counter transitioned from less than 96 to greater than or
 *     equal to 96.
 */
/*@{*/
#define BP_CAN_ESR1_RWRNINT  (16U)         /*!< Bit position for CAN_ESR1_RWRNINT. */
#define BM_CAN_ESR1_RWRNINT  (0x00010000U) /*!< Bit mask for CAN_ESR1_RWRNINT. */
#define BS_CAN_ESR1_RWRNINT  (1U)          /*!< Bit field size in bits for CAN_ESR1_RWRNINT. */

/*! @brief Read current value of the CAN_ESR1_RWRNINT field. */
#define BR_CAN_ESR1_RWRNINT(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_RWRNINT)))

/*! @brief Format value for bitfield CAN_ESR1_RWRNINT. */
#define BF_CAN_ESR1_RWRNINT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_RWRNINT) & BM_CAN_ESR1_RWRNINT)

/*! @brief Set the RWRNINT field to a new value. */
#define BW_CAN_ESR1_RWRNINT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_RWRNINT), v))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TWRNINT[17] (W1C)
 *
 * If the WRNEN bit in MCR is asserted, the TWRNINT bit is set when the TXWRN
 * flag transitions from 0 to 1, meaning that the Tx error counter reached 96. If
 * the corresponding mask bit in the Control Register (TWRNMSK) is set, an
 * interrupt is generated to the CPU. This bit is cleared by writing it to 1. When WRNEN
 * is negated, this flag is masked. CPU must clear this flag before disabling
 * the bit. Otherwise it will be set when the WRNEN is set again. Writing 0 has no
 * effect. This flag is not generated during Bus Off state. This bit is not
 * updated during Freeze mode.
 *
 * Values:
 * - 0 - No such occurrence.
 * - 1 - The Tx error counter transitioned from less than 96 to greater than or
 *     equal to 96.
 */
/*@{*/
#define BP_CAN_ESR1_TWRNINT  (17U)         /*!< Bit position for CAN_ESR1_TWRNINT. */
#define BM_CAN_ESR1_TWRNINT  (0x00020000U) /*!< Bit mask for CAN_ESR1_TWRNINT. */
#define BS_CAN_ESR1_TWRNINT  (1U)          /*!< Bit field size in bits for CAN_ESR1_TWRNINT. */

/*! @brief Read current value of the CAN_ESR1_TWRNINT field. */
#define BR_CAN_ESR1_TWRNINT(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_TWRNINT)))

/*! @brief Format value for bitfield CAN_ESR1_TWRNINT. */
#define BF_CAN_ESR1_TWRNINT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_TWRNINT) & BM_CAN_ESR1_TWRNINT)

/*! @brief Set the TWRNINT field to a new value. */
#define BW_CAN_ESR1_TWRNINT(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_TWRNINT), v))
/*@}*/

/*!
 * @name Register CAN_ESR1, field SYNCH[18] (RO)
 *
 * This read-only flag indicates whether the FlexCAN is synchronized to the CAN
 * bus and able to participate in the communication process. It is set and
 * cleared by the FlexCAN. See the table in the overall CAN_ESR1 register description.
 *
 * Values:
 * - 0 - FlexCAN is not synchronized to the CAN bus.
 * - 1 - FlexCAN is synchronized to the CAN bus.
 */
/*@{*/
#define BP_CAN_ESR1_SYNCH    (18U)         /*!< Bit position for CAN_ESR1_SYNCH. */
#define BM_CAN_ESR1_SYNCH    (0x00040000U) /*!< Bit mask for CAN_ESR1_SYNCH. */
#define BS_CAN_ESR1_SYNCH    (1U)          /*!< Bit field size in bits for CAN_ESR1_SYNCH. */

/*! @brief Read current value of the CAN_ESR1_SYNCH field. */
#define BR_CAN_ESR1_SYNCH(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR1_ADDR(x), BP_CAN_ESR1_SYNCH)))
/*@}*/

/*******************************************************************************
 * HW_CAN_IMASK1 - Interrupt Masks 1 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IMASK1 - Interrupt Masks 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows any number of a range of the 32 Message Buffer
 * Interrupts to be enabled or disabled for MB31 to MB0. It contains one interrupt mask
 * bit per buffer, enabling the CPU to determine which buffer generates an
 * interrupt after a successful transmission or reception, that is, when the
 * corresponding IFLAG1 bit is set.
 */
typedef union _hw_can_imask1
{
    uint32_t U;
    struct _hw_can_imask1_bitfields
    {
        uint32_t BUFLM : 32;           /*!< [31:0] Buffer MB i Mask */
    } B;
} hw_can_imask1_t;

/*!
 * @name Constants and macros for entire CAN_IMASK1 register
 */
/*@{*/
#define HW_CAN_IMASK1_ADDR(x)    ((x) + 0x28U)

#define HW_CAN_IMASK1(x)         (*(__IO hw_can_imask1_t *) HW_CAN_IMASK1_ADDR(x))
#define HW_CAN_IMASK1_RD(x)      (ADDRESS_READ(hw_can_imask1_t, HW_CAN_IMASK1_ADDR(x)))
#define HW_CAN_IMASK1_WR(x, v)   (ADDRESS_WRITE(hw_can_imask1_t, HW_CAN_IMASK1_ADDR(x), v))
#define HW_CAN_IMASK1_SET(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) |  (v)))
#define HW_CAN_IMASK1_CLR(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) & ~(v)))
#define HW_CAN_IMASK1_TOG(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IMASK1 bitfields
 */

/*!
 * @name Register CAN_IMASK1, field BUFLM[31:0] (RW)
 *
 * Each bit enables or disables the corresponding FlexCAN Message Buffer
 * Interrupt for MB31 to MB0. Setting or clearing a bit in the IMASK1 Register can
 * assert or negate an interrupt request, if the corresponding IFLAG1 bit is set.
 *
 * Values:
 * - 0 - The corresponding buffer Interrupt is disabled.
 * - 1 - The corresponding buffer Interrupt is enabled.
 */
/*@{*/
#define BP_CAN_IMASK1_BUFLM  (0U)          /*!< Bit position for CAN_IMASK1_BUFLM. */
#define BM_CAN_IMASK1_BUFLM  (0xFFFFFFFFU) /*!< Bit mask for CAN_IMASK1_BUFLM. */
#define BS_CAN_IMASK1_BUFLM  (32U)         /*!< Bit field size in bits for CAN_IMASK1_BUFLM. */

/*! @brief Read current value of the CAN_IMASK1_BUFLM field. */
#define BR_CAN_IMASK1_BUFLM(x) (HW_CAN_IMASK1(x).U)

/*! @brief Format value for bitfield CAN_IMASK1_BUFLM. */
#define BF_CAN_IMASK1_BUFLM(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IMASK1_BUFLM) & BM_CAN_IMASK1_BUFLM)

/*! @brief Set the BUFLM field to a new value. */
#define BW_CAN_IMASK1_BUFLM(x, v) (HW_CAN_IMASK1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IFLAG1 - Interrupt Flags 1 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IFLAG1 - Interrupt Flags 1 register (W1C)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for the 32 Message Buffer interrupts for MB31
 * to MB0. It contains one interrupt flag bit per buffer. Each successful
 * transmission or reception sets the corresponding IFLAG1 bit. If the corresponding
 * IMASK1 bit is set, an interrupt will be generated. The interrupt flag must be
 * cleared by writing 1 to it. Writing 0 has no effect. The BUF7I to BUF5I flags
 * are also used to represent FIFO interrupts when the Rx FIFO is enabled. When the
 * bit MCR[RFEN] is set, the function of the 8 least significant interrupt flags
 * BUF[7:0]I changes: BUF7I, BUF6I and BUF5I indicate operating conditions of
 * the FIFO, and the BUF4TO0I field is reserved. Before enabling the RFEN, the CPU
 * must service the IFLAG bits asserted in the Rx FIFO region; see Section "Rx
 * FIFO". Otherwise, these IFLAG bits will mistakenly show the related MBs now
 * belonging to FIFO as having contents to be serviced. When the RFEN bit is negated,
 * the FIFO flags must be cleared. The same care must be taken when an RFFN
 * value is selected extending Rx FIFO filters beyond MB7. For example, when RFFN is
 * 0x8, the MB0-23 range is occupied by Rx FIFO filters and related IFLAG bits
 * must be cleared. Before updating MCR[MAXMB] field, CPU must service the IFLAG1
 * bits whose MB value is greater than the MCR[MAXMB] to be updated; otherwise,
 * they will remain set and be inconsistent with the number of MBs available.
 */
typedef union _hw_can_iflag1
{
    uint32_t U;
    struct _hw_can_iflag1_bitfields
    {
        uint32_t BUF0I : 1;            /*!< [0] Buffer MB0 Interrupt Or "reserved" */
        uint32_t BUF4TO1I : 4;         /*!< [4:1] Buffer MB i Interrupt Or "reserved"
                                        * */
        uint32_t BUF5I : 1;            /*!< [5] Buffer MB5 Interrupt Or "Frames
                                        * available in Rx FIFO" */
        uint32_t BUF6I : 1;            /*!< [6] Buffer MB6 Interrupt Or "Rx FIFO
                                        * Warning" */
        uint32_t BUF7I : 1;            /*!< [7] Buffer MB7 Interrupt Or "Rx FIFO
                                        * Overflow" */
        uint32_t BUF31TO8I : 24;       /*!< [31:8] Buffer MBi Interrupt */
    } B;
} hw_can_iflag1_t;

/*!
 * @name Constants and macros for entire CAN_IFLAG1 register
 */
/*@{*/
#define HW_CAN_IFLAG1_ADDR(x)    ((x) + 0x30U)

#define HW_CAN_IFLAG1(x)         (*(__IO hw_can_iflag1_t *) HW_CAN_IFLAG1_ADDR(x))
#define HW_CAN_IFLAG1_RD(x)      (ADDRESS_READ(hw_can_iflag1_t, HW_CAN_IFLAG1_ADDR(x)))
#define HW_CAN_IFLAG1_WR(x, v)   (ADDRESS_WRITE(hw_can_iflag1_t, HW_CAN_IFLAG1_ADDR(x), v))
#define HW_CAN_IFLAG1_SET(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) |  (v)))
#define HW_CAN_IFLAG1_CLR(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) & ~(v)))
#define HW_CAN_IFLAG1_TOG(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG1 bitfields
 */

/*!
 * @name Register CAN_IFLAG1, field BUF0I[0] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB0. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF0I flag is reserved when MCR[RFEN] is
 * set.
 *
 * Values:
 * - 0 - The corresponding buffer has no occurrence of successfully completed
 *     transmission or reception when MCR[RFEN]=0.
 * - 1 - The corresponding buffer has successfully completed transmission or
 *     reception when MCR[RFEN]=0.
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF0I  (0U)          /*!< Bit position for CAN_IFLAG1_BUF0I. */
#define BM_CAN_IFLAG1_BUF0I  (0x00000001U) /*!< Bit mask for CAN_IFLAG1_BUF0I. */
#define BS_CAN_IFLAG1_BUF0I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF0I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF0I field. */
#define BR_CAN_IFLAG1_BUF0I(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF0I)))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF0I. */
#define BF_CAN_IFLAG1_BUF0I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF0I) & BM_CAN_IFLAG1_BUF0I)

/*! @brief Set the BUF0I field to a new value. */
#define BW_CAN_IFLAG1_BUF0I(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF0I), v))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF4TO1I[4:1] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), these bits flag
 * the interrupts for MB4 to MB1. These flags are cleared by the FlexCAN whenever
 * the bit MCR[RFEN] is changed by CPU writes. The BUF4TO1I flags are reserved
 * when MCR[RFEN] is set.
 *
 * Values:
 * - 0 - The corresponding buffer has no occurrence of successfully completed
 *     transmission or reception when MCR[RFEN]=0.
 * - 1 - The corresponding buffer has successfully completed transmission or
 *     reception when MCR[RFEN]=0.
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF4TO1I (1U)        /*!< Bit position for CAN_IFLAG1_BUF4TO1I. */
#define BM_CAN_IFLAG1_BUF4TO1I (0x0000001EU) /*!< Bit mask for CAN_IFLAG1_BUF4TO1I. */
#define BS_CAN_IFLAG1_BUF4TO1I (4U)        /*!< Bit field size in bits for CAN_IFLAG1_BUF4TO1I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF4TO1I field. */
#define BR_CAN_IFLAG1_BUF4TO1I(x) (UNION_READ(hw_can_iflag1_t, HW_CAN_IFLAG1_ADDR(x), U, B.BUF4TO1I))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF4TO1I. */
#define BF_CAN_IFLAG1_BUF4TO1I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF4TO1I) & BM_CAN_IFLAG1_BUF4TO1I)

/*! @brief Set the BUF4TO1I field to a new value. */
#define BW_CAN_IFLAG1_BUF4TO1I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF4TO1I) | BF_CAN_IFLAG1_BUF4TO1I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF5I[5] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB5. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF5I flag represents "Frames available in
 * Rx FIFO" when MCR[RFEN] is set. In this case, the flag indicates that at
 * least one frame is available to be read from the Rx FIFO.
 *
 * Values:
 * - 0 - No occurrence of MB5 completing transmission/reception when
 *     MCR[RFEN]=0, or of frame(s) available in the FIFO, when MCR[RFEN]=1
 * - 1 - MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s)
 *     available in the Rx FIFO when MCR[RFEN]=1
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF5I  (5U)          /*!< Bit position for CAN_IFLAG1_BUF5I. */
#define BM_CAN_IFLAG1_BUF5I  (0x00000020U) /*!< Bit mask for CAN_IFLAG1_BUF5I. */
#define BS_CAN_IFLAG1_BUF5I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF5I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF5I field. */
#define BR_CAN_IFLAG1_BUF5I(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF5I)))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF5I. */
#define BF_CAN_IFLAG1_BUF5I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF5I) & BM_CAN_IFLAG1_BUF5I)

/*! @brief Set the BUF5I field to a new value. */
#define BW_CAN_IFLAG1_BUF5I(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF5I), v))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF6I[6] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB6. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF6I flag represents "Rx FIFO Warning"
 * when MCR[RFEN] is set. In this case, the flag indicates when the number of
 * unread messages within the Rx FIFO is increased to 5 from 4 due to the reception of
 * a new one, meaning that the Rx FIFO is almost full. Note that if the flag is
 * cleared while the number of unread messages is greater than 4, it does not
 * assert again until the number of unread messages within the Rx FIFO is decreased
 * to be equal to or less than 4.
 *
 * Values:
 * - 0 - No occurrence of MB6 completing transmission/reception when
 *     MCR[RFEN]=0, or of Rx FIFO almost full when MCR[RFEN]=1
 * - 1 - MB6 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO
 *     almost full when MCR[RFEN]=1
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF6I  (6U)          /*!< Bit position for CAN_IFLAG1_BUF6I. */
#define BM_CAN_IFLAG1_BUF6I  (0x00000040U) /*!< Bit mask for CAN_IFLAG1_BUF6I. */
#define BS_CAN_IFLAG1_BUF6I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF6I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF6I field. */
#define BR_CAN_IFLAG1_BUF6I(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF6I)))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF6I. */
#define BF_CAN_IFLAG1_BUF6I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF6I) & BM_CAN_IFLAG1_BUF6I)

/*! @brief Set the BUF6I field to a new value. */
#define BW_CAN_IFLAG1_BUF6I(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF6I), v))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF7I[7] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB7. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF7I flag represents "Rx FIFO Overflow"
 * when MCR[RFEN] is set. In this case, the flag indicates that a message was lost
 * because the Rx FIFO is full. Note that the flag will not be asserted when the
 * Rx FIFO is full and the message was captured by a Mailbox.
 *
 * Values:
 * - 0 - No occurrence of MB7 completing transmission/reception when
 *     MCR[RFEN]=0, or of Rx FIFO overflow when MCR[RFEN]=1
 * - 1 - MB7 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO
 *     overflow when MCR[RFEN]=1
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF7I  (7U)          /*!< Bit position for CAN_IFLAG1_BUF7I. */
#define BM_CAN_IFLAG1_BUF7I  (0x00000080U) /*!< Bit mask for CAN_IFLAG1_BUF7I. */
#define BS_CAN_IFLAG1_BUF7I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF7I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF7I field. */
#define BR_CAN_IFLAG1_BUF7I(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF7I)))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF7I. */
#define BF_CAN_IFLAG1_BUF7I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF7I) & BM_CAN_IFLAG1_BUF7I)

/*! @brief Set the BUF7I field to a new value. */
#define BW_CAN_IFLAG1_BUF7I(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_IFLAG1_ADDR(x), BP_CAN_IFLAG1_BUF7I), v))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF31TO8I[31:8] (W1C)
 *
 * Each bit flags the corresponding FlexCAN Message Buffer interrupt for MB31 to
 * MB8.
 *
 * Values:
 * - 0 - The corresponding buffer has no occurrence of successfully completed
 *     transmission or reception.
 * - 1 - The corresponding buffer has successfully completed transmission or
 *     reception.
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF31TO8I (8U)       /*!< Bit position for CAN_IFLAG1_BUF31TO8I. */
#define BM_CAN_IFLAG1_BUF31TO8I (0xFFFFFF00U) /*!< Bit mask for CAN_IFLAG1_BUF31TO8I. */
#define BS_CAN_IFLAG1_BUF31TO8I (24U)      /*!< Bit field size in bits for CAN_IFLAG1_BUF31TO8I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF31TO8I field. */
#define BR_CAN_IFLAG1_BUF31TO8I(x) (UNION_READ(hw_can_iflag1_t, HW_CAN_IFLAG1_ADDR(x), U, B.BUF31TO8I))

/*! @brief Format value for bitfield CAN_IFLAG1_BUF31TO8I. */
#define BF_CAN_IFLAG1_BUF31TO8I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF31TO8I) & BM_CAN_IFLAG1_BUF31TO8I)

/*! @brief Set the BUF31TO8I field to a new value. */
#define BW_CAN_IFLAG1_BUF31TO8I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF31TO8I) | BF_CAN_IFLAG1_BUF31TO8I(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL2 - Control 2 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL2 - Control 2 register (RW)
 *
 * Reset value: 0x00B00000U
 *
 * This register contains control bits for CAN errors, FIFO features, and mode
 * selection.
 */
typedef union _hw_can_ctrl2
{
    uint32_t U;
    struct _hw_can_ctrl2_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t EACEN : 1;            /*!< [16] Entire Frame Arbitration Field
                                        * Comparison Enable For Rx Mailboxes */
        uint32_t RRS : 1;              /*!< [17] Remote Request Storing */
        uint32_t MRP : 1;              /*!< [18] Mailboxes Reception Priority */
        uint32_t TASD : 5;             /*!< [23:19] Tx Arbitration Start Delay */
        uint32_t RFFN : 4;             /*!< [27:24] Number Of Rx FIFO Filters */
        uint32_t WRMFRZ : 1;           /*!< [28] Write-Access To Memory In Freeze Mode
                                        * */
        uint32_t RESERVED1 : 3;        /*!< [31:29]  */
    } B;
} hw_can_ctrl2_t;

/*!
 * @name Constants and macros for entire CAN_CTRL2 register
 */
/*@{*/
#define HW_CAN_CTRL2_ADDR(x)     ((x) + 0x34U)

#define HW_CAN_CTRL2(x)          (*(__IO hw_can_ctrl2_t *) HW_CAN_CTRL2_ADDR(x))
#define HW_CAN_CTRL2_RD(x)       (ADDRESS_READ(hw_can_ctrl2_t, HW_CAN_CTRL2_ADDR(x)))
#define HW_CAN_CTRL2_WR(x, v)    (ADDRESS_WRITE(hw_can_ctrl2_t, HW_CAN_CTRL2_ADDR(x), v))
#define HW_CAN_CTRL2_SET(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) |  (v)))
#define HW_CAN_CTRL2_CLR(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) & ~(v)))
#define HW_CAN_CTRL2_TOG(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL2 bitfields
 */

/*!
 * @name Register CAN_CTRL2, field EACEN[16] (RW)
 *
 * This bit controls the comparison of IDE and RTR bits whithin Rx Mailboxes
 * filters with their corresponding bits in the incoming frame by the matching
 * process. This bit does not affect matching for Rx FIFO. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Rx Mailbox filter's IDE bit is always compared and RTR is never
 *     compared despite mask bits.
 * - 1 - Enables the comparison of both Rx Mailbox filter's IDE and RTR bit with
 *     their corresponding bits within the incoming frame. Mask bits do apply.
 */
/*@{*/
#define BP_CAN_CTRL2_EACEN   (16U)         /*!< Bit position for CAN_CTRL2_EACEN. */
#define BM_CAN_CTRL2_EACEN   (0x00010000U) /*!< Bit mask for CAN_CTRL2_EACEN. */
#define BS_CAN_CTRL2_EACEN   (1U)          /*!< Bit field size in bits for CAN_CTRL2_EACEN. */

/*! @brief Read current value of the CAN_CTRL2_EACEN field. */
#define BR_CAN_CTRL2_EACEN(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_EACEN)))

/*! @brief Format value for bitfield CAN_CTRL2_EACEN. */
#define BF_CAN_CTRL2_EACEN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_EACEN) & BM_CAN_CTRL2_EACEN)

/*! @brief Set the EACEN field to a new value. */
#define BW_CAN_CTRL2_EACEN(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_EACEN), v))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RRS[17] (RW)
 *
 * If this bit is asserted Remote Request Frame is submitted to a matching
 * process and stored in the corresponding Message Buffer in the same fashion of a
 * Data Frame. No automatic Remote Response Frame will be generated. If this bit is
 * negated the Remote Request Frame is submitted to a matching process and an
 * automatic Remote Response Frame is generated if a Message Buffer with CODE=0b1010
 * is found with the same ID. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Remote Response Frame is generated.
 * - 1 - Remote Request Frame is stored.
 */
/*@{*/
#define BP_CAN_CTRL2_RRS     (17U)         /*!< Bit position for CAN_CTRL2_RRS. */
#define BM_CAN_CTRL2_RRS     (0x00020000U) /*!< Bit mask for CAN_CTRL2_RRS. */
#define BS_CAN_CTRL2_RRS     (1U)          /*!< Bit field size in bits for CAN_CTRL2_RRS. */

/*! @brief Read current value of the CAN_CTRL2_RRS field. */
#define BR_CAN_CTRL2_RRS(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_RRS)))

/*! @brief Format value for bitfield CAN_CTRL2_RRS. */
#define BF_CAN_CTRL2_RRS(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RRS) & BM_CAN_CTRL2_RRS)

/*! @brief Set the RRS field to a new value. */
#define BW_CAN_CTRL2_RRS(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_RRS), v))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field MRP[18] (RW)
 *
 * If this bit is set the matching process starts from the Mailboxes and if no
 * match occurs the matching continues on the Rx FIFO. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0 - Matching starts from Rx FIFO and continues on Mailboxes.
 * - 1 - Matching starts from Mailboxes and continues on Rx FIFO.
 */
/*@{*/
#define BP_CAN_CTRL2_MRP     (18U)         /*!< Bit position for CAN_CTRL2_MRP. */
#define BM_CAN_CTRL2_MRP     (0x00040000U) /*!< Bit mask for CAN_CTRL2_MRP. */
#define BS_CAN_CTRL2_MRP     (1U)          /*!< Bit field size in bits for CAN_CTRL2_MRP. */

/*! @brief Read current value of the CAN_CTRL2_MRP field. */
#define BR_CAN_CTRL2_MRP(x)  (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_MRP)))

/*! @brief Format value for bitfield CAN_CTRL2_MRP. */
#define BF_CAN_CTRL2_MRP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_MRP) & BM_CAN_CTRL2_MRP)

/*! @brief Set the MRP field to a new value. */
#define BW_CAN_CTRL2_MRP(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_MRP), v))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field TASD[23:19] (RW)
 *
 * This 5-bit field indicates how many CAN bits the Tx arbitration process start
 * point can be delayed from the first bit of CRC field on CAN bus. This field
 * can be written only in Freeze mode because it is blocked by hardware in other
 * modes. This field is useful to optimize the transmit performance based on
 * factors such as: peripheral/serial clock ratio, CAN bit timing and number of MBs.
 * The duration of an arbitration process, in terms of CAN bits, is directly
 * proportional to the number of available MBs and CAN baud rate and inversely
 * proportional to the peripheral clock frequency. The optimal arbitration timing is
 * that in which the last MB is scanned right before the first bit of the
 * Intermission field of a CAN frame. Therefore, if there are few MBs and the system/serial
 * clock ratio is high and the CAN baud rate is low then the arbitration can be
 * delayed and vice-versa. If TASD is 0 then the arbitration start is not
 * delayed, thus the CPU has less time to configure a Tx MB for the next arbitration,
 * but more time is reserved for arbitration. On the other hand, if TASD is 24 then
 * the CPU can configure a Tx MB later and less time is reserved for
 * arbitration. If too little time is reserved for arbitration the FlexCAN may be not able
 * to find winner MBs in time to compete with other nodes for the CAN bus. If the
 * arbitration ends too much time before the first bit of Intermission field then
 * there is a chance that the CPU reconfigures some Tx MBs and the winner MB is
 * not the best to be transmitted. The optimal configuration for TASD can be
 * calculated as: TASD = 25 - {f CANCLK * [MAXMB + 3 - (RFEN * 8) - (RFEN * RFFN *
 * 2)] * 2} / {f SYS * [1+(PSEG1+1)+(PSEG2+1)+(PROPSEG+1)] * (PRESDIV+1)} where: f
 * CANCLK is the Protocol Engine (PE) Clock (see section "Protocol Timing"), in
 * Hz f SYS is the peripheral clock, in Hz MAXMB is the value in CTRL1[MAXMB]
 * field RFEN is the value in CTRL1[RFEN] bit RFFN is the value in CTRL2[RFFN] field
 * PSEG1 is the value in CTRL1[PSEG1] field PSEG2 is the value in CTRL1[PSEG2]
 * field PROPSEG is the value in CTRL1[PROPSEG] field PRESDIV is the value in
 * CTRL1[PRESDIV] field See Section "Arbitration process" and Section "Protocol
 * Timing" for more details.
 */
/*@{*/
#define BP_CAN_CTRL2_TASD    (19U)         /*!< Bit position for CAN_CTRL2_TASD. */
#define BM_CAN_CTRL2_TASD    (0x00F80000U) /*!< Bit mask for CAN_CTRL2_TASD. */
#define BS_CAN_CTRL2_TASD    (5U)          /*!< Bit field size in bits for CAN_CTRL2_TASD. */

/*! @brief Read current value of the CAN_CTRL2_TASD field. */
#define BR_CAN_CTRL2_TASD(x) (UNION_READ(hw_can_ctrl2_t, HW_CAN_CTRL2_ADDR(x), U, B.TASD))

/*! @brief Format value for bitfield CAN_CTRL2_TASD. */
#define BF_CAN_CTRL2_TASD(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_TASD) & BM_CAN_CTRL2_TASD)

/*! @brief Set the TASD field to a new value. */
#define BW_CAN_CTRL2_TASD(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_TASD) | BF_CAN_CTRL2_TASD(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RFFN[27:24] (RW)
 *
 * This 4-bit field defines the number of Rx FIFO filters, as shown in the
 * following table. The maximum selectable number of filters is determined by the MCU.
 * This field can only be written in Freeze mode as it is blocked by hardware in
 * other modes. This field must not be programmed with values that make the
 * number of Message Buffers occupied by Rx FIFO and ID Filter exceed the number of
 * Mailboxes present, defined by MCR[MAXMB]. Each group of eight filters occupies
 * a memory space equivalent to two Message Buffers which means that the more
 * filters are implemented the less Mailboxes will be available. Considering that
 * the Rx FIFO occupies the memory space originally reserved for MB0-5, RFFN should
 * be programmed with a value correponding to a number of filters not greater
 * than the number of available memory words which can be calculated as follows:
 * (SETUP_MB - 6) * 4 where SETUP_MB is the least between NUMBER_OF_MB and MAXMB.
 * The number of remaining Mailboxes available will be: (SETUP_MB - 8) - (RFFN *
 * 2) If the Number of Rx FIFO Filters programmed through RFFN exceeds the
 * SETUP_MB value (memory space available) the exceeding ones will not be functional.
 * RFFN[3:0] Number of Rx FIFO filters Message Buffers occupied by Rx FIFO and ID
 * Filter Table Remaining Available MailboxesThe number of the last remaining
 * available mailboxes is defined by the least value between the parameter
 * NUMBER_OF_MB minus 1 and the MCR[MAXMB] field. Rx FIFO ID Filter Table Elements Affected
 * by Rx Individual MasksIf Rx Individual Mask Registers are not enabled then
 * all Rx FIFO filters are affected by the Rx FIFO Global Mask. Rx FIFO ID Filter
 * Table Elements Affected by Rx FIFO Global Mask #rxfgmask-note 0x0 8 MB 0-7 MB
 * 8-63 Elements 0-7 none 0x1 16 MB 0-9 MB 10-63 Elements 0-9 Elements 10-15 0x2
 * 24 MB 0-11 MB 12-63 Elements 0-11 Elements 12-23 0x3 32 MB 0-13 MB 14-63
 * Elements 0-13 Elements 14-31 0x4 40 MB 0-15 MB 16-63 Elements 0-15 Elements 16-39
 * 0x5 48 MB 0-17 MB 18-63 Elements 0-17 Elements 18-47 0x6 56 MB 0-19 MB 20-63
 * Elements 0-19 Elements 20-55 0x7 64 MB 0-21 MB 22-63 Elements 0-21 Elements 22-63
 * 0x8 72 MB 0-23 MB 24-63 Elements 0-23 Elements 24-71 0x9 80 MB 0-25 MB 26-63
 * Elements 0-25 Elements 26-79 0xA 88 MB 0-27 MB 28-63 Elements 0-27 Elements
 * 28-87 0xB 96 MB 0-29 MB 30-63 Elements 0-29 Elements 30-95 0xC 104 MB 0-31 MB
 * 32-63 Elements 0-31 Elements 32-103 0xD 112 MB 0-33 MB 34-63 Elements 0-31
 * Elements 32-111 0xE 120 MB 0-35 MB 36-63 Elements 0-31 Elements 32-119 0xF 128 MB
 * 0-37 MB 38-63 Elements 0-31 Elements 32-127
 */
/*@{*/
#define BP_CAN_CTRL2_RFFN    (24U)         /*!< Bit position for CAN_CTRL2_RFFN. */
#define BM_CAN_CTRL2_RFFN    (0x0F000000U) /*!< Bit mask for CAN_CTRL2_RFFN. */
#define BS_CAN_CTRL2_RFFN    (4U)          /*!< Bit field size in bits for CAN_CTRL2_RFFN. */

/*! @brief Read current value of the CAN_CTRL2_RFFN field. */
#define BR_CAN_CTRL2_RFFN(x) (UNION_READ(hw_can_ctrl2_t, HW_CAN_CTRL2_ADDR(x), U, B.RFFN))

/*! @brief Format value for bitfield CAN_CTRL2_RFFN. */
#define BF_CAN_CTRL2_RFFN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RFFN) & BM_CAN_CTRL2_RFFN)

/*! @brief Set the RFFN field to a new value. */
#define BW_CAN_CTRL2_RFFN(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_RFFN) | BF_CAN_CTRL2_RFFN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field WRMFRZ[28] (RW)
 *
 * Enable unrestricted write access to FlexCAN memory in Freeze mode. This bit
 * can only be written in Freeze mode and has no effect out of Freeze mode.
 *
 * Values:
 * - 0 - Maintain the write access restrictions.
 * - 1 - Enable unrestricted write access to FlexCAN memory.
 */
/*@{*/
#define BP_CAN_CTRL2_WRMFRZ  (28U)         /*!< Bit position for CAN_CTRL2_WRMFRZ. */
#define BM_CAN_CTRL2_WRMFRZ  (0x10000000U) /*!< Bit mask for CAN_CTRL2_WRMFRZ. */
#define BS_CAN_CTRL2_WRMFRZ  (1U)          /*!< Bit field size in bits for CAN_CTRL2_WRMFRZ. */

/*! @brief Read current value of the CAN_CTRL2_WRMFRZ field. */
#define BR_CAN_CTRL2_WRMFRZ(x) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_WRMFRZ)))

/*! @brief Format value for bitfield CAN_CTRL2_WRMFRZ. */
#define BF_CAN_CTRL2_WRMFRZ(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_WRMFRZ) & BM_CAN_CTRL2_WRMFRZ)

/*! @brief Set the WRMFRZ field to a new value. */
#define BW_CAN_CTRL2_WRMFRZ(x, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CTRL2_ADDR(x), BP_CAN_CTRL2_WRMFRZ), v))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR2 - Error and Status 2 register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR2 - Error and Status 2 register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various interrupt flags and some general status.
 */
typedef union _hw_can_esr2
{
    uint32_t U;
    struct _hw_can_esr2_bitfields
    {
        uint32_t RESERVED0 : 13;       /*!< [12:0]  */
        uint32_t IMB : 1;              /*!< [13] Inactive Mailbox */
        uint32_t VPS : 1;              /*!< [14] Valid Priority Status */
        uint32_t RESERVED1 : 1;        /*!< [15]  */
        uint32_t LPTM : 7;             /*!< [22:16] Lowest Priority Tx Mailbox */
        uint32_t RESERVED2 : 9;        /*!< [31:23]  */
    } B;
} hw_can_esr2_t;

/*!
 * @name Constants and macros for entire CAN_ESR2 register
 */
/*@{*/
#define HW_CAN_ESR2_ADDR(x)      ((x) + 0x38U)

#define HW_CAN_ESR2(x)           (*(__I hw_can_esr2_t *) HW_CAN_ESR2_ADDR(x))
#define HW_CAN_ESR2_RD(x)        (ADDRESS_READ(hw_can_esr2_t, HW_CAN_ESR2_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR2 bitfields
 */

/*!
 * @name Register CAN_ESR2, field IMB[13] (RO)
 *
 * If ESR2[VPS] is asserted, this bit indicates whether there is any inactive
 * Mailbox (CODE field is either 0b1000 or 0b0000). This bit is asserted in the
 * following cases: During arbitration, if an LPTM is found and it is inactive. If
 * IMB is not asserted and a frame is transmitted successfully. This bit is
 * cleared in all start of arbitration (see Section "Arbitration process"). LPTM
 * mechanism have the following behavior: if an MB is successfully transmitted and
 * ESR2[IMB]=0 (no inactive Mailbox), then ESR2[VPS] and ESR2[IMB] are asserted and
 * the index related to the MB just transmitted is loaded into ESR2[LPTM].
 *
 * Values:
 * - 0 - If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
 * - 1 - If ESR2[VPS] is asserted, there is at least one inactive Mailbox. LPTM
 *     content is the number of the first one.
 */
/*@{*/
#define BP_CAN_ESR2_IMB      (13U)         /*!< Bit position for CAN_ESR2_IMB. */
#define BM_CAN_ESR2_IMB      (0x00002000U) /*!< Bit mask for CAN_ESR2_IMB. */
#define BS_CAN_ESR2_IMB      (1U)          /*!< Bit field size in bits for CAN_ESR2_IMB. */

/*! @brief Read current value of the CAN_ESR2_IMB field. */
#define BR_CAN_ESR2_IMB(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR2_ADDR(x), BP_CAN_ESR2_IMB)))
/*@}*/

/*!
 * @name Register CAN_ESR2, field VPS[14] (RO)
 *
 * This bit indicates whether IMB and LPTM contents are currently valid or not.
 * VPS is asserted upon every complete Tx arbitration process unless the CPU
 * writes to Control and Status word of a Mailbox that has already been scanned, that
 * is, it is behind Tx Arbitration Pointer, during the Tx arbitration process.
 * If there is no inactive Mailbox and only one Tx Mailbox that is being
 * transmitted then VPS is not asserted. VPS is negated upon the start of every Tx
 * arbitration process or upon a write to Control and Status word of any Mailbox.
 * ESR2[VPS] is not affected by any CPU write into Control Status (C/S) of a MB that is
 * blocked by abort mechanism. When MCR[AEN] is asserted, the abort code write
 * in C/S of a MB that is being transmitted (pending abort), or any write attempt
 * into a Tx MB with IFLAG set is blocked.
 *
 * Values:
 * - 0 - Contents of IMB and LPTM are invalid.
 * - 1 - Contents of IMB and LPTM are valid.
 */
/*@{*/
#define BP_CAN_ESR2_VPS      (14U)         /*!< Bit position for CAN_ESR2_VPS. */
#define BM_CAN_ESR2_VPS      (0x00004000U) /*!< Bit mask for CAN_ESR2_VPS. */
#define BS_CAN_ESR2_VPS      (1U)          /*!< Bit field size in bits for CAN_ESR2_VPS. */

/*! @brief Read current value of the CAN_ESR2_VPS field. */
#define BR_CAN_ESR2_VPS(x)   (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_ESR2_ADDR(x), BP_CAN_ESR2_VPS)))
/*@}*/

/*!
 * @name Register CAN_ESR2, field LPTM[22:16] (RO)
 *
 * If ESR2[VPS] is asserted, this field indicates the lowest number inactive
 * Mailbox (see the IMB bit description). If there is no inactive Mailbox then the
 * Mailbox indicated depends on CTRL1[LBUF] bit value. If CTRL1[LBUF] bit is
 * negated then the Mailbox indicated is the one that has the greatest arbitration
 * value (see the "Highest priority Mailbox first" section). If CTRL1[LBUF] bit is
 * asserted then the Mailbox indicated is the highest number active Tx Mailbox. If
 * a Tx Mailbox is being transmitted it is not considered in LPTM calculation.
 * If ESR2[IMB] is not asserted and a frame is transmitted successfully, LPTM is
 * updated with its Mailbox number.
 */
/*@{*/
#define BP_CAN_ESR2_LPTM     (16U)         /*!< Bit position for CAN_ESR2_LPTM. */
#define BM_CAN_ESR2_LPTM     (0x007F0000U) /*!< Bit mask for CAN_ESR2_LPTM. */
#define BS_CAN_ESR2_LPTM     (7U)          /*!< Bit field size in bits for CAN_ESR2_LPTM. */

/*! @brief Read current value of the CAN_ESR2_LPTM field. */
#define BR_CAN_ESR2_LPTM(x)  (UNION_READ(hw_can_esr2_t, HW_CAN_ESR2_ADDR(x), U, B.LPTM))
/*@}*/

/*******************************************************************************
 * HW_CAN_CRCR - CRC Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CRCR - CRC Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register provides information about the CRC of transmitted messages.
 */
typedef union _hw_can_crcr
{
    uint32_t U;
    struct _hw_can_crcr_bitfields
    {
        uint32_t TXCRC : 15;           /*!< [14:0] CRC Transmitted */
        uint32_t RESERVED0 : 1;        /*!< [15]  */
        uint32_t MBCRC : 7;            /*!< [22:16] CRC Mailbox */
        uint32_t RESERVED1 : 9;        /*!< [31:23]  */
    } B;
} hw_can_crcr_t;

/*!
 * @name Constants and macros for entire CAN_CRCR register
 */
/*@{*/
#define HW_CAN_CRCR_ADDR(x)      ((x) + 0x44U)

#define HW_CAN_CRCR(x)           (*(__I hw_can_crcr_t *) HW_CAN_CRCR_ADDR(x))
#define HW_CAN_CRCR_RD(x)        (ADDRESS_READ(hw_can_crcr_t, HW_CAN_CRCR_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual CAN_CRCR bitfields
 */

/*!
 * @name Register CAN_CRCR, field TXCRC[14:0] (RO)
 *
 * This field indicates the CRC value of the last message transmitted. This
 * field is updated at the same time the Tx Interrupt Flag is asserted.
 */
/*@{*/
#define BP_CAN_CRCR_TXCRC    (0U)          /*!< Bit position for CAN_CRCR_TXCRC. */
#define BM_CAN_CRCR_TXCRC    (0x00007FFFU) /*!< Bit mask for CAN_CRCR_TXCRC. */
#define BS_CAN_CRCR_TXCRC    (15U)         /*!< Bit field size in bits for CAN_CRCR_TXCRC. */

/*! @brief Read current value of the CAN_CRCR_TXCRC field. */
#define BR_CAN_CRCR_TXCRC(x) (UNION_READ(hw_can_crcr_t, HW_CAN_CRCR_ADDR(x), U, B.TXCRC))
/*@}*/

/*!
 * @name Register CAN_CRCR, field MBCRC[22:16] (RO)
 *
 * This field indicates the number of the Mailbox corresponding to the value in
 * TXCRC field.
 */
/*@{*/
#define BP_CAN_CRCR_MBCRC    (16U)         /*!< Bit position for CAN_CRCR_MBCRC. */
#define BM_CAN_CRCR_MBCRC    (0x007F0000U) /*!< Bit mask for CAN_CRCR_MBCRC. */
#define BS_CAN_CRCR_MBCRC    (7U)          /*!< Bit field size in bits for CAN_CRCR_MBCRC. */

/*! @brief Read current value of the CAN_CRCR_MBCRC field. */
#define BR_CAN_CRCR_MBCRC(x) (UNION_READ(hw_can_crcr_t, HW_CAN_CRCR_ADDR(x), U, B.MBCRC))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFGMASK - Rx FIFO Global Mask register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFGMASK - Rx FIFO Global Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. If Rx FIFO is enabled RXFGMASK is used to
 * mask the Rx FIFO ID Filter Table elements that do not have a corresponding RXIMR
 * according to CTRL2[RFFN] field setting. This register can only be written in
 * Freeze mode as it is blocked by hardware in other modes.
 */
typedef union _hw_can_rxfgmask
{
    uint32_t U;
    struct _hw_can_rxfgmask_bitfields
    {
        uint32_t FGM : 32;             /*!< [31:0] Rx FIFO Global Mask Bits */
    } B;
} hw_can_rxfgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXFGMASK register
 */
/*@{*/
#define HW_CAN_RXFGMASK_ADDR(x)  ((x) + 0x48U)

#define HW_CAN_RXFGMASK(x)       (*(__IO hw_can_rxfgmask_t *) HW_CAN_RXFGMASK_ADDR(x))
#define HW_CAN_RXFGMASK_RD(x)    (ADDRESS_READ(hw_can_rxfgmask_t, HW_CAN_RXFGMASK_ADDR(x)))
#define HW_CAN_RXFGMASK_WR(x, v) (ADDRESS_WRITE(hw_can_rxfgmask_t, HW_CAN_RXFGMASK_ADDR(x), v))
#define HW_CAN_RXFGMASK_SET(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) |  (v)))
#define HW_CAN_RXFGMASK_CLR(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) & ~(v)))
#define HW_CAN_RXFGMASK_TOG(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXFGMASK bitfields
 */

/*!
 * @name Register CAN_RXFGMASK, field FGM[31:0] (RW)
 *
 * These bits mask the ID Filter Table elements bits in a perfect alignment. The
 * following table shows how the FGM bits correspond to each IDAF field. Rx FIFO
 * ID Filter Table Elements Format (MCR[IDAM]) Identifier Acceptance Filter
 * Fields RTR IDE RXIDA RXIDB If MCR[IDAM] field is equivalent to the format B only
 * the fourteen most significant bits of the Identifier of the incoming frame are
 * compared with the Rx FIFO filter. RXIDC If MCR[IDAM] field is equivalent to
 * the format C only the eight most significant bits of the Identifier of the
 * incoming frame are compared with the Rx FIFO filter. Reserved A FGM[31] FGM[30]
 * FGM[29:1] - - FGM[0] B FGM[31], FGM[15] FGM[30], FGM[14] - FGM[29:16], FGM[13:0]
 * - C - - - FGM[31:24], FGM[23:16], FGM[15:8], FGM[7:0]
 *
 * Values:
 * - 0 - The corresponding bit in the filter is "don't care."
 * - 1 - The corresponding bit in the filter is checked.
 */
/*@{*/
#define BP_CAN_RXFGMASK_FGM  (0U)          /*!< Bit position for CAN_RXFGMASK_FGM. */
#define BM_CAN_RXFGMASK_FGM  (0xFFFFFFFFU) /*!< Bit mask for CAN_RXFGMASK_FGM. */
#define BS_CAN_RXFGMASK_FGM  (32U)         /*!< Bit field size in bits for CAN_RXFGMASK_FGM. */

/*! @brief Read current value of the CAN_RXFGMASK_FGM field. */
#define BR_CAN_RXFGMASK_FGM(x) (HW_CAN_RXFGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXFGMASK_FGM. */
#define BF_CAN_RXFGMASK_FGM(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXFGMASK_FGM) & BM_CAN_RXFGMASK_FGM)

/*! @brief Set the FGM field to a new value. */
#define BW_CAN_RXFGMASK_FGM(x, v) (HW_CAN_RXFGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFIR - Rx FIFO Information Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFIR - Rx FIFO Information Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * RXFIR provides information on Rx FIFO. This register is the port through
 * which the CPU accesses the output of the RXFIR FIFO located in RAM. The RXFIR FIFO
 * is written by the FlexCAN whenever a new message is moved into the Rx FIFO as
 * well as its output is updated whenever the output of the Rx FIFO is updated
 * with the next message. See Section "Rx FIFO" for instructions on reading this
 * register.
 */
typedef union _hw_can_rxfir
{
    uint32_t U;
    struct _hw_can_rxfir_bitfields
    {
        uint32_t IDHIT : 9;            /*!< [8:0] Identifier Acceptance Filter Hit
                                        * Indicator */
        uint32_t RESERVED0 : 23;       /*!< [31:9]  */
    } B;
} hw_can_rxfir_t;

/*!
 * @name Constants and macros for entire CAN_RXFIR register
 */
/*@{*/
#define HW_CAN_RXFIR_ADDR(x)     ((x) + 0x4CU)

#define HW_CAN_RXFIR(x)          (*(__I hw_can_rxfir_t *) HW_CAN_RXFIR_ADDR(x))
#define HW_CAN_RXFIR_RD(x)       (ADDRESS_READ(hw_can_rxfir_t, HW_CAN_RXFIR_ADDR(x)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXFIR bitfields
 */

/*!
 * @name Register CAN_RXFIR, field IDHIT[8:0] (RO)
 *
 * This field indicates which Identifier Acceptance Filter was hit by the
 * received message that is in the output of the Rx FIFO. If multiple filters match the
 * incoming message ID then the first matching IDAF found (lowest number) by the
 * matching process is indicated. This field is valid only while the
 * IFLAG[BUF5I] is asserted.
 */
/*@{*/
#define BP_CAN_RXFIR_IDHIT   (0U)          /*!< Bit position for CAN_RXFIR_IDHIT. */
#define BM_CAN_RXFIR_IDHIT   (0x000001FFU) /*!< Bit mask for CAN_RXFIR_IDHIT. */
#define BS_CAN_RXFIR_IDHIT   (9U)          /*!< Bit field size in bits for CAN_RXFIR_IDHIT. */

/*! @brief Read current value of the CAN_RXFIR_IDHIT field. */
#define BR_CAN_RXFIR_IDHIT(x) (UNION_READ(hw_can_rxfir_t, HW_CAN_RXFIR_ADDR(x), U, B.IDHIT))
/*@}*/

/*******************************************************************************
 * HW_CAN_CSn - Message Buffer 0 CS Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CSn - Message Buffer 0 CS Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_csn
{
    uint32_t U;
    struct _hw_can_csn_bitfields
    {
        uint32_t TIME_STAMP : 16;      /*!< [15:0] Free-Running Counter Time
                                        * stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx
                                        * and Rx frames at the time when the beginning of the Identifier field
                                        * appears on the CAN bus. */
        uint32_t DLC : 4;              /*!< [19:16] Length of the data to be
                                        * stored/transmitted. */
        uint32_t RTR : 1;              /*!< [20] Remote Transmission Request. One/zero for
                                        * remote/data frame. */
        uint32_t IDE : 1;              /*!< [21] ID Extended. One/zero for
                                        * extended/standard format frame. */
        uint32_t SRR : 1;              /*!< [22] Substitute Remote Request. Contains a
                                        * fixed recessive bit. */
        uint32_t RESERVED0 : 1;        /*!< [23] Reserved */
        uint32_t CODE : 4;             /*!< [27:24] Reserved */
        uint32_t RESERVED1 : 4;        /*!< [31:28] Reserved */
    } B;
} hw_can_csn_t;

/*!
 * @name Constants and macros for entire CAN_CSn register
 */
/*@{*/
#define HW_CAN_CSn_COUNT (16U)

#define HW_CAN_CSn_ADDR(x, n)    ((x) + 0x80U + (0x10U * (n)))

#define HW_CAN_CSn(x, n)         (*(__IO hw_can_csn_t *) HW_CAN_CSn_ADDR(x, n))
#define HW_CAN_CSn_RD(x, n)      (ADDRESS_READ(hw_can_csn_t, HW_CAN_CSn_ADDR(x, n)))
#define HW_CAN_CSn_WR(x, n, v)   (ADDRESS_WRITE(hw_can_csn_t, HW_CAN_CSn_ADDR(x, n), v))
#define HW_CAN_CSn_SET(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) |  (v)))
#define HW_CAN_CSn_CLR(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) & ~(v)))
#define HW_CAN_CSn_TOG(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CSn bitfields
 */

/*!
 * @name Register CAN_CSn, field TIME_STAMP[15:0] (RW)
 */
/*@{*/
#define BP_CAN_CSn_TIME_STAMP (0U)         /*!< Bit position for CAN_CSn_TIME_STAMP. */
#define BM_CAN_CSn_TIME_STAMP (0x0000FFFFU) /*!< Bit mask for CAN_CSn_TIME_STAMP. */
#define BS_CAN_CSn_TIME_STAMP (16U)        /*!< Bit field size in bits for CAN_CSn_TIME_STAMP. */

/*! @brief Read current value of the CAN_CSn_TIME_STAMP field. */
#define BR_CAN_CSn_TIME_STAMP(x, n) (UNION_READ(hw_can_csn_t, HW_CAN_CSn_ADDR(x, n), U, B.TIME_STAMP))

/*! @brief Format value for bitfield CAN_CSn_TIME_STAMP. */
#define BF_CAN_CSn_TIME_STAMP(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_TIME_STAMP) & BM_CAN_CSn_TIME_STAMP)

/*! @brief Set the TIME_STAMP field to a new value. */
#define BW_CAN_CSn_TIME_STAMP(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_TIME_STAMP) | BF_CAN_CSn_TIME_STAMP(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field DLC[19:16] (RW)
 */
/*@{*/
#define BP_CAN_CSn_DLC       (16U)         /*!< Bit position for CAN_CSn_DLC. */
#define BM_CAN_CSn_DLC       (0x000F0000U) /*!< Bit mask for CAN_CSn_DLC. */
#define BS_CAN_CSn_DLC       (4U)          /*!< Bit field size in bits for CAN_CSn_DLC. */

/*! @brief Read current value of the CAN_CSn_DLC field. */
#define BR_CAN_CSn_DLC(x, n) (UNION_READ(hw_can_csn_t, HW_CAN_CSn_ADDR(x, n), U, B.DLC))

/*! @brief Format value for bitfield CAN_CSn_DLC. */
#define BF_CAN_CSn_DLC(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_DLC) & BM_CAN_CSn_DLC)

/*! @brief Set the DLC field to a new value. */
#define BW_CAN_CSn_DLC(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_DLC) | BF_CAN_CSn_DLC(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field RTR[20] (RW)
 */
/*@{*/
#define BP_CAN_CSn_RTR       (20U)         /*!< Bit position for CAN_CSn_RTR. */
#define BM_CAN_CSn_RTR       (0x00100000U) /*!< Bit mask for CAN_CSn_RTR. */
#define BS_CAN_CSn_RTR       (1U)          /*!< Bit field size in bits for CAN_CSn_RTR. */

/*! @brief Read current value of the CAN_CSn_RTR field. */
#define BR_CAN_CSn_RTR(x, n) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_RTR)))

/*! @brief Format value for bitfield CAN_CSn_RTR. */
#define BF_CAN_CSn_RTR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_RTR) & BM_CAN_CSn_RTR)

/*! @brief Set the RTR field to a new value. */
#define BW_CAN_CSn_RTR(x, n, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_RTR), v))
/*@}*/

/*!
 * @name Register CAN_CSn, field IDE[21] (RW)
 */
/*@{*/
#define BP_CAN_CSn_IDE       (21U)         /*!< Bit position for CAN_CSn_IDE. */
#define BM_CAN_CSn_IDE       (0x00200000U) /*!< Bit mask for CAN_CSn_IDE. */
#define BS_CAN_CSn_IDE       (1U)          /*!< Bit field size in bits for CAN_CSn_IDE. */

/*! @brief Read current value of the CAN_CSn_IDE field. */
#define BR_CAN_CSn_IDE(x, n) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_IDE)))

/*! @brief Format value for bitfield CAN_CSn_IDE. */
#define BF_CAN_CSn_IDE(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_IDE) & BM_CAN_CSn_IDE)

/*! @brief Set the IDE field to a new value. */
#define BW_CAN_CSn_IDE(x, n, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_IDE), v))
/*@}*/

/*!
 * @name Register CAN_CSn, field SRR[22] (RW)
 */
/*@{*/
#define BP_CAN_CSn_SRR       (22U)         /*!< Bit position for CAN_CSn_SRR. */
#define BM_CAN_CSn_SRR       (0x00400000U) /*!< Bit mask for CAN_CSn_SRR. */
#define BS_CAN_CSn_SRR       (1U)          /*!< Bit field size in bits for CAN_CSn_SRR. */

/*! @brief Read current value of the CAN_CSn_SRR field. */
#define BR_CAN_CSn_SRR(x, n) (ADDRESS_READ(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_SRR)))

/*! @brief Format value for bitfield CAN_CSn_SRR. */
#define BF_CAN_CSn_SRR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_SRR) & BM_CAN_CSn_SRR)

/*! @brief Set the SRR field to a new value. */
#define BW_CAN_CSn_SRR(x, n, v) (ADDRESS_WRITE(uint32_t, BITBAND_ADDRESS32(HW_CAN_CSn_ADDR(x, n), BP_CAN_CSn_SRR), v))
/*@}*/

/*!
 * @name Register CAN_CSn, field CODE[27:24] (RW)
 */
/*@{*/
#define BP_CAN_CSn_CODE      (24U)         /*!< Bit position for CAN_CSn_CODE. */
#define BM_CAN_CSn_CODE      (0x0F000000U) /*!< Bit mask for CAN_CSn_CODE. */
#define BS_CAN_CSn_CODE      (4U)          /*!< Bit field size in bits for CAN_CSn_CODE. */

/*! @brief Read current value of the CAN_CSn_CODE field. */
#define BR_CAN_CSn_CODE(x, n) (UNION_READ(hw_can_csn_t, HW_CAN_CSn_ADDR(x, n), U, B.CODE))

/*! @brief Format value for bitfield CAN_CSn_CODE. */
#define BF_CAN_CSn_CODE(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_CODE) & BM_CAN_CSn_CODE)

/*! @brief Set the CODE field to a new value. */
#define BW_CAN_CSn_CODE(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_CODE) | BF_CAN_CSn_CODE(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_IDn - Message Buffer 0 ID Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IDn - Message Buffer 0 ID Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_idn
{
    uint32_t U;
    struct _hw_can_idn_bitfields
    {
        uint32_t EXT : 18;             /*!< [17:0] Contains extended (LOW word)
                                        * identifier of message buffer. */
        uint32_t STD : 11;             /*!< [28:18] Contains standard/extended (HIGH
                                        * word) identifier of message buffer. */
        uint32_t PRIO : 3;             /*!< [31:29] Local priority. This 3-bit fieldis
                                        * only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx
                                        * buffers. These bits are not transmitted. They are appended to the regular
                                        * ID to define the transmission priority. */
    } B;
} hw_can_idn_t;

/*!
 * @name Constants and macros for entire CAN_IDn register
 */
/*@{*/
#define HW_CAN_IDn_COUNT (16U)

#define HW_CAN_IDn_ADDR(x, n)    ((x) + 0x84U + (0x10U * (n)))

#define HW_CAN_IDn(x, n)         (*(__IO hw_can_idn_t *) HW_CAN_IDn_ADDR(x, n))
#define HW_CAN_IDn_RD(x, n)      (ADDRESS_READ(hw_can_idn_t, HW_CAN_IDn_ADDR(x, n)))
#define HW_CAN_IDn_WR(x, n, v)   (ADDRESS_WRITE(hw_can_idn_t, HW_CAN_IDn_ADDR(x, n), v))
#define HW_CAN_IDn_SET(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) |  (v)))
#define HW_CAN_IDn_CLR(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) & ~(v)))
#define HW_CAN_IDn_TOG(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IDn bitfields
 */

/*!
 * @name Register CAN_IDn, field EXT[17:0] (RW)
 */
/*@{*/
#define BP_CAN_IDn_EXT       (0U)          /*!< Bit position for CAN_IDn_EXT. */
#define BM_CAN_IDn_EXT       (0x0003FFFFU) /*!< Bit mask for CAN_IDn_EXT. */
#define BS_CAN_IDn_EXT       (18U)         /*!< Bit field size in bits for CAN_IDn_EXT. */

/*! @brief Read current value of the CAN_IDn_EXT field. */
#define BR_CAN_IDn_EXT(x, n) (UNION_READ(hw_can_idn_t, HW_CAN_IDn_ADDR(x, n), U, B.EXT))

/*! @brief Format value for bitfield CAN_IDn_EXT. */
#define BF_CAN_IDn_EXT(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_EXT) & BM_CAN_IDn_EXT)

/*! @brief Set the EXT field to a new value. */
#define BW_CAN_IDn_EXT(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_EXT) | BF_CAN_IDn_EXT(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field STD[28:18] (RW)
 */
/*@{*/
#define BP_CAN_IDn_STD       (18U)         /*!< Bit position for CAN_IDn_STD. */
#define BM_CAN_IDn_STD       (0x1FFC0000U) /*!< Bit mask for CAN_IDn_STD. */
#define BS_CAN_IDn_STD       (11U)         /*!< Bit field size in bits for CAN_IDn_STD. */

/*! @brief Read current value of the CAN_IDn_STD field. */
#define BR_CAN_IDn_STD(x, n) (UNION_READ(hw_can_idn_t, HW_CAN_IDn_ADDR(x, n), U, B.STD))

/*! @brief Format value for bitfield CAN_IDn_STD. */
#define BF_CAN_IDn_STD(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_STD) & BM_CAN_IDn_STD)

/*! @brief Set the STD field to a new value. */
#define BW_CAN_IDn_STD(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_STD) | BF_CAN_IDn_STD(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field PRIO[31:29] (RW)
 */
/*@{*/
#define BP_CAN_IDn_PRIO      (29U)         /*!< Bit position for CAN_IDn_PRIO. */
#define BM_CAN_IDn_PRIO      (0xE0000000U) /*!< Bit mask for CAN_IDn_PRIO. */
#define BS_CAN_IDn_PRIO      (3U)          /*!< Bit field size in bits for CAN_IDn_PRIO. */

/*! @brief Read current value of the CAN_IDn_PRIO field. */
#define BR_CAN_IDn_PRIO(x, n) (UNION_READ(hw_can_idn_t, HW_CAN_IDn_ADDR(x, n), U, B.PRIO))

/*! @brief Format value for bitfield CAN_IDn_PRIO. */
#define BF_CAN_IDn_PRIO(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_PRIO) & BM_CAN_IDn_PRIO)

/*! @brief Set the PRIO field to a new value. */
#define BW_CAN_IDn_PRIO(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_PRIO) | BF_CAN_IDn_PRIO(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD0n - Message Buffer 0 WORD0 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word0n
{
    uint32_t U;
    struct _hw_can_word0n_bitfields
    {
        uint32_t DATA_BYTE_3 : 8;      /*!< [7:0] Data byte 3 of Rx/Tx frame. */
        uint32_t DATA_BYTE_2 : 8;      /*!< [15:8] Data byte 2 of Rx/Tx frame. */
        uint32_t DATA_BYTE_1 : 8;      /*!< [23:16] Data byte 1 of Rx/Tx frame. */
        uint32_t DATA_BYTE_0 : 8;      /*!< [31:24] Data byte 0 of Rx/Tx frame. */
    } B;
} hw_can_word0n_t;

/*!
 * @name Constants and macros for entire CAN_WORD0n register
 */
/*@{*/
#define HW_CAN_WORD0n_COUNT (16U)

#define HW_CAN_WORD0n_ADDR(x, n) ((x) + 0x88U + (0x10U * (n)))

#define HW_CAN_WORD0n(x, n)      (*(__IO hw_can_word0n_t *) HW_CAN_WORD0n_ADDR(x, n))
#define HW_CAN_WORD0n_RD(x, n)   (ADDRESS_READ(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n)))
#define HW_CAN_WORD0n_WR(x, n, v) (ADDRESS_WRITE(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n), v))
#define HW_CAN_WORD0n_SET(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) |  (v)))
#define HW_CAN_WORD0n_CLR(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) & ~(v)))
#define HW_CAN_WORD0n_TOG(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD0n bitfields
 */

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_3[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_3 (0U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_3. */
#define BM_CAN_WORD0n_DATA_BYTE_3 (0x000000FFU) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_3. */
#define BS_CAN_WORD0n_DATA_BYTE_3 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_3. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_3 field. */
#define BR_CAN_WORD0n_DATA_BYTE_3(x, n) (UNION_READ(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n), U, B.DATA_BYTE_3))

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_3. */
#define BF_CAN_WORD0n_DATA_BYTE_3(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_3) & BM_CAN_WORD0n_DATA_BYTE_3)

/*! @brief Set the DATA_BYTE_3 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_3(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_3) | BF_CAN_WORD0n_DATA_BYTE_3(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_2[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_2. */
#define BM_CAN_WORD0n_DATA_BYTE_2 (0x0000FF00U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_2. */
#define BS_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_2. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_2 field. */
#define BR_CAN_WORD0n_DATA_BYTE_2(x, n) (UNION_READ(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n), U, B.DATA_BYTE_2))

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_2. */
#define BF_CAN_WORD0n_DATA_BYTE_2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_2) & BM_CAN_WORD0n_DATA_BYTE_2)

/*! @brief Set the DATA_BYTE_2 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_2(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_2) | BF_CAN_WORD0n_DATA_BYTE_2(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_1[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_1 (16U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_1. */
#define BM_CAN_WORD0n_DATA_BYTE_1 (0x00FF0000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_1. */
#define BS_CAN_WORD0n_DATA_BYTE_1 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_1. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_1 field. */
#define BR_CAN_WORD0n_DATA_BYTE_1(x, n) (UNION_READ(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n), U, B.DATA_BYTE_1))

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_1. */
#define BF_CAN_WORD0n_DATA_BYTE_1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_1) & BM_CAN_WORD0n_DATA_BYTE_1)

/*! @brief Set the DATA_BYTE_1 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_1(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_1) | BF_CAN_WORD0n_DATA_BYTE_1(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_0[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_0 (24U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_0. */
#define BM_CAN_WORD0n_DATA_BYTE_0 (0xFF000000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_0. */
#define BS_CAN_WORD0n_DATA_BYTE_0 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_0. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_0 field. */
#define BR_CAN_WORD0n_DATA_BYTE_0(x, n) (UNION_READ(hw_can_word0n_t, HW_CAN_WORD0n_ADDR(x, n), U, B.DATA_BYTE_0))

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_0. */
#define BF_CAN_WORD0n_DATA_BYTE_0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_0) & BM_CAN_WORD0n_DATA_BYTE_0)

/*! @brief Set the DATA_BYTE_0 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_0(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_0) | BF_CAN_WORD0n_DATA_BYTE_0(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD1n - Message Buffer 0 WORD1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word1n
{
    uint32_t U;
    struct _hw_can_word1n_bitfields
    {
        uint32_t DATA_BYTE_7 : 8;      /*!< [7:0] Data byte 7 of Rx/Tx frame. */
        uint32_t DATA_BYTE_6 : 8;      /*!< [15:8] Data byte 6 of Rx/Tx frame. */
        uint32_t DATA_BYTE_5 : 8;      /*!< [23:16] Data byte 5 of Rx/Tx frame. */
        uint32_t DATA_BYTE_4 : 8;      /*!< [31:24] Data byte 4 of Rx/Tx frame. */
    } B;
} hw_can_word1n_t;

/*!
 * @name Constants and macros for entire CAN_WORD1n register
 */
/*@{*/
#define HW_CAN_WORD1n_COUNT (16U)

#define HW_CAN_WORD1n_ADDR(x, n) ((x) + 0x8CU + (0x10U * (n)))

#define HW_CAN_WORD1n(x, n)      (*(__IO hw_can_word1n_t *) HW_CAN_WORD1n_ADDR(x, n))
#define HW_CAN_WORD1n_RD(x, n)   (ADDRESS_READ(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n)))
#define HW_CAN_WORD1n_WR(x, n, v) (ADDRESS_WRITE(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n), v))
#define HW_CAN_WORD1n_SET(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) |  (v)))
#define HW_CAN_WORD1n_CLR(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) & ~(v)))
#define HW_CAN_WORD1n_TOG(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD1n bitfields
 */

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_7[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_7 (0U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_7. */
#define BM_CAN_WORD1n_DATA_BYTE_7 (0x000000FFU) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_7. */
#define BS_CAN_WORD1n_DATA_BYTE_7 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_7. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_7 field. */
#define BR_CAN_WORD1n_DATA_BYTE_7(x, n) (UNION_READ(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n), U, B.DATA_BYTE_7))

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_7. */
#define BF_CAN_WORD1n_DATA_BYTE_7(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_7) & BM_CAN_WORD1n_DATA_BYTE_7)

/*! @brief Set the DATA_BYTE_7 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_7(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_7) | BF_CAN_WORD1n_DATA_BYTE_7(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_6[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_6. */
#define BM_CAN_WORD1n_DATA_BYTE_6 (0x0000FF00U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_6. */
#define BS_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_6. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_6 field. */
#define BR_CAN_WORD1n_DATA_BYTE_6(x, n) (UNION_READ(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n), U, B.DATA_BYTE_6))

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_6. */
#define BF_CAN_WORD1n_DATA_BYTE_6(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_6) & BM_CAN_WORD1n_DATA_BYTE_6)

/*! @brief Set the DATA_BYTE_6 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_6(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_6) | BF_CAN_WORD1n_DATA_BYTE_6(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_5[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_5 (16U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_5. */
#define BM_CAN_WORD1n_DATA_BYTE_5 (0x00FF0000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_5. */
#define BS_CAN_WORD1n_DATA_BYTE_5 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_5. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_5 field. */
#define BR_CAN_WORD1n_DATA_BYTE_5(x, n) (UNION_READ(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n), U, B.DATA_BYTE_5))

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_5. */
#define BF_CAN_WORD1n_DATA_BYTE_5(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_5) & BM_CAN_WORD1n_DATA_BYTE_5)

/*! @brief Set the DATA_BYTE_5 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_5(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_5) | BF_CAN_WORD1n_DATA_BYTE_5(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_4[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_4 (24U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_4. */
#define BM_CAN_WORD1n_DATA_BYTE_4 (0xFF000000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_4. */
#define BS_CAN_WORD1n_DATA_BYTE_4 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_4. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_4 field. */
#define BR_CAN_WORD1n_DATA_BYTE_4(x, n) (UNION_READ(hw_can_word1n_t, HW_CAN_WORD1n_ADDR(x, n), U, B.DATA_BYTE_4))

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_4. */
#define BF_CAN_WORD1n_DATA_BYTE_4(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_4) & BM_CAN_WORD1n_DATA_BYTE_4)

/*! @brief Set the DATA_BYTE_4 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_4(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_4) | BF_CAN_WORD1n_DATA_BYTE_4(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXIMRn - Rx Individual Mask Registers
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXIMRn - Rx Individual Mask Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers are located in RAM. RXIMR are used as acceptance masks for ID
 * filtering in Rx MBs and the Rx FIFO. If the Rx FIFO is not enabled, one mask
 * register is provided for each available Mailbox, providing ID masking
 * capability on a per Mailbox basis. When the Rx FIFO is enabled (MCR[RFEN] bit is
 * asserted), up to 32 Rx Individual Mask Registers can apply to the Rx FIFO ID Filter
 * Table elements on a one-to-one correspondence depending on the setting of
 * CTRL2[RFFN]. RXIMR can only be written by the CPU while the module is in Freeze
 * mode; otherwise, they are blocked by hardware. The Individual Rx Mask Registers
 * are not affected by reset and must be explicitly initialized prior to any
 * reception.
 */
typedef union _hw_can_rximrn
{
    uint32_t U;
    struct _hw_can_rximrn_bitfields
    {
        uint32_t MI : 32;              /*!< [31:0] Individual Mask Bits */
    } B;
} hw_can_rximrn_t;

/*!
 * @name Constants and macros for entire CAN_RXIMRn register
 */
/*@{*/
#define HW_CAN_RXIMRn_COUNT (16U)

#define HW_CAN_RXIMRn_ADDR(x, n) ((x) + 0x880U + (0x4U * (n)))

#define HW_CAN_RXIMRn(x, n)      (*(__IO hw_can_rximrn_t *) HW_CAN_RXIMRn_ADDR(x, n))
#define HW_CAN_RXIMRn_RD(x, n)   (ADDRESS_READ(hw_can_rximrn_t, HW_CAN_RXIMRn_ADDR(x, n)))
#define HW_CAN_RXIMRn_WR(x, n, v) (ADDRESS_WRITE(hw_can_rximrn_t, HW_CAN_RXIMRn_ADDR(x, n), v))
#define HW_CAN_RXIMRn_SET(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) |  (v)))
#define HW_CAN_RXIMRn_CLR(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) & ~(v)))
#define HW_CAN_RXIMRn_TOG(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXIMRn bitfields
 */

/*!
 * @name Register CAN_RXIMRn, field MI[31:0] (RW)
 *
 * Each Individual Mask Bit masks the corresponding bit in both the Mailbox
 * filter and Rx FIFO ID Filter Table element in distinct ways. For Mailbox filters,
 * see the RXMGMASK register description. For Rx FIFO ID Filter Table elements,
 * see the RXFGMASK register description.
 *
 * Values:
 * - 0 - The corresponding bit in the filter is "don't care."
 * - 1 - The corresponding bit in the filter is checked.
 */
/*@{*/
#define BP_CAN_RXIMRn_MI     (0U)          /*!< Bit position for CAN_RXIMRn_MI. */
#define BM_CAN_RXIMRn_MI     (0xFFFFFFFFU) /*!< Bit mask for CAN_RXIMRn_MI. */
#define BS_CAN_RXIMRn_MI     (32U)         /*!< Bit field size in bits for CAN_RXIMRn_MI. */

/*! @brief Read current value of the CAN_RXIMRn_MI field. */
#define BR_CAN_RXIMRn_MI(x, n) (HW_CAN_RXIMRn(x, n).U)

/*! @brief Format value for bitfield CAN_RXIMRn_MI. */
#define BF_CAN_RXIMRn_MI(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_RXIMRn_MI) & BM_CAN_RXIMRn_MI)

/*! @brief Set the MI field to a new value. */
#define BW_CAN_RXIMRn_MI(x, n, v) (HW_CAN_RXIMRn_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * hw_can_t - module struct
 ******************************************************************************/
/*!
 * @brief All CAN module registers.
 */
#pragma pack(1)
typedef struct _hw_can
{
    __IO hw_can_mcr_t MCR;                 /*!< [0x0] Module Configuration Register */
    __IO hw_can_ctrl1_t CTRL1;             /*!< [0x4] Control 1 register */
    __IO hw_can_timer_t TIMER;             /*!< [0x8] Free Running Timer */
    uint8_t _reserved0[4];
    __IO hw_can_rxmgmask_t RXMGMASK;       /*!< [0x10] Rx Mailboxes Global Mask Register */
    __IO hw_can_rx14mask_t RX14MASK;       /*!< [0x14] Rx 14 Mask register */
    __IO hw_can_rx15mask_t RX15MASK;       /*!< [0x18] Rx 15 Mask register */
    __IO hw_can_ecr_t ECR;                 /*!< [0x1C] Error Counter */
    __IO hw_can_esr1_t ESR1;               /*!< [0x20] Error and Status 1 register */
    uint8_t _reserved1[4];
    __IO hw_can_imask1_t IMASK1;           /*!< [0x28] Interrupt Masks 1 register */
    uint8_t _reserved2[4];
    __IO hw_can_iflag1_t IFLAG1;           /*!< [0x30] Interrupt Flags 1 register */
    __IO hw_can_ctrl2_t CTRL2;             /*!< [0x34] Control 2 register */
    __I hw_can_esr2_t ESR2;                /*!< [0x38] Error and Status 2 register */
    uint8_t _reserved3[8];
    __I hw_can_crcr_t CRCR;                /*!< [0x44] CRC Register */
    __IO hw_can_rxfgmask_t RXFGMASK;       /*!< [0x48] Rx FIFO Global Mask register */
    __I hw_can_rxfir_t RXFIR;              /*!< [0x4C] Rx FIFO Information Register */
    uint8_t _reserved4[48];
    struct {
        __IO hw_can_csn_t CSn;             /*!< [0x80] Message Buffer 0 CS Register */
        __IO hw_can_idn_t IDn;             /*!< [0x84] Message Buffer 0 ID Register */
        __IO hw_can_word0n_t WORD0n;       /*!< [0x88] Message Buffer 0 WORD0 Register */
        __IO hw_can_word1n_t WORD1n;       /*!< [0x8C] Message Buffer 0 WORD1 Register */
    } MB[16];
    uint8_t _reserved5[1792];
    __IO hw_can_rximrn_t RXIMRn[16];       /*!< [0x880] Rx Individual Mask Registers */
} hw_can_t;
#pragma pack()

/*! @brief Macro to access all CAN registers. */
/*! @param x CAN module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CAN(CAN0_BASE)</code>. */
#define HW_CAN(x)      (*(hw_can_t *)(x))

#endif /* __HW_CAN_REGISTERS_H__ */
/* EOF */
