/*
Parse of  string for COM-port. As examle - COM from GPS.
Program for step to step read bytes from port (file) and separating stream of bytes on substrings in real time. Separator  is  a comma.
Разбор строки для COM-порта. В качестве примера - COM из GPS.
Программа для пошагового чтения байтов из порта (файла) и разделения потока байтов на подстроки в реальном времени. Разделитель - запятая.
*/
#include "mbed.h"
#include "stdio.h"


#define maxnstr 20                                                              // maximum nbr of params(sybstrings) used to hold the data fields
#define maxnsym 20                                                              // maximum nbr of symbols
char arg$[maxnstr][maxnsym]={""};                                               // 
int nstr=0;                                                                     //номер подстроки (number of substring)
int nsym=0;                                                                     //и номер символа строки в двумерном массиве строк arg$[][]
char x$;                                                                        //байтовый символ полученный из порта (или файла) 
Serial pc(USBTX, USBRX);                                                        // tx, rx for F411RE    out port diagnostica
Serial gps(PA_9, PA_10);                                                        // tx, rx for F411RE    in port nmea
//Serial pc(PA_9,PA_10);                                                        // tx, rx for F091RC    out port diagnostica
//Serial gps(PC_10,PC_11);                                                      // tx, rx for F091RC    in port nmea
int GetGPSData()
{
  do{
      do{x$ = gps.getc();
        } while(x$!='$');                                                       //ждем $ -символ начала строки (first symbol of new string)
       for ( nstr = 0; nstr< maxnstr; nstr++)
       {nsym=0;                                                                 //обнуление индекса символа, подготовка для создания новой строки   
        do{ x$ = gps.getc();              
            if (x$ == ','){arg$[nstr][nsym] ='\0';break;}                       //вставка окончания строки и выход из цикла             
            if (x$ == '\n'){return 0;}                                          //символ окончания сообщения - команда на выход (symbol of end string)
            arg$[nstr][nsym] = x$ ;                                             //побайтовое создание новой строки в массиве строк
            nsym=nsym+1;          
          } while(1);                               
       }                                
    } while(1);
}

int main() 
{   pc.baud(115200);
    gps.baud(9600);
    pc.printf("***********************Device Starting**************\r\n");
   
  while(1)                                                                      //main  cycle
  {   
    GetGPSData();                                                               //ловим очередную строку сообщения и разбиваем на подстроки
    for (int i=0; i<nstr; i++) {pc.printf("arg$[%d]=%s\r\n",i, arg$[i]);}       //поcтрочный вывод из массива

  }

}