
//
// using 2.4TFT shield 320x240 on NucleoF411RE
//
#include "stdio.h"
#include "mbed.h"
#include "string"
#include "Arial24x23.h"
#include "ILI9341.h"

#define PI (3.141592653589793)

Serial pc(USBTX, USBRX);

PinName buspins[8]={D8,D9,D2,D3,D4,D5,D6,D7};
ILI9341 myLCD(BUS_8, buspins, A3, A4, A2, A1, A0,"myLCD"); // Parallel Bus 8bit, buspins array, CS, reset, RS, WR, RD

Timer timer;

const double d2r = PI / 180.0;
const double r2d = 180.0 / PI;

unsigned short backgroundcolor=Black;
unsigned short foregroundcolor=White;

float k0;
float a;
float m0[5];
double k0_;
double a_;
double m0_[5];



int main()
{
    int time;
    timer.start();
    myLCD.cls();   
    myLCD.set_orientation(1);   
    pc.baud (115200);
    myLCD.background(Black);    // set background to black
    myLCD.foreground(White);    // set chars to white
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(1,10);
    myLCD.printf("Speedtest STM32F411");
    
    while(1)
    {
 //Single precision   
    timer.reset();               
    
    k0=0;
M1:
    k0=(k0+1);
    a=(k0/2*3+4-5);
    a=atan2(a,k0);
    a=sin(a);
    a=cos(a);
    float y = sin(a) * cos(a * d2r);
    float x = cos(a*d2r)*sin(a*d2r) - sin(a*d2r)*cos(a*d2r)*cos(a);
    a= 360.0-(atan2(y,x)*r2d);
    
    for (unsigned short i=1; i<5; i++){m0[i]=a;}
    if (k0<1000) {goto M1;}
    
    time=timer.read_us();
    
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(1,50);
    myLCD.printf("Time: %.3fms", (float)(time)/1000);
    myLCD.set_font((unsigned char*) Terminal6x8);
    myLCD.locate(1,100);
    myLCD.printf("a = %.14f deg", a);
    pc.printf("Time: %.3fms\r\n", (float)(time)/1000);
    pc.printf("\n\nSystem Core Clock = %.3f MHZ\r\n",(float)SystemCoreClock/1000000);  
    wait(1);
    
 //Double precision   
    timer.reset();               
    
    k0_=0;
M2:
    k0_=(k0_+1);
    a_=(k0_/2*3+4-5);
    a_=atan2(a_,k0_);
    a_=sin(a_);
    a_=cos(a_);
    double y_ = sin(a_) * cos(a_ * d2r);
    double x_ = cos(a_*d2r)*sin(a_*d2r) - sin(a_*d2r)*cos(a_*d2r)*cos(a_);
    a_= 360.0-(atan2(y_,x_)*r2d);
    for (unsigned short i=1; i<5; i++){m0_[i]=a;}
    if (k0_<1000) {goto M2;}
    
    time=timer.read_us();
    
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(1,150);
    myLCD.printf("Time: %.3fms", (float)(time)/1000);
    myLCD.set_font((unsigned char*) Terminal6x8);
    myLCD.locate(1,200);
    myLCD.printf("a_ = %.14f deg", a_);
    pc.printf("Time: %.3fms\r\n", (float)(time)/1000);
    pc.printf("\n\nSystem Core Clock = %.3f MHZ\r\n",(float)SystemCoreClock/1000000);  
    wait(1);
    }
}